/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.httpd;

import com.bowman.httpd.HttpConstants;
import com.bowman.httpd.HttpRequest;
import com.bowman.httpd.HttpRequestListener;
import com.bowman.httpd.HttpResponse;
import com.bowman.util.Globber;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.net.ssl.SSLException;

public class PseudoHttpd
implements HttpConstants,
Runnable {
    private static Properties mimeTypes = new Properties();
    protected static boolean neverGzip = false;
    protected static boolean v11 = false;
    protected Logger logger;
    protected int listenPort;
    protected InetAddress bindAddr;
    protected ServerSocket srvSock;
    protected boolean alive;
    protected boolean silent;
    protected int sessionCount = 0;
    private String indexName = "";
    private Map listeners = new HashMap();
    private File warFile;
    private String warRoot = "";
    private Map warMap = new HashMap();
    private Set gzipExts = new HashSet<String>(Arrays.asList(HttpConstants.defaultGzipExtensions));
    private ZipFile war;
    private long warLastModified;
    static /* synthetic */ Class class$com$bowman$httpd$PseudoHttpd;

    public PseudoHttpd(int listenPort) {
        this(listenPort, null);
    }

    public PseudoHttpd(int listenPort, InetAddress bindAddr) {
        this.listenPort = listenPort;
        this.bindAddr = bindAddr;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public void addHttpRequestListener(String urlPattern, HttpRequestListener listener) {
        this.listeners.put(urlPattern, listener);
    }

    public void addHttpRequestListener(String[] urlPatterns, HttpRequestListener listener) {
        for (int i = 0; i < urlPatterns.length; ++i) {
            this.addHttpRequestListener(urlPatterns[i], listener);
        }
    }

    public void setWar(File warFile) throws IOException {
        this.warFile = warFile;
        this.warLastModified = warFile.lastModified();
        this.war = new ZipFile(warFile);
        Enumeration<? extends ZipEntry> e = this.war.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            this.warMap.put("/" + entry.getName(), entry);
        }
    }

    public void setWarRoot(String path) {
        if (path == null) {
            this.warRoot = "";
            return;
        }
        if ((path = path.trim()).length() == 0) {
            this.warRoot = "";
            return;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        this.warRoot = path;
    }

    public void setIndexFile(String name) {
        this.indexName = name;
    }

    public void setV11(boolean v11) {
        PseudoHttpd.v11 = v11;
    }

    public void setAutoGzipExtensions(String[] exts) {
        this.gzipExts = new HashSet<String>(Arrays.asList(exts));
    }

    public void start() throws IOException {
        if (!this.alive) {
            this.srvSock = new ServerSocket();
            InetSocketAddress sockAddr = this.bindAddr == null ? new InetSocketAddress(this.listenPort) : new InetSocketAddress(this.bindAddr, this.listenPort);
            this.srvSock.bind(sockAddr);
            this.alive = true;
            new Thread((Runnable)this, "PseudoHttpdAcceptThread").start();
        }
    }

    public void stop() {
        this.alive = false;
        try {
            this.srvSock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void run() {
        while (this.alive) {
            try {
                Socket s = this.srvSock.accept();
                if (this.sessionCount <= 110) {
                    new HttpConnection(s).start();
                    continue;
                }
                try {
                    s.close();
                }
                catch (IOException e) {
                }
            }
            catch (SocketException e) {
                this.alive = false;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.alive = false;
            }
        }
    }

    private HttpResponse handleHttpRequest(HttpRequest request) throws IOException {
        HttpResponse response = null;
        Iterator iter = this.listeners.keySet().iterator();
        while (iter.hasNext()) {
            String urlPattern = (String)iter.next();
            if (!Globber.match((String)urlPattern, (String)request.getQueryString(), (boolean)true)) continue;
            HttpRequestListener listener = (HttpRequestListener)this.listeners.get(urlPattern);
            if ("POST".equals(request.getMethod())) {
                response = listener.doPost(urlPattern, request);
            } else if ("GET".equals(request.getMethod())) {
                response = listener.doGet(urlPattern, request);
            } else if ("CONNECT".equals(request.getMethod()) || "XCNT".equals(request.getMethod())) {
                response = listener.doConnect(urlPattern, request);
            } else {
                return HttpResponse.getErrorResponse(405, request.getMethod());
            }
            if (response == null) continue;
        }
        if (response == null) {
            Date ims = request.getDateHeader("if-modified-since");
            response = this.getFileResponse(request, ims == null ? -1L : ims.getTime());
        }
        return response;
    }

    public boolean fileExists(String path) {
        if (this.warFile == null || this.warMap == null || this.war == null) {
            return false;
        }
        return this.warMap.containsKey(path);
    }

    private HttpResponse getFileResponse(HttpRequest request, long ims) throws IOException {
        ZipEntry entry;
        String path = request.getQueryString();
        if (path.startsWith("/") && this.warRoot.endsWith("/")) {
            path = path.substring(1);
        }
        path = this.warRoot + path;
        if (this.warFile == null || this.warMap == null || this.war == null) {
            return null;
        }
        if (this.warLastModified != this.warFile.lastModified()) {
            this.setWar(this.warFile);
        }
        if (!this.warMap.containsKey(path) && !path.endsWith("/")) {
            path = path + "/";
        }
        if (this.indexName != null && this.indexName.length() > 0 && path.endsWith("/") && this.warMap.containsKey(path + this.indexName)) {
            path = path + this.indexName;
        }
        if ((entry = (ZipEntry)this.warMap.get(path)) != null) {
            if (entry.isDirectory()) {
                return HttpResponse.getErrorResponse(403);
            }
            if (ims != -1L && ims <= entry.getTime()) {
                return new HttpResponse(304, "Not Modified");
            }
            byte[] buf = new byte[(int)entry.getSize()];
            DataInputStream in = new DataInputStream(this.war.getInputStream(entry));
            in.readFully(buf);
            HttpResponse response = HttpResponse.getFileResponse(buf, path, this);
            response.setHeader("Last-Modified", new Date(entry.getTime()));
            return response;
        }
        return null;
    }

    protected static String getMimeType(String path) {
        String type = null;
        if (path.indexOf(46) > -1) {
            String ext = path.substring(path.lastIndexOf(46) + 1);
            type = mimeTypes.getProperty(ext);
        }
        if (type == null) {
            return "text/plain";
        }
        return type;
    }

    protected boolean isGzipExt(String path) {
        if (path.indexOf(46) > -1) {
            String ext = path.substring(path.lastIndexOf(46) + 1);
            return this.gzipExts.contains(ext.toLowerCase());
        }
        return false;
    }

    public void setLogger(Logger newLogger) {
        this.logger = newLogger;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    protected void log(HttpConnection c, HttpResponse r) {
        String agent;
        String date = PseudoHttpd.formatDate(HttpConstants.logDateFmt, new Date());
        HttpRequest request = r.getRequest();
        if (request == null) {
            return;
        }
        String requestStr = request.getRequest();
        String code = String.valueOf(r.getResponseCode());
        String size = String.valueOf(r.getSize());
        String referer = r.getRequest().getHeader("referer");
        if (referer == null) {
            referer = "-";
        }
        if ((agent = r.getRequest().getHeader("user-agent")) == null) {
            agent = "-";
        }
        Object[] params = new Object[]{c.getRemoteAddress(), date, requestStr, code, size, referer, agent};
        this.log(MessageFormat.format("{0} - - [{1}] \"{2}\" {3} {4} \"{5}\" \"{6}\"", params));
    }

    protected void log(String s) {
        if (this.logger == null) {
            if (!this.silent) {
                System.out.println(s);
            }
        } else {
            this.logger.info(s);
        }
    }

    protected void log(String s, Throwable t) {
        if (this.logger == null) {
            if (!this.silent) {
                System.err.println(s);
                t.printStackTrace();
            }
        } else {
            this.logger.log(Level.SEVERE, s, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String formatDate(SimpleDateFormat fmt, Date date) {
        SimpleDateFormat simpleDateFormat = fmt;
        synchronized (simpleDateFormat) {
            return fmt.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Date parseDate(SimpleDateFormat fmt, String dateStr) throws ParseException {
        SimpleDateFormat simpleDateFormat = fmt;
        synchronized (simpleDateFormat) {
            return fmt.parse(dateStr);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        BufferedReader reader = new BufferedReader(new InputStreamReader((class$com$bowman$httpd$PseudoHttpd == null ? (class$com$bowman$httpd$PseudoHttpd = PseudoHttpd.class$("com.bowman.httpd.PseudoHttpd")) : class$com$bowman$httpd$PseudoHttpd).getResourceAsStream("mime.types")));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                StringTokenizer st;
                if (line.startsWith("#") || !(st = new StringTokenizer(line)).hasMoreTokens()) continue;
                String type = st.nextToken();
                while (st.hasMoreTokens()) {
                    mimeTypes.setProperty(st.nextToken(), type);
                }
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if ("true".equalsIgnoreCase(System.getProperty("com.bowman.httpd.nevergzip"))) {
            neverGzip = true;
        }
    }

    class HttpConnection
    extends Thread {
        private static final String CRLF = "\r\n";
        private static final String headerEnd = "\r\n\r\n";
        private static final String mangledEnd = "\n\n";
        private Socket conn;
        private DataInputStream in;
        private BufferedOutputStream out;
        private String remoteAddress;

        public HttpConnection(Socket conn) throws IOException {
            super("HttpdConnectionThread[" + conn + "]");
            this.conn = conn;
            this.remoteAddress = conn.getInetAddress().getHostAddress();
            this.in = new DataInputStream(conn.getInputStream());
            this.out = new BufferedOutputStream(conn.getOutputStream());
        }

        public String getRemoteAddress() {
            return this.remoteAddress;
        }

        public void run() {
            HttpRequest request = null;
            ++PseudoHttpd.this.sessionCount;
            try {
                this.conn.setSoTimeout(300000);
            }
            catch (SocketException e) {
                // empty catch block
            }
            while (this.conn != null) {
                HttpResponse response;
                try {
                    String header;
                    BufferedReader reader = this.readHeader();
                    if (reader == null) {
                        this.close();
                        break;
                    }
                    String requestStr = reader.readLine();
                    if ("".equals(requestStr.trim())) {
                        requestStr = reader.readLine();
                    }
                    HashMap<String, String> headers = new HashMap<String, String>();
                    while ((header = reader.readLine()).length() > 0) {
                        int idx = header.indexOf(58);
                        if ("".equals(header.trim())) continue;
                        headers.put(header.substring(0, idx).toLowerCase().trim(), header.substring(idx + 1).trim());
                    }
                    request = new HttpRequest(requestStr, headers, this.remoteAddress);
                    if ("POST".equals(request.getMethod())) {
                        this.readContent(request);
                    } else if ("CONNECT".equals(request.getMethod()) || "XCNT".equals(request.getMethod())) {
                        request.setConnection(this.conn);
                    }
                    try {
                        if (PseudoHttpd.this.sessionCount > 100) {
                            response = HttpResponse.getErrorResponse(503);
                        } else {
                            response = PseudoHttpd.this.handleHttpRequest(request);
                            if (response == null) {
                                response = HttpResponse.getErrorResponse(404, request.getQueryString());
                            }
                        }
                        this.writeResponse(response, request);
                    }
                    catch (Exception e) {
                        PseudoHttpd.this.log("Exception handling request", e);
                        response = HttpResponse.getErrorResponse(e);
                        this.writeResponse(response, request);
                    }
                }
                catch (Exception e) {
                    PseudoHttpd.this.log("Exception reading/parsing request", e);
                    response = HttpResponse.getErrorResponse(400, e.getMessage());
                    this.writeResponse(response, request);
                    this.close();
                }
            }
            --PseudoHttpd.this.sessionCount;
        }

        private void close() {
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.conn = null;
        }

        private BufferedReader readHeader() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            boolean endReached = false;
            while (!endReached) {
                int last;
                try {
                    last = this.in.read();
                    baos.write(last);
                }
                catch (SSLException e) {
                    return null;
                }
                catch (SocketTimeoutException e) {
                    return null;
                }
                catch (SocketException e) {
                    return null;
                }
                if (baos.size() > 4096) {
                    throw new IOException("Header exceeded maximum size: 4096");
                }
                if (last == 10) {
                    String hdrMaybe = baos.toString();
                    endReached = hdrMaybe.endsWith(headerEnd) || hdrMaybe.endsWith(mangledEnd);
                    continue;
                }
                if (last != -1) continue;
                return null;
            }
            return new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(baos.toByteArray()), "UTF-8"));
        }

        private void readContent(HttpRequest request) throws IOException {
            int length = -1;
            try {
                length = Integer.parseInt(request.getHeader("content-length"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (length > 0) {
                if (length > 0x500000) {
                    throw new IOException("POST Content-Length exceeded maximum size: 5242880");
                }
                byte[] content = new byte[length];
                this.in.readFully(content);
                request.setContent(content);
            } else {
                request.setConnection(this.conn);
            }
        }

        private void writeResponse(HttpResponse response, HttpRequest request) {
            response.setRequest(request);
            if (v11) {
                response.setV11(true);
            }
            PseudoHttpd.this.log(this, response);
            if (response == HttpResponse.CONNECT_RESPONSE) {
                this.conn = null;
                return;
            }
            StringBuffer sb = new StringBuffer(response.isV11() ? "HTTP/1.1 " : "HTTP/1.0 ");
            sb.append(response.getResponseCode()).append(' ').append(response.getResponseMsg()).append(CRLF);
            Map headers = response.getHeaders();
            Iterator iter = headers.keySet().iterator();
            while (iter.hasNext()) {
                String header = (String)iter.next();
                sb.append(header).append(": ").append(headers.get(header)).append(CRLF);
            }
            boolean keepAlive = false;
            boolean explicitClose = false;
            if (response.getRequest() != null && !(keepAlive = "keep-alive".equalsIgnoreCase(response.getRequest().getHeader("Connection")))) {
                explicitClose = "close".equalsIgnoreCase(response.getRequest().getHeader("Connection"));
            }
            if (PseudoHttpd.this.sessionCount > 100) {
                keepAlive = false;
            }
            if (keepAlive) {
                sb.append("Connection: Keep-Alive").append(CRLF);
            }
            if (v11 && !explicitClose) {
                keepAlive = true;
            }
            sb.append(CRLF);
            try {
                byte[] body;
                this.out.write(sb.toString().getBytes());
                if (!v11) {
                    this.out.flush();
                }
                if ((body = response.getContent()) != null && body.length > 0) {
                    this.out.write(body);
                }
                this.out.flush();
            }
            catch (SSLException e) {
                keepAlive = false;
            }
            catch (SocketException e) {
                keepAlive = false;
            }
            catch (IOException e) {
                PseudoHttpd.this.log("Exception writing response", e);
                keepAlive = false;
            }
            if (!keepAlive) {
                this.close();
            }
        }
    }
}

