/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardServProxy;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.interfaces.ProxyPlugin;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.tv.TvService;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class SoftNdsPlugin
implements ProxyPlugin {
    private static final String PLUGIN_NAME = "SoftNdsPlugin";
    private static final String PLUGIN_DESC = "Softcam decryption of NDS";
    private static final int[] CAID = new int[]{2319, 2366};
    private ProxyLogger logger;
    private ProxyConfig config;
    private Set profiles = new HashSet();
    private Set services = new HashSet();
    private int count;
    private byte[] P3;
    private byte[] P4;

    public SoftNdsPlugin() {
        this.logger = ProxyLogger.getLabeledLogger((String)this.getClass().getName());
        this.config = ProxyConfig.getInstance();
    }

    public void start(CardServProxy cardServProxy) {
    }

    public void stop() {
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public String getDescription() {
        return PLUGIN_DESC;
    }

    public Properties getProperties() {
        Properties p = new Properties();
        String caids = "";
        for (int i = 0; i < CAID.length; ++i) {
            if (i != 0) {
                caids = caids + ", ";
            }
            caids = caids + DESUtil.intToHexString((int)CAID[i], (int)4);
        }
        p.setProperty("ca-id's", caids);
        p.setProperty("decoded-count", String.valueOf(this.count));
        if (!this.services.isEmpty()) {
            p.setProperty("decoded-services", String.valueOf(this.services));
        }
        if (!this.profiles.isEmpty()) {
            p.setProperty("profiles", String.valueOf(this.profiles));
        }
        return p;
    }

    public byte[] getResource(String path, boolean admin) {
        return null;
    }

    public byte[] getResource(String path, byte[] inData, boolean admin) {
        return null;
    }

    public CamdNetMessage doFilter(ProxySession session, CamdNetMessage msg) {
        block6: {
            try {
                if (!msg.isEcm() || msg.getType() != -2 || msg.isFiltered() || !this.profiles.isEmpty() && !this.profiles.contains(msg.getProfileName().toLowerCase())) break block6;
                if (msg.getDataLength() < 10) {
                    return msg;
                }
                for (int i = 0; i < CAID.length; ++i) {
                    if (CAID[i] != msg.getCaId()) continue;
                    CamdNetMessage reply = this.handleSoftNds(msg);
                    if (reply != null) {
                        ++this.count;
                        StringBuffer sb = new StringBuffer();
                        TvService ts = this.config.getService(msg);
                        sb.append(ts.getName());
                        if (!ts.isUnknown()) {
                            sb.append(" (").append(Integer.toHexString(ts.getId())).append(')');
                        }
                        sb.append(":" + msg.getProfileName());
                        this.services.add(sb.toString());
                        msg.setFilteredBy(PLUGIN_NAME);
                        msg.setInstant(true);
                        session.sendEcmReply(msg, reply);
                    }
                    break;
                }
            }
            catch (Throwable t) {
                this.logger.throwing(t);
                t.printStackTrace();
            }
        }
        return msg;
    }

    private CamdNetMessage handleSoftNds(CamdNetMessage request) {
        EcmData ecmData = this.parseEcm(request.getCustomData());
        byte[] dw = null;
        if (ecmData != null) {
            ecmData.odd = (request.getCommandTag() & 1) > 0;
            dw = this.calculateDW(request.getServiceId(), ecmData);
        }
        if (dw != null) {
            CamdNetMessage reply = request.getEmptyReply();
            reply.setCustomData(dw);
            reply.refreshDataHash();
            reply.setServiceId(request.getServiceId());
            return reply;
        }
        return null;
    }

    private EcmData parseEcm(byte[] ecm) {
        if (ecm.length < 10) {
            return null;
        }
        byte[] P1 = new byte[10];
        byte[] P2 = new byte[4];
        byte[] CW = new byte[8];
        int pos = 0;
        int len = ecm.length;
        if (ecm[pos] != 0 || ecm[pos + 1] != 0 || ecm[pos + 2] != 1) {
            return null;
        }
        pos += 3;
        int index = 0;
        while (index < 3 && pos < len) {
            switch (index) {
                case 0: {
                    int i;
                    ++pos;
                    for (i = 0; i < P1.length; ++i) {
                        P1[i] = ecm[pos++];
                    }
                    if ((P1[8] & 1) == 0 || (P1[9] & 0x10) == 0) {
                        return null;
                    }
                    pos += 5;
                    ++index;
                    break;
                }
                case 1: {
                    int i;
                    ++pos;
                    for (i = 0; i < CW.length; ++i) {
                        CW[i] = ecm[pos++];
                    }
                    ++index;
                    break;
                }
                case 2: {
                    int i;
                    ++pos;
                    for (i = 0; i < P2.length; ++i) {
                        P2[i] = ecm[pos++];
                    }
                    pos += 2;
                    ++index;
                }
            }
        }
        if (index != 3) {
            return null;
        }
        EcmData ecmData = new EcmData();
        ecmData.P1 = P1;
        ecmData.P2 = P2;
        ecmData.P3 = this.P3;
        ecmData.P4 = this.P4;
        ecmData.CW = CW;
        return ecmData;
    }

    private byte[] calculateDW(int sid, EcmData ecm) {
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(ecm.P1);
            algorithm.update(ecm.P2);
            algorithm.update(ecm.P3);
            algorithm.update(ecm.P4);
            byte[] messageDigest = algorithm.digest();
            byte[] newDW = new byte[8];
            for (int i = 0; i < 8; ++i) {
                newDW[i] = (byte)(messageDigest[i + 8] ^ ecm.CW[i]);
            }
            newDW[3] = (byte)(newDW[0] + newDW[1] + newDW[2] & 0xFF);
            newDW[7] = (byte)(newDW[4] + newDW[5] + newDW[6] & 0xFF);
            this.logger.fine("New DCW[" + Integer.toHexString(sid) + "] : " + DESUtil.bytesToString((byte[])newDW));
            byte[] DW = new byte[16];
            if (ecm.odd) {
                System.arraycopy(newDW, 0, DW, 8, newDW.length);
            } else {
                System.arraycopy(newDW, 0, DW, 0, newDW.length);
            }
            return DW;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        String profilesStr = xml.getStringValue("profiles", "");
        this.profiles = profilesStr != null && profilesStr.length() > 0 ? new HashSet<String>(Arrays.asList(profilesStr.toLowerCase().split(" "))) : Collections.EMPTY_SET;
        this.P3 = xml.getBytesValue("P3");
        this.P4 = xml.getBytesValue("P4");
        try {
            byte[] DW;
            EcmData ecmData;
            byte[] testEcm = xml.getBytesValue("testEcm");
            if (testEcm != null && (ecmData = this.parseEcm(testEcm)) != null && (DW = this.calculateDW(0, ecmData)) != null) {
                this.logger.finest("Test DCW: " + DESUtil.bytesToString((byte[])DW));
            }
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        this.logger.fine("Configuration updated.");
    }

    private static class EcmData {
        byte[] P1;
        byte[] P2;
        byte[] P3;
        byte[] P4;
        byte[] CW;
        boolean odd;

        private EcmData() {
        }
    }
}

