/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardServProxy;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.interfaces.ProxyPlugin;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class ProviderIdentPlugin
implements ProxyPlugin {
    private Set profiles = new HashSet();
    private ProxyLogger logger = ProxyLogger.getLabeledLogger((String)this.getClass().getName());

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        String profilesStr = xml.getStringValue("profiles", "");
        this.profiles = profilesStr != null && profilesStr.length() > 0 ? new HashSet<String>(Arrays.asList(profilesStr.toLowerCase().split(" "))) : Collections.EMPTY_SET;
    }

    public void start(CardServProxy proxy) {
    }

    public void stop() {
    }

    public String getName() {
        return "ProviderIdentPlugin";
    }

    public String getDescription() {
        return "Extracts provider ident from viaccess and seca ecms.";
    }

    public Properties getProperties() {
        return null;
    }

    public CamdNetMessage doFilter(ProxySession session, CamdNetMessage msg) {
        try {
            if (msg.isEcm() && msg.getType() == -2 && !msg.isFiltered() && (this.profiles.isEmpty() || this.profiles.contains(session.getProfileName().toLowerCase()))) {
                if (msg.getDataLength() < 10) {
                    return msg;
                }
                switch (msg.getCaId()) {
                    case 1280: {
                        this.handleViaccess(msg);
                        break;
                    }
                    case 256: {
                        this.handleSeca(msg);
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return msg;
    }

    protected void handleViaccess(CamdNetMessage msg) {
        int i;
        byte[] data = msg.getCustomData();
        int del = data[1] & 0xFF;
        int del2 = data[2] & 0xFF;
        int n = i = del != 210 ? 0 : del2 + 2;
        if (data.length <= 2 + i) {
            this.logger.warning("Unknown viaccess ecm structure or bad ecm from " + msg.getOriginAddress() + ": " + DESUtil.bytesToString((byte[])data));
            return;
        }
        int sec = data[2 + i] & 0xFF;
        int fir = data[1 + i] & 0xFF;
        if (sec == 3 && (fir == 144 || fir == 64)) {
            byte[] prcId = new byte[3];
            System.arraycopy(data, 3 + i, prcId, 0, 3);
            prcId[2] = (byte)(prcId[2] & 0xF0);
            int ident = DESUtil.bytesToInt((byte[])prcId);
            if (msg.getProviderIdent() > 0 && msg.getProviderIdent() != ident) {
                this.logger.warning("Viaccess provider ident " + DESUtil.intToByteString((int)ident, (int)3) + " doesn't match ident in header: " + DESUtil.intToByteString((int)msg.getProviderIdent(), (int)3) + " (overwriting)");
            }
            msg.setProviderIdent(ident);
        } else {
            this.logger.finer("No provider-ident in: " + DESUtil.bytesToString((byte[])data));
        }
    }

    protected void handleSeca(CamdNetMessage msg) {
        byte[] prcId = new byte[2];
        System.arraycopy(msg.getCustomData(), 0, prcId, 0, 2);
        int ident = DESUtil.bytesToInt((byte[])prcId);
        if (msg.getProviderIdent() > 0 && msg.getProviderIdent() != ident) {
            this.logger.warning("Seca provider ident " + DESUtil.intToByteString((int)ident, (int)3) + " doesn't match ident in header: " + DESUtil.intToByteString((int)msg.getProviderIdent(), (int)3) + " (overwriting)");
        }
        msg.setProviderIdent(ident);
    }

    public byte[] getResource(String path, boolean admin) {
        return null;
    }

    public byte[] getResource(String path, byte[] inData, boolean admin) {
        return null;
    }
}

