/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.util;

import java.util.Random;

public class BowSort {
    protected static Random generator;

    public static String[] sort(String[] strings) {
        generator = new Random();
        String[] stuff = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            stuff[i] = strings[i];
        }
        BowSort.quickSort(stuff);
        return stuff;
    }

    protected static void quickSort(String[] A) {
        BowSort.quickSort(A, 0, A.length - 1);
    }

    protected static void quickSort(String[] A, int lb, int ub) {
        if (lb == ub) {
            return;
        }
        BowSort.putPivotAtFront(A, lb, ub);
        int mid = BowSort.partition(A, lb, ub);
        if (mid - 1 >= lb) {
            BowSort.quickSort(A, lb, mid - 1);
        }
        if (mid + 1 <= ub) {
            BowSort.quickSort(A, mid + 1, ub);
        }
    }

    protected static int partition(String[] A, int lb, int ub) {
        String pivotval = A[lb];
        int l = lb;
        int r = ub;
        while (l < r) {
            while (pivotval.toLowerCase().compareTo(A[r].toLowerCase()) < 0 && r > l) {
                --r;
            }
            while (A[l].toLowerCase().compareTo(pivotval.toLowerCase()) <= 0 && l < r) {
                ++l;
            }
            if (A[l].toLowerCase().compareTo(A[r].toLowerCase()) <= 0) continue;
            BowSort.swap(A, l, r);
        }
        BowSort.swap(A, lb, l);
        return l;
    }

    protected static void putPivotAtFront(String[] A, int lb, int ub) {
        int length = ub - lb + 1;
        int r = Math.abs(generator.nextInt()) % length;
        BowSort.swap(A, lb, lb + r);
    }

    protected static void swap(String[] A, int x, int y) {
        String tmp = A[x];
        A[x] = A[y];
        A[y] = tmp;
    }
}

