/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardServProxy;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.interfaces.ProxyPlugin;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class BetacryptTunnelPlugin
implements ProxyPlugin {
    private ProxyLogger logger;
    private Set profiles = new HashSet();
    private int targetNetworkId;
    private int tunneledCount = 0;
    private int fixedEcmCount = 0;
    private byte[] ecmHeader;

    public BetacryptTunnelPlugin() {
        this.logger = ProxyLogger.getLabeledLogger((String)this.getClass().getName());
    }

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        String profilesStr = xml.getStringValue("profiles", "");
        int targetNetworkIdConfig = Integer.parseInt(xml.getStringValue("target-network-id", "0085"), 16);
        byte[] custEcmHeader = DESUtil.stringToBytes((String)xml.getStringValue("ecm-header", "C7 00 00 00 01 10 10 00 87"));
        this.profiles = profilesStr != null && profilesStr.length() > 0 ? new HashSet<String>(Arrays.asList(profilesStr.toLowerCase().split(" "))) : Collections.EMPTY_SET;
        if (targetNetworkIdConfig == 0) {
            throw new ConfigException(xml.getFullName(), "target-network-id should not be zero: " + targetNetworkIdConfig);
        }
        this.targetNetworkId = targetNetworkIdConfig;
        if (custEcmHeader.length != 9) {
            throw new ConfigException(xml.getFullName(), "ecm-header not 9 bytes: " + DESUtil.bytesToString((byte[])custEcmHeader));
        }
        this.ecmHeader = custEcmHeader;
    }

    public void start(CardServProxy proxy) {
        this.logger.info("Adding header to Nagra3 ECMs: " + DESUtil.bytesToString((byte[])this.ecmHeader));
    }

    public void stop() {
    }

    public String getName() {
        return "BetacryptTunnelPlugin";
    }

    public String getDescription() {
        return "Converts plain Nagra3 ECMs to Betacrypt tunneled ECMs (CaId 0x1833/0x1834).";
    }

    public Properties getProperties() {
        Properties p = new Properties();
        if (this.fixedEcmCount > 0) {
            p.setProperty("fixed-ecm-count", String.valueOf(this.fixedEcmCount));
        }
        if (this.tunneledCount > 0) {
            p.setProperty("tunneled-count", String.valueOf(this.tunneledCount));
        }
        if (this.ecmHeader != null) {
            p.setProperty("ecm-header", DESUtil.bytesToString((byte[])this.ecmHeader));
        }
        if (p.isEmpty()) {
            return null;
        }
        return p;
    }

    public CamdNetMessage doFilter(ProxySession session, CamdNetMessage msg) {
        try {
            if (msg.isEcm() && msg.getType() == -2 && !msg.isFiltered() && (this.profiles.isEmpty() || this.profiles.contains(session.getProfileName().toLowerCase()))) {
                int ecmLen = msg.getDataLength();
                byte[] ecmOrg = new byte[ecmLen];
                ecmOrg = msg.getCustomData();
                if ((msg.getCaId() == 5890 || msg.getCaId() == 5922) && ecmOrg[0] == 7 && ecmOrg[1] == -124) {
                    switch (msg.getCaId()) {
                        case 5890: {
                            msg.setCaIdInHdr(6195);
                            msg.setCaId(6195);
                            break;
                        }
                        case 5922: {
                            msg.setCaIdInHdr(6196);
                            msg.setCaId(6196);
                        }
                    }
                    this.logger.warning("Wrong CaId in Betacrypt ecm from " + msg.getRemoteAddress() + ". Changing CaId to Nagra. Check Betacrypt mapping in client config.");
                    ++this.fixedEcmCount;
                }
                if ((msg.getCaId() == 6195 || msg.getCaId() == 6196) && ecmLen >= 134 && ecmLen < 144) {
                    this.logger.fine("Processing ecm (length: " + ecmLen + "): " + DESUtil.bytesToString((byte[])ecmOrg));
                    byte[] ecmNew = new byte[ecmLen + 10];
                    boolean odd = (msg.getCommandTag() & 1) > 0;
                    System.arraycopy(this.ecmHeader, 0, ecmNew, 0, 9);
                    System.arraycopy(ecmOrg, 0, ecmNew, 10, ecmLen);
                    ecmNew[9] = odd ? 19 : 18;
                    switch (msg.getCaId()) {
                        case 6195: {
                            msg.setCaIdInHdr(5890);
                            msg.setCaId(5890);
                            msg.setNetworkId(this.targetNetworkId);
                            break;
                        }
                        case 6196: {
                            msg.setCaIdInHdr(5922);
                            msg.setCaId(5922);
                            msg.setNetworkId(this.targetNetworkId);
                        }
                    }
                    msg.setCustomData(ecmNew);
                    ++this.tunneledCount;
                    this.logger.fine("Resulting ecm (length: " + msg.getDataLength() + "): " + DESUtil.bytesToString((byte[])msg.getCustomData()));
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return msg;
    }

    public byte[] getResource(String path, boolean admin) {
        return null;
    }

    public byte[] getResource(String path, byte[] inData, boolean admin) {
        return null;
    }
}

