/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardServProxy;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.interfaces.ProxyPlugin;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class IrdetoPlugin
implements ProxyPlugin {
    private ProxyLogger logger;
    private Set profiles = new HashSet();

    public IrdetoPlugin() {
        this.logger = ProxyLogger.getLabeledLogger((String)this.getClass().getName());
    }

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        String profilesStr = xml.getStringValue("profiles", "");
        this.profiles = profilesStr != null && profilesStr.length() > 0 ? new HashSet<String>(Arrays.asList(profilesStr.toLowerCase().split(" "))) : Collections.EMPTY_SET;
    }

    public void start(CardServProxy proxy) {
    }

    public void stop() {
    }

    public String getName() {
        return "IrdetoPlugin";
    }

    public String getDescription() {
        return "Extracts irdeto ch-id from irdeto ecms.";
    }

    public Properties getProperties() {
        return null;
    }

    public CamdNetMessage doFilter(ProxySession session, CamdNetMessage msg) {
        try {
            if (msg.isEcm() && msg.getType() == -2 && !msg.isFiltered() && (this.profiles.isEmpty() || this.profiles.contains(session.getProfileName().toLowerCase())) && (msg.getCaId() & 0xFF00) == 1536) {
                if (msg.getDataLength() < 6) {
                    this.logger.warning("Truncated Irdeto ECM ignored: " + DESUtil.bytesToString((byte[])msg.getCustomData()));
                    msg.setFilteredBy("IrdetoPlugin: Bad ECM length (" + msg.getDataLength() + ")");
                    session.sendEcmReply(msg, msg.getEmptyReply());
                    return msg;
                }
                byte[] chId = new byte[2];
                System.arraycopy(msg.getCustomData(), 3, chId, 0, 2);
                msg.setCustomId(DESUtil.bytesToInt((byte[])chId));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return msg;
    }

    public byte[] getResource(String path, boolean admin) {
        return null;
    }

    public byte[] getResource(String path, byte[] inData, boolean admin) {
        return null;
    }
}

