/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardServProxy;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.TriggerMessenger;
import com.bowman.cardserv.interfaces.ProxyPlugin;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.rmi.RemoteHandler;
import com.bowman.cardserv.rmi.RemoteListener;
import com.bowman.cardserv.tv.TvService;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.cardserv.web.Command;
import com.bowman.cardserv.web.CtrlCommand;
import com.bowman.cardserv.web.CtrlCommandResult;
import com.bowman.util.CronTimer;
import com.bowman.util.CronTimerListener;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MessagingPlugin
implements ProxyPlugin {
    protected RemoteHandler proxy;
    private Map userOsdStatus = new HashMap();
    private Map userMailStatus = new HashMap();
    private Map mailAggregate = new HashMap();
    private int minOsdInterval;
    private int minMailInterval;
    private String smtpServer;
    private String senderAddr;
    private int smtpPort;
    private String mailFooter = "";
    private Set commands = new HashSet();
    private TriggerMessenger osdMessenger;
    private TriggerMessenger mailMessenger;
    private CronTimer fetchCron;
    protected ProxyLogger logger = ProxyLogger.getLabeledLogger((String)this.getClass().getName(), (String)this.getName());

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        ProxyXmlConfig autoOsdCfg;
        if (this.fetchCron == null) {
            this.fetchCron = new CronTimer("* * * * *");
            this.fetchCron.start();
        }
        if ("true".equals((autoOsdCfg = xml.getSubConfig("auto-mgcamd-osd")).getStringValue("enabled", "true"))) {
            this.osdMessenger = new TriggerMessenger(this);
            this.minOsdInterval = autoOsdCfg.getTimeValue("min-interval", 20, "s");
            this.osdMessenger.configUpdated(autoOsdCfg);
            this.fetchCron.addTimerListener((CronTimerListener)this.osdMessenger);
        } else {
            this.osdMessenger = null;
        }
        ProxyXmlConfig mailCfg = xml.getSubConfig("email");
        if ("true".equals(mailCfg.getStringValue("enabled", "true"))) {
            this.smtpServer = mailCfg.getStringValue("smtp-server");
            this.smtpPort = mailCfg.getIntValue("smtp-port", 25);
            this.senderAddr = mailCfg.getStringValue("sender-address");
            this.mailFooter = mailCfg.getStringValue("mail-footer", "");
            ProxyXmlConfig autoMailCfg = mailCfg.getSubConfig("auto-email");
            if ("true".equals(autoMailCfg.getStringValue("enabled", "true"))) {
                this.mailMessenger = new TriggerMessenger(this);
                this.minMailInterval = autoMailCfg.getTimeValue("min-interval", 600, "s");
                this.mailMessenger.configUpdated(autoMailCfg);
                this.fetchCron.addTimerListener((CronTimerListener)this.mailMessenger);
            } else {
                this.mailMessenger = null;
            }
        } else {
            this.smtpServer = null;
            this.mailMessenger = null;
        }
    }

    public void start(CardServProxy proxy) {
        this.proxy = proxy.getRemoteHandler();
        if (this.osdMessenger != null) {
            this.proxy.addRemoteListener((RemoteListener)this.osdMessenger);
        }
        if (this.smtpServer != null) {
            if (this.mailMessenger != null) {
                this.proxy.addRemoteListener((RemoteListener)this.mailMessenger);
            }
            try {
                CtrlCommand cmd = new CtrlCommand("mail-user", "Send mail (single)", "Send a mail to the specified user.", true);
                cmd.addParam("text", "Mail body").setSize(4);
                cmd.addParam("name", "User").setOptions("@known-users", false);
                cmd.register((Object)this);
                this.commands.add(cmd);
                cmd = new CtrlCommand("mail-profile", "Send mail (profile)", "Send a mail to all users in the specified profile.", true);
                cmd.addParam("text", "Mail body").setSize(4);
                cmd.addParam("name", "Profile").setOptions("@profiles", false);
                cmd.register((Object)this);
                this.commands.add(cmd);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        if (this.proxy != null) {
            if (this.osdMessenger != null) {
                this.proxy.removeRemoteListener((RemoteListener)this.osdMessenger);
            }
            if (this.mailMessenger != null) {
                this.proxy.removeRemoteListener((RemoteListener)this.mailMessenger);
            }
            this.proxy = null;
        }
        Iterator iter = this.commands.iterator();
        while (iter.hasNext()) {
            Command cmd = (Command)iter.next();
            cmd.unregister();
        }
        this.commands.clear();
        if (this.osdMessenger != null && this.fetchCron != null) {
            this.fetchCron.removeTimerListener((CronTimerListener)this.osdMessenger);
            this.fetchCron.removeTimerListener((CronTimerListener)this.mailMessenger);
            this.fetchCron.stop();
            this.fetchCron = null;
        }
    }

    public CtrlCommandResult runCtrlCmdMailUser(Map params, String admin) {
        String user = (String)params.get("name");
        String text = (String)params.get("text");
        if (user == null) {
            return new CtrlCommandResult(false, "Missing parameter: name");
        }
        if (text == null) {
            return new CtrlCommandResult(false, "Missing parameter: text");
        }
        String emailAddr = this.proxy.getEmailAddress(user);
        if (emailAddr == null || "".equals(emailAddr)) {
            return new CtrlCommandResult(false, user + " has no email address set.");
        }
        String subject = "CSP message from: " + admin;
        try {
            this.sendMail(user, emailAddr, subject, text);
            return new CtrlCommandResult(true, "Mail sent.");
        }
        catch (Throwable e) {
            if (e.getCause() != null) {
                e = e.getCause();
            }
            this.logger.warning("Failed to send mail to '" + emailAddr + "': " + e);
            this.logger.throwing(e);
            return new CtrlCommandResult(false, "Sending failed: " + e.getMessage());
        }
    }

    public CtrlCommandResult runCtrlCmdMailProfile(Map params, String admin) {
        String profile = (String)params.get("name");
        String text = (String)params.get("text");
        if (profile == null) {
            return new CtrlCommandResult(false, "Missing parameter: name");
        }
        if (text == null) {
            return new CtrlCommandResult(false, "Missing parameter: text");
        }
        String subject = "CSP announcement from: " + admin;
        int noMail = 0;
        int failed = 0;
        int sent = 0;
        String[] userNames = this.proxy.getLocalUsers(profile);
        for (int i = 0; i < userNames.length; ++i) {
            String emailAddr = this.proxy.getEmailAddress(userNames[i]);
            if (emailAddr == null) {
                ++noMail;
                continue;
            }
            try {
                this.sendMail(userNames[i], emailAddr, subject, text);
                ++sent;
                continue;
            }
            catch (Throwable e) {
                if (e.getCause() != null) {
                    e = e.getCause();
                }
                this.logger.warning("Failed to send mail to '" + emailAddr + "': " + e);
                this.logger.throwing(e);
                ++failed;
            }
        }
        return new CtrlCommandResult(true, "Sending complete. Counters: no address set = " + noMail + ", failed = " + failed + ", sent ok = " + sent);
    }

    protected void sendMail(String user, String recipient, String subject, String text) throws Exception {
        if (this.mailFooter.length() > 0) {
            text = text + "\n\n" + MessageFormat.format(this.mailFooter, user, "0.9.0");
        }
        Class<?> mailer = Class.forName("com.bowman.util.MailerWrapper");
        Method sendMethod = mailer.getMethod("send", String.class, Integer.TYPE, String.class, String.class, String.class, String.class, URL.class);
        sendMethod.invoke(null, this.smtpServer, new Integer(this.smtpPort), recipient, this.senderAddr, subject, text, null);
        this.logger.info("Mail sent to user '" + user + "' (" + recipient + "): " + text);
    }

    public String getName() {
        return "MessagingPlugin";
    }

    public String getDescription() {
        return "Automated mgcamd osd replies and email functionality.";
    }

    public Properties getProperties() {
        return null;
    }

    public CamdNetMessage doFilter(ProxySession proxySession, CamdNetMessage msg) {
        return msg;
    }

    public byte[] getResource(String path, boolean admin) {
        return null;
    }

    public byte[] getResource(String path, byte[] inData, boolean admin) {
        return null;
    }

    public void addDynamicServiceTrigger(String name, TvService ts, String message) throws ConfigException {
        if (this.osdMessenger != null) {
            this.osdMessenger.addDynamicServiceTrigger(name, ts, message);
        }
    }

    public void clearDynamicServiceTriggers(String name) {
        if (this.osdMessenger != null) {
            this.osdMessenger.clearDynamicServiceTrigger(name);
        }
    }

    protected void triggeredMessage(TriggerMessenger tm, String target, String text) {
        if (tm == this.osdMessenger) {
            this.sendOsdMessage(target, text);
        } else if (tm == this.mailMessenger) {
            this.sendAutoMail(target, text);
        }
    }

    protected void sendOsdMessage(String user, String text) {
        long now = System.currentTimeMillis();
        Long last = (Long)this.userOsdStatus.get(user);
        if (last != null && now - last < (long)this.minOsdInterval) {
            this.logger.fine("Flood detected for user '" + user + "', skipping msg: " + text);
            return;
        }
        this.proxy.sendOsdMessage(user, text);
        this.userOsdStatus.put(user, new Long(now));
    }

    protected void sendAutoMail(String target, String text) {
        String emailAddr = target.indexOf(64) != -1 && target.indexOf(46) != -1 ? target : this.proxy.getEmailAddress(target);
        if (emailAddr == null || "".equals(emailAddr)) {
            this.logger.fine("User '" + target + "' has no email address set, skipping message: " + text);
            return;
        }
        long now = System.currentTimeMillis();
        Long last = (Long)this.userMailStatus.get(target);
        if (last != null && now - last < (long)this.minMailInterval) {
            this.logger.fine("Flood detected for user '" + target + "', aggregating mail: " + text);
            String mail = (String)this.mailAggregate.get(target);
            mail = mail == null ? text : mail + "\n" + text;
            this.mailAggregate.put(target, mail);
            return;
        }
        String mail = (String)this.mailAggregate.get(target);
        mail = mail == null ? text : mail + "\n" + text;
        this.mailAggregate.remove(target);
        try {
            this.sendMail(target, emailAddr, "CSP alert", mail);
        }
        catch (Throwable e) {
            this.logger.throwing(e);
            if (e.getCause() != null) {
                e = e.getCause();
            }
            this.logger.warning("Failed to send auto mail to '" + emailAddr + "' using '" + this.smtpServer + "': " + e);
        }
        this.userMailStatus.put(target, new Long(now));
    }
}

