/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CardServProxy;
import com.bowman.cardserv.ListenPort;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.interfaces.CamdMessageListener;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.session.SessionManager;
import com.bowman.cardserv.util.CustomFormatter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.net.SocketException;

class AcceptThread
extends Thread {
    private CamdMessageListener listener;
    private ListenPort listenPort;
    private static final String SESSION_PKG = "com.bowman.cardserv.session";

    public AcceptThread(CamdMessageListener listener, ListenPort listenPort) {
        super("AcceptThread[" + listenPort.getProfile().getName() + ":" + listenPort + "]");
        this.listener = listener;
        this.listenPort = listenPort;
    }

    public void run() {
        while (this.listenPort.isAlive()) {
            try {
                Socket s = this.listenPort.getServerSocket().accept();
                String ip = s.getInetAddress().getHostAddress();
                int maxThreads = ProxyConfig.getInstance().getMaxThreads();
                if (Thread.activeCount() > maxThreads) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    CardServProxy.logger.severe("Max-threads exceeded (" + maxThreads + "), closing incoming connection for [" + this.listenPort.getProfile().getName() + ":" + this.listenPort + "]: " + CustomFormatter.formatAddress(ip));
                    s.close();
                    continue;
                }
                if (!this.listenPort.isAllowed(ip) || this.listenPort.isDenied(ip)) {
                    CardServProxy.logger.fine("Rejected connection for [" + this.listenPort.getProfile().getName() + ":" + this.listenPort + "]: " + CustomFormatter.formatAddress(ip) + " not allowed.");
                    SessionManager.getInstance().fireUserLoginFailed("?@" + ip, this.listenPort + "/" + this.listenPort.getProfile().getName(), ip, "rejected by [" + this.listenPort + "] ip deny list.");
                    s.close();
                    continue;
                }
                CardServProxy.logger.fine("Accepted connection for [" + this.listenPort.getProfile().getName() + ":" + this.listenPort + "]: " + CustomFormatter.formatAddress(ip));
                ProxySession ps = AcceptThread.createSession(s, this.listenPort, this.listener);
                if (ps == null) {
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (ProxyConfig.getInstance().getRemoteHandler() == null) continue;
                ps.addTransactionListener(ProxyConfig.getInstance().getRemoteHandler());
            }
            catch (SocketException e) {
                CardServProxy.logger.throwing("Server socket closed: " + this.listenPort + " (" + e.getMessage() + ")", e);
                this.listenPort.destroy();
            }
            catch (IOException e) {
                CardServProxy.logger.severe("Exception accepting socket connection for [" + this.listenPort + "], aborting...", e);
                this.listenPort.destroy();
            }
            catch (Throwable t) {
                CardServProxy.logger.severe("Error in accept loop: " + t, t);
                return;
            }
        }
    }

    private static ProxySession createSession(Socket s, ListenPort listenPort, CamdMessageListener listener) throws IOException {
        try {
            Class<?> sessionClass = Class.forName("com.bowman.cardserv.session." + listenPort.getProtocol() + "Session");
            Constructor<?> c = sessionClass.getConstructor(Socket.class, ListenPort.class, CamdMessageListener.class);
            Object o = c.newInstance(s, listenPort, listener);
            if (!(o instanceof ProxySession)) {
                throw new IOException("Session class not instanceof ProxySession: " + sessionClass);
            }
            return (ProxySession)o;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            if (e.getCause() != null) {
                CardServProxy.logger.severe("Exception creating session: " + e.getCause(), e.getCause());
            } else {
                CardServProxy.logger.severe("Exception creating session: " + e, e);
            }
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (e.getCause() != null) {
                e = e.getCause();
            }
            CardServProxy.logger.severe("Unable to create session: " + e, e);
            try {
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException(e.toString());
        }
    }
}

