/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.SimpleUserManager;
import com.bowman.cardserv.XmlUserManager;
import com.bowman.cardserv.util.ProxyXmlConfig;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class AdvXmlUserManager
extends XmlUserManager {
    static final SimpleDateFormat fmt = new SimpleDateFormat("dd-MM-yyyy");

    protected SimpleUserManager.UserEntry parseUser(ProxyXmlConfig xml) throws ConfigException {
        StringTokenizer st;
        AdvUserEntry aue = new AdvUserEntry(super.parseUser(xml));
        String edStr = null;
        try {
            edStr = xml.getStringValue("expire-date");
            aue.expireDate = fmt.parse(edStr).getTime();
        }
        catch (ConfigException e) {
            aue.expireDate = -1L;
        }
        catch (ParseException e) {
            throw new ConfigException("Bad expire-date for user '" + aue.name + "': " + edStr + " (expected dd-mm-yyyy)");
        }
        String sdStr = null;
        try {
            sdStr = xml.getStringValue("start-date");
            aue.startDate = fmt.parse(sdStr).getTime();
        }
        catch (ConfigException e) {
            aue.startDate = -1L;
        }
        catch (ParseException e) {
            throw new ConfigException("Bad start-date for user '" + aue.name + "': " + sdStr + " (expected dd-mm-yyyy)");
        }
        if (aue.startDate != -1L && aue.expireDate != -1L && aue.startDate > aue.expireDate) {
            throw new ConfigException("User '" + aue.name + "' start-date must be before expire-date.");
        }
        try {
            aue.ecmRate = xml.getIntValue("ecm-rate");
        }
        catch (ConfigException e) {
            aue.ecmRate = -1;
        }
        try {
            aue.displayName = xml.getStringValue("display-name");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        try {
            String allowedServices = xml.getStringValue("allowedServices");
            st = new StringTokenizer(allowedServices);
            while (st.hasMoreTokens()) {
                aue.allowedServices.add(st.nextToken());
            }
        }
        catch (ConfigException allowedServices) {
            // empty catch block
        }
        try {
            String blockedServices = xml.getStringValue("blockedServices");
            st = new StringTokenizer(blockedServices);
            while (st.hasMoreTokens()) {
                aue.blockedServices.add(st.nextToken());
            }
        }
        catch (ConfigException blockedServices) {
            // empty catch block
        }
        try {
            String allowedConnectors = xml.getStringValue("allowedConnectors");
            st = new StringTokenizer(allowedConnectors);
            while (st.hasMoreTokens()) {
                aue.allowedConnectors.add(st.nextToken());
            }
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        return aue;
    }

    public boolean isEnabled(String user) {
        if (super.isEnabled(user)) {
            AdvUserEntry entry = (AdvUserEntry)this.getUser(user);
            if (entry == null) {
                return true;
            }
            if (entry.startDate == -1L && entry.expireDate == -1L) {
                return true;
            }
            long now = System.currentTimeMillis();
            if (now < entry.startDate) {
                return false;
            }
            return now <= entry.expireDate;
        }
        return false;
    }

    public Set getAllowedServices(String user, String profile) {
        HashSet<Integer> result = new HashSet<Integer>();
        AdvUserEntry entry = (AdvUserEntry)this.getUser(user);
        if (entry != null && entry.allowedServices.isEmpty()) {
            entry = (AdvUserEntry)this.defaultUser;
        }
        if (entry != null && !entry.allowedServices.isEmpty()) {
            Iterator iterator = entry.allowedServices.iterator();
            while (iterator.hasNext()) {
                String service = (String)iterator.next();
                if (!service.matches("^" + profile + ":[a-zA-Z0-9]*")) continue;
                result.add(new Integer(Integer.parseInt(service.replace(profile + ":", ""), 16)));
            }
        } else {
            result = null;
        }
        return result;
    }

    public Set getBlockedServices(String user, String profile) {
        HashSet<Integer> result = new HashSet<Integer>();
        AdvUserEntry entry = (AdvUserEntry)this.getUser(user);
        if (entry != null && entry.blockedServices.isEmpty()) {
            entry = (AdvUserEntry)this.defaultUser;
        }
        if (entry != null && !entry.blockedServices.isEmpty()) {
            Iterator iterator = entry.blockedServices.iterator();
            while (iterator.hasNext()) {
                String service = (String)iterator.next();
                if (!service.matches("^" + profile + ":[a-zA-Z0-9]*")) continue;
                result.add(new Integer(Integer.parseInt(service.replace(profile + ":", ""), 16)));
            }
        } else {
            result = null;
        }
        return result;
    }

    public Set getAllowedConnectors(String user) {
        AdvUserEntry entry = (AdvUserEntry)this.getUser(user);
        if (entry != null && entry.allowedConnectors.isEmpty()) {
            entry = (AdvUserEntry)this.defaultUser;
        }
        if (entry != null && !entry.allowedConnectors.isEmpty()) {
            return entry.allowedConnectors;
        }
        return null;
    }

    public int getAllowedEcmRate(String user) {
        AdvUserEntry entry = (AdvUserEntry)this.getUser(user);
        if (entry == null) {
            return -1;
        }
        return entry.ecmRate;
    }

    static class AdvUserEntry
    extends SimpleUserManager.UserEntry {
        int ecmRate;
        long startDate;
        long expireDate;
        Set allowedServices = new HashSet();
        Set blockedServices = new HashSet();
        Set allowedConnectors = new HashSet();

        public AdvUserEntry(SimpleUserManager.UserEntry ue) {
            super(ue.name, ue.password, ue.ipMask, ue.email, ue.maxConnections, ue.enabled, ue.admin, ue.exclude, ue.debug);
            this.profiles = ue.profiles;
        }
    }
}

