/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.ListenPort;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.cws.ConnectorSelection;
import com.bowman.cardserv.cws.CwsConnectorManager;
import com.bowman.cardserv.cws.ServiceMapping;
import com.bowman.cardserv.interfaces.CacheHandler;
import com.bowman.cardserv.interfaces.CamdMessageListener;
import com.bowman.cardserv.interfaces.CwsConnector;
import com.bowman.cardserv.interfaces.CwsSelector;
import com.bowman.cardserv.interfaces.ProxyPlugin;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.interfaces.UserManager;
import com.bowman.cardserv.interfaces.XmlConfigurable;
import com.bowman.cardserv.rmi.IpCheckServerSocket;
import com.bowman.cardserv.rmi.IpCheckSocketFactory;
import com.bowman.cardserv.rmi.RemoteHandler;
import com.bowman.cardserv.session.NewcamdSession;
import com.bowman.cardserv.session.SessionManager;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.cardserv.util.TimedAverageList;
import com.bowman.cardserv.web.WebBackend;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RMISecurityManager;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class CardServProxy
implements CamdMessageListener,
XmlConfigurable,
Runnable {
    public static final String APP_VERSION = "0.9.0";
    public static String APP_BUILD = "";
    static ProxyLogger logger;
    private static Registry registry;
    private ProxyConfig config;
    private CwsConnectorManager connManager;
    private UserManager userManager;
    private CacheHandler cacheHandler;
    private RemoteHandler remoteHandler;
    private WebBackend webBackend;
    private SessionManager sessionManager;
    private String remoteName;
    private long startTimeStamp;
    private boolean alive;
    private int ecmCount;
    private int ecmForwards;
    private int ecmCacheHits;
    private int ecmFailures;
    private int ecmDenied;
    private int ecmFiltered;
    private int emmCount;
    private TimedAverageList ecmRate = new TimedAverageList(10);
    private List broadcastQueue = new ArrayList();

    public CardServProxy(File cfgFile) throws FileNotFoundException, ConfigException {
        this.config = ProxyConfig.getInstance();
        this.config.readConfig(this, cfgFile);
        new Thread((Runnable)this, "CwsProbeThread").start();
    }

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        ProxyXmlConfig rmi;
        ProxyLogger.initFormatter(this.config.isDebug(), this.config.isHideIPs());
        if (logger != null) {
            logger.close();
        } else {
            ProxyLogger.initConsole(this.config.getLogLevel());
        }
        try {
            logger = ProxyLogger.getFileLogger("com.bowman.cardserv", new File(this.config.getLogFile()), this.config.getLogLevel(), this.config.getLogRotateCount(), this.config.getLogRotateLimit(), false);
        }
        catch (IOException e) {
            throw new ConfigException(xml.getFullName(), "log-file", "Unable to initialize logger FileHandler: " + e, e);
        }
        logger.setSilent(this.config.isSilent());
        try {
            rmi = xml.getSubConfig("rmi");
        }
        catch (ConfigException e) {
            rmi = null;
        }
        this.updateRmi(rmi);
        this.config.setRemoteHandler(this.remoteHandler);
        logger.fine("Configuration updated");
    }

    private void updateRmi(ProxyXmlConfig rmiConfig) throws ConfigException {
        if (rmiConfig != null && "true".equalsIgnoreCase(rmiConfig.getStringValue("enabled", "true"))) {
            System.setSecurityManager(new RMISecurityManager());
            try {
                IpCheckServerSocket.clearIpMasks();
                String[] allowedIps = rmiConfig.getStringValue("allowed-ip-masks").split(" ");
                for (int i = 0; i < allowedIps.length; ++i) {
                    IpCheckServerSocket.addIpMask(allowedIps[i]);
                }
            }
            catch (ConfigException allowedIps) {
                // empty catch block
            }
            InetAddress bindAddr = null;
            String bindIp = null;
            try {
                bindIp = rmiConfig.getStringValue("bind-ip");
                bindAddr = InetAddress.getByName(bindIp);
            }
            catch (ConfigException configException) {
            }
            catch (UnknownHostException e) {
                throw new ConfigException(rmiConfig.getFullName(), "bind-ip", "Invalid rmi bind-ip: " + bindIp);
            }
            IpCheckServerSocket.setBindAddress(bindAddr);
            try {
                if (registry == null) {
                    registry = LocateRegistry.createRegistry(rmiConfig.getPortValue("registry-port", 4099));
                }
                if (this.remoteHandler == null) {
                    this.remoteHandler = new RemoteHandler(rmiConfig.getPortValue("local-port", 4098), this);
                }
                this.remoteHandler.setName(rmiConfig.getStringValue("display-name"));
                this.remoteName = rmiConfig.getStringValue("local-name", "cardservproxy");
                registry.rebind(this.remoteName, this.remoteHandler);
            }
            catch (IOException e) {
                throw new ConfigException(rmiConfig.getFullName(), "Unable to initialize rmi: " + e, e);
            }
            ProxyXmlConfig webConfig = rmiConfig.getSubConfig("status-web");
            if (webConfig != null) {
                if ("true".equalsIgnoreCase(webConfig.getStringValue("enabled", "true"))) {
                    if (this.webBackend == null) {
                        this.webBackend = new WebBackend(this.remoteHandler);
                    }
                    this.webBackend.configUpdated(webConfig);
                } else if (this.webBackend != null) {
                    this.webBackend.stop();
                }
            }
        } else {
            try {
                if (registry != null && this.remoteName != null) {
                    registry.unbind(this.remoteName);
                }
            }
            catch (Exception e) {
                logger.throwing(e);
            }
            if (this.remoteHandler != null) {
                this.remoteHandler.destroy();
            }
            this.remoteHandler = null;
        }
        this.startPlugins();
    }

    private void startPlugins() {
        Iterator iter = this.config.getProxyPlugins().values().iterator();
        while (iter.hasNext()) {
            ProxyPlugin plugin = (ProxyPlugin)iter.next();
            try {
                logger.info("Starting plugin: " + plugin.getName() + " - " + plugin.getDescription());
                plugin.start(this);
            }
            catch (Throwable t) {
                logger.severe("Exception starting plugin '" + plugin.getClass().getName() + "': " + t, t);
            }
        }
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    public void init() throws IOException, InterruptedException {
        this.startTimeStamp = System.currentTimeMillis();
        logger.info("-= CardServProxy 0.9.0" + APP_BUILD + " initialized =-");
        logger.fine("CA-Profiles: ");
        Iterator iter = this.config.getProfiles().values().iterator();
        while (iter.hasNext()) {
            CaProfile cp = (CaProfile)iter.next();
            long wait = this.config.getCacheHandler().getMaxCacheWait(this.config.getConnManager().getMaxCwWait(cp));
            logger.fine("  - " + cp + (cp != CaProfile.MULTIPLE ? " (cache wait: " + wait + ")" : ""));
        }
        logger.fine("Connectors: ");
        iter = this.config.getConnManager().getConnectors().values().iterator();
        while (iter.hasNext()) {
            logger.fine("  - " + iter.next());
        }
        logger.fine("User-Manager: " + this.config.getUserManager().getClass().getName());
        logger.fine("Cache-Handler: " + this.config.getCacheHandler().getClass().getName());
        logger.fine("Plugins: " + this.config.getProxyPlugins());
        logger.fine("Services: " + this.config.getServiceCount() + " parsed");
        CaProfile[] profiles = this.openPorts();
        if (this.remoteHandler != null) {
            this.remoteHandler.start();
        }
        this.cacheHandler = this.config.getCacheHandler();
        this.cacheHandler.start();
        this.connManager = this.config.getConnManager();
        this.connManager.start();
        this.userManager = this.config.getUserManager();
        this.userManager.start();
        this.sessionManager = SessionManager.getInstance();
        if (this.webBackend != null) {
            this.webBackend.start();
        }
        logger.info("Waiting for connection manager to finish one cycle...");
        while (!this.connManager.isReady()) {
            Thread.sleep(500L);
        }
        logger.info("Ready. Receiving connections...");
        this.startListening(profiles);
    }

    private CaProfile[] openPorts() throws IOException {
        Set set = this.config.getRealProfiles();
        CaProfile[] profiles = set.toArray(new CaProfile[set.size()]);
        ArrayList<String> portList = new ArrayList<String>();
        for (int i = 0; i < profiles.length; ++i) {
            ListenPort lp = null;
            try {
                if (profiles[i].getServiceConflicts() > 0) {
                    logger.warning("Service conflict(s) for Ca[" + profiles[i].getName() + "]: " + profiles[i].getServiceConflicts());
                }
                Iterator iter = profiles[i].getListenPorts().iterator();
                while (iter.hasNext()) {
                    lp = (ListenPort)iter.next();
                    lp.createServerSocket();
                    portList.add(lp.toString());
                }
                continue;
            }
            catch (IOException e) {
                logger.severe("Failed to open listen port [" + lp + "] for '" + profiles[i].getName() + "' (" + e.getMessage() + ")", e);
                throw e;
            }
        }
        Collections.sort(portList);
        logger.info("Listening on: " + portList);
        return profiles;
    }

    private void startListening(CaProfile[] profiles) {
        this.setAlive(true);
        for (int i = 0; i < profiles.length; ++i) {
            profiles[i].startListening(this);
        }
        this.config.setDefaultMsgListener(this);
    }

    public static void main(String[] args) {
        if (!"true".equalsIgnoreCase(System.getProperty("com.bowman.cardserv.allowanyjvm"))) {
            boolean start = true;
            String vendorUrl = System.getProperty("java.vendor.url");
            String vmName = System.getProperty("java.vm.name");
            if (vendorUrl != null && !vendorUrl.startsWith("http://java.sun.com")) {
                start = false;
            }
            if (vendorUrl.startsWith("http://java.oracle.com/")) {
                start = true;
            }
            if (vmName != null && vmName.startsWith("OpenJDK")) {
                start = false;
            }
            if (!start) {
                System.err.println("Startup failed: Unsupported java vm '" + System.getProperty("java.vm.name") + "', only the original sun vm has been tested with csp.");
                System.exit(5);
            }
        }
        File cfgFile = null;
        if (args.length > 0) {
            cfgFile = new File(args[0]);
        }
        try {
            new CardServProxy(cfgFile).init();
        }
        catch (FileNotFoundException e) {
            System.err.println("Configuration file not found: " + e.getMessage());
            System.exit(1);
        }
        catch (ConfigException e) {
            System.err.println("Configuration error:");
            if (e.getLabel() != null) {
                if (e.getLabel().indexOf(32) == -1) {
                    System.err.println("- Element: <" + e.getLabel() + ">");
                } else {
                    System.err.println("- Element: <" + e.getLabel());
                    if (e.getSubLabel() != null) {
                        System.err.println("- Attribute: " + e.getSubLabel());
                    }
                }
            }
            System.err.println("- Message: " + e.getMessage());
            System.exit(2);
        }
        catch (IOException e) {
            System.err.println("Failed to open listen port: " + e.getMessage());
            System.exit(3);
        }
        catch (InterruptedException e) {
            System.err.println("Startup aborted: " + e);
            System.exit(4);
        }
    }

    private CamdNetMessage applyFilters(ProxySession session, CamdNetMessage msg) {
        Iterator iter = new ArrayList(this.config.getProxyPlugins().values()).iterator();
        while (iter.hasNext()) {
            try {
                msg = ((ProxyPlugin)iter.next()).doFilter(session, msg);
                if (msg != null) continue;
                break;
            }
            catch (Throwable t) {
                logger.severe("Exception in plugin filtering: " + t, t);
            }
        }
        if (msg != null && msg.getFilteredBy() != null && (this.config.isLogEcm() || this.userManager.isDebug(session.getUser()))) {
            logger.info("ECM " + msg.hashCodeStr() + " (0x" + Integer.toHexString(msg.getDataLength()) + " " + DESUtil.intToHexString(msg.getNetworkId(), 4) + " " + DESUtil.intToHexString(msg.getCaId(), 4) + ") " + (msg.getProviderIdent() < 0 ? "" : "[" + DESUtil.intToByteString(msg.getProviderIdent(), 3) + "]") + " - " + session + "[" + this.config.getServiceName(msg) + "] -> " + msg.getFilteredBy());
        }
        return msg;
    }

    private Set applySelectors(ProxySession session, CamdNetMessage msg, Set connectors) {
        Iterator iter = new ArrayList(this.config.getProxyPlugins().values()).iterator();
        while (iter.hasNext()) {
            try {
                ProxyPlugin plugin = (ProxyPlugin)iter.next();
                if (plugin instanceof CwsSelector) {
                    connectors = ((CwsSelector)((Object)plugin)).doSelection(session, msg, connectors);
                }
                if (connectors != null && !connectors.isEmpty()) continue;
                break;
            }
            catch (Throwable t) {
                logger.severe("Exception in plugin connector selection: " + t, t);
            }
        }
        return connectors;
    }

    public void messageReceived(ProxySession session, CamdNetMessage msg) {
        if ((msg = this.applyFilters(session, msg)) == null || msg.isFiltered()) {
            if (msg.isEcm()) {
                ++this.ecmFiltered;
                ++this.ecmCount;
            }
            return;
        }
        CaProfile profile = session.getProfile();
        if (msg.isEcm() || msg.isEmm()) {
            if (profile == CaProfile.MULTIPLE) {
                profile = this.config.getProfileById(msg.getNetworkId(), msg.getCaId());
                if (profile == null) {
                    if (msg.getNetworkId() == -1) {
                        logger.warning("Denying multi-context message without network id from: " + session);
                    } else {
                        logger.warning("Denying csp message with unknown network-id from '" + session + "': " + DESUtil.intToHexString(msg.getNetworkId(), 4));
                    }
                    this.denyMessage(session, msg);
                    return;
                }
                if (msg.getNetworkId() == -1) {
                    msg.setNetworkId(profile.getNetworkId());
                }
            } else if (msg.getNetworkId() != profile.getNetworkId() && (profile = this.config.getProfileById(msg.getNetworkId(), msg.getCaId())) == null) {
                profile = session.getProfile();
            }
            msg.setProfileName(profile.getName());
        }
        switch (msg.getCommandTag()) {
            case 214: 
            case 224: 
            case 227: 
            case 253: {
                break;
            }
            case 128: 
            case 129: {
                ConnectorSelection connectors;
                ++this.ecmCount;
                this.ecmRate.addRecord(1);
                HashSet allowed = session.getAllowedConnectors();
                if (allowed == null || allowed.isEmpty()) {
                    allowed = new HashSet(this.connManager.getReadyConnectors(profile.getName()).keySet());
                    allowed.addAll(this.connManager.getMultiConnectors(profile.getNetworkId(), profile.getCaId()).keySet());
                }
                Set modified = this.applySelectors(session, msg, allowed);
                logger.finer("Allowed connectors '" + modified + "' for: " + msg.hashCodeStr());
                modified = this.filterConnectors(msg, modified);
                if (modified.isEmpty() && !profile.isCacheOnly() && !this.config.isCatchAll() && !this.cacheHandler.containsCaid(msg.getCaId())) {
                    logger.fine("Denying message with no connector candidates from '" + session + "': " + msg.hashCodeStr());
                    this.denyMessage(session, msg);
                    return;
                }
                ServiceMapping id = new ServiceMapping(msg);
                if (!profile.isCacheOnly()) {
                    connectors = this.connManager.getConnectorsForService(profile.getName(), id, modified);
                    if (msg.getCustomId() != 0 && connectors.isEmpty()) {
                        msg.setFilteredBy("No available connectors for cid: " + DESUtil.intToHexString(msg.getCustomId(), 4));
                        session.setFlag(msg, 'B');
                        session.sendEcmReply(msg, msg.getEmptyReply());
                        ++this.ecmFiltered;
                        return;
                    }
                } else {
                    connectors = ConnectorSelection.EMPTY;
                }
                int successFactor = -1;
                CwsConnector cws = connectors.getPrimary();
                if (cws != null) {
                    Boolean status = this.connManager.canDecode(cws, id);
                    successFactor = cws.getEstimatedQueueTime();
                    if (successFactor < 5 && successFactor != -1) {
                        successFactor = -1;
                    } else {
                        if (cws.getTimeoutCount() > 0) {
                            successFactor *= 3;
                        }
                        if (status == null || id.serviceId == 0) {
                            successFactor *= 3;
                        } else if (status == Boolean.FALSE) {
                            successFactor = -1;
                        }
                    }
                }
                CamdNetMessage cached = this.checkCache(successFactor, msg, session, false);
                if (!session.isConnected()) {
                    return;
                }
                if (cached != null) {
                    this.probeConnectors(connectors.getUnknown(), session, msg);
                    session.sendEcmReply(msg, cached);
                    break;
                }
                if (msg.isTimeOut() && cws != null) {
                    int qt = cws.getEstimatedQueueTime();
                    if (msg.getCacheTime() + (long)qt > this.connManager.getMaxCwWait(profile)) {
                        logger.warning("Cache timeout at " + msg.getCacheTime() + " ms left no time for forwarding to '" + cws.getName() + "' (" + qt + " ms queue), discarding request and returning empty for: " + session + " - max-cw-wait is " + this.connManager.getMaxCwWait(profile) + " ms");
                        session.setFlag(msg, 'T');
                        session.sendEcmReply(msg, msg.getEmptyReply());
                        return;
                    }
                }
                try {
                    this.forwardEcmRequest(profile, session, msg, connectors);
                    break;
                }
                catch (IllegalStateException e) {
                    if (!session.isConnected()) {
                        return;
                    }
                    logger.fine("Duplicate request in connector queue '" + e.getMessage() + "' for:" + msg + " (" + session + ") - sleeping 200 and rechecking once...");
                    try {
                        Thread.sleep(200L);
                        cached = this.checkCache(successFactor, msg, session, false);
                        if (cached == null) {
                            cached = msg.getEmptyReply();
                            session.setFlag(msg, 'H');
                        }
                        session.sendEcmReply(msg, cached);
                        break;
                    }
                    catch (InterruptedException e1) {
                        return;
                    }
                }
            }
            default: {
                if (msg.isEmm()) {
                    ++this.emmCount;
                    int seqNr = msg.getSequenceNr();
                    if (!profile.isCacheOnly() && msg.getProfileName() != null) {
                        this.forwardEmmRequest(session, msg);
                    }
                    CamdNetMessage emmReplyMsg = msg.getEmmReply();
                    ((NewcamdSession)session).sendMessageNative(emmReplyMsg, seqNr, true);
                    ((NewcamdSession)session).fireCamdMessage(emmReplyMsg, true);
                    break;
                }
                logger.warning("Unknown message received and ignored: " + msg + " (" + session + ")");
            }
        }
    }

    private Set filterConnectors(CamdNetMessage msg, Set modified) {
        int count = modified.size();
        HashSet<String> set = new HashSet<String>();
        Iterator iter = new ArrayList(modified).iterator();
        while (iter.hasNext()) {
            String cwsName = (String)iter.next();
            CwsConnector cws = this.connManager.getCwsConnectorByName(cwsName);
            if (cws.isBlackListed(msg)) {
                if (count <= 1) continue;
                modified.remove(cwsName);
                set.add(cwsName);
                continue;
            }
            if (cws.canDecode(msg)) continue;
            modified.remove(cwsName);
            set.add(cwsName);
        }
        if (!set.isEmpty()) {
            logger.fine("Blacklisting/filtering removed allowed connector(s) " + set + " for: " + msg.hashCodeStr() + " [" + DESUtil.intToHexString(msg.getServiceId(), 4) + " " + DESUtil.intToHexString(msg.getCaId(), 4) + " - " + DESUtil.intToByteString(msg.getProviderIdent(), 3) + "]");
        }
        return modified;
    }

    private CamdNetMessage checkCache(int successFactor, CamdNetMessage msg, ProxySession session, boolean peek) {
        CamdNetMessage cached;
        CaProfile profile = this.config.getProfile(msg.getProfileName());
        if (!peek) {
            if (msg.getServiceId() == 0 && this.connManager.getDelayNoSid() > 0L) {
                try {
                    Thread.sleep(this.connManager.getDelayNoSid());
                }
                catch (InterruptedException e) {
                    session.setFlag(msg, 'U');
                    logger.warning(session + " thread interrupted while in no-sid-delay, session closed?");
                    return null;
                }
            }
            cached = this.cacheHandler.processRequest(successFactor, msg, session.getProfile().isCacheOnly() || this.config.isCatchAll(), this.connManager.getMaxCwWait(profile));
        } else {
            cached = this.cacheHandler.peekReply(msg);
            if (cached != null) {
                session.setFlag(msg, 'W');
            }
        }
        if (cached != null) {
            ++this.ecmCacheHits;
            if (msg.getLinkedService() != null) {
                session.setFlag(msg, 'L');
            }
            session.setFlag(msg, cached.getOriginAddress() == null ? (char)'C' : 'R');
            if (this.config.isLogEcm() || this.userManager.isDebug(session.getUser())) {
                String origin = cached.getOriginAddress() == null ? "" : " - (remote origin)";
                logger.info("ECM cache hit for   - " + session + ": " + msg.hashCodeStr() + " [" + this.config.getServiceName(msg) + "]" + origin);
            }
            this.sessionManager.updateUserStatus(session, msg, this.userManager.isDebug(session.getUser()));
        } else if (msg.isTimeOut()) {
            if (msg.getCacheTime() >= this.cacheHandler.getMaxCacheWait(this.connManager.getMaxCwWait(profile))) {
                session.setFlag(msg, 'O');
            } else {
                session.setFlag(msg, 'Q');
            }
        }
        return cached;
    }

    private void forwardEcmRequest(CaProfile profile, ProxySession session, CamdNetMessage msg, ConnectorSelection connectors) {
        CwsConnector cws = connectors.getPrimary();
        this.probeConnectors(connectors.getUnknown(), session, msg);
        if (connectors.getSecondary() != null) {
            session.setFlag(msg, '2');
            this.broadcastMessage(msg, connectors.getSecondary(), false);
        }
        if (cws != null) {
            if (this.config.isLogEcm() || this.userManager.isDebug(session.getUser())) {
                logger.info("ECM " + msg.hashCodeStr() + " (0x" + Integer.toHexString(msg.getDataLength()) + " " + DESUtil.intToHexString(msg.getNetworkId(), 4) + " " + DESUtil.intToHexString(msg.getCaId(), 4) + ") " + (msg.getProviderIdent() < 0 ? "" : "[" + DESUtil.intToByteString(msg.getProviderIdent(), 3) + "]") + " - " + session + "[" + this.config.getServiceName(msg) + "] -> " + cws.getLabel());
            }
            if (!cws.sendEcmRequest(msg, session)) {
                ++this.ecmFailures;
                if ((long)session.getTransactionTime() >= this.connManager.getMaxCwWait(profile)) {
                    session.setFlag(msg, 'S');
                    session.sendEcmReply(msg, msg.getEmptyReply());
                    logger.warning(session + " transaction timeout in send queue, returned empty...");
                } else {
                    if (!session.isConnected()) {
                        return;
                    }
                    logger.warning(session + " lost card? Trying another in 100 ms...");
                    session.setFlag(msg, 'Y');
                    try {
                        Thread.sleep(100L);
                        this.forwardEcmRequest(profile, session, msg, this.connManager.getConnectorsForService(profile.getName(), new ServiceMapping(msg), session.getAllowedConnectors()));
                    }
                    catch (InterruptedException e) {
                        logger.throwing(e);
                    }
                }
            } else {
                ++this.ecmForwards;
                session.setFlag(msg, 'F');
                this.sessionManager.updateUserStatus(session, msg, this.userManager.isDebug(session.getUser()));
            }
        } else {
            if (!profile.isCacheOnly() && this.connManager.getCannotDecodeWait() > 0L) {
                try {
                    Thread.sleep(this.connManager.getCannotDecodeWait() * 1000L);
                }
                catch (InterruptedException e) {
                    logger.throwing(e);
                }
                CamdNetMessage cached = this.checkCache(-1, msg, session, true);
                if (cached != null) {
                    session.sendEcmReply(msg, cached);
                    logger.fine("Session " + session + " received cache-reply after cannot-decode-wait for: [ " + this.config.getServiceName(profile.getName(), msg.getServiceId()) + "]");
                    return;
                }
            }
            logger.fine("Session " + session + " has no available card for [" + this.config.getServiceName(msg) + "], sending empty...");
            this.cacheHandler.processReply(msg, null);
            this.denyMessage(session, msg);
        }
    }

    private void denyMessage(ProxySession session, CamdNetMessage msg) {
        session.setFlag(msg, 'N');
        ++this.ecmDenied;
        this.sessionManager.updateUserStatus(session, msg, this.userManager.isDebug(session.getUser()));
        session.sendEcmReply(msg, msg.getEmptyReply());
    }

    private void forwardEmmRequest(ProxySession session, CamdNetMessage msg) {
        CwsConnector cws = this.connManager.getConnectorForAU(msg.getProfileName(), session.getUser());
        if (cws != null) {
            cws.sendMessage(msg);
            if (this.config.isLogEmm() || this.userManager.isDebug(session.getUser())) {
                logger.info("EMM " + msg.hashCodeStr() + " (0x" + Integer.toHexString(msg.getDataLength()) + ", 0x" + Integer.toHexString(msg.getUpperBits()) + ") from " + session + " -> " + cws.getName());
            }
        } else if (this.config.isLogEmm() || this.userManager.isDebug(session.getUser())) {
            logger.info("EMM " + msg.hashCodeStr() + " (0x" + Integer.toHexString(msg.getDataLength()) + ", 0x" + Integer.toHexString(msg.getUpperBits()) + ") from " + session);
        }
    }

    private void probeConnectors(List candidates, ProxySession session, CamdNetMessage msg) {
        if (candidates != null && !this.userManager.isMapExcluded(session.getUser())) {
            session.setFlag(msg, 'P');
            msg.setOriginAddress(session.toString());
            this.broadcastMessage(msg, candidates, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastMessage(CamdNetMessage msg, List connectors, boolean probe) {
        this.broadcastQueue.add(new BroadcastEntry(msg, connectors, probe));
        if (!this.broadcastQueue.isEmpty()) {
            CardServProxy cardServProxy = this;
            synchronized (cardServProxy) {
                this.notifyAll();
            }
        }
    }

    public void messageSent(ProxySession session, CamdNetMessage msg) {
        if (msg.isEcm() && (this.config.isLogEcm() || this.userManager.isDebug(session.getUser())) && !msg.isFiltered()) {
            logger.info("CW  " + msg.hashCodeStr() + " (0x" + Integer.toHexString(msg.getDataLength()) + ") - [" + session.getLastTransactionTime() + ":" + session.getLastTransactionFlags() + "] -> " + session);
        }
        this.applyFilters(session, msg);
    }

    public int getEcmCount() {
        return this.ecmCount;
    }

    public int getEcmForwards() {
        return this.ecmForwards;
    }

    public int getEcmCacheHits() {
        return this.ecmCacheHits;
    }

    public int getEcmFailures() {
        return this.ecmFailures;
    }

    public int getEcmDenied() {
        return this.ecmDenied;
    }

    public int getEcmFiltered() {
        return this.ecmFiltered;
    }

    public int getEcmRate() {
        double rate = (double)this.ecmRate.getTotal(true) / 10.0;
        return (int)Math.round(rate);
    }

    public int getEmmCount() {
        return this.emmCount;
    }

    public long getStartTime() {
        return this.startTimeStamp;
    }

    public RemoteHandler getRemoteHandler() {
        return this.remoteHandler;
    }

    public CacheHandler getCacheHandler() {
        return this.cacheHandler;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public CwsConnectorManager getConnManager() {
        return this.connManager;
    }

    public WebBackend getWebBackend() {
        return this.webBackend;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public int getProbeQueue() {
        return this.broadcastQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            CardServProxy cardServProxy = this;
            synchronized (cardServProxy) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            try {
                Iterator iter = new ArrayList(this.broadcastQueue).iterator();
                while (iter.hasNext()) {
                    BroadcastEntry entry = (BroadcastEntry)iter.next();
                    if (entry == null) continue;
                    this.broadcastQueue.remove(entry);
                    ServiceMapping id = new ServiceMapping(entry.msg);
                    Iterator i = entry.connectors.iterator();
                    while (i.hasNext()) {
                        CwsConnector conn = (CwsConnector)i.next();
                        if (!conn.isReady()) continue;
                        if (entry.probe) {
                            if (this.connManager.canDecode(conn, id) != null || (long)conn.getEstimatedQueueTime() >= this.connManager.getMaxCwWait(null) / 2L || conn.isPending(entry.msg) || !conn.canDecode(entry.msg)) continue;
                            try {
                                if (!conn.sendEcmRequest(new CamdNetMessage(entry.msg), null) || entry.msg.getServiceId() == 0) continue;
                                logger.info("Probing " + conn.getLabel() + " for service [" + this.config.getServiceName(entry.msg) + "] ...");
                            }
                            catch (IllegalStateException e) {
                                logger.fine("Skipping probe for " + entry.msg.hashCodeStr() + ", request already in connector queue: " + conn.getName());
                            }
                            continue;
                        }
                        if ((long)conn.getEstimatedQueueTime() >= this.connManager.getMaxCwWait(null) / 2L || conn.isPending(entry.msg) || !conn.canDecode(entry.msg)) continue;
                        try {
                            if (!conn.sendEcmRequest(new CamdNetMessage(entry.msg), null)) continue;
                            if (!this.connManager.isServiceUnknown(entry.msg.getProfileName(), entry.msg.getServiceId())) {
                                logger.fine("Redundant forward to " + conn.getLabel() + " for service [" + this.config.getServiceName(entry.msg) + "] ...");
                                continue;
                            }
                            logger.fine("Broadcasting " + entry.msg.hashCodeStr() + " with unknown service to " + conn.getLabel() + "...");
                        }
                        catch (IllegalStateException e) {
                            logger.fine("Skipping broadcast for " + entry.msg.hashCodeStr() + ", request already in connector queue: " + conn.getName());
                        }
                    }
                }
                if (this.alive) continue;
            }
            catch (Exception e) {
                logger.severe("Uncaught exception in broadcast loop: " + e, e);
                continue;
            }
            break;
        }
    }

    static {
        System.setProperty("java.security.policy", "etc/policy.all");
        try {
            RMISocketFactory.setSocketFactory(new IpCheckSocketFactory());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            Properties props = new Properties();
            props.load(CardServProxy.class.getResourceAsStream("build.properties"));
            String svnRev = props.getProperty("svn.revision");
            if (svnRev != null && svnRev.indexOf(36) == -1) {
                APP_BUILD = "r" + svnRev;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class BroadcastEntry {
        CamdNetMessage msg;
        List connectors;
        boolean probe;

        BroadcastEntry(CamdNetMessage msg, List connectors, boolean probe) {
            this.msg = msg;
            this.connectors = connectors;
            this.probe = probe;
        }
    }
}

