/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.interfaces.UserManager;
import com.bowman.cardserv.util.ProxyXmlConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class SimpleUserManager
implements UserManager {
    protected Map users = new HashMap();
    protected UserEntry defaultUser;
    protected String openPrefix;
    protected String openPasswd;
    protected Set openProfiles;

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        ProxyXmlConfig userConf;
        this.users.clear();
        ProxyXmlConfig openConf = null;
        try {
            openConf = xml.getSubConfig("open-access");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        if (openConf != null && "true".equalsIgnoreCase(openConf.getStringValue("enabled", "true"))) {
            this.openPrefix = openConf.getStringValue("open-username-prefix", "");
            this.openPasswd = openConf.getStringValue("open-password");
            String profiles = openConf.getStringValue("open-profiles", "");
            this.openProfiles = profiles.length() > 0 ? new HashSet<String>(Arrays.asList(profiles.split(" "))) : Collections.EMPTY_SET;
        } else {
            this.openPrefix = null;
            this.openPasswd = null;
            this.openProfiles = Collections.EMPTY_SET;
        }
        Iterator iter = xml.getMultipleSubConfigs("user");
        try {
            userConf = xml.getSubConfig("default-user");
            this.defaultUser = this.parseUser(userConf);
        }
        catch (ConfigException e) {
            this.defaultUser = null;
        }
        while (iter.hasNext()) {
            userConf = (ProxyXmlConfig)iter.next();
            this.addUser(userConf);
        }
    }

    protected void addUser(ProxyXmlConfig xml) throws ConfigException {
        this.addUser(this.parseUser(xml), this.users, false);
    }

    protected void addUser(UserEntry user, Map users, boolean overwrite) throws ConfigException {
        if (users.put(user.name.toLowerCase(), user) != null && !overwrite) {
            throw new ConfigException("Duplicate user definition: " + user.name);
        }
    }

    protected UserEntry parseUser(ProxyXmlConfig xml) throws ConfigException {
        String ipMask = xml.getStringValue("ip-mask", "*");
        String emailAddr = null;
        try {
            emailAddr = xml.getStringValue("email-address");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        int maxConnections = xml.getIntValue("max-connections", -1);
        boolean enabled = "true".equalsIgnoreCase(xml.getStringValue("enabled", "true"));
        boolean admin = "true".equalsIgnoreCase(xml.getStringValue("admin", "false"));
        boolean exclude = "true".equalsIgnoreCase(xml.getStringValue("map-exclude", "false"));
        boolean debug = "true".equalsIgnoreCase(xml.getStringValue("debug", "false"));
        UserEntry user = new UserEntry(xml.getStringValue("name"), xml.getStringValue("password"), ipMask, emailAddr, maxConnections, enabled, admin, exclude, debug);
        try {
            user.displayName = xml.getStringValue("display-name");
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        try {
            String profiles = xml.getStringValue("profiles");
            StringTokenizer st = new StringTokenizer(profiles);
            while (st.hasMoreTokens()) {
                user.profiles.add(st.nextToken());
            }
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        return user;
    }

    public String[] getUserNames() {
        ArrayList userNames = new ArrayList(this.users.keySet());
        Collections.sort(userNames);
        return userNames.toArray(new String[userNames.size()]);
    }

    protected UserEntry getUser(String name) {
        if (name == null) {
            return null;
        }
        UserEntry user = (UserEntry)this.users.get(name.toLowerCase());
        if (user != null) {
            return user;
        }
        return this.defaultUser;
    }

    protected boolean matchesOpen(String user) {
        if (this.openPrefix == null) {
            return false;
        }
        if ("".equals(this.openPrefix)) {
            return true;
        }
        return user.toLowerCase().startsWith(this.openPrefix.toLowerCase());
    }

    public String getPassword(String user) {
        UserEntry entry = this.getUser(user);
        if (entry == null) {
            if (this.matchesOpen(user)) {
                return this.openPasswd;
            }
            return null;
        }
        return entry.password;
    }

    public String getUserName(String user) {
        UserEntry entry = this.getUser(user);
        if (entry == null) {
            String suffix = Long.toString(System.currentTimeMillis(), 36);
            if ("".equals(this.openPrefix)) {
                return suffix;
            }
            if (this.matchesOpen(user)) {
                return this.openPrefix + suffix;
            }
            return null;
        }
        if (entry == this.defaultUser) {
            return user;
        }
        return entry.name;
    }

    public boolean authenticate(String user, String pass) {
        UserEntry entry = this.getUser(user);
        if (entry == null || entry == this.defaultUser) {
            return false;
        }
        return entry.password.equals(pass);
    }

    public String getIpMask(String user) {
        UserEntry entry = this.getUser(user);
        if (entry == null) {
            return "*";
        }
        return entry.ipMask;
    }

    public String getEmailAddress(String user) {
        UserEntry entry = this.getUser(user);
        if (entry == null) {
            return null;
        }
        return entry.email;
    }

    public String getDisplayName(String user) {
        UserEntry entry = this.getUser(user);
        if (entry == null) {
            if (this.matchesOpen(user)) {
                return user;
            }
            return null;
        }
        return entry.displayName;
    }

    public int getMaxConnections(String user) {
        UserEntry entry = this.getUser(user);
        if (entry == null) {
            return 1;
        }
        return entry.maxConnections;
    }

    public Set getAllowedProfiles(String user) {
        UserEntry entry = this.getUser(user);
        if (entry == null) {
            if (this.matchesOpen(user)) {
                return this.openProfiles;
            }
            return Collections.EMPTY_SET;
        }
        return entry.profiles;
    }

    public boolean isEnabled(String user) {
        UserEntry entry = this.getUser(user);
        if (entry == null) {
            return true;
        }
        return entry.enabled;
    }

    public boolean isAdmin(String user) {
        UserEntry entry = this.getUser(user);
        if (entry == null) {
            return false;
        }
        return entry.admin;
    }

    public boolean exists(String user) {
        return this.getPassword(user) != null;
    }

    public boolean isMapExcluded(String user) {
        UserEntry entry = this.getUser(user);
        if (entry == null) {
            return false;
        }
        return entry.exclude;
    }

    public boolean isDebug(String user) {
        UserEntry entry = this.getUser(user);
        if (entry == null) {
            return false;
        }
        return entry.debug;
    }

    public void setDebug(String user, boolean debug) {
        UserEntry entry = this.getUser(user);
        if (entry != null) {
            entry.debug = debug;
        }
    }

    public int getUserCount() {
        return this.users.size();
    }

    public void start() {
    }

    public Set getAllowedServices(String user, String profile) {
        return null;
    }

    public Set getBlockedServices(String user, String profile) {
        return null;
    }

    public Set getAllowedConnectors(String user) {
        return null;
    }

    public int getAllowedEcmRate(String user) {
        return -1;
    }

    static class UserEntry {
        String name;
        String password;
        String ipMask;
        String email;
        String displayName;
        int maxConnections;
        boolean enabled;
        boolean admin;
        boolean exclude;
        boolean debug;
        Set profiles = new HashSet();

        public UserEntry(String name, String password, String ipMask, String email, int maxConnections, boolean enabled, boolean admin, boolean exclude, boolean debug) {
            this.name = name;
            this.displayName = name;
            this.password = password;
            this.ipMask = ipMask;
            this.email = email;
            this.maxConnections = maxConnections;
            this.enabled = enabled;
            this.admin = admin;
            this.exclude = exclude;
            this.debug = debug;
        }
    }
}

