/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.cws;

import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.interfaces.CwsConnector;
import com.bowman.cardserv.interfaces.ProxySession;

public class QueueEntry {
    CamdNetMessage request;
    CamdNetMessage reply;
    private ProxySession targetSession;
    private Thread senderThread;
    private long timeStamp;
    private long sentTimeStamp;
    private long duration;

    public QueueEntry(CamdNetMessage request, ProxySession targetSession, Thread senderThread) {
        this.request = request;
        this.targetSession = targetSession;
        this.senderThread = senderThread;
        this.timeStamp = System.currentTimeMillis();
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public CamdNetMessage getRequest() {
        return this.request;
    }

    public ProxySession getTargetSession() {
        return this.targetSession;
    }

    public boolean isKeepAlive() {
        return this.request.isKeepAlive();
    }

    public boolean isMe(Thread thread) {
        return this.senderThread == thread;
    }

    public void timeOut(CwsConnector conn, char flag) {
        this.setReply(this.request.getEmptyReply());
        this.reply.setConnectorName(conn.getName());
        if (this.targetSession != null) {
            this.targetSession.setFlag(this.request, flag);
            this.targetSession.sendEcmReply(this.request, this.reply);
        }
    }

    public void setFlag(char flag) {
        if (this.targetSession != null) {
            this.targetSession.setFlag(this.request, flag);
        }
    }

    public void setReply(CamdNetMessage reply) {
        if (reply.getServiceId() == 0) {
            reply.setServiceId(this.request.getServiceId());
        }
        if (reply.getProfileName() == null) {
            reply.setProfileName(this.request.getProfileName());
        }
        this.reply = reply;
        this.duration = System.currentTimeMillis() - this.sentTimeStamp;
        this.request.setCWSTime(this.duration);
    }

    public long getDuration() {
        if (this.duration == 0L) {
            return System.currentTimeMillis() - this.timeStamp;
        }
        return this.duration;
    }

    public CamdNetMessage getReply() {
        return this.reply;
    }

    public long setSent() {
        this.sentTimeStamp = System.currentTimeMillis();
        long queueTime = this.sentTimeStamp - this.timeStamp;
        this.request.setQueueTime(queueTime);
        return queueTime;
    }

    public boolean isProbe() {
        return this.request.isEcm() && this.targetSession == null;
    }

    public boolean isStillValid() {
        return this.targetSession == null || this.targetSession.isInterested(this.request);
    }

    public boolean isSuccessful(long maxTime) {
        if (this.reply == null) {
            return false;
        }
        if (this.reply.isEmpty()) {
            return false;
        }
        return this.duration < maxTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueEntry that = (QueueEntry)o;
        return this.request.equals(that.request);
    }

    public int hashCode() {
        return this.request.hashCode();
    }

    public String toString() {
        return "[" + this.request.getSequenceNr() + " " + Integer.toHexString(this.request.getServiceId()) + " " + DESUtil.intToHexString(this.request.getNetworkId(), 4) + " " + DESUtil.intToHexString(this.request.getCaId(), 4) + "] " + (this.request.getProviderIdent() <= 0 ? "" : "[" + DESUtil.intToByteString(this.request.getProviderIdent(), 3) + "] ") + this.request.getCommandName() + "\t" + this.request.hashCodeStr() + " [" + this.getDuration() + " ms] \t[" + ((this.isStillValid() ? "valid " : "") + (this.request.getServiceId() == 0 ? "bc " : "") + (this.reply != null && this.reply.isEmpty() ? "empty" : "")).trim() + "]" + (this.targetSession == null ? "" : "\t" + this.targetSession);
    }

    public void sendReply() {
        if (this.targetSession != null) {
            this.targetSession.sendEcmReply(this.request, new CamdNetMessage(this.reply));
            this.targetSession = null;
        }
    }
}

