/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.cws;

import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardData;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.cws.AbstractCwsConnector;
import com.bowman.cardserv.cws.CwsConnectorManager;
import com.bowman.cardserv.util.ProxyXmlConfig;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Set;

public class RadegastCwsConnector
extends AbstractCwsConnector {
    private int sequenceNr = 1;
    private Socket conn;
    private DataInputStream is;
    private BufferedOutputStream os;
    private CardData fakeCard;
    private long lastTrafficTimeStamp = System.currentTimeMillis();
    private boolean tracing;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        super.configUpdated(xml);
        xml.getStringValue("profile");
        String host = xml.getStringValue("host");
        int port = xml.getPortValue("port");
        boolean enabled = "true".equalsIgnoreCase(xml.getStringValue("enabled", "true"));
        boolean changed = !host.equals(this.host) || port != this.port || enabled != this.enabled;
        this.host = host;
        this.port = port;
        this.enabled = enabled;
        this.tracing = "true".equalsIgnoreCase(xml.getStringValue("tracing", "false"));
        if (!enabled) {
            this.close();
        } else {
            xml.getStringValue("provider-idents");
            this.fakeCard = CardData.createData(this.profile.getCaId(), this.predefinedProviders.toArray(new Integer[this.predefinedProviders.size()]));
        }
        if (changed && enabled) {
            this.close();
            if (this.connManager != null) {
                CwsConnectorManager cwsConnectorManager = this.connManager;
                synchronized (cwsConnectorManager) {
                    this.connManager.notifyAll();
                }
            }
        }
        this.logger.fine("Configuration updated. Enabled: " + enabled + " Changed: " + changed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.alive = true;
        this.connectTimeStamp = System.currentTimeMillis();
        this.connManager.cwsConnected(this);
        this.connecting = false;
        try {
            while (this.alive && this.conn != null) {
                CamdNetMessage msg = this.readMessage();
                this.lastSent = null;
                if (msg == null) {
                    this.alive = false;
                    this.logger.warning("Connection closed");
                    continue;
                }
                msg.setSequenceNr(this.sequenceNr);
                msg.setCaId(this.profile.getCaId());
                if (this.reportReply(msg)) continue;
                this.logger.fine("No listener found for ECM reply: " + msg);
            }
        }
        catch (SocketException e) {
            this.logger.warning("Connection closed: " + e);
        }
        catch (IOException e) {
            this.logger.throwing("Exception reading/parsing message: " + e, e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn = null;
        this.readerThread = null;
        this.reset();
        this.lastDisconnectTimeStamp = System.currentTimeMillis();
        this.connManager.cwsDisconnected(this);
        CwsConnectorManager cwsConnectorManager = this.connManager;
        synchronized (cwsConnectorManager) {
            this.connManager.notifyAll();
        }
        this.logger.info("Connector dying");
    }

    CamdNetMessage readMessage() throws IOException {
        int commandTag;
        int i = this.is.read();
        if (i == -1) {
            return null;
        }
        if (i != 2) {
            throw new IOException("Unexpected header byte from rdg server: " + i);
        }
        i = this.is.read();
        byte[] buf = new byte[i];
        this.is.readFully(buf);
        String s = DESUtil.bytesToString(buf);
        this.logger.finer("Received reply: " + s);
        if (this.tracing) {
            System.out.println("Recv [" + this.name + "] " + s);
        }
        if (this.lastSent == null) {
            System.err.println("lastSent was null when reading: " + s);
        }
        int n = commandTag = this.lastSent == null ? 129 : this.lastSent.getRequest().getCommandTag();
        if (buf[0] == 4) {
            return CamdNetMessage.parseRadegast(commandTag, new byte[0], buf, this.getRemoteAddress());
        }
        if (buf[0] == 5) {
            if (buf[1] != 16) {
                throw new IOException("Unexpected CW length from rdg server: " + buf[1]);
            }
            byte[] cwData = new byte[16];
            System.arraycopy(buf, 2, cwData, 0, 16);
            return CamdNetMessage.parseRadegast(commandTag, cwData, buf, this.getRemoteAddress());
        }
        throw new IOException("Unknown reply from rdg server: " + s);
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    public boolean isReady() {
        return this.isConnected();
    }

    public CardData getRemoteCard() {
        return this.fakeCard;
    }

    public long getLastTrafficTimeStamp() {
        return this.lastTrafficTimeStamp;
    }

    public synchronized int sendMessage(CamdNetMessage msg) {
        if (msg.isKeepAlive()) {
            return -1;
        }
        if (msg.isEmm()) {
            return -1;
        }
        if (msg.isOsdMsg()) {
            return -1;
        }
        if (!this.waitForPending()) {
            return -1;
        }
        msg.setSequenceNr(this.sequenceNr);
        int caId = this.getProfile().getCaId();
        int sid = msg.getServiceId();
        int hdrSize = sid == 0 ? 33 : 37;
        byte[] buf = new byte[hdrSize + msg.getDataLength()];
        buf[0] = 1;
        buf[1] = (byte)(buf.length - 2);
        buf[2] = 2;
        buf[3] = 1;
        buf[4] = (byte)(caId >> 8 & 0xFF);
        buf[5] = 6;
        buf[6] = 8;
        String providerStr = DESUtil.intToHexString(msg.getProviderIdent(), 8);
        System.arraycopy(providerStr.getBytes(), 0, buf, 7, 8);
        buf[15] = 7;
        buf[16] = 4;
        System.arraycopy(msg.getRdgKeyNumber(), 0, buf, 17, 4);
        buf[21] = 8;
        buf[22] = 1;
        buf[23] = 1;
        buf[24] = 10;
        buf[25] = 2;
        buf[26] = (byte)(caId >> 8 & 0xFF);
        buf[27] = (byte)(caId & 0xFF);
        int offs = 28;
        if (sid != 0) {
            buf[28] = 33;
            buf[29] = 2;
            buf[30] = (byte)(sid >> 8 & 0xFF);
            buf[31] = (byte)(sid & 0xFF);
            offs = 32;
        }
        buf[offs] = 3;
        buf[offs + 1] = (byte)(msg.getDataLength() + 3);
        buf[offs + 2] = (byte)msg.getCommandTag();
        buf[offs + 3] = 112;
        buf[offs + 4] = (byte)msg.getDataLength();
        System.arraycopy(msg.getCustomData(), 0, buf, hdrSize, msg.getDataLength());
        try {
            String s = DESUtil.bytesToString(buf);
            this.logger.finer("Sending message [" + msg.getSequenceNr() + "]: " + s);
            if (this.tracing) {
                System.out.println("Sent [" + this.name + "] " + s);
            }
            this.os.write(buf);
            this.os.flush();
            msg.setSent(this.getRemoteAddress(), buf, this.getProtocol());
            return 1;
        }
        catch (IOException e) {
            this.logger.throwing("Connection closed while sending", e);
            this.close();
            return this.sequenceNr;
        }
    }

    protected synchronized void connectNative() throws IOException {
        this.conn = new Socket();
        if (this.qosClass != -1) {
            this.conn.setTrafficClass(this.qosClass);
        }
        this.conn.connect(new InetSocketAddress(this.host, this.port), 10000);
        if (this.conn == null) {
            throw new IOException("Connection aborted");
        }
        this.is = new DataInputStream(this.conn.getInputStream());
        this.os = new BufferedOutputStream(this.conn.getOutputStream());
        this.conn.setSoTimeout(0);
        this.logger.info("Connected");
    }

    public String getProtocol() {
        return "Radegast";
    }

    public Set getProviderIdents() {
        return this.predefinedProviders;
    }

    public String getRemoteAddress() {
        if (this.conn == null) {
            return "0.0.0.0";
        }
        return this.conn.getInetAddress().getHostAddress();
    }

    public void close() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.conn = null;
        super.close();
    }
}

