/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.session;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CaidProviderPair;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardData;
import com.bowman.cardserv.ListenPort;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.cws.CwsConnectorManager;
import com.bowman.cardserv.interfaces.CamdMessageListener;
import com.bowman.cardserv.interfaces.CwsConnector;
import com.bowman.cardserv.interfaces.CwsListener;
import com.bowman.cardserv.session.NewcamdSession;
import com.bowman.cardserv.tv.TvService;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ExtNewcamdSession
extends NewcamdSession
implements CwsListener {
    private Set allowedClients = new HashSet();
    private Map sentData = new HashMap();
    private CardData mainCard;
    private int mainCaId;
    private int mainNetworkId;
    private Integer[] mergedProviders;
    private boolean catchAllExists;

    public ExtNewcamdSession(Socket conn, ListenPort listenPort, CamdMessageListener listener) {
        super(conn, listenPort, listener);
        String mainCaId = listenPort.getStringProperty("main-ca-id");
        if (mainCaId != null) {
            this.mainCaId = Integer.parseInt(mainCaId, 16);
            this.mergedProviders = this.getProvidersForCaId(this.mainCaId);
        }
        this.catchAllExists = ProxyConfig.getInstance().isCatchAll();
        this.initSession();
    }

    protected void initSession() {
        String clients = this.listenPort.getStringProperty("clients");
        if (clients != null) {
            this.allowedClients.addAll(Arrays.asList(clients.split(" ")));
        }
        String excludeProfiles = this.listenPort.getStringProperty("exclude-profiles");
        ProxyConfig config = ProxyConfig.getInstance();
        this.mappedProfiles = config.getRealProfiles();
        if (excludeProfiles != null) {
            HashSet<String> excluded = new HashSet<String>(Arrays.asList(excludeProfiles.split(" ")));
            Iterator iter = this.mappedProfiles.iterator();
            while (iter.hasNext()) {
                CaProfile profile = (CaProfile)iter.next();
                if (!excluded.contains(profile.getName())) continue;
                iter.remove();
            }
        }
        if (this.user != null) {
            this.setupLimits(ProxyConfig.getInstance().getUserManager());
        }
    }

    protected Integer[] getProvidersForCaId(int caId) {
        HashSet providers = new HashSet();
        Iterator iter = this.mappedProfiles.iterator();
        while (iter.hasNext()) {
            CaProfile profile = (CaProfile)iter.next();
            if (profile.getCaId() != caId) continue;
            providers.addAll(profile.getProviderSet());
        }
        return providers.toArray(new Integer[providers.size()]);
    }

    protected CamdNetMessage getLoginOkMsg() {
        CamdNetMessage msg = super.getLoginOkMsg();
        msg.setServiceId(28275);
        msg.getFixedData()[9] = 20;
        return msg;
    }

    protected boolean handleMessage(CamdNetMessage msg) {
        switch (msg.getCommandTag()) {
            case 214: {
                CamdNetMessage versionMsg = new CamdNetMessage(214);
                versionMsg.setCustomData("1.67".getBytes());
                this.sendMessageNative(versionMsg, msg.getSequenceNr(), true);
                this.fireCamdMessage(versionMsg, true);
                break;
            }
            case 227: {
                CwsConnector auConn = this.findAuConnector();
                CardData card = this.getAuCardData(auConn);
                boolean au = true;
                if (card == null) {
                    card = CardData.createEmptyData(this.mainCaId);
                    au = false;
                }
                if (card.getCaId() == this.mainCaId && this.mergedProviders != null) {
                    card = CardData.createMergedData(card, this.mergedProviders);
                }
                if (au) {
                    this.mainCard = card;
                    this.mainNetworkId = auConn.getProfile().getNetworkId();
                } else {
                    this.mainCard = new CardData(card.getData(true));
                }
                CamdNetMessage cardDataMsg = new CamdNetMessage(228);
                cardDataMsg.setCustomData(card.getData(!au));
                this.sendMessageNative(cardDataMsg, msg.getSequenceNr(), true);
                this.fireCamdMessage(cardDataMsg, true);
                this.logger.fine("Sent card-data: " + card);
                this.sentData.clear();
                Map map = this.getProfileMap();
                Iterator iter = map.keySet().iterator();
                while (iter.hasNext()) {
                    CaidProviderPair pair = (CaidProviderPair)iter.next();
                    this.sendAddCardData(msg.getSequenceNr(), pair, (CaProfile)map.get(pair));
                }
                ProxyConfig.getInstance().getConnManager().addCwsListener(this);
                this.logger.fine("Sent extended state: " + this.sentData);
                if (!this.sentData.isEmpty() || this.catchAllExists) break;
                this.logger.warning("No extended data available for user '" + this.user + "' (no provider-idents currently associated with any active and allowed profiles).");
                break;
            }
            default: {
                return this.handleNewcamd(msg);
            }
        }
        return true;
    }

    void endSession() {
        ProxyConfig.getInstance().getConnManager().removeCwsListener(this);
        super.endSession();
    }

    private CwsConnector findAuConnector() {
        ProxyConfig config = ProxyConfig.getInstance();
        CwsConnectorManager cm = config.getConnManager();
        ArrayList<CwsConnector> connectors = new ArrayList<CwsConnector>();
        Iterator iter = config.getRealProfiles().iterator();
        while (iter.hasNext()) {
            CwsConnector cws = cm.getConnectorForAU(((CaProfile)iter.next()).getName(), this.user);
            if (cws == null) continue;
            connectors.add(cws);
        }
        if (connectors.size() > 1) {
            this.logger.warning("AU-user '" + this.user + "' assigned for multiple active connectors: " + connectors + " (only " + connectors.get(0) + " is likely to receive the correct updates)");
        } else if (connectors.isEmpty()) {
            return null;
        }
        return (CwsConnector)connectors.get(0);
    }

    protected void sendAddCardData(int seqNr, CaidProviderPair pair, CaProfile profile) {
        CamdNetMessage addMsg = new CamdNetMessage(211);
        addMsg.setServiceId(this.listenPort.getPort());
        addMsg.setCaIdInHdr(pair.caId);
        addMsg.setProviderInHdr(pair.providerIdent);
        this.sendMessageNative(addMsg, seqNr, true);
        this.sentData.put(pair, profile);
        this.fireCamdMessage(addMsg, true);
    }

    protected void sendRemoveCardData(int seqNr, CaidProviderPair pair) {
        CamdNetMessage delMsg = new CamdNetMessage(212);
        delMsg.setServiceId(this.listenPort.getPort());
        delMsg.setCaIdInHdr(pair.caId);
        delMsg.setProviderInHdr(pair.providerIdent);
        this.sendMessageNative(delMsg, seqNr, true);
        this.sentData.remove(pair);
        this.fireCamdMessage(delMsg, true);
    }

    protected boolean profileAllowed(CaProfile profile) {
        Set allowed = ProxyConfig.getInstance().getUserManager().getAllowedProfiles(this.user);
        return allowed == null || allowed.isEmpty() || allowed.contains(profile.getName());
    }

    CamdNetMessage readMessage() throws IOException {
        CamdNetMessage msg = super.readMessage();
        if (msg != null) {
            if (msg.isEcm()) {
                msg.setProviderIdent(msg.getProviderFromHdr());
                msg.setCaId(msg.getCaIdFromHdr());
                msg.setNetworkId(-1);
                CaidProviderPair pair = new CaidProviderPair(msg.getCaId(), msg.getProviderIdent());
                if (!this.sentData.containsKey(pair)) {
                    if (!this.catchAllExists) {
                        this.logger.warning("User '" + this.user + "' sent request for ca-id/provider-ident not previously communicated: " + pair);
                    }
                } else {
                    msg.setNetworkId(((CaProfile)this.sentData.get(pair)).getNetworkId());
                }
            } else if (msg.isEmm() && this.mainCard != null) {
                msg.setCaId(this.mainCard.getCaId());
                msg.setProviderIdent(msg.getProviderFromHdr());
                CaidProviderPair pair = new CaidProviderPair(this.mainCard.getCaId(), msg.getProviderIdent());
                if (!this.sentData.containsKey(pair)) {
                    msg.setNetworkId(this.mainNetworkId);
                } else {
                    msg.setNetworkId(((CaProfile)this.sentData.get(pair)).getNetworkId());
                }
            }
        }
        return msg;
    }

    private Map getProfileMap() {
        HashMap<CaidProviderPair, CaProfile> map = new HashMap<CaidProviderPair, CaProfile>();
        Iterator iter = this.mappedProfiles.iterator();
        while (iter.hasNext()) {
            CaProfile profile = (CaProfile)iter.next();
            if (profile.getNetworkId() <= 0 || profile.getCaId() <= 0 || !this.profileAllowed(profile)) continue;
            Integer[] pi = profile.getProviderIdents();
            for (int i = 0; i < pi.length; ++i) {
                CaidProviderPair record = new CaidProviderPair(profile.getCaId(), pi[i]);
                if (!map.containsKey(record)) {
                    map.put(record, profile);
                    continue;
                }
                if (this.catchAllExists) continue;
                this.logger.warning("Ambigious situation - [" + record + "] (profile: " + profile.getName() + ") clashes with profile: " + ((CaProfile)map.get(record)).getName() + " (both profiles can't be assigned to the same extended-newcamd port)");
            }
        }
        return map;
    }

    private void updateSentState(Map map) {
        CaidProviderPair key;
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            key = (CaidProviderPair)iter.next();
            if (!this.sentData.containsKey(key)) {
                this.sendAddCardData(-1, key, (CaProfile)map.get(key));
                this.logger.fine("New mapping: " + key + " -> " + map.get(key));
                continue;
            }
            if (this.sentData.get(key) == map.get(key)) continue;
            this.logger.fine("Mapping change: " + key + " -> " + map.get(key) + " (was: " + this.sentData.get(key) + ")");
            this.sentData.put(key, map.get(key));
        }
        iter = new ArrayList(this.sentData.keySet()).iterator();
        while (iter.hasNext()) {
            key = (CaidProviderPair)iter.next();
            if (map.containsKey(key)) continue;
            this.logger.fine("Mapping removed: " + key + " -> " + this.sentData.get(key));
            this.sendRemoveCardData(-1, key);
        }
    }

    public String getProtocol() {
        return "ExtNewcamd";
    }

    public String getLastContext() {
        if (this.mainCard == null) {
            return "?";
        }
        return this.mainCard.toString();
    }

    public void cwsConnected(CwsConnector cws) {
        this.updateSentState(this.getProfileMap());
    }

    public void cwsDisconnected(CwsConnector cws) {
        this.updateSentState(this.getProfileMap());
    }

    public void cwsConnectionFailed(CwsConnector cws, String message) {
    }

    public void cwsEcmTimeout(CwsConnector cws, String message, int failureCount) {
    }

    public void cwsLostService(CwsConnector cws, TvService service, boolean show) {
    }

    public void cwsFoundService(CwsConnector cws, TvService service, boolean show) {
    }

    public void cwsInvalidCard(CwsConnector cws, String message) {
    }

    public void cwsProfileChanged(CaProfile profile, boolean added) {
        this.initSession();
        this.updateSentState(this.getProfileMap());
    }
}

