/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.session;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.ListenPort;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.session.AbstractSession;
import java.util.LinkedHashMap;
import java.util.Map;

public class GHttpSession
extends AbstractSession {
    private static final long SESSION_LIFETIME = 600000L;
    private String ghttpSessionId;
    private long lastAccess;
    private final Map replies = new ReplyMap();

    public GHttpSession(String ghttpSessionId, String user, String ip) {
        super((ListenPort)CaProfile.MULTIPLE.getListenPorts().get(0), ProxyConfig.getInstance().getDefaultMsgListener());
        this.ghttpSessionId = ghttpSessionId;
        this.user = user;
        this.loginName = user;
        this.remoteAddress = ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int sendEcmReplyNative(CamdNetMessage ecmRequest, CamdNetMessage ecmReply) {
        ecmReply.setSent(this.remoteAddress, ecmReply.getCustomData(), "GHttp");
        this.endTransaction(ecmRequest, ecmReply, 0);
        Map map = this.replies;
        synchronized (map) {
            this.replies.put(ecmRequest, ecmReply);
            this.replies.notify();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CamdNetMessage waitForReply(CamdNetMessage request) {
        Map map = this.replies;
        synchronized (map) {
            if (this.replies.containsKey(request)) {
                return (CamdNetMessage)this.replies.get(request);
            }
            try {
                long start = System.currentTimeMillis();
                long maxWait = request.getMaxWait();
                CamdNetMessage reply = null;
                while (System.currentTimeMillis() - start < maxWait && reply == null) {
                    this.replies.wait(maxWait);
                    reply = (CamdNetMessage)this.replies.get(request);
                }
                return reply;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public String getProtocol() {
        return "GHttp";
    }

    public String getLastContext() {
        return "Dummy";
    }

    public void close() {
    }

    public boolean isConnected() {
        return true;
    }

    public int sendMessage(CamdNetMessage msg) {
        return 0;
    }

    public void run() {
    }

    public String getGhttpSessionId() {
        return this.ghttpSessionId;
    }

    public void touch() {
        this.lastAccess = System.currentTimeMillis();
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.lastAccess > 600000L;
    }

    static class ReplyMap
    extends LinkedHashMap {
        ReplyMap() {
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return System.currentTimeMillis() - ((CamdNetMessage)eldest.getKey()).getTimeStamp() > 10000L;
        }
    }
}

