/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.util;

import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;

public class UnixUtil {
    private static ThreadMXBean tmxb;

    public static long getOpenFileDescriptorCount() {
        OperatingSystemMXBean o = ManagementFactory.getOperatingSystemMXBean();
        if (o instanceof UnixOperatingSystemMXBean) {
            return ((UnixOperatingSystemMXBean)o).getOpenFileDescriptorCount();
        }
        return -1L;
    }

    public static long getMaxFileDescriptorCount() {
        OperatingSystemMXBean o = ManagementFactory.getOperatingSystemMXBean();
        if (o instanceof UnixOperatingSystemMXBean) {
            return ((UnixOperatingSystemMXBean)o).getMaxFileDescriptorCount();
        }
        return -1L;
    }

    public static long getThreadCpuTime(long id) {
        if (tmxb == null) {
            tmxb = ManagementFactory.getThreadMXBean();
        }
        if (tmxb != null) {
            return tmxb.getThreadCpuTime(id) / 1000000L;
        }
        return -1L;
    }

    public static long getThreadUserTime(long id) {
        if (tmxb == null) {
            tmxb = ManagementFactory.getThreadMXBean();
        }
        if (tmxb != null) {
            return tmxb.getThreadCpuTime(id) / 1000000L;
        }
        return -1L;
    }
}

