/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.wizard;

import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.console.ui.notification.NotificationPlugin;
import com.jrockit.mc.console.ui.notification.widget.ConditionChooser;
import com.jrockit.mc.console.ui.notification.wizard.Messages;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.triggers.IValueEvaluator;
import com.jrockit.mc.rjmx.triggers.TriggerRule;
import com.jrockit.mc.rjmx.triggers.condition.internal.TriggerCondition;
import com.jrockit.mc.rjmx.triggers.fields.internal.Field;
import com.jrockit.mc.rjmx.triggers.fields.internal.QuantityField;
import com.jrockit.mc.rjmx.triggers.internal.NotificationRegistry;
import com.jrockit.mc.rjmx.triggers.internal.NotificationTrigger;
import com.jrockit.mc.rjmx.triggers.internal.ValueEvaluatorNumberMax;
import com.jrockit.mc.rjmx.triggers.internal.ValueEvaluatorStringMatch;
import com.jrockit.mc.rjmx.ui.internal.AttributeSelectionContentModel;
import com.jrockit.mc.rjmx.ui.internal.IAttributeSelectionContentListener;
import com.jrockit.mc.ui.uibuilder.IUIBuilder;
import com.jrockit.mc.ui.uibuilder.StandardUIBuilder;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TriggerConditionWizardPage
extends WizardPage {
    public static final String PAGE_NAME = "com.jrockit.mc.notification.trigger.condition";
    private final AttributeSelectionContentModel m_selectorModel;
    private final TriggerRule m_notificationRule;
    private final IConnectionHandle m_connectionHandle;
    private ConditionChooser m_conditionChooser;

    public TriggerConditionWizardPage(AttributeSelectionContentModel selectorModel, NotificationRegistry model, IConnectionHandle connectionHandle, TriggerRule notificationRule) {
        super(PAGE_NAME, Messages.TriggerConditionWizardPage_TITLE, null);
        this.setDescription(Messages.TriggerConditionWizardPage_DESCRIPTION);
        this.m_selectorModel = selectorModel;
        this.m_notificationRule = notificationRule;
        this.m_connectionHandle = connectionHandle;
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        StandardUIBuilder suib = new StandardUIBuilder(control);
        if (this.m_notificationRule.getTrigger() instanceof TriggerCondition) {
            this.m_conditionChooser = new ConditionChooser(false, (IUIBuilder)suib, this.m_notificationRule, this.m_connectionHandle, control);
            this.m_conditionChooser.select(this.m_notificationRule.getTrigger());
            this.m_selectorModel.addListener(new IAttributeSelectionContentListener(){

                public void selectionChanged(AttributeSelectionContentModel selectorModel) {
                    final MRI[] selectedAttributes = selectorModel.getSelectedAttributes();
                    if (selectedAttributes.length > 0) {
                        final IUnit unit = selectorModel.getAttributeUnit(selectedAttributes[0]);
                        final TriggerCondition trigger = (TriggerCondition)TriggerConditionWizardPage.this.m_notificationRule.getTrigger();
                        NotificationPlugin.getDefault().getNotificationRepository().performCriticalRuleChange(TriggerConditionWizardPage.this.m_notificationRule, new Runnable(){

                            @Override
                            public void run() {
                                ((NotificationTrigger)TriggerConditionWizardPage.this.m_notificationRule.getTrigger()).setAttributeDescriptor(selectedAttributes[0]);
                                if (unit != null) {
                                    IQuantity zeroQuantity = unit.quantity(0L);
                                    trigger.setValueEvaluator((IValueEvaluator)new ValueEvaluatorNumberMax(zeroQuantity));
                                    Field field = trigger.getFieldHolder().getField("EVAL_NUM_MAX");
                                    if (field instanceof QuantityField) {
                                        ((QuantityField)field).initKind(unit.getContentType(), zeroQuantity.interactiveFormat(), null, null);
                                    }
                                    field.setValue(zeroQuantity.interactiveFormat());
                                } else {
                                    trigger.setValueEvaluator((IValueEvaluator)new ValueEvaluatorStringMatch("*"));
                                }
                            }
                        });
                    }
                }
            });
        } else {
            NotificationPlugin.getDefault().getLogger().severe("Create control: wrong type!");
        }
        this.setControl((Control)control);
    }

    public void setVisible(boolean visble) {
        super.setVisible(visble);
        if (this.m_notificationRule.getTrigger() instanceof TriggerCondition) {
            this.m_conditionChooser.select(this.m_notificationRule.getTrigger());
        } else {
            NotificationPlugin.getDefault().getLogger().severe("Set visible: wrong type!");
        }
    }
}

