/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.unit;

import com.jrockit.mc.common.unit.IScalarAffineTransform;
import com.jrockit.mc.common.unit.ImpreciseScaleFactor;
import com.jrockit.mc.common.unit.ScaleFactor;

public class LongScaleFactor
extends ScaleFactor {
    private final long longMultiplier;

    public LongScaleFactor(long factor) {
        this.longMultiplier = factor;
    }

    @Override
    public IScalarAffineTransform chain(IScalarAffineTransform factor) {
        if (factor.isUnity()) {
            return this;
        }
        if (factor instanceof ScaleFactor) {
            return this.chain((ScaleFactor)factor);
        }
        return new ImpreciseScaleFactor(factor.targetValue((double)this.longMultiplier));
    }

    @Override
    public ScaleFactor chain(ScaleFactor factor) {
        if (factor.isUnity()) {
            return this;
        }
        if (factor.isInteger() && !factor.targetOutOfRange(this.longMultiplier, Long.MAX_VALUE)) {
            return new LongScaleFactor(factor.targetValue(this.longMultiplier));
        }
        return new ImpreciseScaleFactor(factor.targetValue((double)this.longMultiplier));
    }

    @Override
    public ScaleFactor invert() {
        return new ImpreciseScaleFactor(1.0 / (double)this.longMultiplier);
    }

    @Override
    public boolean targetOutOfRange(double srcNumericalValue, long maxAbsValue) {
        if (srcNumericalValue >= 0.0) {
            return srcNumericalValue > (double)maxAbsValue / this.getMultiplier();
        }
        return srcNumericalValue < (double)(maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL) / this.getMultiplier();
    }

    @Override
    public double targetValue(double srcNumericalValue) {
        return srcNumericalValue * (double)this.longMultiplier;
    }

    @Override
    public boolean targetOutOfRange(long srcNumericalValue, long maxAbsValue) {
        if (srcNumericalValue >= 0L) {
            return srcNumericalValue > maxAbsValue / this.longMultiplier;
        }
        return srcNumericalValue < (maxAbsValue ^ 0xFFFFFFFFFFFFFFFFL) / this.longMultiplier;
    }

    @Override
    public long targetValue(long srcNumericalValue) {
        return this.targetFloor(srcNumericalValue);
    }

    @Override
    public long targetFloor(long srcNumericalValue) {
        if (this.targetOutOfRange(srcNumericalValue, Long.MAX_VALUE)) {
            return srcNumericalValue >= 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return srcNumericalValue * this.longMultiplier;
    }

    @Override
    public boolean isUnity() {
        return this.longMultiplier == 1L;
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof LongScaleFactor && this.longMultiplier == ((LongScaleFactor)other).longMultiplier;
    }

    @Override
    public int hashCode() {
        return (int)this.longMultiplier;
    }

    public String toString() {
        return String.valueOf(this.longMultiplier);
    }

    @Override
    public double getMultiplier() {
        return this.longMultiplier;
    }
}

