#if defined(WITH_SSL) || defined(WITH_LIBCRYPTO)
#  include <openssl/aes.h>
#else
#ifndef HEADER_AES_H
#define HEADER_AES_H

#define AES_ENCRYPT 1
#define AES_DECRYPT 0

/* Because array size can't be a const in C, the following two are macros.
   Both sizes are in bytes. */
#define AES_MAXNR 14
#define AES_BLOCK_SIZE 16

# define GETU32(pt) (((uint32_t)(pt)[0] << 24) ^ ((uint32_t)(pt)[1] << 16) ^ ((uint32_t)(pt)[2] <<  8) ^ ((uint32_t)(pt)[3]))
# define PUTU32(ct, st) { (ct)[0] = (uint8_t)((st) >> 24); (ct)[1] = (uint8_t)((st) >> 16); (ct)[2] = (uint8_t)((st) >>  8); (ct)[3] = (uint8_t)(st); }

#include <stdint.h>

#define MAXKC   (256/32)
#define MAXKB   (256/8)
#define MAXNR   14

/* This controls loop-unrolling in aes_core.c */
#undef FULL_UNROLL

/* This should be a hidden type, but EVP requires that the size be known */
struct aes_key_st
{
	uint32_t rd_key[4 * (AES_MAXNR + 1)];
	int rounds;
};
typedef struct aes_key_st AES_KEY;

int AES_set_encrypt_key(const unsigned char *userKey, const int bits,
						AES_KEY *key);
int AES_set_decrypt_key(const unsigned char *userKey, const int bits,
						AES_KEY *key);

void AES_encrypt(const unsigned char *in, unsigned char *out,
				 const AES_KEY *key);
void AES_decrypt(const unsigned char *in, unsigned char *out,
				 const AES_KEY *key);

#endif /* !HEADER_AES_H */

#endif
