/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.irc.dcc;

import com.bowman.irc.IrcMessage;
import com.bowman.irc.dcc.DCCChatEvent;
import com.bowman.irc.dcc.DCCChatListener;
import com.bowman.util.ServerSocketProvider;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class DCCChatSession
implements Runnable {
    public static final String CRLF = "\r\n";
    public static final int DCS_TYPE_ACCEPT = 0;
    public static final int DCS_TYPE_CONNECT = 1;
    public static final int MAX_LINE_LENGTH = 900;
    private int sessionType;
    private Vector listeners;
    private InetAddress host;
    private int port;
    private int listeningPort;
    private int timeOut;
    private int soTimeout;
    private Object reference;
    private boolean timeOutWarning;
    private Socket chatConn;
    private ServerSocket serverSocket;
    private BufferedWriter chatWriter;
    private BufferedReader chatReader;
    private Vector welcomeMsg;
    private Thread readerThread;
    public static PrintWriter dbgLogger;

    private DCCChatSession(int type, int timeOut) {
        this.timeOut = timeOut * 1000;
        this.sessionType = type;
        this.listeners = new Vector();
        this.welcomeMsg = new Vector();
    }

    public DCCChatSession(int timeOut, String host, int port) throws UnknownHostException {
        this(1, timeOut);
        this.host = InetAddress.getByName(host);
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Illegal port: " + port);
        }
        this.port = port;
    }

    public DCCChatSession(int timeOut, String ctcpStr) throws UnknownHostException {
        this(1, timeOut);
        StringTokenizer st = new StringTokenizer(ctcpStr);
        try {
            if (!st.nextToken().equals("DCC")) {
                throw new IllegalArgumentException("Unexpected token, wanted 'DCC'");
            }
            if (!st.nextToken().equals("CHAT")) {
                throw new IllegalArgumentException("Unexpected token, wanted 'DCC CHAT'");
            }
            st.nextToken();
            long hostnum = Long.parseLong(st.nextToken());
            String addr = "";
            addr = addr + (hostnum >> 24 & 0xFFL) + ".";
            addr = addr + (hostnum >> 16 & 0xFFL) + ".";
            addr = addr + (hostnum >> 8 & 0xFFL) + ".";
            addr = addr + (hostnum >> 0 & 0xFFL);
            this.host = InetAddress.getByName(addr);
            this.port = Integer.parseInt(st.nextToken());
        }
        catch (NoSuchElementException nse) {
            throw new IllegalArgumentException("Malformed ctcp string: " + ctcpStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing ctcp string: " + ctcpStr);
        }
    }

    public DCCChatSession(int timeOut) {
        this(0, timeOut);
    }

    public void start() {
        this.start(null);
    }

    public void start(Object reference) {
        this.reference = reference;
        if (this.timeOut == 0) {
            this.soTimeout = 0;
        } else {
            if (this.timeOut < 60000) {
                this.timeOut = 60000;
            }
            this.soTimeout = 30000;
        }
        this.timeOutWarning = false;
        this.fireDCCChatEvent(0, null);
        switch (this.sessionType) {
            case 1: {
                break;
            }
            case 0: {
                try {
                    this.serverSocket = ServerSocketProvider.createServerSocket();
                    this.listeningPort = this.serverSocket.getLocalPort();
                    break;
                }
                catch (IOException ioe) {
                    this.fireDCCChatEvent(2, "Unable to open socket.");
                    return;
                }
            }
        }
        this.readerThread = new Thread((Runnable)this, "DCCChatReaderThread");
        this.readerThread.start();
    }

    private void fireDCCChatEvent(int type, String strArg) {
        DCCChatEvent ev = new DCCChatEvent(type, this, strArg, this.reference);
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((DCCChatListener)e.nextElement()).onDCCChatEvent(ev);
        }
    }

    public void run() {
        block25: {
            switch (this.sessionType) {
                case 1: {
                    try {
                        this.chatConn = new Socket(this.host, this.port);
                    }
                    catch (IOException ioe) {
                        this.fireDCCChatEvent(2, "Failed to connect to " + this.host.getHostAddress() + ":" + this.port + " (" + ioe + ")");
                        this.chatConn = null;
                    }
                    break;
                }
                case 0: {
                    try {
                        this.serverSocket.setSoTimeout(this.soTimeout);
                        this.chatConn = this.serverSocket.accept();
                        this.serverSocket.close();
                        break;
                    }
                    catch (InterruptedIOException ie) {
                        this.fireDCCChatEvent(2, "Timed out waiting for connect.");
                        this.chatConn = null;
                        break;
                    }
                    catch (IOException ioe) {
                        this.fireDCCChatEvent(2, "Error accepting connection: " + ioe);
                        this.chatConn = null;
                    }
                }
            }
            if (this.chatConn != null) {
                this.fireDCCChatEvent(1, "Connected to " + this.chatConn.getInetAddress().getHostAddress());
                try {
                    this.chatConn.setKeepAlive(true);
                    if (this.soTimeout > 0) {
                        this.chatConn.setSoTimeout(this.timeOut - this.soTimeout);
                    }
                    this.chatWriter = new BufferedWriter(new OutputStreamWriter(this.chatConn.getOutputStream()));
                    this.chatReader = new BufferedReader(new InputStreamReader(this.chatConn.getInputStream()));
                }
                catch (IOException ioe) {
                    if (dbgLogger == null) break block25;
                    ioe.printStackTrace(dbgLogger);
                }
            }
        }
        while (this.chatConn != null) {
            block26: {
                String line = "";
                try {
                    if (!this.welcomeMsg.isEmpty()) {
                        Enumeration enumeration = this.welcomeMsg.elements();
                        while (enumeration.hasMoreElements()) {
                            this.sendLine((String)enumeration.nextElement());
                        }
                        this.welcomeMsg.removeAllElements();
                    }
                    while ((line = this.chatReader.readLine()) != null) {
                        this.timeOutWarning = false;
                        this.fireDCCChatEvent(6, line);
                    }
                }
                catch (InterruptedIOException ie) {
                    if (this.timeOutWarning) {
                        this.fireDCCChatEvent(3, "Timed out waiting for peer input.");
                        this.close();
                    } else {
                        this.fireDCCChatEvent(4, "Connection idle, timeout in 30 seconds.");
                        this.timeOutWarning = true;
                        try {
                            this.chatConn.setSoTimeout(this.soTimeout);
                        }
                        catch (SocketException se) {}
                    }
                }
                catch (Exception ioe) {
                    if (dbgLogger != null) {
                        dbgLogger.println("DCCChat: " + ioe);
                    }
                    if (this.chatConn == null) break block26;
                    this.fireDCCChatEvent(2, "Error reading: " + ioe);
                    this.close();
                }
            }
            if (this.timeOutWarning) continue;
            this.close();
        }
    }

    public void sendLine(String line) {
        if (this.chatWriter != null) {
            while (line.length() > 900) {
                this.sendLine(line.substring(0, 900));
                line = line.substring(900);
            }
            try {
                this.chatWriter.write(line + CRLF);
                this.chatWriter.flush();
            }
            catch (IOException ioe) {
                this.close();
            }
        } else {
            this.welcomeMsg.addElement(line);
        }
    }

    public void sendCtcp(String line) {
        this.sendLine(IrcMessage.makeCtcp(line));
    }

    public void close() {
        if (this.chatConn != null) {
            try {
                this.chatConn.close();
                this.chatConn = null;
                this.fireDCCChatEvent(5, "Chat session closed.");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void addDCCChatListener(DCCChatListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeDCCChatListener(DCCChatListener listener) {
        this.listeners.removeElement(listener);
    }

    public String generateCtcpReply(InetAddress inetAddr) {
        byte[] address = null;
        if (inetAddr == null) {
            try {
                inetAddr = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                // empty catch block
            }
        }
        address = inetAddr.getAddress();
        long longAddress = 0L;
        longAddress |= ((long)address[0] & 0xFFL) << 24;
        longAddress |= ((long)address[1] & 0xFFL) << 16;
        longAddress |= ((long)address[2] & 0xFFL) << 8;
        int port = this.getLocalPort();
        return "DCC CHAT chat " + (longAddress |= ((long)address[3] & 0xFFL) << 0) + " " + port;
    }

    public String generateCtcpReply() {
        return this.generateCtcpReply(null);
    }

    public int getLocalPort() {
        return this.listeningPort;
    }

    public static void setDebugLogger(PrintWriter dbgWriter) {
        dbgLogger = dbgWriter;
    }
}

