/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.httpd;

import com.bowman.httpd.PseudoHttpd;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SecurePseudoHttpd
extends PseudoHttpd {
    private static SSLContext sslContext = null;

    public SecurePseudoHttpd(int listenPort, String keyStorePath, String keyStorePasswd) throws GeneralSecurityException, IOException {
        this(listenPort, null, keyStorePath, keyStorePasswd);
    }

    public SecurePseudoHttpd(int listenPort, InetAddress bindAddr, String keyStorePath, String keyStorePasswd) throws GeneralSecurityException, IOException {
        super(listenPort, bindAddr);
        if (sslContext == null) {
            if (System.getProperty("java.protocol.handler.pkgs") == null) {
                try {
                    Security.addProvider((Provider)Class.forName("com.sun.net.ssl.internal.ssl.Provider").newInstance());
                    System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        Security.addProvider((Provider)Class.forName("org.metastatic.jessie.provider.Jessie").newInstance());
                        System.setProperty("java.protocol.handler.pkgs", "org.metastatic.jessie");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new IOException("Unable to find SSL provider (tried jsse and jessie).");
                    }
                }
            }
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(SecurePseudoHttpd.loadKeyStore(keyStorePath, keyStorePasswd.toCharArray()), new TrustManager[]{new PseudoHttpdTrustManager()}, new SecureRandom());
        }
    }

    private static KeyManager[] loadKeyStore(String keyStorePath, char[] keyStorePasswd) throws GeneralSecurityException, IOException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(new FileInputStream(keyStorePath), keyStorePasswd);
        keyManagerFactory.init(keyStore, keyStorePasswd);
        return keyManagerFactory.getKeyManagers();
    }

    public void start() throws IOException {
        if (!this.alive) {
            this.srvSock = sslContext.getServerSocketFactory().createServerSocket();
            InetSocketAddress sockAddr = this.bindAddr == null ? new InetSocketAddress(this.listenPort) : new InetSocketAddress(this.bindAddr, this.listenPort);
            this.srvSock.bind(sockAddr);
            SecurePseudoHttpd.initSSLServerSocket((SSLServerSocket)this.srvSock);
            this.alive = true;
            new Thread((Runnable)this, "SecurePseudoHttpdAcceptThread").start();
        }
    }

    private static void initSSLServerSocket(SSLServerSocket ss) {
    }

    private static class PseudoHttpdTrustManager
    implements X509TrustManager {
        private PseudoHttpdTrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public boolean isClientTrusted(X509Certificate[] x509Certificates) {
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] x509Certificates) {
            return true;
        }
    }
}

