/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CardServProxy;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.ListenPort;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.cws.CwsConnectorManager;
import com.bowman.cardserv.cws.ServiceMapping;
import com.bowman.cardserv.interfaces.CamdMessageListener;
import com.bowman.cardserv.interfaces.XmlConfigurable;
import com.bowman.cardserv.session.SessionManager;
import com.bowman.cardserv.tv.CccamParser;
import com.bowman.cardserv.tv.DvbviewerParser;
import com.bowman.cardserv.tv.NeutrinoParser;
import com.bowman.cardserv.tv.ServicesParser;
import com.bowman.cardserv.tv.TvService;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.util.FileChangeListener;
import com.bowman.util.FileWatchdog;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class CaProfile
implements XmlConfigurable,
FileChangeListener {
    public static final CaProfile MULTIPLE = new CaProfile("*");
    public static final CaProfile CATCHALL;
    private String name;
    private boolean enabled;
    private boolean cacheOnly;
    private boolean debug;
    private boolean mismatchedCards;
    private Boolean requireProviderMatch;
    private Boolean checkLength;
    private int caId;
    private int networkId;
    private long maxCwWait;
    private long congestionLimit;
    private int serviceConflicts;
    private String servicesFile;
    private String providerFilter;
    private String fileCaId;
    private String servicesFileFormat;
    private FileWatchdog servicesFwd;
    private Properties previousPorts;
    private CamdMessageListener listener;
    private Map services = new HashMap();
    private List listenPorts = new ArrayList();
    private Set predefinedProviders = new HashSet();
    private Set predefinedLengths = new HashSet();
    private static Properties caNames;

    public CaProfile() {
    }

    public CaProfile(String name) {
        this.name = name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        this.name = xml.getStringValue("name");
        if (MULTIPLE.getName().equals(this.name) || CATCHALL.getName().equals(this.name)) {
            throw new ConfigException(xml.getFullName(), "Invalid profile name: " + this.name);
        }
        this.enabled = "true".equalsIgnoreCase(xml.getStringValue("enabled", "true"));
        this.debug = "true".equalsIgnoreCase(xml.getStringValue("debug", "true"));
        this.cacheOnly = "true".equalsIgnoreCase(xml.getStringValue("cache-only", "false"));
        this.requireProviderMatch = null;
        this.checkLength = null;
        try {
            this.requireProviderMatch = "true".equalsIgnoreCase(xml.getStringValue("require-provider-match")) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (ConfigException e) {
            this.requireProviderMatch = null;
        }
        try {
            this.checkLength = "true".equalsIgnoreCase(xml.getStringValue("check-ecm-length")) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (ConfigException e) {
            this.checkLength = null;
        }
        try {
            this.maxCwWait = xml.getTimeValue("max-cw-wait", "s");
        }
        catch (ConfigException e) {
            this.maxCwWait = -1L;
        }
        if (this.maxCwWait != -1L) {
            if (this.maxCwWait <= 100L) {
                throw new ConfigException(xml.getFullName(), "max-cw-wait must be > 100 ms");
            }
            try {
                this.congestionLimit = xml.getTimeValue("congestion-limit", (int)this.maxCwWait / 1000, "s");
                if (this.maxCwWait < 1000L && this.congestionLimit == 0L) {
                    this.congestionLimit = this.maxCwWait;
                }
                if (this.congestionLimit > this.maxCwWait || this.congestionLimit < this.maxCwWait / 2L) {
                    throw new ConfigException(xml.getFullName(), "congestion-limit must be between max-cw-wait/2 and max-cw-wait");
                }
            }
            catch (ConfigException e) {
                this.congestionLimit = this.maxCwWait;
            }
        } else {
            this.congestionLimit = -1L;
        }
        if (this.enabled) {
            try {
                this.caId = Integer.parseInt(xml.getStringValue("ca-id", "0000"), 16);
            }
            catch (NumberFormatException e) {
                throw new ConfigException(xml.getFullName(), "ca-id", "Bad hex integer value: " + e.getMessage());
            }
            try {
                this.networkId = Integer.parseInt(xml.getStringValue("network-id", "0000"), 16);
            }
            catch (NumberFormatException e) {
                throw new ConfigException(xml.getFullName(), "network-id", "Bad hex integer value: " + e.getMessage());
            }
            if (this.networkId == 0 && CardServProxy.logger != null) {
                CardServProxy.logger.warning("No original network-id set for profile: " + this.name);
            }
            this.predefinedProviders.clear();
            String[] providerIdents = xml.getStringValue("provider-idents", "").split(",");
            for (int i = 0; i < providerIdents.length; ++i) {
                providerIdents[i] = providerIdents[i].trim();
                try {
                    if (providerIdents[i].length() <= 0) continue;
                    this.predefinedProviders.add(new Integer(DESUtil.byteStringToInt(providerIdents[i])));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ConfigException(xml.getFullName(), "provider-idents", "Bad provider value: " + e.getMessage());
                }
            }
            Integer defaultPi = new Integer(0);
            if (this.predefinedProviders.size() > 1 && this.requireProviderMatch == null) {
                this.requireProviderMatch = Boolean.TRUE;
            }
            if (this.predefinedProviders.size() == 1 && this.predefinedProviders.contains(defaultPi) && this.requireProviderMatch == null) {
                this.requireProviderMatch = Boolean.FALSE;
            }
            if (this.requireProviderMatch != null && !this.requireProviderMatch.booleanValue()) {
                this.predefinedProviders.add(defaultPi);
            }
            this.predefinedLengths.clear();
        }
        if (this.servicesFwd != null) {
            this.servicesFwd.addFileChangeListener(null);
            this.servicesFwd.removeAllFiles();
            this.servicesFwd.interrupt();
            this.servicesFwd = null;
        }
        if (this.enabled) {
            this.updateListenPorts(xml);
            this.servicesFile = null;
            try {
                this.servicesFile = xml.getStringValue("services-file");
            }
            catch (ConfigException providerIdents) {
                // empty catch block
            }
            if (this.servicesFile != null) {
                try {
                    this.providerFilter = null;
                    try {
                        this.providerFilter = xml.getSubConfig("services-file").getStringValue("filter");
                    }
                    catch (ConfigException providerIdents) {
                        // empty catch block
                    }
                    this.fileCaId = null;
                    try {
                        this.fileCaId = xml.getSubConfig("services-file").getStringValue("ca-id");
                    }
                    catch (ConfigException providerIdents) {
                        // empty catch block
                    }
                    this.servicesFileFormat = xml.getSubConfig("services-file").getStringValue("format", "enigma");
                    this.parseServicesFile();
                    this.servicesFwd = new FileWatchdog(this.servicesFile, 3000L);
                    this.servicesFwd.addFileChangeListener(this);
                    this.servicesFwd.start();
                    return;
                }
                catch (FileNotFoundException e) {
                    if (CardServProxy.logger == null) return;
                    CardServProxy.logger.warning("Services file not found: " + this.servicesFile);
                    return;
                }
                catch (Exception e) {
                    String path = this.servicesFile;
                    try {
                        path = new File(this.servicesFile).getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (CardServProxy.logger != null) {
                        CardServProxy.logger.throwing(e);
                        throw new ConfigException(xml.getSubConfig("services-file").getFullName(), "Unable to parse '" + path + "' : " + e);
                    } else {
                        e.printStackTrace();
                    }
                    throw new ConfigException(xml.getSubConfig("services-file").getFullName(), "Unable to parse '" + path + "' : " + e);
                }
            }
            this.services = Collections.EMPTY_MAP;
            this.serviceConflicts = 0;
            return;
        }
        this.removeAllPorts(null);
    }

    private int removeAllPorts(String protocol) {
        int count = 0;
        Iterator iter = new ArrayList(this.listenPorts).iterator();
        while (iter.hasNext()) {
            ListenPort lp = (ListenPort)iter.next();
            if (protocol != null && !protocol.equals(lp.getProtocol())) continue;
            this.listenPorts.remove(lp);
            lp.destroy();
            ++count;
        }
        return count;
    }

    private void updateListenPorts(ProxyXmlConfig xml) throws ConfigException {
        ListenPort lp;
        Iterator iter;
        Properties newPorts = xml.toProperties();
        if (newPorts.equals(this.previousPorts)) {
            return;
        }
        this.previousPorts = newPorts;
        if (CardServProxy.logger != null) {
            CardServProxy.logger.fine("Listen port changes detected for: " + this);
        }
        if (this.removeAllPorts(null) > 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if ((iter = xml.getMultipleSubConfigs("newcamd")) != null) {
            while (iter.hasNext()) {
                lp = new ListenPort("Newcamd");
                this.listenPorts.add(lp);
                lp.configUpdated((ProxyXmlConfig)iter.next());
                if (this.listener == null) continue;
                lp.start(this.listener, this);
            }
        }
        if ((iter = xml.getMultipleSubConfigs("radegast")) != null) {
            while (iter.hasNext()) {
                lp = new ListenPort("Radegast");
                this.listenPorts.add(lp);
                lp.configUpdated((ProxyXmlConfig)iter.next());
                if (this.listener == null) continue;
                lp.start(this.listener, this);
            }
        }
    }

    private void parseServicesFile() throws IOException {
        if ("enigma".equalsIgnoreCase(this.servicesFileFormat)) {
            ServicesParser parser = new ServicesParser(this.servicesFile);
            this.services = parser.parse(this.providerFilter, this.name, this.networkId);
            this.serviceConflicts = parser.getConflicts();
        } else if ("cccam".equalsIgnoreCase(this.servicesFileFormat)) {
            CccamParser parser = new CccamParser(this.servicesFile);
            String caStr = CaProfile.getCaName(this.caId, false);
            if (this.fileCaId != null) {
                caStr = this.fileCaId;
            }
            if (this.providerFilter == null || this.providerFilter.length() == 0) {
                if (this.requireProviderMatch != null && this.requireProviderMatch.booleanValue()) {
                    StringBuffer sb = new StringBuffer();
                    Iterator iter = this.getProviderSet().iterator();
                    while (iter.hasNext()) {
                        Integer pi = (Integer)iter.next();
                        sb.append(DESUtil.intToByteString(pi, 3).replaceAll(" ", ""));
                        if (!iter.hasNext()) continue;
                        sb.append(' ');
                    }
                    this.providerFilter = sb.toString();
                } else {
                    this.providerFilter = "000000";
                }
            }
            if (CardServProxy.logger != null) {
                CardServProxy.logger.fine("Profile '" + this.name + "' parsing '" + this.servicesFile + "' for [" + caStr + "], filter: " + this.providerFilter);
            }
            this.services = parser.parse(caStr, this.providerFilter, this.name, this.getNetworkIdStr());
            this.serviceConflicts = parser.getConflicts();
            if (CardServProxy.logger != null) {
                CardServProxy.logger.fine("Profile '" + this.name + "' parsing '" + this.servicesFile + "' found " + this.services.size() + " services, " + this.serviceConflicts + " conflicts.");
            }
        } else if ("dvbviewer".equalsIgnoreCase(this.servicesFileFormat)) {
            DvbviewerParser parser = new DvbviewerParser(this.servicesFile);
            this.services = parser.parse(this.providerFilter, this.name, this.networkId);
            this.serviceConflicts = parser.getConflicts();
        } else if ("simple".equalsIgnoreCase(this.servicesFileFormat)) {
            Properties p = new Properties();
            p.load(new BufferedInputStream(new FileInputStream(this.servicesFile)));
            this.services = new HashMap();
            String networkIdStr = this.getNetworkIdStr();
            Enumeration<Object> e = p.keys();
            while (e.hasMoreElements()) {
                String id = (String)e.nextElement();
                TvService service = new TvService(new String[]{id, "00000000", "0000", networkIdStr, "1", "0"}, this.name);
                service.setName(p.getProperty(id));
                this.services.put(new Integer(service.getId()), service);
            }
            this.serviceConflicts = 0;
        } else if ("neutrino".equalsIgnoreCase(this.servicesFileFormat)) {
            NeutrinoParser parser = new NeutrinoParser(this.servicesFile);
            this.services = parser.parse(this.providerFilter, this.name, this.networkId);
            this.serviceConflicts = parser.getConflicts();
        } else {
            throw new IOException("Unknown format name: " + this.servicesFileFormat);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.removeAllPorts(null);
            this.listener = null;
        }
        this.enabled = enabled;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isCacheOnly() {
        return this.cacheOnly;
    }

    public boolean isMismatchedCards() {
        return this.mismatchedCards;
    }

    public void setMismatchedCards(boolean mismatchedCards) {
        this.mismatchedCards = mismatchedCards;
    }

    public boolean isRequireProviderMatch() {
        if (this.requireProviderMatch == null) {
            Set set = this.getProviderSet();
            if (set.isEmpty()) {
                return false;
            }
            return set.size() != 1 || !set.contains(new Integer(0));
        }
        return this.requireProviderMatch;
    }

    public boolean isCheckLength() {
        if (this.checkLength == null) {
            return !this.getLengthSet().isEmpty();
        }
        return this.checkLength;
    }

    public int getCaId() {
        return this.caId;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public String getCaIdStr() {
        if (this.caId < 0) {
            return "undefined";
        }
        return CaProfile.getCaName(this.getCaId());
    }

    public String getNetworkIdStr() {
        return DESUtil.intToHexString(this.networkId, 4);
    }

    public Map getServices() {
        return this.services;
    }

    public int getServiceConflicts() {
        return this.serviceConflicts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaProfile caProfile = (CaProfile)o;
        return this.name.equals(caProfile.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void fileChanged(String name) {
        try {
            CardServProxy.logger.info("Services file '" + name + "' updated, parsing...");
            this.parseServicesFile();
            CardServProxy.logger.info("Services: " + this.services.size() + " Conflicts: " + this.serviceConflicts);
        }
        catch (Exception e) {
            CardServProxy.logger.severe("Unable to parse services file '" + name + "': " + e, e);
        }
    }

    public void startListening(CamdMessageListener listener) {
        this.listener = listener;
        Iterator iter = this.listenPorts.iterator();
        while (iter.hasNext()) {
            ((ListenPort)iter.next()).start(listener, this);
        }
    }

    public List getListenPorts() {
        return new ArrayList(this.listenPorts);
    }

    protected void addListenPort(ListenPort lp) {
        if (!this.listenPorts.contains(lp)) {
            this.listenPorts.add(lp);
        }
    }

    protected void removeListenPort(ListenPort lp) {
        if (lp != null) {
            this.listenPorts.remove(lp);
        }
    }

    public int getNewcamdPortCount() {
        if (this == MULTIPLE) {
            return 1;
        }
        int count = 0;
        Iterator iter = this.listenPorts.iterator();
        while (iter.hasNext()) {
            if (!"Newcamd".equalsIgnoreCase(((ListenPort)iter.next()).getProtocol())) continue;
            ++count;
        }
        return count;
    }

    public int getSessionCount() {
        return SessionManager.getInstance().getSessionCount(this.name);
    }

    public long getMaxCwWait() {
        return this.maxCwWait;
    }

    public long getCongestionLimit() {
        return this.congestionLimit;
    }

    public String toString() {
        if (this == MULTIPLE) {
            return "Ca[" + this.name + "]";
        }
        return "Ca[" + this.name + ":" + this.getNetworkIdStr() + ":" + CaProfile.getCaName(this.caId, false) + "]";
    }

    private static String getCaName(int id) {
        return CaProfile.getCaName(id, true);
    }

    public Set getProviderSet() {
        CwsConnectorManager cm = ProxyConfig.getInstance().getConnManager();
        Set set = cm == null ? new TreeSet() : cm.getMergedProviders(this.name);
        set.addAll(this.predefinedProviders);
        return set;
    }

    public Set getLengthSet() {
        return this.predefinedLengths;
    }

    public Integer[] getProviderIdents() {
        Set set = this.getProviderSet();
        return set.toArray(new Integer[set.size()]);
    }

    public String getProviderIdentsStr() {
        return ProxyConfig.providerIdentsToString(this.getProviderSet());
    }

    public ServiceMapping[] getServices(boolean canDecode) {
        if (this == MULTIPLE) {
            throw new IllegalStateException("getServices(" + canDecode + ") called on profile *.");
        }
        return ProxyConfig.getInstance().getConnManager().getServicesForProfile(this.name, canDecode);
    }

    public String getKeyStr() {
        return CaProfile.getKeyStr(this);
    }

    public static String getKeyStr(CaProfile profile) {
        return CaProfile.getKeyStr(profile.networkId, profile.caId);
    }

    public static String getKeyStr(int networkId, int caId) {
        return DESUtil.intToHexString(networkId, 4) + '-' + DESUtil.intToHexString(caId, 4);
    }

    private static String getCaName(int id, boolean includeName) {
        String caId = Integer.toHexString(id);
        while (caId.length() < 4) {
            caId = "0" + caId;
        }
        if (!includeName) {
            return caId;
        }
        String caName = caNames.getProperty(caId.toUpperCase());
        if (caName == null) {
            caName = caNames.getProperty(caId.substring(0, 2).toUpperCase() + "00");
        }
        if (caName == null) {
            return "Unknown:" + caId;
        }
        return caName + ":" + caId;
    }

    static {
        MULTIPLE.setEnabled(true);
        CaProfile.MULTIPLE.caId = -1;
        ListenPort lp = new ListenPort("Csp");
        lp.setProfile(MULTIPLE);
        CaProfile.MULTIPLE.listenPorts.add(lp);
        CATCHALL = new CaProfile("**");
        CATCHALL.setEnabled(true);
        CaProfile.CATCHALL.caId = 65534;
        CaProfile.CATCHALL.networkId = 65534;
        CaProfile.CATCHALL.cacheOnly = true;
        CaProfile.CATCHALL.maxCwWait = -1L;
        CaProfile.CATCHALL.congestionLimit = -1L;
        caNames = new Properties();
        try {
            caNames.load(CaProfile.class.getResourceAsStream("ca.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

