/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.cws;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CaidProviderPair;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardData;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.cws.CwsConnectorManager;
import com.bowman.cardserv.cws.NewcamdCwsConnector;
import com.bowman.cardserv.interfaces.CwsConnector;
import com.bowman.cardserv.interfaces.CwsListener;
import com.bowman.cardserv.interfaces.MultiCwsConnector;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.tv.TvService;
import com.bowman.cardserv.util.ProxyXmlConfig;
import java.io.IOException;
import java.net.SocketException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ChameleonCwsConnector
extends NewcamdCwsConnector
implements MultiCwsConnector,
CwsListener {
    private Set selectedProfiles;
    private Set receivedData = new HashSet();
    private Set unmappedData = Collections.synchronizedSet(new HashSet());
    private Map profileMap = new HashMap();
    private String remoteVersion;
    private boolean catchAll;

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        String profiles;
        super.configUpdated(xml);
        this.clientId = new byte[]{109, 103};
        this.profile = CaProfile.MULTIPLE;
        this.asynchronous = true;
        this.noEncrypt = false;
        this.overrideChecks = true;
        this.catchAll = "true".equalsIgnoreCase(xml.getStringValue("catch-all", "false"));
        if (this.catchAll) {
            ProxyConfig.getInstance().addCatchAll(this.name);
        }
        if (!this.enabled || !this.catchAll) {
            ProxyConfig.getInstance().removeCatchAll(this.name);
        }
        if ((profiles = xml.getStringValue("profiles", "")).length() > 0) {
            this.selectedProfiles = new HashSet();
            String[] names = profiles.split(" ");
            ProxyConfig config = ProxyConfig.getInstance();
            for (int i = 0; i < names.length; ++i) {
                CaProfile profile = config.getProfile(names[i]);
                if (profile == null || profile == CaProfile.MULTIPLE) continue;
                this.selectedProfiles.add(profile);
            }
        } else {
            this.selectedProfiles = null;
        }
        if (!this.receivedData.isEmpty()) {
            this.refreshMappings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.alive = true;
        try {
            CamdNetMessage msg = CamdNetMessage.getNewcamdLoginMessage(this.user, this.password, this.clientId);
            msg.getFixedData()[9] = 17;
            this.doLogin(msg);
            msg = new CamdNetMessage(214);
            this.sendMessage(msg);
            if (this.conn != null && this.conn.isConnected()) {
                this.conn.setSoTimeout(0);
                this.connecting = false;
                this.connManager.addCwsListener(this);
                while (this.alive && this.conn != null) {
                    msg = this.conn.readMessage();
                    this.lastSent = null;
                    if (msg == null) {
                        this.alive = false;
                        this.logger.warning("Connection closed");
                        continue;
                    }
                    if (msg.isEcm()) {
                        if (this.reportReply(msg)) continue;
                        this.logger.fine("No listener found for ECM reply: " + msg);
                        continue;
                    }
                    if (msg.isEmm()) {
                        this.logger.fine("EMM reply ignored: " + msg);
                        continue;
                    }
                    if (msg.isKeepAlive()) {
                        this.logger.fine("Keep-alive reply received: [" + msg.getSequenceNr() + "]");
                        this.reportReply(msg);
                        continue;
                    }
                    if (msg.isOsdMsg()) {
                        this.logger.info("Mgcamd OSD message received: " + msg);
                        continue;
                    }
                    this.handleExtendedNewcamd(msg);
                }
            }
        }
        catch (SocketException e) {
            this.logger.warning("Connection closed: " + e.getMessage());
        }
        catch (IOException e) {
            this.logger.throwing("Exception reading/decrypting message: " + e, e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn = null;
        this.remoteCard = null;
        this.receivedData.clear();
        this.unmappedData.clear();
        this.remoteVersion = null;
        this.connManager.removeCwsListener(this);
        this.reset();
        if (!this.connecting) {
            this.lastDisconnectTimeStamp = System.currentTimeMillis();
            this.connManager.cwsDisconnected(this);
            CwsConnectorManager cwsConnectorManager = this.connManager;
            synchronized (cwsConnectorManager) {
                this.connManager.notifyAll();
            }
        }
        this.readerThread = null;
        this.connecting = false;
        this.logger.info("Connector dying");
    }

    public boolean sendEcmRequest(CamdNetMessage request, ProxySession listener) {
        request.setCaIdInHdr(request.getCaId());
        request.setProviderInHdr(request.getProviderIdent());
        return super.sendEcmRequest(request, listener);
    }

    public boolean canDecode(CamdNetMessage request) {
        if (this.catchAll) {
            return true;
        }
        if (request.getCaId() <= 0 || request.getProviderIdent() == -1) {
            return false;
        }
        return this.profileMap.containsKey(new CaidProviderPair(request.getCaId(), request.getProviderIdent()));
    }

    protected void setRemoteCard(CardData card) {
        super.setRemoteCard(card);
        Integer[] providers = card.getProvidersAsInt();
        for (int i = 0; i < providers.length; ++i) {
            this.addProfileMapping(new CaidProviderPair(card.getCaId(), providers[i]), true);
        }
    }

    private void handleExtendedNewcamd(CamdNetMessage msg) {
        switch (msg.getCommandTag()) {
            case 211: {
                CaidProviderPair pair = new CaidProviderPair(msg.getCaIdFromHdr(), msg.getProviderFromHdr());
                this.receivedData.add(pair);
                this.addProfileMapping(pair, true);
                this.logger.fine("Received card data [" + pair + "] (port: " + msg.getServiceId() + ")");
                break;
            }
            case 212: {
                CaidProviderPair remPair = new CaidProviderPair(msg.getCaIdFromHdr(), msg.getProviderFromHdr());
                this.profileMap.remove(remPair);
                this.unmappedData.remove(remPair);
                this.logger.fine("Removed card data [" + remPair + "] (port: " + msg.getServiceId() + ")");
                break;
            }
            case 214: {
                this.remoteVersion = msg.getStringData()[0];
                break;
            }
            case 215: {
                this.logger.fine("Sid list ignored: " + DESUtil.bytesToString(msg.getRawIn()));
                break;
            }
            default: {
                this.logger.warning("Unknown msg received from CWS: " + msg.getCommandName() + " - " + DESUtil.bytesToString(msg.getRawIn()));
            }
        }
    }

    private boolean addProfileMapping(CaidProviderPair pair, boolean log) {
        Set profiles = this.selectedProfiles == null ? this.config.getRealProfiles() : this.selectedProfiles;
        boolean mapped = false;
        Iterator iter = profiles.iterator();
        while (iter.hasNext()) {
            CaProfile profile = (CaProfile)iter.next();
            if (profile.getCaId() != pair.caId || !profile.getProviderSet().contains(new Integer(pair.providerIdent))) continue;
            if (this.profileMap.containsKey(pair) && profile != this.profileMap.get(pair)) {
                this.logger.warning("Ambigious situation [" + pair + "] maps to multiple profiles: " + profile + ", " + this.profileMap.get(pair) + " (specify <profiles> list for connector and exclude overlapping profiles)");
                continue;
            }
            CaProfile previous = this.profileMap.put(pair, profile);
            if (previous == null || previous != profile) {
                if (log) {
                    this.logger.info("Mapped [" + pair + "] to: " + profile);
                } else {
                    this.logger.fine("Mapped [" + pair + "] to: " + profile);
                }
            }
            mapped = true;
        }
        if (!mapped) {
            this.unmappedData.add(pair);
        }
        return mapped;
    }

    private void refreshMappings() {
        this.profileMap.clear();
        this.unmappedData.clear();
        Iterator iter = this.receivedData.iterator();
        while (iter.hasNext()) {
            CaidProviderPair pair = (CaidProviderPair)iter.next();
            this.addProfileMapping(pair, false);
        }
    }

    public Properties getRemoteInfo() {
        Properties p = new Properties();
        Iterator iter = this.profileMap.values().iterator();
        while (iter.hasNext()) {
            CaProfile profile = (CaProfile)iter.next();
            String label = DESUtil.intToHexString(profile.getNetworkId(), 4);
            p.setProperty(label + "-caid", DESUtil.intToHexString(profile.getCaId(), 4));
            p.setProperty(label + "-providers", ProxyConfig.providerIdentsToString(profile.getProviderIdents()));
        }
        if (this.remoteVersion != null) {
            p.setProperty("remote-version", this.remoteVersion);
        }
        if (!this.unmappedData.isEmpty()) {
            p.setProperty("umapped-data", this.unmappedData.toString());
        }
        if (this.catchAll) {
            p.setProperty("catch-all", "true");
        }
        return p;
    }

    public boolean hasMatchingProfile(int networkId, int caId) {
        if (this.catchAll) {
            return true;
        }
        if (networkId == 0 || caId == 0) {
            return false;
        }
        Iterator iter = this.profileMap.values().iterator();
        while (iter.hasNext()) {
            CaProfile profile = (CaProfile)iter.next();
            if (profile.getNetworkId() != networkId || profile.getCaId() != caId) continue;
            return true;
        }
        return false;
    }

    public void clearRemoteState(boolean all) {
        Iterator iter = this.profileMap.values().iterator();
        while (iter.hasNext()) {
            CaProfile profile = (CaProfile)iter.next();
            this.connManager.getServiceMapper(profile.getName()).resetStatus(this.name, all);
        }
    }

    public String getLabel() {
        return "ChameleonCws[" + this.name + ":*]";
    }

    public String getProtocol() {
        return "Chameleon";
    }

    public void cwsConnected(CwsConnector cws) {
        this.refreshMappings();
    }

    public void cwsDisconnected(CwsConnector cws) {
        this.refreshMappings();
    }

    public void cwsConnectionFailed(CwsConnector cws, String message) {
    }

    public void cwsEcmTimeout(CwsConnector cws, String message, int failureCount) {
    }

    public void cwsLostService(CwsConnector cws, TvService service, boolean show) {
    }

    public void cwsFoundService(CwsConnector cws, TvService service, boolean show) {
    }

    public void cwsInvalidCard(CwsConnector cws, String message) {
    }

    public void cwsProfileChanged(CaProfile profile, boolean added) {
        this.refreshMappings();
    }
}

