/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.rmi;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CardServProxy;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.cws.ServiceMapping;
import com.bowman.cardserv.interfaces.CacheHandler;
import com.bowman.cardserv.interfaces.CwsConnector;
import com.bowman.cardserv.interfaces.CwsListener;
import com.bowman.cardserv.interfaces.EcmTransactionListener;
import com.bowman.cardserv.interfaces.LogListener;
import com.bowman.cardserv.interfaces.ProxyPlugin;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.interfaces.UserManager;
import com.bowman.cardserv.interfaces.UserStatusListener;
import com.bowman.cardserv.rmi.CacheStatus;
import com.bowman.cardserv.rmi.CwsStatus;
import com.bowman.cardserv.rmi.PluginStatus;
import com.bowman.cardserv.rmi.ProfileStatus;
import com.bowman.cardserv.rmi.RemoteEvent;
import com.bowman.cardserv.rmi.RemoteListener;
import com.bowman.cardserv.rmi.RemoteProxy;
import com.bowman.cardserv.rmi.UserStatus;
import com.bowman.cardserv.session.CspSession;
import com.bowman.cardserv.session.EcmTransaction;
import com.bowman.cardserv.session.NewcamdSession;
import com.bowman.cardserv.session.SeenEntry;
import com.bowman.cardserv.session.SessionManager;
import com.bowman.cardserv.tv.TvService;
import com.bowman.cardserv.util.ProxyLogger;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;

public class RemoteHandler
extends UnicastRemoteObject
implements RemoteProxy,
UserStatusListener,
CwsListener,
EcmTransactionListener,
LogListener,
Runnable {
    private static final long EVENT_START_DELAY = 15000L;
    private Map listeners = new HashMap();
    private CardServProxy proxy;
    private ProxyConfig config;
    private ProxyLogger logger;
    private SessionManager sm;
    private List eventQueue = Collections.synchronizedList(new ArrayList());
    private Thread eventThread;
    private String name;

    public RemoteHandler(int port, CardServProxy proxy) throws RemoteException {
        super(port);
        this.proxy = proxy;
        this.config = ProxyConfig.getInstance();
        this.logger = ProxyLogger.getLabeledLogger(this.getClass().getName());
        this.sm = SessionManager.getInstance();
        ProxyLogger.setLogListener(this);
    }

    public void start() {
        this.eventThread = new Thread((Runnable)this, "RemoteEventDispatcherThread");
        this.eventThread.start();
        this.sm.addUserStatusListener(this);
        this.config.getConnManager().addCwsListener(this);
        this.fireRemoteEvent(new RemoteEvent(10, this.name, "Proxy node started.", null));
    }

    private synchronized void fireRemoteEvent(RemoteEvent event) {
        if (this.eventThread == null) {
            return;
        }
        if (event.getType() == 2 && System.currentTimeMillis() - this.proxy.getStartTime() < 15000L) {
            return;
        }
        this.eventQueue.add(event);
        this.notify();
    }

    public void addRemoteListener(RemoteListener listener) {
        this.addRemoteListener(listener, null);
    }

    public void addRemoteListener(RemoteListener listener, String profileName) {
        this.listeners.put(listener, profileName);
        this.logger.fine("RemoteListener added: " + listener + " profile: " + profileName);
    }

    public void removeRemoteListener(RemoteListener listener) {
        if (this.listeners.remove(listener) != null) {
            this.logger.fine("RemoteListener removed: " + listener);
        }
    }

    private Map getConnectors(String[] profiles) {
        if (profiles == null) {
            return new HashMap(this.config.getConnManager().getConnectors());
        }
        HashMap connectors = new HashMap();
        for (int i = 0; i < profiles.length; ++i) {
            if (!this.profileExists(profiles[i])) continue;
            connectors.putAll(this.config.getConnManager().getConnectors(profiles[i]));
        }
        return connectors;
    }

    private List getSessions(String[] profiles, boolean activeOnly) {
        if (profiles == null) {
            return activeOnly ? this.sm.getActiveSessions() : this.sm.getSessions();
        }
        ArrayList sessions = new ArrayList();
        for (int i = 0; i < profiles.length; ++i) {
            if (!this.profileExists(profiles[i])) continue;
            sessions.addAll(activeOnly ? this.sm.getActiveSessions(profiles[i]) : this.sm.getSessions(profiles[i]));
        }
        return sessions;
    }

    private List getSeenData(String[] profiles, boolean failures) {
        if (failures) {
            return this.sm.getFailData();
        }
        if (profiles == null) {
            return this.sm.getSeenData(null);
        }
        ArrayList entries = new ArrayList();
        for (int i = 0; i < profiles.length; ++i) {
            if (!this.profileExists(profiles[i])) continue;
            entries.addAll(this.sm.getSeenData(profiles[i]));
        }
        return entries;
    }

    public int getCwsCount(String[] profiles) {
        return this.getConnectors(profiles).size();
    }

    public int getSessionCount(String[] profiles, boolean activeOnly) {
        if (profiles == null) {
            return activeOnly ? this.sm.getActiveSessions().size() : this.sm.getSessionCount();
        }
        int count = 0;
        if (activeOnly) {
            return this.getSessions(profiles, true).size();
        }
        for (int i = 0; i < profiles.length; ++i) {
            if (!this.profileExists(profiles[i])) continue;
            count += this.sm.getSessionCount(profiles[i]);
        }
        return count;
    }

    public int getCwsCapacity(String[] profiles) throws RemoteException {
        Map connectors = this.getConnectors(profiles);
        int total = 0;
        Iterator iter = connectors.values().iterator();
        while (iter.hasNext()) {
            CwsConnector cws = (CwsConnector)iter.next();
            if (cws.getCapacity() == -1) continue;
            total += cws.getCapacity();
        }
        return total;
    }

    public long getProxyStartTime() {
        return this.proxy.getStartTime();
    }

    public CwsStatus getCwsStatus(String name) {
        CwsConnector cws = this.config.getConnManager().getCwsConnectorByName(name);
        if (cws == null) {
            return null;
        }
        return new CwsStatus(cws);
    }

    public CwsStatus[] getMultiCwsStatus(String[] profiles) {
        Map connectors = this.getConnectors(profiles);
        CwsStatus[] result = new CwsStatus[connectors.size()];
        int i = 0;
        Iterator iter = connectors.values().iterator();
        while (iter.hasNext()) {
            CwsConnector cws = (CwsConnector)iter.next();
            result[i++] = new CwsStatus(cws);
        }
        return result;
    }

    public UserStatus[] getUsersStatus(String[] profiles, boolean activeOnly) {
        UserManager um = this.config.getUserManager();
        List sessions = this.getSessions(profiles, activeOnly);
        TreeMap<String, UserStatus> users = new TreeMap<String, UserStatus>();
        Iterator iter = sessions.iterator();
        while (iter.hasNext()) {
            UserStatus user;
            ProxySession session = (ProxySession)iter.next();
            String name = session.getUser();
            if (users.containsKey(name)) {
                user = (UserStatus)users.get(name);
                user.addSession(session);
                continue;
            }
            String displayName = session.isTempUser() ? session.getLoginName() : um.getDisplayName(name);
            user = new UserStatus(name, displayName, um.getMaxConnections(name), false);
            user.addSession(session);
            users.put(name, user);
        }
        return users.values().toArray(new UserStatus[users.size()]);
    }

    public SeenEntry[] getSeenUsers(String[] profiles, String userName, boolean failures) throws RemoteException {
        List entries = this.getSeenData(profiles, failures);
        if (userName != null) {
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                SeenEntry se = (SeenEntry)iter.next();
                if (se.getName().equalsIgnoreCase(userName)) continue;
                iter.remove();
            }
        }
        Collections.sort(entries);
        return entries.toArray(new SeenEntry[entries.size()]);
    }

    public UserStatus getUserStatus(String userName, boolean activeOnly) {
        UserManager um = this.config.getUserManager();
        List sessions = this.getSessions(null, activeOnly);
        UserStatus user = null;
        Iterator iter = sessions.iterator();
        while (iter.hasNext()) {
            ProxySession session = (ProxySession)iter.next();
            if (!userName.equalsIgnoreCase(session.getUser())) continue;
            if (user == null) {
                String displayName = session.isTempUser() ? session.getLoginName() : um.getDisplayName(userName);
                user = new UserStatus(userName, displayName, um.getMaxConnections(userName), um.isAdmin(userName));
            }
            user.addSession(session);
        }
        return user;
    }

    private boolean profileExists(String profileName) {
        return this.config.getProfile(profileName) != null;
    }

    public String getUserPasswd(String userName) {
        return this.config.getUserManager().getPassword(userName);
    }

    public ProfileStatus[] getUserProfiles(String userName) throws RemoteException {
        Set profiles = this.config.getUserManager().getAllowedProfiles(userName);
        if (profiles.isEmpty()) {
            return this.getProfiles();
        }
        ArrayList<ProfileStatus> ps = new ArrayList<ProfileStatus>();
        ps.add(new ProfileStatus(CaProfile.MULTIPLE));
        Iterator iter = profiles.iterator();
        while (iter.hasNext()) {
            CaProfile profile = this.config.getProfile((String)iter.next());
            if (profile == null) continue;
            ps.add(new ProfileStatus(profile));
        }
        return ps.toArray(new ProfileStatus[ps.size()]);
    }

    public boolean authenticateUser(String userName, String pass) {
        return this.config.getUserManager() != null && this.config.getUserManager().authenticate(userName, pass);
    }

    public boolean isAdmin(String userName) throws RemoteException {
        return this.config.getUserManager().isAdmin(userName);
    }

    public String getEmailAddress(String userName) {
        return this.config.getUserManager().getEmailAddress(userName);
    }

    public String[] getLocalUsers() {
        return this.getLocalUsers(null);
    }

    public String[] getLocalUsers(String profileName) {
        String[] names = this.config.getUserManager().getUserNames();
        if (profileName != null) {
            ArrayList<String> profileUsers = new ArrayList<String>();
            for (int i = 0; i < names.length; ++i) {
                Set profiles = this.config.getUserManager().getAllowedProfiles(names[i]);
                if (profiles == null || profiles.isEmpty()) {
                    profileUsers.add(names[i]);
                    continue;
                }
                if (!profiles.contains(profileName)) continue;
                profileUsers.add(names[i]);
            }
            return profileUsers.toArray(new String[profileUsers.size()]);
        }
        return names;
    }

    public TvService[] getServices(String name, boolean merge) {
        List services = this.config.getConnManager().getServicesForConnector(name, true, false);
        if (services == null) {
            return null;
        }
        if (!merge) {
            return services.toArray(new TvService[services.size()]);
        }
        HashMap<Integer, TvService> map = new HashMap<Integer, TvService>();
        Iterator iter = services.iterator();
        while (iter.hasNext()) {
            TvService service = (TvService)iter.next();
            map.put(new Integer(service.getId()), service);
        }
        return map.values().toArray(new TvService[map.size()]);
    }

    public TvService[] getParsedServices(String[] profiles) {
        if (profiles == null) {
            Set names = this.config.getProfiles().keySet();
            profiles = names.toArray(new String[names.size()]);
        }
        TreeSet all = new TreeSet();
        for (int i = 0; i < profiles.length; ++i) {
            CaProfile profile = this.config.getProfile(profiles[i]);
            all.addAll(profile.getServices().values());
        }
        return all.toArray(new TvService[all.size()]);
    }

    public TvService[] getCannotDecodeServices(String name) {
        List services = this.config.getConnManager().getServicesForConnector(name, false, false);
        if (services == null) {
            return null;
        }
        return services.toArray(new TvService[services.size()]);
    }

    public synchronized TvService[] getWatchedServices(String[] profiles) throws RemoteException {
        Set<Object> p;
        List activeSessions = this.getSessions(profiles, true);
        Set<Object> set = p = profiles == null ? Collections.EMPTY_SET : new HashSet<String>(Arrays.asList(profiles));
        if (!p.contains(CaProfile.MULTIPLE.getName())) {
            activeSessions.addAll(this.sm.getActiveSessions(CaProfile.MULTIPLE.getName()));
        }
        TreeMap<TvService, Integer> services = new TreeMap<TvService, Integer>();
        Iterator iter = activeSessions.iterator();
        while (iter.hasNext()) {
            ProxySession session = (ProxySession)iter.next();
            TvService service = session.getCurrentService();
            if (service.getId() == -1 || !p.isEmpty() && !p.contains(service.getProfileName())) continue;
            if (services.containsKey(service)) {
                services.put(service, new Integer((Integer)services.get(service) + 1));
                continue;
            }
            services.put(service, new Integer(1));
        }
        TvService[] result = new TvService[services.size()];
        Iterator iter2 = services.keySet().iterator();
        for (int i = 0; i < result.length; ++i) {
            result[i] = (TvService)iter2.next();
            result[i].setWatchers((Integer)services.get(result[i]));
        }
        return result;
    }

    public ProfileStatus[] getProfiles() {
        ArrayList profiles = new ArrayList(this.config.getProfiles().values());
        if (!this.config.isCatchAll()) {
            profiles.remove(CaProfile.CATCHALL);
        }
        ProfileStatus[] ps = new ProfileStatus[profiles.size()];
        int i = 0;
        Iterator iter = profiles.iterator();
        while (iter.hasNext()) {
            ps[i++] = new ProfileStatus((CaProfile)iter.next());
        }
        return ps;
    }

    public CacheStatus getCacheStatus() {
        CacheHandler ch = this.config.getCacheHandler();
        return new CacheStatus(ch.getClass().getName(), ch.getUsageStats());
    }

    public PluginStatus[] getPlugins() throws RemoteException {
        Map plugins = this.config.getProxyPlugins();
        PluginStatus[] status = new PluginStatus[plugins.size()];
        int i = 0;
        Iterator iter = plugins.values().iterator();
        while (iter.hasNext()) {
            ProxyPlugin plugin = (ProxyPlugin)iter.next();
            status[i++] = new PluginStatus(plugin);
        }
        return status;
    }

    public boolean resetStatus(String profileName, int serviceId, long customData) {
        if (this.profileExists(profileName)) {
            ServiceMapping sm = new ServiceMapping(serviceId, customData);
            if (!this.config.getConnManager().resetStatus(profileName, sm)) {
                if (customData <= 0L) {
                    sm.setProviderIdent(0xFFFFFF);
                    return this.config.getConnManager().resetStatus(profileName, sm);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public int resetStatus(String cwsName, boolean full) {
        return this.config.getConnManager().resetStatus(cwsName, full);
    }

    public int kickUser(String userName) {
        List sessions = this.sm.getSessions();
        int count = 0;
        Iterator iter = sessions.iterator();
        while (iter.hasNext()) {
            ProxySession session = (ProxySession)iter.next();
            if (!userName.equalsIgnoreCase(session.getUser())) continue;
            this.logger.info("Closing session, user kicked: " + session);
            session.close();
            ++count;
        }
        return count;
    }

    public void shutdown() {
        this.logger.warning("Remote shutdown requested, stopping proxy in 3 secs...");
        new Thread("RemoteShutdownThread"){

            public void run() {
                try {
                    RemoteHandler.this.config.getConnManager().saveServiceMaps();
                    Thread.sleep(3000L);
                    System.exit(0);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public int sendOsdMessage(String userName, String message) {
        List activeSessions = this.getSessions(null, true);
        int count = 0;
        if (userName == null) {
            this.logger.info("Sending newcamd OSD message to all eligible active sessions...");
        } else {
            this.logger.info("Sending newcamd OSD message to all eligible sessions for user '" + userName + "'...");
        }
        Iterator iter = activeSessions.iterator();
        while (iter.hasNext()) {
            ProxySession session = (ProxySession)iter.next();
            if (!(session instanceof NewcamdSession)) continue;
            if (userName != null) {
                if (!userName.equalsIgnoreCase(session.getUser()) || !((NewcamdSession)session).sendOsdMessage(message)) continue;
                ++count;
                continue;
            }
            if (!((NewcamdSession)session).sendOsdMessage(message)) continue;
            ++count;
        }
        this.logger.info("Newcamd OSD message sucessfully sent to " + count + " sessions.");
        return count;
    }

    public void retryConnector(String cwsName) throws RemoteException {
        CwsConnector conn = (CwsConnector)this.config.getConnManager().getConnectors().get(cwsName);
        conn.close();
        conn.setEnabled(true);
    }

    public void disableConnector(String cwsName) throws RemoteException {
        CwsConnector conn = (CwsConnector)this.config.getConnManager().getConnectors().get(cwsName);
        conn.setEnabled(false);
        conn.close();
    }

    public void setConnectorMetric(String cwsName, int metric) throws RemoteException {
        CwsConnector conn = (CwsConnector)this.config.getConnManager().getConnectors().get(cwsName);
        conn.setMetric(metric);
    }

    public boolean setAuUser(String cwsName, String user) throws RemoteException {
        return this.config.getConnManager().setTempAuUser(cwsName, user);
    }

    public void setProfileDebug(boolean debug, String profileName) throws RemoteException {
        if (profileName != null) {
            CaProfile profile = this.config.getProfile(profileName);
            profile.setDebug(debug);
        } else {
            Iterator iter = this.config.getProfiles().values().iterator();
            while (iter.hasNext()) {
                CaProfile profile = (CaProfile)iter.next();
                profile.setDebug(debug);
            }
        }
    }

    public boolean setUserDebug(boolean debug, String userName) throws RemoteException {
        UserManager um = this.config.getUserManager();
        if (!um.exists(userName)) {
            return false;
        }
        um.setDebug(userName, debug);
        return true;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int[] getCounters() {
        return new int[]{this.proxy.getEcmCount(), this.proxy.getEcmForwards(), this.proxy.getEcmCacheHits(), this.proxy.getEcmFailures(), this.proxy.getEmmCount(), this.proxy.getEcmDenied(), this.proxy.getEcmFiltered(), this.proxy.getEcmRate(), this.proxy.getProbeQueue()};
    }

    public int removeSeenUser(String name) throws RemoteException {
        return SessionManager.getInstance().removeSeenUser(name);
    }

    public int removeLoginFailure(String mask) throws RemoteException {
        return SessionManager.getInstance().removeLoginFailure(mask);
    }

    public void userStatusChanged(String userName, TvService service, String profile, String sessionId) {
        if (service != null) {
            RemoteEvent re = new RemoteEvent(1, userName, service.getName(), profile);
            re.setProperty("service", service.getName() + " (" + profile + ":" + Integer.toHexString(service.getId()) + ")");
            re.setProperty("sid", Integer.toHexString(service.getId()));
            re.setProperty("id", sessionId);
            this.fireRemoteEvent(re);
        }
    }

    public void userLogin(String userName, String profile, String ip, String sessionId) {
        RemoteEvent re = new RemoteEvent(0, userName, ip, profile);
        re.setProperty("ip-address", ip);
        re.setProperty("id", sessionId);
        this.fireRemoteEvent(re);
    }

    public void userLogout(String userName, String profile, String sessionId) {
        RemoteEvent re = new RemoteEvent(-1, userName, null, profile);
        re.setProperty("id", sessionId);
        this.fireRemoteEvent(re);
    }

    public void userLoginFailed(String userName, String profile, String ip, String reason) {
        RemoteEvent re = new RemoteEvent(-2, userName, reason, profile);
        re.setProperty("ip-address", ip);
        this.fireRemoteEvent(re);
    }

    public void cwsConnected(CwsConnector cws) {
        this.fireRemoteEvent(new RemoteEvent(2, cws.getLabel(), cws.toString(), cws.getProfileName()));
    }

    public void cwsDisconnected(CwsConnector cws) {
        this.fireRemoteEvent(new RemoteEvent(3, cws.getLabel(), cws.toString(), cws.getProfileName()));
    }

    public void cwsConnectionFailed(CwsConnector cws, String message) {
        this.fireRemoteEvent(new RemoteEvent(4, cws.getLabel(), message, cws.getProfileName()));
    }

    public void cwsEcmTimeout(CwsConnector cws, String message, int failureCount) {
        if (failureCount >= this.config.getEtMinCount()) {
            this.fireRemoteEvent(new RemoteEvent(5, cws.getLabel(), message, cws.getProfileName()));
        }
    }

    public void cwsLostService(CwsConnector cws, TvService service, boolean show) {
        if (service != null && show) {
            String label = cws == null ? "Internal[SidCacheLinker]" : cws.getLabel();
            this.fireRemoteEvent(new RemoteEvent(6, label, service.toString(), service.getProfileName()));
        }
    }

    public void cwsFoundService(CwsConnector cws, TvService service, boolean show) {
        if (service != null && show) {
            String label = cws == null ? "Internal[SidCacheLinker]" : cws.getLabel();
            this.fireRemoteEvent(new RemoteEvent(9, label, service.toString(), service.getProfileName()));
        }
    }

    public void cwsInvalidCard(CwsConnector cws, String message) {
        this.fireRemoteEvent(new RemoteEvent(8, cws.getLabel(), message, cws.getProfileName()));
    }

    public void cwsProfileChanged(CaProfile profile, boolean added) {
    }

    public void transactionCompleted(EcmTransaction transaction, ProxySession session) {
        int pi;
        RemoteEvent re = new RemoteEvent(7, session.getLabel(), session.getUser(), session.getProfileName());
        String cw = transaction.getReplyData();
        int sid = transaction.getServiceId();
        re.setProperty("id", SessionManager.getSessionIdStr(session));
        re.setProperty("request-hash", transaction.getRequest().hashCodeStr());
        re.setProperty("ecm-size", String.valueOf(transaction.getRequest().getDataLength()));
        if (cw != null && cw.length() > 0) {
            re.setProperty("cw", cw);
        }
        re.setProperty("timestamp", String.valueOf(transaction.getReadTime()));
        re.setProperty("time", String.valueOf(transaction.getDuration()));
        re.setProperty("flags", transaction.getFlags());
        re.setProperty("filtered-by", transaction.getFilteredBy());
        re.setProperty("service", transaction.getService().getName() + " (" + transaction.getService().getProfileName() + ":" + Integer.toHexString(sid) + ")");
        re.setProperty("sid", Integer.toHexString(sid));
        if (transaction.getReplyServiceId() != -1 && transaction.getReplyServiceId() != sid) {
            re.setProperty("reply-sid", Integer.toHexString(transaction.getReplyServiceId()));
        }
        if (transaction.getConnectorName() != null) {
            re.setProperty("cws-name", transaction.getConnectorName());
        }
        if ((pi = transaction.getRequest().getProviderIdent()) != -1) {
            re.setProperty("provider-ident", DESUtil.intToByteString(pi, 3));
        }
        if (session.getProfile() == CaProfile.MULTIPLE) {
            re.setProperty("ca-id", DESUtil.intToHexString(transaction.getRequest().getCaId(), 4));
            re.setProperty("network-id", DESUtil.intToHexString(transaction.getRequest().getNetworkId(), 4));
        }
        if (session instanceof CspSession) {
            re.setProperty("origin-id", Integer.toHexString(transaction.getRequest().getOriginId()));
        }
        if ("Newcamd".equals(transaction.getRequest().getProtocol())) {
            StringBuffer unknown = new StringBuffer(">");
            unknown.append(DESUtil.bytesToString(transaction.getRequest().getFixedData(), 4, 6));
            unknown.append(" (").append(transaction.getRequest().getUpperBits() >> 4).append(")");
            if ("Newcamd".equals(transaction.getReply().getProtocol())) {
                unknown.append(" <").append(DESUtil.bytesToString(transaction.getReply().getFixedData(), 4, 6));
                unknown.append(" (").append(transaction.getReply().getUpperBits() >> 4).append(")");
            }
            re.setProperty("ext-newcamd", unknown.toString());
        }
        boolean warning = this.config.isTransactionWarning(transaction.getFlags(), transaction.getDuration());
        re.setProperty("warning", String.valueOf(warning));
        if (warning) {
            re.setProperties(transaction.getTimings());
        }
        this.fireRemoteEvent(re);
    }

    public void onLog(Level l, String label, String message) {
        if ((l == Level.SEVERE || l == Level.WARNING) && this.config.isIncludeFileEvents()) {
            RemoteEvent re = new RemoteEvent(11, label, message, null);
            re.setProperty("log-level", l.getName());
            this.fireRemoteEvent(re);
        }
    }

    public synchronized void destroy() {
        this.eventQueue.clear();
        this.listeners.clear();
        this.sm.removeUserStatusListener(this);
        this.config.getConnManager().removeCwsListener(this);
        this.eventThread = null;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (Thread.currentThread() == this.eventThread) {
            RemoteHandler remoteHandler = this;
            synchronized (remoteHandler) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    this.eventQueue.clear();
                    break;
                }
            }
            while (!this.eventQueue.isEmpty()) {
                RemoteEvent event = (RemoteEvent)this.eventQueue.remove(0);
                this.logger.finer("Firing remote event: " + event + " " + this.listeners);
                Iterator iter = new ArrayList(this.listeners.keySet()).iterator();
                while (iter.hasNext()) {
                    RemoteListener listener = (RemoteListener)iter.next();
                    try {
                        if (this.listeners.get(listener) != null && !this.listeners.get(listener).equals(event.getProfile())) continue;
                        listener.eventRaised(event);
                    }
                    catch (RuntimeException e) {
                        this.logger.warning("Exception in remote event handling: " + e);
                        this.logger.throwing(e);
                        e.printStackTrace();
                    }
                    catch (RemoteException e) {
                        this.logger.warning("Exception in remote event handling: " + e.getCause());
                        this.logger.throwing(e);
                        this.listeners.remove(listener);
                    }
                    catch (Exception e) {
                        this.logger.severe("Exception in remote event handling: " + e, e);
                        this.listeners.remove(listener);
                    }
                }
            }
        }
    }
}

