/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.session;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.ClusteredCache;
import com.bowman.cardserv.CspConnection;
import com.bowman.cardserv.CspNetMessage;
import com.bowman.cardserv.ListenPort;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.cws.ConnectorSelection;
import com.bowman.cardserv.cws.CwsConnectorManager;
import com.bowman.cardserv.cws.ServiceMapping;
import com.bowman.cardserv.interfaces.CacheHandler;
import com.bowman.cardserv.interfaces.CamdMessageListener;
import com.bowman.cardserv.interfaces.CwsConnector;
import com.bowman.cardserv.interfaces.CwsListener;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.interfaces.UserManager;
import com.bowman.cardserv.session.AbstractSession;
import com.bowman.cardserv.session.SessionManager;
import com.bowman.cardserv.tv.TvService;
import com.bowman.cardserv.util.CustomFormatter;
import com.bowman.httpd.HttpRequest;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CspSession
extends AbstractSession
implements CwsListener {
    private CspConnection conn;
    private int remoteProxyId;
    private int keepAliveCount;
    private boolean sendExtra;
    private int cachePort = -1;
    private String cacheHost;
    private final Map stateHashes = new HashMap();
    private final Map sentState = new HashMap();
    private CwsConnectorManager cm;

    public CspSession(HttpRequest req, String user, ListenPort listenPort, CamdMessageListener listener, boolean cache) {
        super(listenPort, listener);
        this.conn = new CspConnection(req.getConnection());
        this.user = ProxyConfig.getInstance().getUserManager().getUserName(user);
        if (this.user == null) {
            this.user = user;
        }
        this.loginName = user;
        this.clientId = req.getHeader("user-agent");
        this.remoteProxyId = Integer.parseInt(req.getHeader("proxy-origin-id"));
        String s = req.getHeader("cache-port");
        if (s != null && cache) {
            this.cachePort = Integer.parseInt(s);
            this.cacheHost = req.getHeader("cache-host");
        } else {
            this.cachePort = -1;
            this.cacheHost = null;
        }
        this.sendExtra = req.getHeader("send-extra") != null;
        this.maxPending = 10;
        this.cm = ProxyConfig.getInstance().getConnManager();
        this.logger.fine(req.getHeaders().toString());
        Iterator iter = req.getHeaders().keySet().iterator();
        while (iter.hasNext()) {
            String key = ((String)iter.next()).toLowerCase();
            if (!key.startsWith("state-hash-")) continue;
            String hash = req.getHeader(key);
            key = key.substring(12);
            this.stateHashes.put(new CspNetMessage.ProfileKey(key), Integer.valueOf(hash));
        }
        this.sessionThread = new Thread((Runnable)this, "CspSessionThread-" + this.sessionId + "[" + user + "]");
        this.sessionThread.start();
    }

    public boolean stateChanged(CspNetMessage.ProfileKey key, List updates) {
        Integer oldHash = (Integer)this.stateHashes.get(key);
        int newHash = CspNetMessage.statusHashCode(updates);
        if (oldHash == null || oldHash != newHash) {
            this.stateHashes.put(key, new Integer(newHash));
            return true;
        }
        this.logger.fine("State unchanged for: " + key + " (" + this.stateHashes.get(key) + ")");
        return false;
    }

    public void run() {
        this.logger.fine("Starting...");
        this.alive = true;
        ProxyConfig config = ProxyConfig.getInstance();
        SessionManager sm = SessionManager.getInstance();
        UserManager um = config.getUserManager();
        CacheHandler ch = config.getCacheHandler();
        ClusteredCache.CachePeer peer = null;
        this.maxSessions = 1;
        this.remoteAddress = this.conn.getRemoteAddress();
        this.logger.info("User '" + this.user + "' (" + CustomFormatter.formatAddress(this.getRemoteAddress()) + ") login successful. Client: " + this.clientId + " Origin: " + DESUtil.intToHexString(this.remoteProxyId, 8));
        ProxySession oldSession = sm.hasSession(this.user, this.getClass().getName());
        if (oldSession != null) {
            long idleMins = oldSession.getIdleTime() / 60000L;
            this.logger.info("User '" + this.user + "' already has [1] csp connection, closing oldest (idle " + idleMins + " mins)");
            oldSession.close();
        }
        this.setupLimits(config.getUserManager());
        if ("0.0.0.0".equals(this.getRemoteAddress())) {
            this.close();
            return;
        }
        sm.addSession(this);
        try {
            this.conn.init();
            this.conn.setSoTimeout(config.getSessionTimeout());
            CspNetMessage statusMsg = new CspNetMessage(3);
            statusMsg.setOriginId(config.getProxyOriginId());
            HashSet profiles = new HashSet(config.getProfiles().values());
            Iterator iter = profiles.iterator();
            while (iter.hasNext()) {
                CaProfile profile = (CaProfile)iter.next();
                CspNetMessage.ProfileKey key = new CspNetMessage.ProfileKey(profile);
                if (profile.getNetworkId() > 0) {
                    if (this.profileAllowed(profile)) {
                        List updates = CspNetMessage.buildProfileUpdate(profile, this.sendExtra);
                        this.sentState.put(key, updates);
                        if (!this.stateChanged(key, updates)) continue;
                        statusMsg.addStatusUpdates(key, updates);
                        continue;
                    }
                    if (!this.stateHashes.containsKey(key)) continue;
                    statusMsg.addDeleteUpdate(key);
                    continue;
                }
                if (!this.stateHashes.containsKey(key)) continue;
                statusMsg.addDeleteUpdate(key);
            }
            this.conn.sendCspMessage(statusMsg);
            this.conn.readMessage();
            this.cm.addCwsListener(this);
            if (ch instanceof ClusteredCache) {
                peer = ((ClusteredCache)ch).addCachePeer(this);
            } else {
                this.logger.warning("Client requested cache updates but ClusteredCache isn't in use, ignoring...");
            }
            block10: while (this.alive) {
                CspNetMessage msg = this.conn.readMessage();
                if (msg == null) {
                    this.alive = false;
                    this.logger.info("Connection closed");
                    continue;
                }
                switch (msg.getType()) {
                    case 1: {
                        ++this.ecmCount;
                        CamdNetMessage camdMsg = msg.getCamdMessage();
                        if (um.isEnabled(this.user)) {
                            boolean checksOk = this.checkLimits(camdMsg);
                            this.fireCamdMessage(camdMsg, false);
                            if (checksOk) continue block10;
                            this.setFlag(camdMsg, 'B');
                            this.sendEcmReply(camdMsg, camdMsg.getEmptyReply());
                            continue block10;
                        }
                        this.logger.warning("'User '" + this.user + "' kicked, account disabled");
                        this.alive = false;
                        this.close();
                        continue block10;
                    }
                    case 5: {
                        if (msg.isKeepAlive()) {
                            ++this.keepAliveCount;
                            this.logger.fine("Keep-alive received from '" + this.user + "' (" + this.clientId + "), responding...");
                        } else {
                            this.logger.warning("Unexpected status information received from client");
                        }
                        this.conn.sendCspMessage(new CspNetMessage(4), msg.getSeqNr());
                        continue block10;
                    }
                    case 4: {
                        continue block10;
                    }
                }
                this.logger.warning("Unexpected message type: " + DESUtil.byteToString((byte)msg.getType()));
            }
        }
        catch (EOFException e) {
            this.logger.info("Connection closed");
        }
        catch (SocketException e) {
            this.logger.info(e.getMessage() + " for user '" + this.getUser() + "' (" + e + ")");
        }
        catch (Exception e) {
            this.logger.throwing("Unexpected exception reading/parsing message: " + e, e);
        }
        this.alive = false;
        if (peer != null) {
            ((ClusteredCache)ch).removeCachePeer(peer);
        }
        this.cm.removeCwsListener(this);
        this.endSession();
    }

    protected boolean profileAllowed(CaProfile profile) {
        Set allowed = ProxyConfig.getInstance().getUserManager().getAllowedProfiles(this.user);
        if (allowed == null || allowed.isEmpty() || allowed.contains(profile.getName())) {
            List connectors = ProxyConfig.getInstance().getConnManager().getReadyConnectorList(profile.getName());
            Iterator iter = connectors.iterator();
            while (iter.hasNext()) {
                CwsConnector cws = (CwsConnector)iter.next();
                if (cws.getProfile() == CaProfile.MULTIPLE) continue;
                return true;
            }
        }
        return false;
    }

    protected int sendEcmReplyNative(CamdNetMessage ecmRequest, CamdNetMessage ecmReply) {
        int result;
        CspNetMessage msg = new CspNetMessage(2);
        msg.setCamdMessage(ecmReply);
        try {
            result = this.conn.sendCspMessage(msg, ecmRequest.getSequenceNr());
        }
        catch (IOException e) {
            result = -1;
            this.logger.throwing(e);
            this.conn.close();
        }
        this.endTransaction(ecmRequest, ecmReply, result);
        return result;
    }

    public int sendMessage(CamdNetMessage msg) {
        if (msg.isKeepAlive() && this.conn != null) {
            try {
                if (this.conn.isConnected()) {
                    return this.conn.sendCspMessage(new CspNetMessage(3));
                }
            }
            catch (IOException e) {
                this.logger.throwing(e);
            }
        }
        return -1;
    }

    public String getProtocol() {
        return "Csp";
    }

    public String getLastContext() {
        return "Dummy";
    }

    public int getKeepAliveCount() {
        return this.keepAliveCount;
    }

    public long getIdleTime() {
        if (this.conn == null) {
            return -1L;
        }
        return System.currentTimeMillis() - this.conn.getLastTrafficTimeStamp();
    }

    public void close() {
        if (this.conn != null) {
            this.conn.close();
        }
        if (this.sessionThread != null) {
            this.sessionThread.interrupt();
        }
    }

    public boolean isConnected() {
        return this.sessionThread != null;
    }

    private boolean updateProfileState(CaProfile profile) {
        if (profile.getNetworkId() == 0) {
            return false;
        }
        CspNetMessage.ProfileKey key = new CspNetMessage.ProfileKey(profile);
        if (this.profileAllowed(profile)) {
            List updates = CspNetMessage.buildProfileUpdate(profile, this.sendExtra);
            if (updates == null) {
                return false;
            }
            if (this.stateChanged(key, updates)) {
                CspNetMessage statusMsg = new CspNetMessage(3);
                statusMsg.setStatusUpdates(updates);
                try {
                    this.conn.sendCspMessage(statusMsg);
                    this.sentState.put(key, updates);
                }
                catch (IOException e) {
                    this.logger.throwing(e);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void cwsConnected(CwsConnector cws) {
        if (this.updateProfileState(cws.getProfile())) {
            this.logger.fine("Connector '" + cws.getName() + "' connected/disconnected and caused change in profile state, sent full update.");
        } else {
            this.logger.fine("Connector '" + cws.getName() + "' connected/disconnected but no state change for profile.");
        }
    }

    public void cwsDisconnected(CwsConnector cws) {
        this.cwsConnected(cws);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cwsLostService(CwsConnector cws, TvService service, boolean show) {
        CaProfile profile;
        CaProfile caProfile = profile = cws == null ? ProxyConfig.getInstance().getProfile(service.getProfileName()) : cws.getProfile();
        if (profile == null || profile.getNetworkId() == 0) {
            return;
        }
        ConnectorSelection conns = this.cm.getConnectorsForService(profile.getName(), new ServiceMapping(service), null);
        CspNetMessage.ProfileKey key = new CspNetMessage.ProfileKey(profile);
        Integer sid = new Integer(service.getId());
        List state = (List)this.sentState.get(key);
        List sentSids = CspNetMessage.getStatusItems(1, true, state);
        if (sentSids != null && conns.isEmpty()) {
            CspNetMessage statusMsg = new CspNetMessage(5);
            statusMsg.addSidUpdate(key, sid, false);
            this.logger.fine("Lost service caused state changed, sending incremental update...");
            try {
                Map map = this.sentState;
                synchronized (map) {
                    this.conn.sendCspMessage(statusMsg);
                    sentSids.add(sid);
                    this.stateHashes.put(key, new Integer(CspNetMessage.statusHashCode(state)));
                }
            }
            catch (IOException e) {
                this.logger.throwing(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cwsFoundService(CwsConnector cws, TvService service, boolean show) {
        CaProfile profile;
        CaProfile caProfile = profile = cws == null ? ProxyConfig.getInstance().getProfile(service.getProfileName()) : cws.getProfile();
        if (profile == null || profile.getNetworkId() == 0) {
            return;
        }
        CspNetMessage.ProfileKey key = new CspNetMessage.ProfileKey(profile);
        Integer sid = new Integer(service.getId());
        List state = (List)this.sentState.get(key);
        List sentSids = CspNetMessage.getStatusItems(1, true, state);
        if (sentSids != null && !sentSids.contains(sid)) {
            CspNetMessage statusMsg = new CspNetMessage(5);
            statusMsg.addSidUpdate(key, sid, true);
            this.logger.fine("Found service caused state change, sending incremental update...");
            try {
                Map map = this.sentState;
                synchronized (map) {
                    this.conn.sendCspMessage(statusMsg);
                    sentSids.add(sid);
                    this.stateHashes.put(key, new Integer(CspNetMessage.statusHashCode(state)));
                }
            }
            catch (IOException e) {
                this.logger.throwing(e);
            }
        }
    }

    public void cwsConnectionFailed(CwsConnector cws, String message) {
    }

    public void cwsEcmTimeout(CwsConnector cws, String message, int failureCount) {
    }

    public void cwsInvalidCard(CwsConnector cws, String message) {
    }

    public void cwsProfileChanged(CaProfile profile, boolean added) {
        if (!profile.isEnabled()) {
            CspNetMessage.ProfileKey key = new CspNetMessage.ProfileKey(profile);
            CspNetMessage statusMsg = new CspNetMessage(3);
            statusMsg.addDeleteUpdate(key);
            try {
                this.conn.sendCspMessage(statusMsg);
                this.sentState.remove(key);
                this.stateHashes.remove(key);
            }
            catch (IOException e) {
                this.logger.throwing(e);
            }
        } else if (this.updateProfileState(profile)) {
            if (this.user != null) {
                this.setupLimits(ProxyConfig.getInstance().getUserManager());
            }
            this.logger.fine("Profile '" + profile.getName() + "' updated, sent altered state information.");
        }
    }

    public int getCachePort() {
        return this.cachePort;
    }

    public String getCacheHost() {
        if (this.cacheHost == null) {
            return this.getRemoteAddress();
        }
        return this.cacheHost;
    }
}

