/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.util;

import com.bowman.cardserv.crypto.DESUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleTlvBlob {
    private Map contents = new LinkedHashMap();

    public SimpleTlvBlob() {
    }

    public SimpleTlvBlob(byte[] buf) {
        int pos = 0;
        int numRecords = buf[pos++];
        for (int i = 0; i < numRecords; ++i) {
            int type = buf[pos++] & 0xFF;
            int count = buf[pos++] & 0xFF;
            int length = buf[pos++] & 0xFF;
            for (int n = 0; n < count; ++n) {
                if (n > 0 && length > 8) {
                    length = buf[pos++] & 0xFF;
                }
                byte[] value = new byte[length];
                System.arraycopy(buf, pos, value, 0, length);
                this.add(type, value);
                pos += length;
            }
        }
    }

    public void add(int key, byte[] value) {
        Integer k = new Integer(key);
        ArrayList<byte[]> values = (ArrayList<byte[]>)this.contents.get(k);
        if (values == null) {
            values = new ArrayList<byte[]>();
            this.contents.put(k, values);
        }
        values.add(value);
    }

    public void addInt(int key, int value) {
        this.add(key, DESUtil.intToBytes(value, 4));
    }

    public void addShort(int key, short value) {
        this.add(key, DESUtil.intToBytes(value, 2));
    }

    public void addShort(int key, int[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.addShort(key, (short)values[i]);
        }
    }

    public List get(int key) {
        return (List)this.contents.get(new Integer(key));
    }

    public int[] getIntArray(int key) {
        List values = this.get(key);
        int[] ia = new int[values.size()];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = DESUtil.bytesToInt((byte[])values.get(i));
        }
        return ia;
    }

    public byte[] getSingle(int key) {
        List values = this.get(key);
        return (byte[])values.get(0);
    }

    public Set keySet() {
        return this.contents.keySet();
    }

    public byte[] getBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.contents.size());
        Iterator iter = this.contents.keySet().iterator();
        while (iter.hasNext()) {
            Integer key = (Integer)iter.next();
            List values = (List)this.contents.get(key);
            baos.write(key);
            baos.write(values.size());
            for (int i = 0; i < values.size(); ++i) {
                try {
                    byte[] value = (byte[])values.get(i);
                    if (i == 0 || value.length > 8) {
                        baos.write(value.length);
                    }
                    baos.write(value);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return baos.toByteArray();
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }
}

