/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.web;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.interfaces.CacheHandler;
import com.bowman.cardserv.interfaces.XmlConfigurable;
import com.bowman.cardserv.session.GHttpSession;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.cardserv.util.XmlStringBuffer;
import com.bowman.cardserv.web.FileFetcher;
import com.bowman.cardserv.web.StatusCommand;
import com.bowman.cardserv.web.WebBackend;
import com.bowman.httpd.HttpRequest;
import com.bowman.httpd.HttpRequestListener;
import com.bowman.httpd.HttpResponse;
import com.bowman.httpd.PseudoHttpd;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class GHttpBackend
implements XmlConfigurable,
HttpRequestListener {
    private static final int RECORD_SIZE = 28;
    protected static final String API_PREFIX = "/api";
    protected static final String API_CACHE_GET = "/api/c/";
    protected static final String API_ECM_POST = "/api/e/";
    protected static final String API_FEEDER_POST = "/api/f/";
    protected static final String API_CAPMT = "/api/p/";
    private WebBackend parent;
    private CacheHandler cache;
    private ProxyConfig config;
    private boolean enabled;
    private int alternatePort;
    private PseudoHttpd httpd;
    private ProxyLogger ghttpdLogger;
    private String accessPasswd;
    private String feederPasswd;
    private Map sessions = new HashMap();
    private Map sessionsByUser = new HashMap();
    private Map contexts = Collections.synchronizedMap(new LinkedHashMap());
    private Set blackList = new HashSet();
    private StatusCommand contextsCmd;

    public GHttpBackend(WebBackend parent) {
        this.parent = parent;
        this.config = ProxyConfig.getInstance();
    }

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        this.enabled = xml == null ? true : "true".equalsIgnoreCase(xml.getStringValue("enabled", "true"));
        if (this.enabled) {
            if (xml == null) {
                this.alternatePort = -1;
            } else {
                block38: {
                    try {
                        xml.getStringValue("alternate-port");
                    }
                    catch (ConfigException e) {
                        this.alternatePort = -1;
                        if (this.httpd == null) break block38;
                        this.httpd.stop();
                        this.httpd = null;
                    }
                }
                if (this.alternatePort != -1) {
                    InetAddress bindAddr = null;
                    String bindIp = null;
                    try {
                        bindIp = xml.getStringValue("alternate-bind-ip");
                        bindAddr = InetAddress.getByName(bindIp);
                    }
                    catch (ConfigException configException) {
                    }
                    catch (UnknownHostException e) {
                        throw new ConfigException(xml.getFullName(), "alternate-bind-ip", "Invalid ghttp bind-ip: " + bindIp);
                    }
                    this.alternatePort = xml.getPortValue("alternate-port");
                    if (this.alternatePort == this.parent.httpd.getListenPort()) {
                        throw new ConfigException(xml.getFullName(), "alternate-port", "Port in use: " + this.alternatePort);
                    }
                    if (this.httpd != null && this.httpd.getListenPort() != this.alternatePort) {
                        this.httpd.stop();
                        this.httpd = null;
                    }
                    if (this.httpd == null) {
                        this.httpd = new PseudoHttpd(this.alternatePort, bindAddr);
                    }
                    this.httpd.addHttpRequestListener("/api/*", (HttpRequestListener)this);
                    this.httpd.setSilent(true);
                    this.httpd.setV11(true);
                    try {
                        this.httpd.start();
                    }
                    catch (IOException e) {
                        this.httpd = null;
                        throw new ConfigException(xml.getFullName(), "Unable to start alternate httpd for ghttp: " + e, e);
                    }
                }
            }
            if (xml == null) {
                this.accessPasswd = null;
                this.feederPasswd = null;
            } else {
                try {
                    this.accessPasswd = xml.getStringValue("open-access-password");
                }
                catch (ConfigException e) {
                    this.accessPasswd = null;
                }
                try {
                    this.feederPasswd = xml.getStringValue("feeder-password");
                }
                catch (ConfigException e) {
                    this.feederPasswd = null;
                }
                if (this.feederPasswd != null && this.accessPasswd != null && this.accessPasswd.equals(this.feederPasswd)) {
                    throw new ConfigException(xml.getFullName(), "Passwords must be different.");
                }
                if (this.httpd != null) {
                    String logFile = null;
                    int count = 0;
                    int limit = 0;
                    try {
                        ProxyXmlConfig logXml = xml.getSubConfig("log-file");
                        count = logXml.getIntValue("rotate-count");
                        if (count < 1) {
                            count = 0;
                        }
                        if ((limit = logXml.getIntValue("rotate-max-size")) < 1) {
                            limit = 0;
                        }
                    }
                    catch (ConfigException logXml) {
                        // empty catch block
                    }
                    try {
                        if (this.ghttpdLogger != null) {
                            this.ghttpdLogger.close();
                        }
                        logFile = xml.getFileValue("log-file", true);
                        if (count <= 0 || limit <= 0 || !new File(logFile).delete()) {
                            // empty if block
                        }
                        this.ghttpdLogger = ProxyLogger.getFileLogger("GHttpBackend", new File(logFile), "FINER", count, limit, true);
                        this.httpd.setLogger(this.ghttpdLogger.getWrappedLogger());
                    }
                    catch (ConfigException e) {
                        this.httpd.setLogger(null);
                    }
                    catch (IOException e) {
                        throw new ConfigException(xml.getSubConfig("log-file").getFullName(), "Unable to assign log-file: " + logFile, e);
                    }
                }
            }
            if (this.contextsCmd == null) {
                try {
                    this.contextsCmd = new StatusCommand("ca-contexts", "Show ca-contexts map", "List all known ca-contexts and associated ecm pids.", true);
                    this.contextsCmd.register(this);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            this.blackList.clear();
            String bl = FileFetcher.getProperty("cache.bl");
            if (bl != null) {
                this.blackList.addAll(Arrays.asList(bl.split(" ")));
            }
        } else {
            if (this.httpd != null) {
                this.httpd.stop();
                this.httpd = null;
            }
            if (this.contextsCmd != null) {
                this.contextsCmd.unregister();
                this.contextsCmd = null;
            }
        }
    }

    public void runStatusCmdCaContexts(XmlStringBuffer xb, Map params) {
        xb.appendElement("ca-contexts", "count", this.contexts.size());
        Iterator iter = new ArrayList(this.contexts.keySet()).iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            CaContext cc = (CaContext)this.contexts.get(key);
            xb.appendElement("ca-context", "key", key);
            xb.appendAttr("name-space", Long.toHexString(cc.nameSpace));
            if (!cc.ecmPids.isEmpty()) {
                xb.appendAttr("pids", cc.ecmPids.size());
                xb.endElement(false);
                Iterator i = cc.iterator();
                while (i.hasNext()) {
                    EcmPid pid = (EcmPid)i.next();
                    xb.appendElement("ecm-pid", "pid", Integer.toHexString(pid.pid));
                    xb.appendAttr("caid", Integer.toHexString(pid.caId));
                    xb.appendAttr("provider-ident", Integer.toHexString(pid.provId));
                    if (!pid.lengths.isEmpty()) {
                        xb.appendAttr("lengths", pid.getLengths());
                    }
                    xb.closeElement();
                }
                xb.closeElement("ca-context");
                continue;
            }
            xb.endElement(true);
        }
        xb.closeElement("ca-contexts");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean hasAlternatePort() {
        return this.httpd != null;
    }

    private CamdNetMessage waitForReply(CamdNetMessage request) {
        CamdNetMessage reply = this.cache.peekReply(request);
        if (reply != null) {
            return reply;
        }
        reply = this.cache.processRequest(-1, request, true, request.getMaxWait() * 2L);
        return reply;
    }

    private String generateSessionId(String seed) {
        String sessionId = Integer.toString(Math.abs(seed.hashCode()), 36);
        while (sessionId.length() < 6) {
            sessionId = "0" + sessionId;
        }
        return sessionId;
    }

    private GHttpSession newSession(String user, String ip) {
        String id = this.generateSessionId(user + this.parent.createSession(user) + ip);
        GHttpSession gs = new GHttpSession(id, user, ip);
        this.sessions.put(id, gs);
        if (!user.startsWith("anon:")) {
            this.sessionsByUser.put(user, gs);
        }
        return gs;
    }

    private GHttpSession getSession(String id, String ip) throws GHttpAuthException {
        GHttpSession gs = (GHttpSession)this.sessions.get(id);
        if (gs != null && gs.isExpired()) {
            this.sessionsByUser.remove(gs.getUser());
            this.sessions.remove(id);
            throw new GHttpAuthException(this.getErrorResponse(401, "Authorization required"));
        }
        if (gs != null && ip.equals(gs.getRemoteAddress())) {
            return gs;
        }
        return null;
    }

    private GHttpSession findSession(String user, String ip) throws GHttpAuthException {
        GHttpSession gs = (GHttpSession)this.sessionsByUser.get(user);
        if (gs != null && gs.isExpired()) {
            this.sessionsByUser.remove(user);
            this.sessions.remove(gs.getGhttpSessionId());
            throw new GHttpAuthException(this.getErrorResponse(401, "Authorization required"));
        }
        if (gs != null && ip.equals(gs.getRemoteAddress())) {
            return gs;
        }
        return null;
    }

    private synchronized GHttpSession doGhttpAuth(HttpRequest req, String[] s) throws GHttpAuthException {
        return this.doGhttpAuth(req, s, this.accessPasswd);
    }

    private synchronized GHttpSession doGhttpAuth(HttpRequest req, String[] s, String passwd) throws GHttpAuthException {
        GHttpSession gs = null;
        if (s.length > 3 && s[3].length() >= 6) {
            gs = this.getSession(s[3], req.getRemoteAddress());
        }
        if (gs == null) {
            String user = this.parent.checkBasicAuth(req, passwd);
            if (user == null) {
                throw new GHttpAuthException(this.getErrorResponse(403, "Forbidden"));
            }
            if (!user.startsWith("anon:")) {
                HttpResponse error = this.parent.doIpCheck(req, user);
                if (error != null) {
                    throw new GHttpAuthException(this.getErrorResponse(403, "IP check failed"));
                }
                gs = this.findSession(user, req.getRemoteAddress());
            }
            if (gs == null) {
                gs = this.newSession(user, req.getRemoteAddress());
            }
        }
        if (gs != null) {
            gs.touch();
        }
        return gs;
    }

    public HttpResponse doGet(String urlPattern, HttpRequest req) {
        if (!this.enabled) {
            return this.getErrorResponse(403, "Disabled");
        }
        String q = req.getQueryString();
        if (q.startsWith(API_CACHE_GET)) {
            return this.doCacheGet(req);
        }
        if (q.startsWith(API_CAPMT)) {
            return this.doPmtGetOrPost(req);
        }
        return HttpResponse.getErrorResponse(404);
    }

    private HttpResponse doCacheGet(HttpRequest req) {
        if (this.cache == null) {
            this.cache = this.config.getCacheHandler();
        }
        try {
            String[] s = req.getQueryString().split("/");
            GHttpSession gs = this.doGhttpAuth(req, s);
            if (gs == null) {
                throw new GHttpAuthException(this.getErrorResponse(401, "Authorization required"));
            }
            CamdNetMessage request = CamdNetMessage.parseGHttpReq(s, req.getRemoteAddress(), null);
            CamdNetMessage reply = this.waitForReply(request);
            if (reply == null) {
                reply = this.cache.peekReply(request);
            }
            HttpResponse res = reply == null ? this.getErrorResponse(503, "Cache timeout") : new HttpResponse(200, "OK", reply.getCustomData(), "application/octet-stream");
            if (s.length < 6) {
                res.setCookie("GSSID", gs.getGhttpSessionId());
            }
            return res;
        }
        catch (GHttpAuthException e) {
            return e.getResponse();
        }
        catch (Exception e) {
            this.parent.logger.throwing("Bad ghttp cache request: " + req.getQueryString(), e);
            return HttpResponse.getErrorResponse(400, req.getQueryString());
        }
    }

    public HttpResponse doPost(String urlPattern, HttpRequest req) {
        if (!this.enabled) {
            return this.getErrorResponse(403, "Disabled");
        }
        String q = req.getQueryString();
        if (q.startsWith(API_ECM_POST)) {
            return this.doEcmPost(req);
        }
        if (q.startsWith(API_CAPMT)) {
            return this.doPmtGetOrPost(req);
        }
        if (q.startsWith(API_FEEDER_POST)) {
            return this.doCachePost(req);
        }
        return this.getErrorResponse(503, "Not implemented");
    }

    private HttpResponse doCachePost(HttpRequest req) {
        if (this.feederPasswd == null) {
            return this.getErrorResponse(403, "Disabled");
        }
        if (this.cache == null) {
            this.cache = this.config.getCacheHandler();
        }
        try {
            String[] s = req.getQueryString().split("/");
            GHttpSession gs = this.doGhttpAuth(req, s, this.feederPasswd);
            if (gs == null) {
                return this.getErrorResponse(403, "Forbidden");
            }
            byte[] content = req.getContent();
            String addr = req.getRemoteAddress();
            if (content.length >= 28) {
                HashMap<CamdNetMessage, CamdNetMessage> replies = new HashMap<CamdNetMessage, CamdNetMessage>();
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(content));
                while (dis.available() >= 28) {
                    CamdNetMessage request = CamdNetMessage.parseCacheReq(dis, false);
                    CamdNetMessage reply = CamdNetMessage.parseCacheRpl(dis, request, false);
                    if (!this.blackList.contains(addr)) {
                        request.setOriginAddress(addr);
                        reply.setOriginAddress(addr);
                    }
                    replies.put(request, reply);
                }
                this.cache.processReplies(replies);
                if (dis.available() != 0) {
                    this.parent.logger.warning("Trailing bytes in feed post: " + dis.available());
                }
                HttpResponse res = new HttpResponse(204, "No Content");
                if (s.length <= 3) {
                    res.setCookie("GSSID", gs.getGhttpSessionId());
                }
                return res;
            }
            throw new IOException("Invalid content length (" + content.length + ")");
        }
        catch (GHttpAuthException e) {
            return e.getResponse();
        }
        catch (Exception e) {
            this.parent.logger.throwing("Bad ghttp feeder request: " + req.getQueryString(), e);
            return HttpResponse.getErrorResponse(400, req.getQueryString());
        }
    }

    private HttpResponse doEcmPost(HttpRequest req) {
        if (this.cache == null) {
            this.cache = this.config.getCacheHandler();
        }
        try {
            String[] s = req.getQueryString().split("/");
            GHttpSession gs = this.doGhttpAuth(req, s);
            if (gs == null) {
                throw new GHttpAuthException(HttpResponse.getAuthReqResponse("GHttp"));
            }
            CamdNetMessage ecmReq = CamdNetMessage.parseGHttpReq(s, req.getRemoteAddress(), req.getContent());
            CamdNetMessage reply = this.cache.peekReply(ecmReq);
            boolean instant = false;
            if (reply == null) {
                if (ProxyConfig.getInstance().getProfileById(ecmReq.getNetworkId(), ecmReq.getCaId()) == null) {
                    return this.getErrorResponse(503, "Unknown system: " + CaProfile.getKeyStr(ecmReq.getNetworkId(), ecmReq.getCaId()));
                }
                if (!this.cache.containsCaid(ecmReq.getCaId())) {
                    return this.getErrorResponse(503, "Unknown caid: " + CaProfile.getKeyStr(ecmReq.getNetworkId(), ecmReq.getCaId()));
                }
                gs.fireCamdMessage(ecmReq, false);
                reply = gs.waitForReply(ecmReq);
            } else {
                instant = true;
            }
            if (reply == null) {
                reply = this.cache.peekReply(ecmReq);
            }
            if (reply == null) {
                return this.getErrorResponse(503, "Ecm timeout");
            }
            CaContext cc = new CaContext(ecmReq.getNetworkId(), ecmReq.getTid(), ecmReq.getServiceId());
            if ((cc = (CaContext)this.contexts.get(cc.toString())) != null) {
                cc.addLength(ecmReq.getPid(), ecmReq.getDataLength());
            }
            HttpResponse res = new HttpResponse(200, "OK", reply.getCustomData(), "application/octet-stream");
            if (instant) {
                res.setHeader("Pragma", "cached");
            }
            if (s.length < 10) {
                res.setCookie("GSSID", gs.getGhttpSessionId());
            }
            return res;
        }
        catch (GHttpAuthException e) {
            return e.getResponse();
        }
        catch (Exception e) {
            this.parent.logger.throwing("Bad ghttp ecm request: " + req.getQueryString(), e);
            return HttpResponse.getErrorResponse(400, req.getQueryString());
        }
    }

    private HttpResponse doPmtGetOrPost(HttpRequest req) {
        try {
            EcmPid pid;
            String key;
            String[] s = req.getQueryString().split("/");
            GHttpSession gs = this.doGhttpAuth(req, s);
            if (gs == null) {
                throw new GHttpAuthException(HttpResponse.getAuthReqResponse("GHttp"));
            }
            int offs = s[3].length() >= 6 ? 4 : 3;
            CaContext cc = new CaContext();
            cc.networkId = Integer.parseInt(s[offs++], 16);
            cc.tsId = Integer.parseInt(s[offs++], 16);
            cc.serviceId = Integer.parseInt(s[offs++], 16);
            int pidCount = Integer.parseInt(s[offs++], 16);
            cc.nameSpace = 0L;
            if (s.length > offs) {
                cc.nameSpace = Long.parseLong(s[offs], 16);
            }
            if (this.contexts.containsKey(key = cc.toString())) {
                cc = (CaContext)this.contexts.get(key);
            } else {
                this.contexts.put(key, cc);
            }
            if (pidCount > 0) {
                if (!"POST".equalsIgnoreCase(req.getMethod())) {
                    return HttpResponse.getErrorResponse(400, req.getQueryString() + " (expected post)");
                }
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(req.getContent()));
                for (int i = 0; i < pidCount; ++i) {
                    pid = new EcmPid();
                    pid.pid = dis.readUnsignedShort();
                    pid.caId = dis.readUnsignedShort();
                    pid.provId = dis.readInt();
                    cc.addPid(pid);
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream daos = new DataOutputStream(baos);
            Iterator iter = cc.iterator();
            while (iter.hasNext()) {
                pid = (EcmPid)iter.next();
                if (this.config.getProfileById(cc.networkId, pid.caId) != null) continue;
                daos.writeShort(pid.pid);
            }
            byte[] pids = baos.toByteArray();
            HttpResponse res = pids.length == 0 ? new HttpResponse(204, "No Content") : new HttpResponse(200, "OK", pids, "application/octet-stream");
            if (s[3].length() < 6) {
                res.setCookie("GSSID", gs.getGhttpSessionId());
            }
            res.setHeader("Pragma", "context-ignore=" + key);
            return res;
        }
        catch (GHttpAuthException e) {
            return e.getResponse();
        }
        catch (Exception e) {
            this.parent.logger.throwing("Bad ghttp pmt request: " + req.getQueryString(), e);
            return HttpResponse.getErrorResponse(400, req.getQueryString());
        }
    }

    public HttpResponse doConnect(String urlPattern, HttpRequest req) {
        return HttpResponse.getErrorResponse(405, req.getMethod());
    }

    private HttpResponse getErrorResponse(int code, String msg) {
        HttpResponse error = HttpResponse.getErrorResponse(code);
        error.setContent(msg.getBytes(), "application/octet-stream");
        return error;
    }

    static class EcmPid {
        int pid;
        int caId;
        int provId;
        private Set lengths = new HashSet();

        EcmPid() {
        }

        void addLength(int len) {
            this.lengths.add(new Integer(len));
        }

        String getLengths() {
            return this.lengths.toString();
        }
    }

    static class CaContext {
        int networkId;
        int tsId;
        int serviceId;
        long nameSpace;
        private Map ecmPids = new LinkedHashMap();

        CaContext() {
        }

        CaContext(int networkId, int tsId, int serviceId) {
            this.networkId = networkId;
            this.tsId = tsId;
            this.serviceId = serviceId;
        }

        void addPid(EcmPid pid) {
            this.ecmPids.put(String.valueOf(pid.pid), pid);
        }

        void addLength(int pid, int len) {
            EcmPid ecmPid = (EcmPid)this.ecmPids.get(String.valueOf(pid));
            if (ecmPid != null) {
                ecmPid.addLength(len);
            }
        }

        Iterator iterator() {
            return this.ecmPids.values().iterator();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CaContext caContext = (CaContext)o;
            if (this.networkId != caContext.networkId) {
                return false;
            }
            if (this.serviceId != caContext.serviceId) {
                return false;
            }
            return this.tsId == caContext.tsId;
        }

        public int hashCode() {
            int result = this.networkId;
            result = 31 * result + this.tsId;
            result = 31 * result + this.serviceId;
            return result;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(Integer.toHexString(this.networkId)).append('-');
            sb.append(Integer.toHexString(this.tsId)).append('-');
            sb.append(Integer.toHexString(this.serviceId));
            return sb.toString();
        }
    }

    static class GHttpAuthException
    extends Exception {
        HttpResponse response;

        GHttpAuthException(HttpResponse response) {
            this.response = response;
        }

        public HttpResponse getResponse() {
            return this.response;
        }
    }
}

