/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CacheCoveragePlugin;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.session.CacheDummySession;
import com.bowman.cardserv.web.FileFetcher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CacheTester
implements Runnable {
    private final CacheCoveragePlugin parent;
    private Set testHosts = new HashSet();
    private int testPort = -1;
    private Thread readerThread;
    private DatagramSocket recvSock;
    private DatagramSocket sendSock;
    private CacheDummySession dummy = new CacheDummySession();
    private ProxyConfig config;

    public CacheTester(CacheCoveragePlugin parent) {
        this.parent = parent;
        String hostStr = FileFetcher.getProperty((String)"cache.bl");
        String portStr = FileFetcher.getProperty((String)"cache.bl.port");
        if (hostStr != null) {
            this.testHosts.addAll(Arrays.asList(hostStr.split(" ")));
        }
        if (portStr != null) {
            this.testPort = Integer.parseInt(portStr);
        }
        if (this.testPort != -1) {
            try {
                this.sendSock = new DatagramSocket();
                this.recvSock = new DatagramSocket(this.testPort);
                this.config = ProxyConfig.getInstance();
                this.readerThread = new Thread((Runnable)this, "CacheCoverageTestThread");
                this.readerThread.start();
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }
    }

    public void run() {
        while (Thread.currentThread() == this.readerThread) {
            try {
                DataInputStream dis;
                CamdNetMessage req;
                byte[] buf = new byte[1024];
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                this.recvSock.receive(packet);
                if (!this.parent.proxy.isAlive() || this.config.getProfileById((req = CamdNetMessage.parseGHttpReq((DataInputStream)(dis = new DataInputStream(new ByteArrayInputStream(packet.getData(), 0, packet.getLength()))), null, (boolean)true)).getNetworkId(), req.getCaId()) == null) continue;
                this.parent.proxy.messageReceived((ProxySession)this.dummy, req);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isAlive() {
        return this.readerThread != null;
    }

    public void testMessage(CamdNetMessage req) {
        if (this.testPort == -1 || this.testHosts.isEmpty()) {
            return;
        }
        if (this.config.getProfileById(req.getNetworkId(), req.getCaId()) == null) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream daos = new DataOutputStream(baos);
        try {
            CacheTester.writeTestReq(req, daos, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] buf = baos.toByteArray();
        Iterator iter = this.testHosts.iterator();
        while (iter.hasNext()) {
            try {
                DatagramPacket packet = new DatagramPacket(buf, buf.length, InetAddress.getByName((String)iter.next()), this.testPort);
                this.sendSock.send(packet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void writeTestReq(CamdNetMessage req, DataOutputStream dos, boolean full) throws IOException {
        dos.writeByte(req.getCommandTag());
        if (full) {
            dos.writeShort(req.getNetworkId());
            dos.writeShort(req.getTid());
            dos.writeShort(req.getPid());
        }
        dos.writeShort(req.getCaId());
        dos.writeInt(req.getProviderIdent());
        dos.writeShort(req.getServiceId());
        dos.writeShort(req.getDataLength());
        dos.write(req.getCustomData());
    }

    public void stop() {
        this.readerThread = null;
        if (this.recvSock != null) {
            this.recvSock.close();
        }
    }
}

