/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.MessageCacheMap;
import com.bowman.cardserv.ServiceCacheEntry;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.util.TimedAverageList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class SourceCacheEntry
implements Comparable {
    static final Map owCw = Collections.synchronizedMap(new LinkedHashMap());
    static final Map recurringOwCw = Collections.synchronizedMap(new LinkedHashMap());
    int updateCount;
    int abortCount;
    int duplicateCount;
    int overwriteCount;
    String sourceStr;
    String ipStr;
    String label;
    private TimedAverageList discards = new TimedAverageList(60);
    private MessageCacheMap overwrites = new MessageCacheMap(60000L);

    public SourceCacheEntry(String sourceStr) {
        this.sourceStr = sourceStr;
        this.ipStr = sourceStr.substring(2);
        this.label = "?";
    }

    public static String getSourceStr(CamdNetMessage request) {
        if (request.getRemoteAddress() == null && request.getOriginAddress() == null) {
            return null;
        }
        if (request.getRemoteAddress() == null) {
            return "R:" + request.getOriginAddress();
        }
        return "L:" + request.getRemoteAddress();
    }

    public String toString() {
        return this.sourceStr;
    }

    public boolean isLocal() {
        return this.sourceStr.startsWith("L");
    }

    public boolean reportOverWrite(ServiceCacheEntry entry, CamdNetMessage newRequest, CamdNetMessage oldReply, CamdNetMessage newReply) {
        if ((oldReply.hasZeroDcw() || newReply.hasZeroDcw()) && oldReply.equalsSingleDcw(newReply)) {
            return false;
        }
        ++this.overwriteCount;
        this.overwrites.put((Object)newRequest, (Object)new ReplyTuple(newReply, oldReply));
        if (SourceCacheEntry.countOwCw(newReply) || SourceCacheEntry.countOwCw(oldReply)) {
            System.out.println("ecm: " + newRequest.hashCodeStr() + " " + DESUtil.bytesToString((byte[])newRequest.getCustomData()));
            System.out.println(entry + " " + this.overwrites.get((Object)newRequest) + "\n");
        }
        return true;
    }

    static boolean countOwCw(CamdNetMessage rep) {
        Integer i = (Integer)owCw.get(rep);
        if (i == null) {
            owCw.put(rep, new Integer(1));
        } else {
            i = new Integer(i + 1);
            owCw.put(rep, i);
            if (i > 2) {
                recurringOwCw.put(rep, i);
                System.out.println("Recurring overwrite cw: [" + CaProfile.getKeyStr((int)rep.getNetworkId(), (int)rep.getCaId()) + "] " + DESUtil.bytesToString((byte[])rep.getCustomData()) + " (" + i + ")");
                return true;
            }
        }
        return false;
    }

    public void reportDuplicate(ServiceCacheEntry entry, CamdNetMessage newRequest, CamdNetMessage oldReply) {
        if (this.sourceStr.equals(SourceCacheEntry.getSourceStr(oldReply))) {
            ++this.duplicateCount;
        } else {
            this.discards.addRecord((int)(newRequest.getTimeStamp() - oldReply.getTimeStamp()));
        }
    }

    public int compareTo(Object o) {
        return this.sourceStr.compareTo(((SourceCacheEntry)o).sourceStr);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceCacheEntry that = (SourceCacheEntry)o;
        return this.sourceStr.equals(that.sourceStr);
    }

    public int hashCode() {
        return this.sourceStr.hashCode();
    }

    static class ReplyTuple {
        CamdNetMessage newReply;
        CamdNetMessage oldReply;

        ReplyTuple(CamdNetMessage newReply, CamdNetMessage oldReply) {
            this.newReply = newReply;
            this.oldReply = oldReply;
        }

        public String toString() {
            return "\nold: " + this.oldReply.toDebugString() + "\nnew: " + this.newReply.toDebugString();
        }
    }
}

