/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CacheCoveragePlugin;
import com.bowman.cardserv.CacheForwarder;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.ClusteredCache;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.cardserv.util.TimedAverageList;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class UdpCacheForwarder
implements CacheForwarder {
    private final String name;
    private final CacheCoveragePlugin parent;
    private DatagramSocket sendSock;
    private InetAddress host;
    private int port;
    private Set profiles;
    private Set caids;
    private boolean sendLocks;
    private boolean hideNames;
    private int requests;
    private int replies;
    private int filtered;
    private TimedAverageList sentAvg = new TimedAverageList(10);

    public UdpCacheForwarder(CacheCoveragePlugin parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        if ("true".equalsIgnoreCase(xml.getStringValue("enabled", "true"))) {
            try {
                this.host = InetAddress.getByName(xml.getStringValue("host"));
            }
            catch (UnknownHostException e) {
                throw new ConfigException(xml.getFullName(), "host", "Unable to resolve host: " + xml.getStringValue("host"), (Throwable)e);
            }
            this.port = xml.getPortValue("port");
            this.sendLocks = "true".equalsIgnoreCase(xml.getStringValue("send-locks", "true"));
            this.hideNames = "true".equalsIgnoreCase(xml.getStringValue("hide-names", "true"));
            String profileStr = xml.getStringValue("profiles", "").trim().toLowerCase();
            this.profiles = profileStr.length() > 0 ? new HashSet<String>(Arrays.asList(profileStr.split(" "))) : null;
            String caidStr = xml.getStringValue("caids", "").trim();
            this.caids = caidStr.length() > 0 ? ProxyXmlConfig.getIntTokens((String)"caids", (String)caidStr) : null;
            try {
                this.sendSock = new DatagramSocket();
            }
            catch (SocketException e) {
                throw new ConfigException(xml.getFullName(), "Unable to create udp forwarder socket: " + e, (Throwable)e);
            }
        }
        this.close();
    }

    public String getName() {
        return this.name;
    }

    public boolean isConnected() {
        return this.sendSock != null;
    }

    public Properties getProperties() {
        Properties p = new Properties();
        p.setProperty("lock-count", String.valueOf(this.requests));
        p.setProperty("msg-count", String.valueOf(this.replies));
        p.setProperty("filtered", String.valueOf(this.filtered));
        p.setProperty("avg-sent-rate", String.valueOf(this.sentAvg.getTotal(true) / 10));
        return p;
    }

    public void close() {
        this.sendSock = null;
    }

    public void forwardRequest(CamdNetMessage req) {
        if (!this.sendLocks) {
            return;
        }
        if (this.isFiltered(req)) {
            ++this.filtered;
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeByte(1);
            ClusteredCache.writeCacheReq((DataOutputStream)dos, (CamdNetMessage)req, (boolean)false);
            dos.close();
            byte[] buf = bos.toByteArray();
            DatagramPacket packet = new DatagramPacket(buf, buf.length, this.host, this.port);
            this.sendSock.send(packet);
            this.sentAvg.addRecord(packet.getLength());
            ++this.requests;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void forwardReply(CamdNetMessage req, CamdNetMessage reply) {
        if (reply.getDataLength() == 16) {
            if (this.isFiltered(req)) {
                ++this.filtered;
                return;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                dos.writeByte(2);
                ClusteredCache.writeCacheReq((DataOutputStream)dos, (CamdNetMessage)req, (boolean)false);
                ClusteredCache.writeCacheRpl((DataOutputStream)dos, (CamdNetMessage)reply, (!this.hideNames ? 1 : 0) != 0);
                dos.close();
                byte[] buf = bos.toByteArray();
                DatagramPacket packet = new DatagramPacket(buf, buf.length, this.host, this.port);
                this.sendSock.send(packet);
                this.sentAvg.addRecord(packet.getLength());
                ++this.replies;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isFiltered(CamdNetMessage req) {
        if (!(this.profiles == null || req.getProfileName() != null && this.profiles.contains(req.getProfileName().toLowerCase()))) {
            return true;
        }
        return this.caids != null && !this.caids.contains(new Integer(req.getCaId()));
    }
}

