/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicLabelUI;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;

public class LabelRenderer
extends JLabel
implements ProfilerRenderer {
    private static final LabelRendererUI UI = new LabelRendererUI();
    private static final int DIRTY = Integer.MIN_VALUE;
    private Dimension preferredSize;
    private int iconWidth;
    private int iconHeight;
    private int iconTextGap;
    private int textWidth;
    private int fontAscent;
    private Point sharedPoint;
    private Dimension sharedDimension;
    private Rectangle sharedRectangle;
    protected final Point location = new Point();
    protected final Dimension size = new Dimension();
    private final Insets insets = new Insets(0, 0, 0, 0);
    private final Insets margin = new Insets(0, 0, 0, 0);
    private FontMetrics fontMetrics;
    private int fontSizeDiff;
    private String text;
    private Icon icon;
    private Color foreground;
    private Color background;
    private boolean enabled;

    public LabelRenderer() {
        this(false);
    }

    public LabelRenderer(boolean bl) {
        this.setEnabled(true);
        this.setHorizontalAlignment(10);
        this.setVerticalAlignment(1);
        this.setSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
        if (bl) {
            this.setOpaque(false);
        } else {
            this.setOpaque(true);
            this.setMargin(3, 3, 3, 3);
        }
        this.iconTextGap = super.getIconTextGap();
    }

    @Override
    public void setValue(Object object, int n) {
        this.setText(object.toString());
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void setUI(LabelUI labelUI) {
        super.setUI(UI);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.sharedDimension(this.getPreferredSizeImpl());
    }

    public Dimension getPreferredSizeImpl() {
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension(Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        if (this.preferredSize.width == Integer.MIN_VALUE) {
            this.textWidth = this.text == null || this.text.isEmpty() ? 0 : this.fontMetrics.stringWidth(this.text);
            this.preferredSize.width = this.iconWidth + this.textWidth;
            this.preferredSize.width += this.margin.left + this.margin.right;
            if (this.iconWidth > 0 && this.textWidth > 0) {
                this.preferredSize.width += this.iconTextGap;
            }
        }
        if (this.preferredSize.height == Integer.MIN_VALUE) {
            this.fontAscent = this.fontMetrics.getAscent();
            this.preferredSize.height = this.fontAscent + this.fontMetrics.getDescent();
            this.preferredSize.height += this.margin.top + this.margin.bottom;
        }
        return this.preferredSize;
    }

    private void resetPreferredSize(boolean bl, boolean bl2) {
        if (this.preferredSize == null) {
            return;
        }
        if (bl) {
            this.preferredSize.width = Integer.MIN_VALUE;
        }
        if (bl2) {
            this.preferredSize.height = Integer.MIN_VALUE;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2 = this.location.x;
        int n3 = this.size.height;
        int n4 = this.getPreferredSizeImpl().height;
        if (this.background != null && this.isOpaque()) {
            graphics.setColor(this.background);
            graphics.fillRect(n2, this.location.y, this.size.width, n3);
        }
        graphics.setFont(this.getFont());
        if (this.getHorizontalAlignment() == 10) {
            n2 += this.margin.left;
        } else {
            n2 += this.size.width - this.margin.right - this.textWidth;
            if (this.iconWidth > 0) {
                n2 += -this.iconWidth - this.iconTextGap;
            }
        }
        if (this.iconWidth > 0) {
            n = (n3 - this.iconHeight) / 2;
            this.icon.paintIcon(this, graphics, n2, this.location.y + n);
            n2 += this.iconWidth + this.iconTextGap;
        }
        if (this.textWidth > 0) {
            n = (n3 - n4 - this.fontSizeDiff) / 2 + this.margin.top;
            UI.paintEnabledText(this, graphics, this.text, n2, this.location.y + n + this.fontAscent);
        }
    }

    protected final Point sharedPoint(int n, int n2) {
        if (this.sharedPoint == null) {
            this.sharedPoint = new Point();
        }
        this.sharedPoint.x = n;
        this.sharedPoint.y = n2;
        return this.sharedPoint;
    }

    protected final Point sharedPoint(Point point) {
        return this.sharedPoint(point.x, point.y);
    }

    protected final Dimension sharedDimension(int n, int n2) {
        if (this.sharedDimension == null) {
            this.sharedDimension = new Dimension();
        }
        this.sharedDimension.width = n;
        this.sharedDimension.height = n2;
        return this.sharedDimension;
    }

    protected final Dimension sharedDimension(Dimension dimension) {
        return this.sharedDimension(dimension.width, dimension.height);
    }

    protected final Rectangle sharedRectangle(int n, int n2, int n3, int n4) {
        if (this.sharedRectangle == null) {
            this.sharedRectangle = new Rectangle();
        }
        this.sharedRectangle.x = n;
        this.sharedRectangle.y = n2;
        this.sharedRectangle.width = n3;
        this.sharedRectangle.height = n4;
        return this.sharedRectangle;
    }

    protected final Rectangle sharedRectangle(Rectangle rectangle) {
        return this.sharedRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void move(int n, int n2) {
        this.location.x = n;
        this.location.y = n2;
    }

    @Override
    public Point getLocation() {
        return this.sharedPoint(this.location);
    }

    @Override
    public int getX() {
        return this.location.x;
    }

    @Override
    public int getY() {
        return this.location.y;
    }

    @Override
    public void setSize(int n, int n2) {
        this.size.width = n;
        this.size.height = n2;
    }

    @Override
    public Dimension getSize() {
        return this.sharedDimension(this.size);
    }

    @Override
    public int getWidth() {
        return this.size.width;
    }

    @Override
    public int getHeight() {
        return this.size.height;
    }

    @Override
    public Rectangle getBounds() {
        return this.sharedRectangle(this.location.x, this.location.y, this.size.width, this.size.height);
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        this.size.width = n3;
        this.size.height = n4;
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    @Override
    public Insets getInsets(Insets insets) {
        return this.insets;
    }

    public void setMargin(int n, int n2, int n3, int n4) {
        this.margin.top = n;
        this.margin.left = n2;
        this.margin.bottom = n3;
        this.margin.right = n4;
        this.resetPreferredSize(true, true);
    }

    public Insets getMargin() {
        return this.margin;
    }

    @Override
    public void setText(String string) {
        this.text = string;
        this.resetPreferredSize(true, false);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setIcon(Icon icon) {
        this.icon = icon;
        this.iconWidth = icon == null ? 0 : icon.getIconWidth();
        this.iconHeight = icon == null ? 0 : icon.getIconHeight();
        this.resetPreferredSize(true, false);
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void setForeground(Color color) {
        this.foreground = color;
    }

    @Override
    public Color getForeground() {
        return this.foreground;
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return -1;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.fontMetrics;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = super.getFontMetrics(font);
        this.resetPreferredSize(true, true);
    }

    public void changeFontSize(int n) {
        this.fontSizeDiff = n;
        Font font = this.getFont();
        this.setFont(font.deriveFont(font.getSize2D() + (float)n));
    }

    @Override
    public int getIconTextGap() {
        return this.iconTextGap;
    }

    @Override
    public void setIconTextGap(int n) {
        this.iconTextGap = n;
        this.resetPreferredSize(true, false);
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void setDisplayedMnemonic(int n) {
    }

    @Override
    public void setDisplayedMnemonic(char c) {
    }

    @Override
    public void setDisplayedMnemonicIndex(int n) {
    }

    @Override
    public void firePropertyChange(String string, byte by, byte by2) {
    }

    @Override
    public void firePropertyChange(String string, char c, char c2) {
    }

    @Override
    public void firePropertyChange(String string, short s, short s2) {
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
    }

    @Override
    public void firePropertyChange(String string, long l, long l2) {
    }

    @Override
    public void firePropertyChange(String string, float f, float f2) {
    }

    @Override
    public void firePropertyChange(String string, double d, double d2) {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
    }

    private static final class LabelRendererUI
    extends BasicLabelUI {
        private LabelRendererUI() {
        }

        @Override
        protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
            super.paintEnabledText(jLabel, graphics, string, n, n2);
        }
    }
}

