/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.canvas;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.VolatileImage;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public abstract class BufferedCanvasComponent
extends JComponent {
    public static final int BUFFER_NONE = 0;
    public static final int BUFFER_IMAGE = 1;
    public static final int BUFFER_VOLATILE_IMAGE = 2;
    private static final int DEFAULT_BUFFER = Integer.getInteger("graphs.defaultBuffer", 2);
    private static final boolean ACCEL_DISABLED = true;
    private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    private int bufferType = -1;
    private float accelerationPriority = 0.5f;
    private Image offscreenImage = null;
    private WeakReference<Image> offscreenImageReference = new WeakReference<Image>(this.offscreenImage);
    private Rectangle invalidOffscreenArea = new Rectangle();

    public BufferedCanvasComponent() {
        this(DEFAULT_BUFFER);
    }

    public BufferedCanvasComponent(int n) {
        this.setOpaque(true);
        this.setBufferType(n);
        this.addHierarchyListener(new VisibilityHandler());
    }

    protected abstract void paintComponent(Graphics var1, Rectangle var2);

    protected void reshaped(Rectangle rectangle, Rectangle rectangle2) {
        if (!rectangle.getSize().equals(rectangle2.getSize())) {
            this.releaseOffscreenImage();
        }
    }

    protected void shown() {
        this.invalidateImage();
        this.repaintDirty();
    }

    protected void hidden() {
        this.weaklyReleaseOffscreenImage();
    }

    protected void windowIconified() {
        this.hidden();
    }

    protected void windowDeiconified() {
        this.shown();
    }

    protected final void setBufferType(int n) {
        if (this.bufferType == n) {
            return;
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Unknown buffer type: " + n);
        }
        this.bufferType = n;
        this.releaseOffscreenImage();
        this.repaintImpl(0, 0, this.getWidth(), this.getHeight());
    }

    protected final int getBufferType() {
        return this.bufferType;
    }

    protected final boolean isBuffered() {
        return this.bufferType != 0;
    }

    protected final void setAccelerationPriority(float f) {
        this.accelerationPriority = f;
        Image image = (Image)this.offscreenImageReference.get();
        if (image != null) {
            image.setAccelerationPriority(this.accelerationPriority);
        }
    }

    protected final float getAccelerationPriority() {
        return this.accelerationPriority;
    }

    protected final void releaseOffscreenImage() {
        if (this.offscreenImage != null) {
            this.offscreenImage.flush();
        }
        this.offscreenImage = null;
        this.offscreenImageReference.clear();
    }

    protected final void weaklyReleaseOffscreenImage() {
        if (this.offscreenImage != null) {
            this.offscreenImage.flush();
        }
        this.offscreenImage = null;
    }

    protected final void invalidateImage() {
        this.invalidOffscreenArea.setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    protected final void invalidateImage(Rectangle rectangle) {
        if (rectangle.isEmpty()) {
            return;
        }
        this.addInvalidArea(rectangle);
    }

    public final void repaintDirty() {
        if (!this.isDirty()) {
            return;
        }
        this.repaintImpl(0, 0, this.getWidth(), this.getHeight());
    }

    public final void repaintDirty(Rectangle rectangle) {
        this.addInvalidArea(rectangle);
        this.repaintImpl(this.invalidOffscreenArea.x, this.invalidOffscreenArea.y, this.invalidOffscreenArea.width, this.invalidOffscreenArea.height);
    }

    public final void repaintDirtyAccel() {
        if (!this.isDirty()) {
            return;
        }
        this.repaintImpl(0, 0, this.getWidth(), this.getHeight());
    }

    private void repaintImpl(int n, int n2, int n3, int n4) {
        this.repaint(n, n2, n3, n4);
    }

    boolean isDirty() {
        return !this.invalidOffscreenArea.isEmpty();
    }

    private void addInvalidArea(Rectangle rectangle) {
        if (rectangle.x > this.getWidth() || rectangle.x + rectangle.width < 0) {
            return;
        }
        if (rectangle.y > this.getHeight() || rectangle.y + rectangle.height < 0) {
            return;
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        rectangle.x = Math.max(rectangle.x, 0);
        rectangle.y = Math.max(rectangle.y, 0);
        rectangle.width = Math.min(n + rectangle.width, this.getWidth()) - rectangle.x;
        rectangle.height = Math.min(n2 + rectangle.height, this.getHeight()) - rectangle.y;
        if (this.invalidOffscreenArea.isEmpty()) {
            this.invalidOffscreenArea.setBounds(rectangle);
        } else {
            this.invalidOffscreenArea.add(rectangle);
        }
    }

    @Override
    public final void paint(Graphics graphics) {
        super.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void paintComponent(Graphics graphics) {
        if (this.bufferType != 0) {
            int n = this.updateOffscreenImage();
            if (n == 2) {
                this.offscreenImage = this.createOffscreenImage();
                if (this.offscreenImage == null) {
                    return;
                }
                this.offscreenImage.setAccelerationPriority(this.accelerationPriority);
                this.offscreenImageReference = new WeakReference<Image>(this.offscreenImage);
                n = 1;
            }
            if (n == 1) {
                this.invalidOffscreenArea.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.isDirty()) {
                Graphics graphics2 = this.offscreenImage.getGraphics();
                try {
                    this.paintComponent(graphics2, this.invalidOffscreenArea);
                }
                finally {
                    graphics2.dispose();
                }
            }
            graphics.drawImage(this.offscreenImage, 0, 0, null);
        } else {
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle == null) {
                rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            }
            this.paintComponent(graphics, rectangle);
        }
        this.invalidOffscreenArea.setBounds(0, 0, 0, 0);
    }

    @Override
    protected final void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
    }

    @Override
    protected final void paintBorder(Graphics graphics) {
    }

    @Override
    public final void update(Graphics graphics) {
    }

    protected boolean canDirectlyAccessGraphics() {
        Container container;
        if (this.getComponentCount() != 0) {
            return false;
        }
        if (!this.isOpaque()) {
            return false;
        }
        if (!(this.getParent() instanceof JComponent)) {
            return false;
        }
        if (!this.isShowing()) {
            return false;
        }
        Rectangle rectangle = RepaintManager.currentManager(this).getDirtyRegion((JComponent)this.getParent());
        if (rectangle != null && rectangle.width > 0 && rectangle.height > 0) {
            return false;
        }
        Rectangle rectangle2 = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = null;
        BufferedCanvasComponent bufferedCanvasComponent = null;
        for (container = this; container != null && BufferedCanvasComponent.isLightweightComponent(container); container = container.getParent()) {
            int n = ((Component)container).getX();
            int n2 = ((Component)container).getY();
            int n3 = ((Component)container).getWidth();
            int n4 = ((Component)container).getHeight();
            rectangle3.setBounds(rectangle2);
            SwingUtilities.computeIntersection(0, 0, n3, n4, rectangle2);
            if (!rectangle2.equals(rectangle3)) {
                return false;
            }
            if (bufferedCanvasComponent != null && container instanceof JComponent && !((JComponent)container).isOptimizedDrawingEnabled()) {
                Component[] componentArray = container.getComponents();
                int n5 = 0;
                for (int i = componentArray.length - 1; i >= 0; --i) {
                    if (componentArray[i] != bufferedCanvasComponent) continue;
                    n5 = i - 1;
                    break;
                }
                while (n5 >= 0) {
                    if ((rectangle4 = componentArray[n5].getBounds(rectangle4)).intersects(rectangle2)) {
                        return false;
                    }
                    --n5;
                }
            }
            rectangle2.x += n;
            rectangle2.y += n2;
            bufferedCanvasComponent = container;
        }
        return container != null;
    }

    private Image createOffscreenImage() {
        switch (this.bufferType) {
            case 2: {
                if (this.offscreenImage != null) {
                    this.offscreenImage.flush();
                }
                return this.createVolatileImage(this.getWidth(), this.getHeight());
            }
            case 1: {
                if (this.offscreenImage != null) {
                    this.offscreenImage.flush();
                }
                return this.createImage(this.getWidth(), this.getHeight());
            }
        }
        return null;
    }

    private int updateOffscreenImage() {
        if (this.offscreenImage == null) {
            this.offscreenImage = (Image)this.offscreenImageReference.get();
        }
        if (this.offscreenImage == null) {
            return 2;
        }
        if (this.bufferType != 2) {
            return 0;
        }
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            return 2;
        }
        return ((VolatileImage)this.offscreenImage).validate(graphicsConfiguration);
    }

    @Override
    public final void reshape(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        super.reshape(n, n2, n3, n4);
        this.reshaped(rectangle, rectangle2);
    }

    @Override
    public final void setBorder(Border border) {
        if (border != null) {
            throw new IllegalArgumentException("setBorder() not supported");
        }
    }

    @Override
    public final Insets getInsets() {
        return ZERO_INSETS;
    }

    @Override
    public final Insets getInsets(Insets insets) {
        insets.set(0, 0, 0, 0);
        return insets;
    }

    private class VisibilityHandler
    extends WindowAdapter
    implements HierarchyListener {
        private Window lastParentWindow;

        private VisibilityHandler() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            Window window;
            if ((hierarchyEvent.getChangeFlags() & 1L) != 0L && this.lastParentWindow != (window = SwingUtilities.getWindowAncestor(BufferedCanvasComponent.this))) {
                if (this.lastParentWindow != null) {
                    this.lastParentWindow.removeWindowListener(this);
                }
                if (window != null) {
                    window.addWindowListener(this);
                }
                this.lastParentWindow = window;
            }
            if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
                if (BufferedCanvasComponent.this.isShowing()) {
                    BufferedCanvasComponent.this.shown();
                } else {
                    BufferedCanvasComponent.this.hidden();
                }
            }
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
            BufferedCanvasComponent.this.windowDeiconified();
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
            BufferedCanvasComponent.this.windowIconified();
        }
    }
}

