/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.dictionary.OptionalTool;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.optional.api.LuceneIndexDescriptor;
import org.apache.derby.optional.api.LuceneUtils;
import org.apache.derby.optional.lucene.DerbyLuceneDir;
import org.apache.derby.optional.lucene.LuceneListIndexesVTI;
import org.apache.derby.optional.lucene.LuceneQueryVTI;
import org.apache.derby.vti.VTITemplate;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;

public class LuceneSupport
implements OptionalTool {
    private static final String LUCENE_SCHEMA = "LuceneSupport";
    private static final String LIST_INDEXES = "LuceneSupport.listIndexes";
    private static final String CREATE_INDEX = "LuceneSupport.createIndex";
    private static final String DROP_INDEX = "LuceneSupport.dropIndex";
    private static final String UPDATE_INDEX = "LuceneSupport.updateIndex";
    private static final String SEPARATOR = "__";
    private static final String SCORE = "SCORE";
    private static final String DOCUMENT_ID = "DOCUMENTID";
    static final int TABLE_PART = 0;
    static final int COLUMN_PART = 1;
    static final int PART_COUNT = 2;
    private static final String PROPERTIES_FILE_NAME = "derby-lucene.properties";
    public static final String INDEX_DESCRIPTOR_MAKER = "derby.lucene.index.descriptor.maker";
    public static final String ANALYZER = "derby.lucene.analyzer";
    public static final String LUCENE_VERSION = "derby.lucene.version";
    public static final String UPDATE_TIMESTAMP = "derby.lucene.last.updated";

    public void loadTool(String ... stringArray) throws SQLException {
        LuceneSupport.forbidReadOnlyConnections();
        try {
            ConnectionUtil.getCurrentLCC().getDataDictionary().checkVersion(230, "luceneSupport");
        }
        catch (StandardException standardException) {
            throw LuceneSupport.sqlException(standardException);
        }
        Connection connection = LuceneSupport.getDefaultConnection();
        LuceneSupport.mustBeDBO(connection);
        if (LuceneSupport.getDataFactory(connection).databaseEncrypted()) {
            throw LuceneSupport.newSQLException("42XBL", new Object[0]);
        }
        if (LuceneSupport.luceneSchemaExists(connection)) {
            throw LuceneSupport.newSQLException("42XBG", new Object[0]);
        }
        boolean bl = LuceneSupport.sqlAuthorizationEnabled(connection);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("create function LuceneSupport.listIndexes");
        stringBuilder.append(" () ");
        stringBuilder.append("returns table");
        stringBuilder.append("(");
        stringBuilder.append("schemaname varchar( 128 ),");
        stringBuilder.append("tablename varchar( 128 ),");
        stringBuilder.append("columnname varchar( 128 ),");
        stringBuilder.append("lastupdated timestamp,");
        stringBuilder.append("luceneversion varchar( 20 ),");
        stringBuilder.append("analyzer varchar( 32672 ),");
        stringBuilder.append("indexdescriptormaker varchar( 32672 )");
        stringBuilder.append(")");
        stringBuilder.append("language java ");
        stringBuilder.append("parameter style DERBY_JDBC_RESULT_SET ");
        stringBuilder.append("contains sql ");
        stringBuilder.append("external name '" + this.getClass().getName() + ".listIndexes'");
        this.executeDDL(connection, stringBuilder.toString());
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("create procedure LuceneSupport.createIndex");
        stringBuilder2.append(" (schemaname varchar( 128 ),");
        stringBuilder2.append("tablename varchar( 128 ),");
        stringBuilder2.append("textcolumn varchar( 128 ),");
        stringBuilder2.append("indexdescriptormaker varchar( 32672 ),");
        stringBuilder2.append("keyColumns varchar( 32672 )...)");
        stringBuilder2.append("parameter style derby modifies sql data language java external name ");
        stringBuilder2.append("'" + this.getClass().getName() + ".createIndex'");
        this.executeDDL(connection, stringBuilder2.toString());
        StringBuilder stringBuilder3 = new StringBuilder();
        stringBuilder3.append("create procedure LuceneSupport.dropIndex");
        stringBuilder3.append(" (schemaname varchar( 128 ),");
        stringBuilder3.append("tablename varchar( 128 ),");
        stringBuilder3.append("textcolumn varchar( 128 ))");
        stringBuilder3.append("parameter style java modifies sql data language java external name ");
        stringBuilder3.append("'" + this.getClass().getName() + ".dropIndex'");
        this.executeDDL(connection, stringBuilder3.toString());
        StringBuilder stringBuilder4 = new StringBuilder();
        stringBuilder4.append("create procedure LuceneSupport.updateIndex");
        stringBuilder4.append(" (schemaname varchar( 128 ),");
        stringBuilder4.append("tablename varchar( 128 ),");
        stringBuilder4.append("textcolumn varchar( 128 ),");
        stringBuilder4.append("indexdescriptormaker varchar( 32672 ))");
        stringBuilder4.append("parameter style java reads sql data language java external name ");
        stringBuilder4.append("'" + this.getClass().getName() + ".updateIndex'");
        this.executeDDL(connection, stringBuilder4.toString());
        if (bl) {
            this.grantPermissions();
        }
        LuceneSupport.createLuceneDir(connection);
    }

    private void grantPermissions() throws SQLException {
        Connection connection = LuceneSupport.getDefaultConnection();
        this.executeDDL(connection, "grant execute on function LuceneSupport.listIndexes to public");
        this.executeDDL(connection, "grant execute on procedure LuceneSupport.createIndex to public");
        this.executeDDL(connection, "grant execute on procedure LuceneSupport.dropIndex to public");
        this.executeDDL(connection, "grant execute on procedure LuceneSupport.updateIndex to public");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadTool(String ... stringArray) throws SQLException {
        String string;
        String string2;
        LuceneSupport.forbidReadOnlyConnections();
        Connection connection = LuceneSupport.getDefaultConnection();
        LuceneSupport.mustBeDBO(connection);
        if (!LuceneSupport.luceneSchemaExists(connection)) {
            throw LuceneSupport.newSQLException("42XBH", new Object[0]);
        }
        String string3 = this.getClass().getName();
        int n = string3.lastIndexOf(".");
        String string4 = string3.substring(0, n);
        PreparedStatement preparedStatement = connection.prepareStatement("select s.schemaName, a.alias, a.aliastype\nfrom sys.sysschemas s, sys.sysaliases a\nwhere s.schemaID = a.schemaID\nand substr( cast( a.javaclassname as varchar( 32672 ) ), 1, ? ) = ?\n");
        preparedStatement.setInt(1, string4.length());
        preparedStatement.setString(2, string4);
        ResultSet resultSet = preparedStatement.executeQuery();
        try {
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
                string = resultSet.getString(2);
                String string5 = "P".equals(resultSet.getString(3)) ? "procedure" : "function";
                connection.prepareStatement("drop " + string5 + " " + LuceneSupport.makeTableName(string2, string)).execute();
            }
        }
        finally {
            resultSet.close();
        }
        connection.prepareStatement("drop schema LuceneSupport restrict").execute();
        string2 = LuceneSupport.getStorageFactory(connection);
        string = string2.newStorageFile("LUCENE");
        if (LuceneSupport.exists((StorageFile)string)) {
            LuceneSupport.deleteFile((StorageFile)string);
        }
    }

    public static LuceneQueryVTI luceneQuery(String string, int n, Float f) throws ParseException, IOException, SQLException {
        LuceneQueryVTI luceneQueryVTI = new LuceneQueryVTI(string, n, f);
        return luceneQueryVTI;
    }

    public static LuceneListIndexesVTI listIndexes() throws IOException, PrivilegedActionException, SQLException {
        LuceneListIndexesVTI luceneListIndexesVTI = new LuceneListIndexesVTI();
        return luceneListIndexesVTI;
    }

    public static void updateIndex(String string, String string2, String string3, String string4) throws SQLException, IOException, PrivilegedActionException {
        LuceneSupport.forbidReadOnlyConnections();
        Connection connection = LuceneSupport.getDefaultConnection();
        LuceneSupport.vetIdentifiers(string, string2, string3);
        LuceneSupport.mustBeOwner(connection, string);
        if (!LuceneSupport.tableFunctionExists(connection, string, string2, string3)) {
            throw LuceneSupport.newSQLException("42XBE", new Object[0]);
        }
        LuceneSupport.createOrRecreateIndex(connection, string, string2, string3, string4, false, new String[0]);
    }

    public static void createIndex(String string, String string2, String string3, String string4, String ... stringArray) throws SQLException, IOException, PrivilegedActionException {
        LuceneSupport.forbidReadOnlyConnections();
        Connection connection = LuceneSupport.getDefaultConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        LuceneSupport.vetIdentifiers(string, string2, string3);
        LuceneSupport.vetTextColumn(databaseMetaData, string, string2, string3);
        LuceneSupport.createOrRecreateIndex(connection, string, string2, string3, string4, true, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createOrRecreateIndex(Connection connection, String string, String string2, String string3, String string4, boolean bl, String ... stringArray) throws SQLException, IOException, PrivilegedActionException {
        Object object2;
        VTITemplate.ColumnDescriptor[] columnDescriptorArray = new Document[]{};
        columnDescriptorArray = !bl ? LuceneSupport.getKeys(connection, string, string2, string3) : (stringArray != null && stringArray.length > 0 ? LuceneSupport.getKeys(connection, string, string2, stringArray) : LuceneSupport.getPrimaryKeys(connection, string, string2));
        if (columnDescriptorArray.length == 0) {
            throw LuceneSupport.newSQLException("42XBB", new Object[0]);
        }
        LuceneSupport.vetColumnName(string3);
        for (Object object2 : columnDescriptorArray) {
            LuceneSupport.vetColumnName(object2.columnName);
        }
        int n = 0;
        StorageFile storageFile = LuceneSupport.getIndexPropertiesFile(connection, string, string2, string3);
        if (!bl) {
            LuceneSupport.dropIndexDirectories(string, string2, string3);
        }
        Version version = LuceneUtils.currentVersion();
        object2 = LuceneSupport.getDerbyLuceneDir(connection, string, string2, string3);
        if (string4 == null) {
            string4 = LuceneUtils.class.getName() + ".defaultIndexDescriptor";
        }
        LuceneIndexDescriptor luceneIndexDescriptor = LuceneSupport.getIndexDescriptor(string4);
        String[] stringArray2 = luceneIndexDescriptor.getFieldNames();
        Analyzer analyzer = luceneIndexDescriptor.getAnalyzer();
        LuceneSupport.sortAndVetFieldNames(stringArray2, columnDescriptorArray);
        Properties properties = new Properties();
        properties.setProperty(LUCENE_VERSION, version.toString());
        properties.setProperty(UPDATE_TIMESTAMP, Long.toString(System.currentTimeMillis()));
        properties.setProperty(INDEX_DESCRIPTOR_MAKER, string4);
        properties.setProperty(ANALYZER, analyzer.getClass().getName());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("create function " + LuceneSupport.makeTableFunctionName(string, string2, string3) + "\n");
        stringBuilder.append("( query varchar( 32672 ), windowSize int, scoreCeiling real )\n");
        stringBuilder.append("returns table\n(");
        LuceneSupport.writeIndexProperties(storageFile, properties);
        Statement statement = null;
        ResultSet resultSet = null;
        IndexWriter indexWriter = null;
        try {
            indexWriter = LuceneSupport.getIndexWriter(version, analyzer, (DerbyLuceneDir)((Object)object2));
            StringBuilder stringBuilder2 = new StringBuilder("select ");
            for (VTITemplate.ColumnDescriptor columnDescriptor : columnDescriptorArray) {
                String string5 = LuceneSupport.derbyIdentifier(columnDescriptor.columnName);
                if (n > 0) {
                    stringBuilder2.append(", ");
                }
                stringBuilder2.append(string5);
                String string6 = LuceneSupport.mapType(columnDescriptor);
                if (n > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("\n\t" + string5 + " " + string6);
                ++n;
            }
            stringBuilder.append(",\n\tDOCUMENTID int");
            stringBuilder.append(",\n\tSCORE real");
            stringBuilder.append("\n)\nlanguage java parameter style derby_jdbc_result_set contains sql\n");
            stringBuilder.append("external name '" + LuceneSupport.class.getName() + ".luceneQuery'");
            if (bl) {
                connection.prepareStatement(stringBuilder.toString()).execute();
            }
            stringBuilder2.append(", ");
            stringBuilder2.append(LuceneSupport.derbyIdentifier(string3));
            stringBuilder2.append(" from " + LuceneSupport.makeTableName(string, string2));
            statement = connection.prepareStatement(stringBuilder2.toString());
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                VTITemplate.ColumnDescriptor[] columnDescriptorArray2 = new Document();
                for (int i = 0; i < n; ++i) {
                    Document document = columnDescriptorArray[i];
                    LuceneSupport.addValue((Document)columnDescriptorArray2, (VTITemplate.ColumnDescriptor)document, resultSet, i + 1);
                }
                String string7 = resultSet.getString(n + 1);
                if (string7 != null) {
                    for (String string6 : stringArray2) {
                        columnDescriptorArray2.add((IndexableField)new TextField(string6, string7, Field.Store.NO));
                    }
                }
                LuceneSupport.addDocument(indexWriter, (Document)columnDescriptorArray2);
            }
        }
        finally {
            try {
                if (indexWriter != null) {
                    LuceneSupport.close(indexWriter);
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
        }
    }

    private static void vetIdentifiers(String string, String string2, String string3) throws SQLException {
        LuceneSupport.checkNotNull("SCHEMANAME", string);
        LuceneSupport.checkNotNull("TABLENAME", string2);
        LuceneSupport.checkNotNull("TEXTCOLUMN", string3);
    }

    /*
     * WARNING - void declaration
     */
    private static void sortAndVetFieldNames(String[] stringArray, VTITemplate.ColumnDescriptor[] columnDescriptorArray) throws SQLException {
        for (String string : stringArray) {
            if (string != null) continue;
            throw LuceneSupport.newSQLException("42XBO", string);
        }
        Arrays.sort(stringArray);
        HashSet hashSet = new HashSet();
        for (VTITemplate.ColumnDescriptor columnDescriptor : columnDescriptorArray) {
            hashSet.add(columnDescriptor.columnName);
        }
        Object var3_5 = null;
        for (String string : stringArray) {
            void var3_6;
            if (string.equals(var3_6)) {
                throw LuceneSupport.newSQLException("42XBO", string);
            }
            String string2 = string;
            if (!hashSet.contains(string)) continue;
            throw LuceneSupport.newSQLException("42XBN", string);
        }
    }

    public static void dropIndex(String string, String string2, String string3) throws SQLException {
        LuceneSupport.forbidReadOnlyConnections();
        LuceneSupport.vetIdentifiers(string, string2, string3);
        LuceneSupport.getDefaultConnection().prepareStatement("drop function " + LuceneSupport.makeTableFunctionName(string, string2, string3)).execute();
        LuceneSupport.dropIndexDirectories(string, string2, string3);
    }

    private static void dropIndexDirectories(String string, String string2, String string3) throws SQLException {
        DerbyLuceneDir derbyLuceneDir = LuceneSupport.getDerbyLuceneDir(LuceneSupport.getDefaultConnection(), string, string2, string3);
        StorageFile storageFile = derbyLuceneDir.getDirectory();
        StorageFile storageFile2 = storageFile.getParentDir();
        StorageFile storageFile3 = storageFile2.getParentDir();
        LuceneSupport.deleteFile(storageFile);
        if (LuceneSupport.isEmpty(storageFile2)) {
            LuceneSupport.deleteFile(storageFile2);
            if (LuceneSupport.isEmpty(storageFile3)) {
                LuceneSupport.deleteFile(storageFile3);
            }
        }
    }

    public static SQLException newSQLException(String string, Object ... objectArray) {
        StandardException standardException = StandardException.newException((String)string, (Object[])objectArray);
        return LuceneSupport.sqlException(standardException);
    }

    public static SQLException sqlException(StandardException standardException) {
        return PublicAPI.wrapStandardException((StandardException)standardException);
    }

    public static SQLException wrap(Throwable throwable) {
        return LuceneSupport.sqlException(StandardException.plainWrapException((Throwable)throwable));
    }

    private static String mapType(VTITemplate.ColumnDescriptor columnDescriptor) throws SQLException {
        return LuceneSupport.mapType(columnDescriptor.jdbcType, columnDescriptor.precision, columnDescriptor.scale, columnDescriptor.typeName);
    }

    private static String mapType(int n, int n2, int n3, String string) throws SQLException {
        switch (n) {
            case -5: {
                return "bigint";
            }
            case -2: {
                return "char " + LuceneSupport.precisionToLength(n2) + "  for bit data";
            }
            case -7: {
                return "boolean";
            }
            case 2004: {
                return "blob";
            }
            case 16: {
                return "boolean";
            }
            case 1: {
                return "char" + LuceneSupport.precisionToLength(n2);
            }
            case 2005: {
                return "clob";
            }
            case 91: {
                return "date";
            }
            case 3: {
                return "decimal" + LuceneSupport.precisionAndScale(n2, n3);
            }
            case 8: {
                return "double";
            }
            case 6: {
                return "float";
            }
            case 4: {
                return "integer";
            }
            case -4: {
                return "long varchar for bit data";
            }
            case -1: {
                return "long varchar";
            }
            case 2: {
                return "numeric" + LuceneSupport.precisionAndScale(n2, n3);
            }
            case 7: {
                return "real";
            }
            case 5: {
                return "smallint";
            }
            case 92: {
                return "time";
            }
            case 93: {
                return "timestamp";
            }
            case -6: {
                return "smallint";
            }
            case -3: {
                return "varchar " + LuceneSupport.precisionToLength(n2) + "  for bit data";
            }
            case 12: {
                return "varchar" + LuceneSupport.precisionToLength(n2);
            }
        }
        throw LuceneSupport.newSQLException("42XBC", string);
    }

    private static String precisionToLength(int n) {
        return "( " + n + " )";
    }

    private static String precisionAndScale(int n, int n2) {
        return "( " + n + ", " + n2 + " )";
    }

    private static void addValue(Document document, VTITemplate.ColumnDescriptor columnDescriptor, ResultSet resultSet, int n) throws SQLException {
        IndexableField indexableField = null;
        switch (columnDescriptor.jdbcType) {
            case -6: 
            case 4: 
            case 5: {
                indexableField = LuceneSupport.getIntField(columnDescriptor, resultSet, n);
                break;
            }
            case 7: {
                indexableField = LuceneSupport.getFloatField(columnDescriptor, resultSet, n);
                break;
            }
            case 6: 
            case 8: {
                indexableField = LuceneSupport.getDoubleField(columnDescriptor, resultSet, n);
                break;
            }
            case -5: {
                indexableField = LuceneSupport.getLongField(columnDescriptor, resultSet, n);
                break;
            }
            case 91: {
                indexableField = LuceneSupport.getDateField(columnDescriptor, resultSet, n);
                break;
            }
            case 92: {
                indexableField = LuceneSupport.getTimeField(columnDescriptor, resultSet, n);
                break;
            }
            case 93: {
                indexableField = LuceneSupport.getTimestampField(columnDescriptor, resultSet, n);
                break;
            }
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 2005: {
                indexableField = LuceneSupport.getStringField(columnDescriptor, resultSet, n);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                indexableField = LuceneSupport.getBinaryField(columnDescriptor, resultSet, n);
                break;
            }
            case -7: 
            case 16: {
                boolean bl = resultSet.getBoolean(n);
                if (resultSet.wasNull()) break;
                indexableField = new StringField(columnDescriptor.columnName, bl ? "true" : "false", Field.Store.YES);
                break;
            }
            default: {
                throw LuceneSupport.newSQLException("42XBC", columnDescriptor.typeName);
            }
        }
        if (resultSet.wasNull()) {
            indexableField = null;
        }
        if (indexableField != null) {
            document.add(indexableField);
        }
    }

    private static IndexableField getStringField(VTITemplate.ColumnDescriptor columnDescriptor, ResultSet resultSet, int n) throws SQLException {
        String string = resultSet.getString(n);
        if (string != null) {
            return new StringField(columnDescriptor.columnName, string, Field.Store.YES);
        }
        return null;
    }

    private static IndexableField getFloatField(VTITemplate.ColumnDescriptor columnDescriptor, ResultSet resultSet, int n) throws SQLException {
        float f = resultSet.getFloat(n);
        if (resultSet.wasNull()) {
            return null;
        }
        return new StoredField(columnDescriptor.columnName, f);
    }

    private static IndexableField getDoubleField(VTITemplate.ColumnDescriptor columnDescriptor, ResultSet resultSet, int n) throws SQLException {
        double d = resultSet.getDouble(n);
        if (resultSet.wasNull()) {
            return null;
        }
        return new StoredField(columnDescriptor.columnName, d);
    }

    private static IndexableField getLongField(VTITemplate.ColumnDescriptor columnDescriptor, ResultSet resultSet, int n) throws SQLException {
        long l = resultSet.getLong(n);
        if (resultSet.wasNull()) {
            return null;
        }
        return new StoredField(columnDescriptor.columnName, l);
    }

    private static IndexableField getDateField(VTITemplate.ColumnDescriptor columnDescriptor, ResultSet resultSet, int n) throws SQLException {
        Date date = resultSet.getDate(n);
        if (resultSet.wasNull()) {
            return null;
        }
        return new StoredField(columnDescriptor.columnName, date.getTime());
    }

    private static IndexableField getTimeField(VTITemplate.ColumnDescriptor columnDescriptor, ResultSet resultSet, int n) throws SQLException {
        Time time = resultSet.getTime(n);
        if (resultSet.wasNull()) {
            return null;
        }
        return new StoredField(columnDescriptor.columnName, time.getTime());
    }

    private static IndexableField getTimestampField(VTITemplate.ColumnDescriptor columnDescriptor, ResultSet resultSet, int n) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(n);
        if (resultSet.wasNull()) {
            return null;
        }
        return new StoredField(columnDescriptor.columnName, timestamp.getTime());
    }

    private static IndexableField getIntField(VTITemplate.ColumnDescriptor columnDescriptor, ResultSet resultSet, int n) throws SQLException {
        int n2 = resultSet.getInt(n);
        if (resultSet.wasNull()) {
            return null;
        }
        return new StoredField(columnDescriptor.columnName, n2);
    }

    private static IndexableField getBinaryField(VTITemplate.ColumnDescriptor columnDescriptor, ResultSet resultSet, int n) throws SQLException {
        byte[] byArray = resultSet.getBytes(n);
        if (byArray != null) {
            BytesRef bytesRef = new BytesRef(byArray);
            return new StoredField(columnDescriptor.columnName, bytesRef);
        }
        return null;
    }

    private static void vetTextColumn(DatabaseMetaData databaseMetaData, String string, String string2, String string3) throws SQLException {
        string = LuceneSupport.derbyIdentifier(string);
        string2 = LuceneSupport.derbyIdentifier(string2);
        string3 = LuceneSupport.derbyIdentifier(string3);
        ResultSet resultSet = databaseMetaData.getColumns(null, string, string2, string3);
        try {
            if (resultSet.next()) {
                switch (resultSet.getInt("DATA_TYPE")) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        return;
                    }
                }
            }
            throw LuceneSupport.sqlException(StandardException.newException((String)"42XBA", (Object[])new Object[0]));
        }
        finally {
            resultSet.close();
        }
    }

    private static void vetColumnName(String string) throws SQLException {
        String string2 = LuceneSupport.derbyIdentifier(string);
        if (DOCUMENT_ID.equals(string2) || SCORE.equals(string2)) {
            throw LuceneSupport.newSQLException("42XBJ", string2);
        }
    }

    static String makeTableName(String string, String string2) throws SQLException {
        string = LuceneSupport.derbyIdentifier(string);
        string2 = LuceneSupport.derbyIdentifier(string2);
        return IdUtil.mkQualifiedName((String)string, (String)string2);
    }

    private static String makeTableFunctionName(String string, String string2, String string3) throws SQLException {
        LuceneSupport.forbidCharacter(string, string2, string3, ".");
        LuceneSupport.forbidCharacter(string, string2, string3, "/");
        LuceneSupport.forbidCharacter(string, string2, string3, "\\");
        string = LuceneSupport.derbyIdentifier(string);
        String string4 = LuceneSupport.makeUnqualifiedTableFunctionName(string2, string3);
        return IdUtil.mkQualifiedName((String)string, (String)string4);
    }

    private static String makeUnqualifiedTableFunctionName(String string, String string2) throws SQLException {
        return LuceneSupport.derbyIdentifier(string) + SEPARATOR + LuceneSupport.derbyIdentifier(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tableFunctionExists(Connection connection, String string, String string2, String string3) throws SQLException {
        string = LuceneSupport.derbyIdentifier(string);
        String string4 = LuceneSupport.makeUnqualifiedTableFunctionName(string2, string3);
        ResultSet resultSet = connection.getMetaData().getFunctions(null, string, string4);
        try {
            boolean bl = resultSet.next();
            return bl;
        }
        finally {
            resultSet.close();
        }
    }

    static String[] decodeFunctionName(String string) {
        int n = string.indexOf(SEPARATOR);
        String[] stringArray = new String[]{string.substring(0, n), string.substring(n + SEPARATOR.length())};
        return stringArray;
    }

    static StorageFile getIndexPropertiesFile(Connection connection, String string, String string2, String string3) throws SQLException, IOException, PrivilegedActionException {
        return LuceneSupport.getIndexPropertiesFile(LuceneSupport.getDerbyLuceneDir(connection, string, string2, string3));
    }

    static StorageFile getIndexPropertiesFile(DerbyLuceneDir derbyLuceneDir) throws SQLException, IOException, PrivilegedActionException {
        StorageFile storageFile = derbyLuceneDir.getFile(PROPERTIES_FILE_NAME);
        return storageFile;
    }

    static Properties readIndexPropertiesNoPrivs(StorageFile storageFile) throws IOException {
        if (storageFile == null) {
            return null;
        }
        Properties properties = new Properties();
        InputStream inputStream = storageFile.getInputStream();
        properties.load(inputStream);
        inputStream.close();
        return properties;
    }

    private static void writeIndexProperties(final StorageFile storageFile, Properties properties) throws IOException {
        OutputStream outputStream;
        if (storageFile == null || properties == null) {
            return;
        }
        try {
            outputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){

                @Override
                public OutputStream run() throws IOException {
                    return storageFile.getOutputStream();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
        properties.store(outputStream, null);
        outputStream.flush();
        outputStream.close();
    }

    private static void forbidReadOnlyConnections() throws SQLException {
        if (ConnectionUtil.getCurrentLCC().getAuthorizer().isReadOnlyConnection()) {
            throw LuceneSupport.newSQLException("25502", new Object[0]);
        }
    }

    static Connection getDefaultConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:default:connection");
    }

    private static void mustBeOwner(Connection connection, String string) throws SQLException {
        if (!LuceneSupport.sqlAuthorizationEnabled(connection)) {
            return;
        }
        String string2 = LuceneSupport.getOwner(connection, "SYS");
        String string3 = LuceneSupport.getOwner(connection, string);
        String string4 = LuceneSupport.getCurrentUser(connection);
        if (string3 != null && (string3.equals(string4) || string2.equals(string4))) {
            return;
        }
        throw LuceneSupport.newSQLException("42XBF", new Object[0]);
    }

    private static void mustBeDBO(Connection connection) throws SQLException {
        String string;
        if (!LuceneSupport.sqlAuthorizationEnabled(connection)) {
            return;
        }
        String string2 = LuceneSupport.getOwner(connection, "SYS");
        if (string2.equals(string = LuceneSupport.getCurrentUser(connection))) {
            return;
        }
        throw LuceneSupport.newSQLException("4251D", new Object[0]);
    }

    private static String getCurrentUser(Connection connection) throws SQLException {
        ResultSet resultSet = connection.prepareStatement("values current_user").executeQuery();
        try {
            resultSet.next();
            String string = resultSet.getString(1);
            return string;
        }
        finally {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getOwner(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("select authorizationID from sys.sysschemas where schemaName = ?");
        preparedStatement.setString(1, LuceneSupport.derbyIdentifier(string));
        ResultSet resultSet = preparedStatement.executeQuery();
        try {
            if (resultSet.next()) {
                String string2 = resultSet.getString(1);
                return string2;
            }
            String string3 = null;
            return string3;
        }
        finally {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean luceneSchemaExists(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("select count(*) from sys.sysschemas where schemaName = ?");
        preparedStatement.setString(1, LUCENE_SCHEMA.toUpperCase());
        ResultSet resultSet = preparedStatement.executeQuery();
        try {
            resultSet.next();
            boolean bl = resultSet.getInt(1) > 0;
            return bl;
        }
        finally {
            resultSet.close();
            preparedStatement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean sqlAuthorizationEnabled(Connection connection) throws SQLException {
        ResultSet resultSet;
        block11: {
            try {
                resultSet = connection.prepareStatement("select count(*) from sys.sysusers").executeQuery();
                resultSet.next();
                try {
                    if (resultSet.getInt(1) > 0) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                if (!"4251D".equals(sQLException.getSQLState())) break block11;
                return true;
            }
        }
        resultSet = connection.prepareStatement("values syscs_util.syscs_get_database_property( 'derby.database.sqlAuthorization' )").executeQuery();
        try {
            if (!resultSet.next()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = "true".equals(resultSet.getString(1));
            return bl;
        }
        finally {
            resultSet.close();
        }
    }

    private void executeDDL(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.execute();
        preparedStatement.close();
    }

    static String derbyIdentifier(String string) throws SQLException {
        try {
            return IdUtil.parseSQLIdentifier((String)string);
        }
        catch (StandardException standardException) {
            throw LuceneSupport.sqlException(standardException);
        }
    }

    static void checkNotNull(String string, String string2) throws SQLException {
        if (string2 == null) {
            throw LuceneSupport.newSQLException("42XBM", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VTITemplate.ColumnDescriptor[] getPrimaryKeys(Connection connection, String string, String string2) throws SQLException {
        Object[] objectArray;
        ResultSet resultSet = connection.getMetaData().getPrimaryKeys(null, LuceneSupport.derbyIdentifier(string), LuceneSupport.derbyIdentifier(string2));
        ArrayList<VTITemplate.ColumnDescriptor> arrayList = new ArrayList<VTITemplate.ColumnDescriptor>();
        try {
            while (resultSet.next()) {
                objectArray = resultSet.getString("COLUMN_NAME");
                int n = resultSet.getInt("KEY_SEQ");
                ResultSet resultSet2 = connection.prepareStatement("select " + (String)objectArray + " from " + LuceneSupport.makeTableName(string, string2) + " where 1=2").executeQuery();
                ResultSetMetaData resultSetMetaData = resultSet2.getMetaData();
                VTITemplate.ColumnDescriptor columnDescriptor = new VTITemplate.ColumnDescriptor((String)objectArray, resultSetMetaData.getColumnType(1), resultSetMetaData.getPrecision(1), resultSetMetaData.getScale(1), resultSetMetaData.getColumnTypeName(1), n);
                arrayList.add(columnDescriptor);
                resultSet2.close();
            }
        }
        finally {
            resultSet.close();
        }
        objectArray = new VTITemplate.ColumnDescriptor[arrayList.size()];
        arrayList.toArray(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VTITemplate.ColumnDescriptor[] getKeys(Connection connection, String string, String string2, String string3) throws SQLException {
        VTITemplate.ColumnDescriptor columnDescriptor;
        string = LuceneSupport.derbyIdentifier(string);
        String string4 = LuceneSupport.makeUnqualifiedTableFunctionName(string2, string3);
        ArrayList<VTITemplate.ColumnDescriptor> arrayList = new ArrayList<VTITemplate.ColumnDescriptor>();
        ResultSet resultSet = connection.getMetaData().getFunctionColumns(null, string, string4, "%");
        try {
            while (resultSet.next()) {
                if (resultSet.getInt("COLUMN_TYPE") != 5) continue;
                columnDescriptor = new VTITemplate.ColumnDescriptor(resultSet.getString("COLUMN_NAME"), resultSet.getInt("DATA_TYPE"), resultSet.getInt("PRECISION"), resultSet.getInt("SCALE"), resultSet.getString("TYPE_NAME"), resultSet.getInt("ORDINAL_POSITION"));
                arrayList.add(columnDescriptor);
            }
        }
        finally {
            resultSet.close();
        }
        columnDescriptor = new VTITemplate.ColumnDescriptor[arrayList.size()];
        arrayList.toArray((T[])columnDescriptor);
        Arrays.sort((Object[])columnDescriptor);
        int n = ((Object[])columnDescriptor).length - 2;
        VTITemplate.ColumnDescriptor[] columnDescriptorArray = new VTITemplate.ColumnDescriptor[n];
        for (int i = 0; i < n; ++i) {
            columnDescriptorArray[i] = columnDescriptor[i];
        }
        return columnDescriptorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VTITemplate.ColumnDescriptor[] getKeys(Connection connection, String string, String string2, String ... stringArray) throws SQLException {
        String string3 = LuceneSupport.makeTableName(string, string2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select ");
        int n = 0;
        for (String string4 : stringArray) {
            LuceneSupport.checkNotNull("KEYCOLUMNS", string4);
            if (n > 0) {
                stringBuilder.append(", ");
            }
            ++n;
            stringBuilder.append(LuceneSupport.derbyIdentifier(string4));
        }
        stringBuilder.append("\nfrom " + string3);
        stringBuilder.append("\nwhere 1=2");
        ArrayList arrayList = new ArrayList();
        ResultSet resultSet = connection.prepareStatement(stringBuilder.toString()).executeQuery();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        try {
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                VTITemplate.ColumnDescriptor columnDescriptor = new VTITemplate.ColumnDescriptor(resultSetMetaData.getColumnName(i), resultSetMetaData.getColumnType(i), resultSetMetaData.getPrecision(i), resultSetMetaData.getScale(i), resultSetMetaData.getColumnTypeName(i), i);
                arrayList.add(columnDescriptor);
            }
        }
        finally {
            resultSet.close();
        }
        VTITemplate.ColumnDescriptor[] columnDescriptorArray = new VTITemplate.ColumnDescriptor[arrayList.size()];
        arrayList.toArray(columnDescriptorArray);
        return columnDescriptorArray;
    }

    private static boolean isEmpty(final StorageFile storageFile) {
        String[] stringArray = AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                return storageFile.list();
            }
        });
        if (stringArray == null) {
            return true;
        }
        return stringArray.length == 0;
    }

    private static boolean exists(final StorageFile storageFile) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return storageFile.exists();
            }
        });
    }

    private static boolean deleteFile(final StorageFile storageFile) throws SQLException {
        boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return storageFile.isDirectory() ? storageFile.deleteAll() : storageFile.delete();
            }
        });
        if (!bl) {
            throw LuceneSupport.newSQLException("XBM0R.D", storageFile.getPath());
        }
        return bl;
    }

    private static void forbidCharacter(String string, String string2, String string3, String string4) throws SQLException {
        if (string.indexOf(string4) > 0 || string2.indexOf(string4) > 0 || string3.indexOf(string4) > 0) {
            throw LuceneSupport.newSQLException("42XBD", string4);
        }
    }

    private static IndexWriter getIndexWriter(final Version version, final Analyzer analyzer, final DerbyLuceneDir derbyLuceneDir) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<IndexWriter>(){

                @Override
                public IndexWriter run() throws IOException {
                    IndexWriterConfig indexWriterConfig = new IndexWriterConfig(version, analyzer);
                    IndexWriter indexWriter = new IndexWriter((Directory)derbyLuceneDir, indexWriterConfig);
                    return indexWriter;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    private static void addDocument(final IndexWriter indexWriter, final Document document) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    indexWriter.addDocument((Iterable)document);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    private static void close(final IndexWriter indexWriter) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    indexWriter.close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    private static LuceneIndexDescriptor getIndexDescriptor(final String string) throws PrivilegedActionException, SQLException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<LuceneIndexDescriptor>(){

            @Override
            public LuceneIndexDescriptor run() throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SQLException {
                return LuceneSupport.getIndexDescriptorNoPrivs(string);
            }
        });
    }

    static LuceneIndexDescriptor getIndexDescriptorNoPrivs(String string) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SQLException {
        int n = string.lastIndexOf(".");
        String string2 = string.substring(0, n);
        ClassInspector classInspector = LuceneSupport.getClassFactory().getClassInspector();
        Class clazz = classInspector.getClass(string2);
        String string3 = string.substring(n + 1, string.length());
        Method method = clazz.getDeclaredMethod(string3, new Class[0]);
        return (LuceneIndexDescriptor)method.invoke(null, new Object[0]);
    }

    private static void createLuceneDir(final Connection connection) throws SQLException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws SQLException {
                    StorageFactory storageFactory = LuceneSupport.getStorageFactory(connection);
                    StorageFile storageFile = storageFactory.newStorageFile("LUCENE");
                    storageFile.mkdir();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (SQLException)privilegedActionException.getCause();
        }
    }

    static DerbyLuceneDir getDerbyLuceneDir(Connection connection, String string, String string2, String string3) throws SQLException {
        StorageFactory storageFactory = LuceneSupport.getStorageFactory(connection);
        DerbyLuceneDir derbyLuceneDir = DerbyLuceneDir.getDirectory(storageFactory, string, string2, string3);
        return derbyLuceneDir;
    }

    static StorageFactory getStorageFactory(Connection connection) throws SQLException {
        return LuceneSupport.getDataFactory(connection).getStorageFactory();
    }

    static DataFactory getDataFactory(Connection connection) throws SQLException {
        try {
            Object object = Monitor.findService((String)"org.apache.derby.database.Database", (String)((EmbedConnection)connection).getDBName());
            return (DataFactory)Monitor.findServiceModule((Object)object, (String)"org.apache.derby.iapi.store.raw.data.DataFactory");
        }
        catch (StandardException standardException) {
            throw LuceneSupport.wrap(standardException);
        }
    }

    static ClassFactory getClassFactory() throws SQLException {
        return ConnectionUtil.getCurrentLCC().getLanguageConnectionFactory().getClassFactory();
    }
}

