/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.providers;

import se.hirt.greychart.impl.SamplePoint;
import se.hirt.greychart.providers.AbstractSampler;

public class IntegratingSampleCountingBuffer
extends AbstractSampler {
    public IntegratingSampleCountingBuffer(int size) {
        super(size);
    }

    public void addDataPoint(double normalizedStartX, double normalizedEndX, double value) {
        if (normalizedStartX < 0.0 || normalizedStartX > 1.0) {
            throw new IllegalArgumentException("Must add a normalized value [0, 1]! Value was " + normalizedStartX);
        }
        if (normalizedEndX < 0.0 || normalizedEndX > 1.0) {
            throw new IllegalArgumentException("Must add a normalized value [0, 1]! Value was " + normalizedEndX);
        }
        this.addSamplePoint((double)this.getSize() * normalizedStartX, value);
        this.addSamplePoint(Math.max((double)this.getSize() * normalizedEndX, (double)this.getSize() * normalizedStartX + 1.0), -value);
    }

    private void addSamplePoint(double currentX, double currentY) {
        int currentIndex = this.getIndex(currentX);
        if (currentIndex >= 0 && currentIndex < this.getSize()) {
            SamplePoint point = this.getSamplePoint(currentIndex);
            ++point.count;
            point.y += currentY;
        }
    }

    public void fixSamples() {
        double currentY = 0.0;
        int n = 0;
        while (n < this.getSize()) {
            SamplePoint point = this.getSamplePoint(n);
            point.y += currentY;
            currentY = point.y;
            ++n;
        }
        if (this.getSize() > 0 && this.getSamples()[this.getSize() - 1] == null && currentY > 0.0) {
            this.getSamplePoint((int)(this.getSize() - 1)).y = currentY;
        }
        this.invalidateStatistics();
    }
}

