/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardData;
import com.bowman.cardserv.CardServProxy;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.interfaces.ProxyPlugin;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.cardserv.util.XmlStringBuffer;
import com.bowman.cardserv.web.StatusCommand;
import com.bowman.cardserv.web.XmlHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class EmmAnalyzerPlugin
implements ProxyPlugin {
    private Set profiles;
    private Set users;
    private StatusCommand statCmd;
    private Map capture = new HashMap();

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        String users;
        String profiles = xml.getStringValue("profiles", "");
        if ("".equals(profiles)) {
            profiles = null;
        }
        if ("".equals(users = xml.getStringValue("users", ""))) {
            users = null;
        }
        this.profiles = profiles != null ? new HashSet<String>(Arrays.asList(profiles.split(" "))) : Collections.EMPTY_SET;
        this.users = users != null ? new HashSet<String>(Arrays.asList(users.split(" "))) : Collections.EMPTY_SET;
    }

    public void start(CardServProxy proxy) {
        this.statCmd = new StatusCommand("emm-log", "Show emm stats", "Show gathered emm statistics for the specified user.", true);
        this.statCmd.addParam("name", "").setOptions("@known-users", false);
        this.statCmd.addParam("profile", "").setOptions("@profiles", false);
        this.statCmd.addParam("data", "").setOptions(Arrays.asList("true", "false"), false);
        try {
            this.statCmd.register((Object)this);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        if (this.statCmd != null) {
            this.statCmd.unregister();
            this.statCmd = null;
        }
    }

    public void runStatusCmdEmmLog(XmlStringBuffer xb, Map params) {
        String user = (String)params.get("name");
        String profile = (String)params.get("profile");
        boolean data = "true".equals(params.get("data"));
        EmmInfoAggregate info = this.getInfo(user, profile);
        if (info != null) {
            EmmAnalyzerPlugin.xmlFormatEmmInfo(xb, info, data);
        }
    }

    public static void xmlFormatEmmInfo(XmlStringBuffer xb, EmmInfoAggregate info, boolean includeData) {
        xb.appendElement("emm-info");
        xb.appendAttr("user-name", info.user);
        xb.appendAttr("profile", info.profile);
        if (info.lastCard != null) {
            xb.appendAttr("sent-carddata", info.lastCard.toString());
        }
        xb.appendAttr("total-count", info.receiveOrder.size());
        xb.appendAttr("unique-count", info.emms.size());
        if (info.lastInterval != -1L) {
            xb.appendAttr("last-interval", info.lastInterval);
        }
        if (info.shortestInterval != -1L) {
            xb.appendAttr("shortest-interval", info.shortestInterval);
        }
        if (info.longestInterval != -1L) {
            xb.appendAttr("longest-interval", info.longestInterval);
        }
        xb.endElement(false);
        if (info.mostFrequent != null) {
            EmmAnalyzerPlugin.xmlFormatEmmRecord("most-frequent", xb, info.mostFrequent, includeData);
        }
        if (info.leastFrequent != null) {
            EmmAnalyzerPlugin.xmlFormatEmmRecord("least-frequent", xb, info.leastFrequent, includeData);
        }
        xb.appendElement("all-emms");
        Iterator iter = info.emms.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            EmmRecord er = (EmmRecord)info.emms.get(key);
            EmmAnalyzerPlugin.xmlFormatEmmRecord("emm-record", xb, er, includeData);
        }
        xb.closeElement("all-emms");
        xb.closeElement("emm-info");
    }

    public static void xmlFormatEmmRecord(String name, XmlStringBuffer xb, EmmRecord er, boolean includeData) {
        xb.appendElement(name);
        xb.appendAttr("hash", er.emm.hashCodeStr());
        xb.appendAttr("count", er.count());
        xb.appendAttr("size", er.emm.getDataLength());
        if (includeData) {
            xb.appendAttr("data", DESUtil.bytesToString((byte[])er.emm.getCustomData()));
        }
        xb.endElement(false);
        xb.appendElement("seen-log");
        EmmAnalyzerPlugin.xmlFormatEmmRecordSeenLog(xb, er);
        xb.closeElement("seen-log");
        xb.closeElement(name);
    }

    public static void xmlFormatEmmRecordSeenLog(XmlStringBuffer xb, EmmRecord er) {
        if (er.linked != null) {
            EmmAnalyzerPlugin.xmlFormatEmmRecordSeenLog(xb, er.linked);
        }
        xb.appendElement("sighting");
        xb.appendAttr("timestamp", XmlHelper.formatTimeStamp((long)er.emm.getTimeStamp()));
        xb.appendAttr("client-sid", Integer.toHexString(er.sid));
        xb.appendAttr("index", er.index);
        if (er.repeatInterval != -1L) {
            xb.appendAttr("repeat-interval", XmlHelper.formatDuration((long)(er.repeatInterval / 1000L)));
        }
        xb.endElement(true);
    }

    public String getName() {
        return "EmmAnalyzerPlugin";
    }

    public String getDescription() {
        return "Gathers information about emm's received from clients.";
    }

    public Properties getProperties() {
        return null;
    }

    public CamdNetMessage doFilter(ProxySession session, CamdNetMessage msg) {
        try {
            if (msg.getCommandTag() == 228) {
                CardData newData = new CardData(msg.getCustomData());
                EmmInfoAggregate info = this.getInfo(session.getUser(), session.getProfileName());
                info.lastCard = newData;
            }
            if (msg.isEcm() && msg.getType() == -2 && msg.getServiceId() != 0) {
                this.getInfo((String)session.getUser(), (String)session.getProfileName()).currentSid = msg.getServiceId();
            }
            if (msg.isEmm() && !msg.isEmpty() && msg.getType() == -2) {
                this.processEmm(session, msg);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return msg;
    }

    private void processEmm(ProxySession session, CamdNetMessage emm) {
        if (!this.users.isEmpty() && !this.users.contains(session.getUser())) {
            return;
        }
        if (!this.profiles.isEmpty() && !this.profiles.contains(session.getProfileName())) {
            return;
        }
        EmmInfoAggregate info = this.getInfo(session.getUser(), session.getProfileName());
        info.addEmm(new CamdNetMessage(emm));
    }

    private EmmInfoAggregate getInfo(String user, String profile) {
        String key = user + ":" + profile;
        EmmInfoAggregate info = (EmmInfoAggregate)this.capture.get(key);
        if (info == null) {
            info = new EmmInfoAggregate(user, profile);
            this.capture.put(key, info);
        }
        return info;
    }

    public byte[] getResource(String path, boolean admin) {
        return null;
    }

    public byte[] getResource(String path, byte[] inData, boolean admin) {
        return null;
    }

    static class EmmRecord {
        CamdNetMessage emm;
        EmmRecord linked;
        CardData card;
        int index;
        int sid;
        long repeatInterval = -1L;

        public EmmRecord(CamdNetMessage emm, int index, int sid, CardData card) {
            this.emm = emm;
            this.index = index;
            this.sid = sid;
            this.card = card;
        }

        void link(EmmRecord er) {
            this.repeatInterval = this.emm.getTimeStamp() - er.emm.getTimeStamp();
            this.linked = er;
        }

        int count() {
            if (this.linked == null) {
                return 1;
            }
            return 1 + this.linked.count();
        }
    }

    static class EmmInfoAggregate {
        String user;
        String profile;
        int currentSid;
        long lastInterval = -1L;
        long shortestInterval = -1L;
        long longestInterval = -1L;
        EmmRecord mostFrequent;
        EmmRecord leastFrequent;
        CardData lastCard;
        Map emms = new LinkedHashMap();
        List receiveOrder = new ArrayList();

        EmmInfoAggregate(String user, String profile) {
            this.user = user;
            this.profile = profile;
        }

        void addEmm(CamdNetMessage emm) {
            if (!this.receiveOrder.isEmpty()) {
                EmmRecord prev = (EmmRecord)this.emms.get(this.receiveOrder.get(this.receiveOrder.size() - 1));
                this.lastInterval = emm.getTimeStamp() - prev.emm.getTimeStamp();
                if (this.shortestInterval == -1L || this.lastInterval < this.shortestInterval) {
                    this.shortestInterval = this.lastInterval;
                }
                if (this.longestInterval == -1L || this.lastInterval > this.longestInterval) {
                    this.longestInterval = this.lastInterval;
                }
            }
            this.receiveOrder.add(emm.hashCodeStr());
            int index = this.receiveOrder.size();
            EmmRecord nr = new EmmRecord(emm, index, this.currentSid, this.lastCard);
            EmmRecord or = this.emms.put(emm.hashCodeStr(), nr);
            if (or != null) {
                nr.link(or);
                if (this.mostFrequent == null || this.mostFrequent.repeatInterval < nr.repeatInterval) {
                    this.mostFrequent = nr;
                }
                if (this.leastFrequent == null || this.leastFrequent.repeatInterval > nr.repeatInterval) {
                    this.leastFrequent = nr;
                }
            }
        }
    }
}

