/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.cws;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardData;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.cws.CspCwsConnector;
import com.bowman.cardserv.cws.CwsConnectorManager;
import com.bowman.cardserv.cws.QueueEntry;
import com.bowman.cardserv.interfaces.CacheHandler;
import com.bowman.cardserv.interfaces.CwsConnector;
import com.bowman.cardserv.interfaces.MultiCwsConnector;
import com.bowman.cardserv.interfaces.ProxyPlugin;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.interfaces.ReplyFilter;
import com.bowman.cardserv.util.CustomFormatter;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.cardserv.util.TimedAverageList;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class AbstractCwsConnector
implements Comparable,
Runnable,
CwsConnector {
    private static final int RAMPUP_ECM_TIME = 400;
    protected static final int LOGIN_SO_TIMEOUT = 30000;
    protected static final int SESSION_SO_TIMEOUT = 0;
    protected static final int CONNECT_TIMEOUT = 10000;
    protected static final int MIN_PROBE_INTERVAL = 3000;
    protected String name;
    protected String host;
    protected int port;
    protected int qosClass;
    protected int timeoutCount;
    protected int minDelay;
    private int metric;
    private int maxQueue;
    private int ecmCount;
    private int successEcmCount;
    private int totalFailures;
    protected boolean enabled;
    protected boolean noProfile;
    protected boolean asynchronous = false;
    protected boolean replyPlugins = true;
    protected long connectTimeStamp;
    protected long lastEcmTimeStamp;
    protected long lastDisconnectTimeStamp;
    private long totalTime;
    private long lastReadTimeStamp;
    private long lastAttemptTimeStamp;
    protected Thread readerThread;
    private Thread timeoutThread;
    private CacheHandler cacheHandler;
    private TimedAverageList avgList = new TimedAverageList(60);
    private TimedAverageList sidList = new TimedAverageList(60);
    protected Set auUsers = new HashSet();
    protected Set providerIdents;
    protected CaProfile profile;
    protected ProxyLogger logger;
    protected ProxyConfig config;
    protected CwsConnectorManager connManager;
    private List sendQueue = Collections.synchronizedList(new ArrayList());
    private List blackList = Collections.synchronizedList(new ArrayList());
    private List replyQueue = new ArrayList();
    private Map sentMap = Collections.synchronizedMap(new LinkedHashMap());
    private Set sentSet = Collections.synchronizedSet(new HashSet());
    protected Set predefinedProviders = new HashSet();
    protected QueueEntry lastSent;
    protected boolean connecting;
    protected boolean alive;

    public AbstractCwsConnector() {
        this.lastEcmTimeStamp = System.currentTimeMillis();
    }

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        this.config = ProxyConfig.getInstance();
        this.name = xml.getStringValue("name");
        this.metric = xml.getIntValue("metric", 1);
        this.maxQueue = xml.getIntValue("max-queue", this.config.getDefaultConnectorMaxQueue());
        this.minDelay = xml.getTimeValue("min-delay", this.config.getDefaultConnectorMinDelay(), "ms");
        try {
            String qosClassStr = xml.getStringValue("qos-class");
            this.qosClass = "none".equalsIgnoreCase(qosClassStr) || qosClassStr.length() == 0 ? -1 : xml.getIntValue("qos-class");
        }
        catch (ConfigException e) {
            this.qosClass = 16;
        }
        String profileName = null;
        try {
            profileName = xml.getStringValue("profile");
            this.profile = this.config.getProfile(profileName);
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        if (profileName != null && this instanceof MultiCwsConnector) {
            throw new ConfigException(xml.getFullName(), "profile", "Illegal to have profile specified for connector type: " + this.getProtocol());
        }
        if (profileName != null && this.profile == null && "true".equalsIgnoreCase(xml.getStringValue("enabled", "true"))) {
            if (!this.config.isProfileDisabled(profileName)) {
                throw new ConfigException(xml.getFullName(), "profile", "Unknown profile for '" + this.name + "': " + profileName);
            }
            if (this.logger != null) {
                this.logger.warning("Profile '" + profileName + "' disabled, disabling connector as well.");
            }
            xml.setStringOverride("enabled", "false");
        }
        if ("true".equalsIgnoreCase(xml.getStringValue("enabled", "true"))) {
            this.providersUpdated(xml);
        } else {
            this.predefinedProviders.clear();
        }
        this.noProfile = profileName == null;
        this.replyPlugins = true;
        this.logger = ProxyLogger.getLabeledLogger(this.getClass().getName(), this.getLabel());
    }

    public void providersUpdated(ProxyXmlConfig xml) throws ConfigException {
        this.predefinedProviders.clear();
        String[] providerIdents = xml.getStringValue("provider-idents", "").split(",");
        for (int i = 0; i < providerIdents.length; ++i) {
            providerIdents[i] = providerIdents[i].trim();
            try {
                if (providerIdents[i].length() <= 0) continue;
                this.predefinedProviders.add(new Integer(DESUtil.byteStringToInt(providerIdents[i])));
                continue;
            }
            catch (NumberFormatException e) {
                throw new ConfigException(xml.getFullName(), "provider-idents", "Bad provider value: " + e.getMessage());
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public int getMetric() {
        return this.metric;
    }

    public void setMetric(int metric) {
        this.metric = metric;
    }

    public String getUser() {
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled && this.connManager != null) {
            CwsConnectorManager cwsConnectorManager = this.connManager;
            synchronized (cwsConnectorManager) {
                this.connManager.notifyAll();
            }
        }
    }

    public long getConnectTimeStamp() {
        return this.connectTimeStamp;
    }

    public int getTimeoutCount() {
        return this.timeoutCount;
    }

    public int getEcmCount(boolean total) {
        if (total) {
            return this.ecmCount;
        }
        if (this.successEcmCount == 0) {
            return 0;
        }
        return this.avgList.size(this.connManager.getMaxCwWait(this.profile));
    }

    public int[] getRecentSids() {
        if (this.successEcmCount == 0) {
            return new int[0];
        }
        Set sids = this.sidList.getCurrentSet(this.connManager.getMaxCwWait(this.profile) + (long)this.getAverageEcmTime());
        int[] result = new int[sids.size()];
        int i = 0;
        Iterator iter = sids.iterator();
        while (iter.hasNext()) {
            result[i++] = (Integer)iter.next();
        }
        return result;
    }

    public int getEmmCount() {
        return 0;
    }

    public int getKeepAliveCount() {
        return 0;
    }

    public int getKeepAliveInterval() {
        return -1;
    }

    public int getTotalFailures() {
        return this.totalFailures;
    }

    public CaProfile getProfile() {
        return this.profile;
    }

    public String getProfileName() {
        if (this.profile == null) {
            return "?";
        }
        return this.profile.getName();
    }

    public int getCurrentEcmTime() {
        if (this.successEcmCount == 0) {
            return -1;
        }
        return this.avgList.getAverage(false);
    }

    public int getCapacity() {
        int time = this.getAverageEcmTime();
        if (time == -1 || !this.isConnected()) {
            return -1;
        }
        int lowest = this.avgList.getLowest();
        if (lowest < time) {
            time = lowest;
        }
        if (time == 0) {
            time = 1;
        }
        return (int)(this.connManager.getMaxCwWait(this.profile) / (long)time);
    }

    public int getAverageEcmTime() {
        if (this.successEcmCount == 0) {
            return -1;
        }
        return (int)(this.totalTime / (long)this.successEcmCount);
    }

    public int getUtilization(boolean average) {
        double totalEcmTime;
        double duration;
        if (this.successEcmCount == 0) {
            return 0;
        }
        double d = duration = average ? (double)(System.currentTimeMillis() - this.connectTimeStamp) : (double)this.avgList.getMaxAge();
        if (!this.asynchronous) {
            totalEcmTime = average ? (double)(this.successEcmCount * this.getAverageEcmTime()) : (double)this.avgList.getTotal(true);
        } else {
            double d2 = totalEcmTime = average ? (double)(this.successEcmCount * this.getAverageEcmTime()) : (double)(this.avgList.size(true) * this.avgList.getLowest());
        }
        if (totalEcmTime <= 0.0) {
            return 0;
        }
        double percent = totalEcmTime / duration;
        return (int)(percent * 100.0);
    }

    public int getEstimatedQueueTime() {
        if (this.successEcmCount == 0) {
            return 400;
        }
        return (this.getQueueSize() + 1) * this.getCurrentEcmTime();
    }

    public synchronized boolean connect(CwsConnectorManager manager) throws IOException {
        if (!this.enabled || this.isConnected()) {
            return false;
        }
        if (this.connManager != null) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        this.lastAttemptTimeStamp = System.currentTimeMillis();
        try {
            if (this.host != null) {
                this.logger.info("Connecting to " + CustomFormatter.formatAddress(this.host) + ":" + this.port + " ...");
            }
            this.connManager = manager;
            this.cacheHandler = ProxyConfig.getInstance().getCacheHandler();
            this.reset();
            this.connecting = true;
            this.connectNative();
            this.timeoutCount = 0;
            this.ecmCount = 0;
            this.successEcmCount = 0;
            this.totalTime = 0L;
            this.avgList.clear();
            this.readerThread = new Thread((Runnable)this, this.getProtocol() + "CwsConnectorReaderThread-" + this.name);
            this.readerThread.start();
            this.timeoutThread = new Thread("CwsConnectorDispatcherThread-" + this.name){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (Thread.currentThread() == AbstractCwsConnector.this.timeoutThread) {
                        try {
                            AbstractCwsConnector.this.checkSentMap(AbstractCwsConnector.this.getMaxWait());
                            AbstractCwsConnector.this.sendReplies();
                            List list = AbstractCwsConnector.this.replyQueue;
                            synchronized (list) {
                                try {
                                    AbstractCwsConnector.this.replyQueue.wait(50L);
                                }
                                catch (InterruptedException e) {
                                    return;
                                }
                            }
                        }
                        catch (Exception e) {
                            AbstractCwsConnector.this.logger.severe("Uncaught exception in CwsConnectorDispatcherThread loop: " + e, e);
                            e.printStackTrace();
                        }
                    }
                }
            };
            this.timeoutThread.start();
            return true;
        }
        catch (IOException e) {
            this.connecting = false;
            this.connManager.cwsConnectionFailed(this, e.toString());
            throw e;
        }
    }

    protected abstract void connectNative() throws IOException;

    public boolean isAuAllowed(String userName) {
        return false;
    }

    public String[] getAuUsers() {
        return new String[0];
    }

    public String getLabel() {
        return this.getProtocol() + "Cws[" + this.name + ":" + this.getProfileName() + "]";
    }

    protected synchronized QueueEntry getSentEntry(int sequenceNr) {
        return (QueueEntry)this.sentMap.remove(new Integer(sequenceNr));
    }

    protected void reportChannelStatus(QueueEntry qe) {
        boolean success;
        ProxySession session = qe.getTargetSession();
        boolean bl = success = !qe.getReply().isEmpty();
        if (session != null) {
            if (this.config.getUserManager().isMapExcluded(session.getUser())) {
                return;
            }
        } else if (this instanceof CspCwsConnector) {
            if (success) {
                this.logger.fine("Changed out-come for csp-connector probe to cannot-decode");
            }
            success = false;
        }
        this.connManager.reportChannelStatus(this, qe.getRequest(), success, session);
    }

    protected CamdNetMessage applyFilters(CamdNetMessage msg) {
        int count = 0;
        Iterator iter = this.config.getProxyPlugins().values().iterator();
        while (iter.hasNext()) {
            ProxyPlugin plugin = (ProxyPlugin)iter.next();
            try {
                if (plugin instanceof ReplyFilter) {
                    msg = ((ReplyFilter)((Object)plugin)).doReplyFilter(this, msg);
                    ++count;
                }
                if (msg != null) continue;
                break;
            }
            catch (Throwable t) {
                this.logger.severe("Exception in plugin filtering: " + t, t);
            }
        }
        if (count == 0) {
            this.replyPlugins = false;
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reportReply(CamdNetMessage reply) {
        List list;
        reply.setConnectorName(this.getName());
        if (this.timeoutCount > 0) {
            this.logger.info("Message received, cancelling timeout-state");
            this.timeoutCount = 0;
        }
        this.lastEcmTimeStamp = reply.getTimeStamp();
        this.lastReadTimeStamp = reply.getTimeStamp();
        QueueEntry qe = this.getSentEntry(reply.getSequenceNr());
        if (qe == null) {
            if (reply.isKeepAlive()) {
                return false;
            }
            if (this.sentMap.size() >= 1) {
                Integer i = (Integer)this.sentMap.keySet().iterator().next();
                qe = (QueueEntry)this.sentMap.get(i);
                if (qe.getRequest().getServiceId() != reply.getServiceId()) {
                    qe = null;
                } else {
                    this.sentMap.remove(i);
                    this.logger.warning("Bad sequence nr in reply? Expected [" + i + "] Got [" + reply.getSequenceNr() + "]");
                }
            }
        }
        if (qe == null) {
            this.logger.warning("No request found for reply: " + reply.getSequenceNr() + " (" + reply.getCommandName() + ", " + this.config.getService(reply) + ") pending are: " + this.sentMap.keySet());
            return false;
        }
        qe.setReply(reply);
        if (this.replyPlugins && (reply = this.applyFilters(reply)) == null) {
            this.sentMap.put(new Integer(reply.getSequenceNr()), qe);
            this.blackListRequest(qe.getRequest());
            return true;
        }
        if (reply.getServiceId() != 0) {
            this.sidList.addRecord(reply.getServiceId());
            if (qe.getRequest().getServiceId() != 0) {
                if (this.connManager.isLogSidMismatch() && reply.getServiceId() != qe.getRequest().getServiceId()) {
                    this.logger.warning("Service id in reply [" + reply.getSequenceNr() + "] does not match that of the request: " + this.config.getService(reply) + " vs " + this.config.getService(qe.getRequest()));
                }
            } else {
                this.logger.fine("Request [" + reply.getSequenceNr() + "] had service id 0, but reply had: " + reply.getServiceId());
            }
        } else {
            this.logger.fine("Reply [" + reply.getSequenceNr() + "] had service id 0.");
        }
        if (!qe.isKeepAlive()) {
            this.reportChannelStatus(qe);
            if (qe.isSuccessful(this.connManager.getMaxCwWait(this.profile))) {
                this.avgList.addRecord((int)qe.getDuration());
                this.totalTime += qe.getDuration();
                ++this.successEcmCount;
            }
            ++this.ecmCount;
            this.logger.fine("\t" + qe);
            if (reply.isEmpty()) {
                this.blackListRequest(qe.getRequest());
            }
            if (qe.isProbe()) {
                if (!reply.isEmpty()) {
                    this.cacheHandler.processReply(qe.getRequest(), reply);
                }
            } else {
                CamdNetMessage cachedReply;
                this.cacheHandler.processReply(qe.getRequest(), reply);
                if (reply.isEmpty() && (cachedReply = this.cacheHandler.peekReply(qe.getRequest())) != null) {
                    reply = cachedReply;
                    qe.getTargetSession().setFlag(qe.getRequest(), 'X');
                }
                list = this.replyQueue;
                synchronized (list) {
                    qe.reply = reply;
                    this.replyQueue.add(qe);
                }
            }
        }
        list = this.replyQueue;
        synchronized (list) {
            this.replyQueue.notifyAll();
        }
        return true;
    }

    protected void blackListRequest(CamdNetMessage msg) {
        this.blackList.add(msg);
        this.logger.fine("Blacklisting failed request: " + msg + " (list size: " + this.blackList.size() + ")");
        if (!this.blackList.isEmpty()) {
            CamdNetMessage oldest = (CamdNetMessage)this.blackList.get(0);
            if (System.currentTimeMillis() - oldest.getTimeStamp() > this.getMaxWait() * 3L) {
                this.blackList.remove(oldest);
            }
        }
    }

    public boolean isBlackListed(CamdNetMessage request) {
        return this.blackList.contains(request);
    }

    public boolean canDecode(CamdNetMessage request) {
        if (request.getProviderIdent() != -1 && this.profile.isRequireProviderMatch()) {
            return this.getProviderIdents().contains(new Integer(request.getProviderIdent()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendReplies() {
        List list = this.replyQueue;
        synchronized (list) {
            Iterator iter = this.replyQueue.iterator();
            while (iter.hasNext()) {
                QueueEntry qe = (QueueEntry)iter.next();
                iter.remove();
                try {
                    this.sentSet.remove(qe.getRequest());
                    qe.sendReply();
                }
                catch (Exception e) {
                    this.logger.severe("Uncaught exception in session sendEcmReply: " + e, e);
                }
            }
        }
    }

    public void reset() {
        this.logger.fine("Connector reset, " + this.getQueueSize() + " requests affected (" + this.sentMap.size() + " sent, " + this.sendQueue.size() + " unsent).");
        this.timeoutCount = 0;
        if (!this.sentMap.isEmpty()) {
            this.checkSentMap(-1L);
        }
        this.lastSent = null;
        this.sendQueue.clear();
        this.blackList.clear();
    }

    protected boolean isNext() {
        return this.sendQueue.size() == 0 || ((QueueEntry)this.sendQueue.get(0)).isMe(Thread.currentThread());
    }

    protected synchronized boolean waitForPending() {
        if (this.sendQueue.isEmpty()) {
            return true;
        }
        long maxWait = this.getMaxWait();
        long start = System.currentTimeMillis();
        while (this.sentMap.size() > 0 || !this.isNext()) {
            try {
                this.wait(500L);
                if (!this.isConnected()) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                return false;
            }
            if (System.currentTimeMillis() - start <= maxWait) continue;
            this.checkSentMap(maxWait);
            return false;
        }
        return true;
    }

    public boolean isPending(CamdNetMessage request) {
        return this.sentMap.values().contains(request) || this.sendQueue.contains(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpQueue() {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            Iterator<Object> iter;
            System.out.println("\n\n---- sendQueue (awaiting send) ----");
            try {
                iter = this.sendQueue.iterator();
                while (iter.hasNext()) {
                    System.out.println(iter.next());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            System.out.println("\n---- sentMap (already sent, awaiting reply ----");
            try {
                iter = this.sentMap.keySet().iterator();
                while (iter.hasNext()) {
                    System.out.println(this.sentMap.get(iter.next()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendEcmRequest(CamdNetMessage request, ProxySession listener) {
        int seqNr;
        if (!this.isConnected()) {
            return false;
        }
        QueueEntry qe = new QueueEntry(request, listener, Thread.currentThread());
        this.lastEcmTimeStamp = qe.getTimeStamp();
        if (this.sentSet.contains(request) || this.sendQueue.contains(qe)) {
            throw new IllegalStateException(this.getLabel());
        }
        request.setConnectorName(this.getName());
        if (this.getQueueSize() > this.maxQueue) {
            this.logger.severe("Max queue size exceeded, closing...");
            this.dumpQueue();
            this.close();
            return false;
        }
        this.sendQueue.add(qe);
        AbstractCwsConnector abstractCwsConnector = this;
        synchronized (abstractCwsConnector) {
            if (!this.isConnected()) {
                return false;
            }
            CamdNetMessage req = new CamdNetMessage(request);
            if (this.connManager.getUnknownSid(req.getProfileName()) != -1 && this.connManager.isServiceUnknown(req.getProfileName(), req.getServiceId())) {
                req.setServiceId(this.connManager.getUnknownSid(req.getProfileName()));
            }
            if ((seqNr = this.sendMessage(req)) != -1) {
                if (this.sentMap.put(new Integer(seqNr), qe) != null) {
                    this.logger.severe("Overwrote existing pending seqNr: " + seqNr);
                }
                this.sentSet.add(request);
                this.lastSent = qe;
            }
            if (this.asynchronous && this.minDelay > 0) {
                try {
                    Thread.sleep(this.minDelay);
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
        }
        this.sendQueue.remove(qe);
        if (seqNr != -1) {
            long queueTime = qe.setSent();
            if (listener != null && queueTime > this.connManager.getMaxCwWait(this.profile) / 2L) {
                listener.setFlag(request, 'G');
            }
            return true;
        }
        return false;
    }

    protected void checkSentMap(long maxAge) {
        boolean timeout = false;
        int timeoutRequests = 0;
        String timeoutService = null;
        Iterator iter = new ArrayList(this.sentMap.keySet()).iterator();
        while (iter.hasNext()) {
            QueueEntry qe;
            Integer key = (Integer)iter.next();
            if (key == null || (qe = (QueueEntry)this.sentMap.get(key)) == null) continue;
            if (qe.getDuration() > maxAge) {
                timeout = maxAge != -1L;
                this.failRequest(qe, timeout);
                this.sentMap.remove(key);
                this.sentSet.remove(qe.getRequest());
                if (timeout) {
                    ++timeoutRequests;
                    timeoutService = qe.getRequest().getProfileName() + ":" + Integer.toHexString(qe.getRequest().getServiceId());
                }
            }
            this.peekCache(qe);
        }
        if (maxAge == -1L) {
            this.sentMap.clear();
            this.sentSet.clear();
        } else {
            if (timeout) {
                if (System.currentTimeMillis() - this.lastReadTimeStamp > this.connManager.getMaxCwWait(this.profile)) {
                    ++this.timeoutCount;
                }
                this.connManager.cwsEcmTimeout(this, "ECM timeout for [" + (timeoutRequests == 1 && timeoutService != null ? timeoutService : timeoutRequests + " queued requests") + "]: " + this.timeoutCount, this.timeoutCount);
            }
            if ((long)this.timeoutCount >= this.connManager.getTimeoutThreshold()) {
                this.logger.warning("Too many failures, closing connection...");
                this.close();
            }
        }
    }

    protected void peekCache(QueueEntry qe) {
        CamdNetMessage reply;
        if (qe.reply == null && (reply = this.cacheHandler.peekReply(qe.getRequest())) != null) {
            qe.reply = reply;
            qe.setFlag(reply.getOriginAddress() == null ? (char)'C' : 'R');
            this.replyQueue.add(qe);
        }
    }

    protected void failRequest(QueueEntry qe, boolean timeout) {
        ++this.totalFailures;
        if (!timeout) {
            if (qe.getDuration() < this.connManager.getMaxCwWait(this.profile) / 2L) {
                this.logger.info("CWS send aborted, but there's still time left for: " + qe);
            }
            qe.timeOut(this, 'A');
        } else {
            if (!qe.isProbe()) {
                this.logger.warning("Timeout waiting for ecm reply, discarding request and returning empty (" + (this.timeoutCount + 1) + " failures) - " + qe);
            }
            qe.timeOut(this, 'T');
        }
        if (this.cacheHandler != null) {
            this.cacheHandler.processReply(qe.getRequest(), null);
        }
    }

    public void sendKeepAlive() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CwsConnector that = (CwsConnector)o;
        return this.enabled == that.isEnabled() && this.name.equals(that.getName());
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 29 * result + (this.enabled ? 1 : 0);
        return result;
    }

    public int compareTo(Object o) {
        CwsConnector c = (CwsConnector)o;
        int a = this.getQueueSize();
        int b = c.getQueueSize();
        if (a == 0 && b == 0) {
            return new Long(c.getLastEcmTimeStamp()).compareTo(new Long(this.lastEcmTimeStamp));
        }
        a = this.getCurrentEcmTime() * a;
        b = c.getCurrentEcmTime() * b;
        if (a < 0 || b < 0) {
            return new Long(c.getLastEcmTimeStamp()).compareTo(new Long(this.lastEcmTimeStamp));
        }
        return new Integer(b).compareTo(new Integer(a));
    }

    protected long getMaxWait() {
        return this.connManager.getMaxCwWait(this.profile) - (long)Math.max(500, this.getAverageEcmTime());
    }

    public long getLastEcmTimeStamp() {
        return this.lastEcmTimeStamp;
    }

    public long getLastAttemptTimeStamp() {
        return this.lastAttemptTimeStamp;
    }

    public long getLastDisconnectTimeStamp() {
        return this.lastDisconnectTimeStamp;
    }

    public void close() {
        this.connectTimeStamp = -1L;
        this.timeoutCount = 0;
        if (this.readerThread != null) {
            this.readerThread.interrupt();
            this.readerThread = null;
        }
        if (this.timeoutThread != null) {
            this.timeoutThread.interrupt();
            this.timeoutThread = null;
        }
        this.alive = false;
        this.providerIdents = null;
        this.reset();
    }

    public int getQueueSize() {
        int qSize = this.sentMap.size();
        return qSize += this.sendQueue.size();
    }

    public String toString() {
        return this.getLabel() + (this.enabled ? "" : " (disabled)");
    }

    public boolean isConnected() {
        return this.readerThread != null;
    }

    public Properties getRemoteInfo() {
        return null;
    }

    public Set getProviderIdents() {
        if (!this.predefinedProviders.isEmpty()) {
            return this.predefinedProviders;
        }
        if (this.providerIdents == null) {
            CardData card = this.getRemoteCard();
            if (card == null) {
                return Collections.EMPTY_SET;
            }
            return new HashSet<Integer>(Arrays.asList(card.getProvidersAsInt()));
        }
        return this.providerIdents;
    }
}

