/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.test;

import com.bowman.cardserv.rmi.CwsStatus;
import com.bowman.cardserv.rmi.RemoteEvent;
import com.bowman.cardserv.rmi.RemoteListener;
import com.bowman.cardserv.rmi.RemoteProxy;
import com.bowman.cardserv.rmi.SessionStatus;
import com.bowman.cardserv.rmi.UserStatus;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class RemoteTestClient
extends UnicastRemoteObject
implements RemoteListener {
    private static final String[] CWS_STATES = new String[]{"disconnected", "connected", "connecting", "", "unresponsive", "disabled"};
    private static final SimpleDateFormat fmt = new SimpleDateFormat("yyMMdd HH:mm:ss");
    private String registryUrl;

    public RemoteTestClient(int port, String registryUrl) throws RemoteException {
        super(port);
        this.registryUrl = registryUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws IOException, NotBoundException {
        System.setSecurityManager(new RMISecurityManager());
        RemoteProxy proxy = (RemoteProxy)Naming.lookup(this.registryUrl);
        proxy.addRemoteListener(this);
        System.out.println("connected to: " + this.registryUrl);
        System.out.println("proxy name: " + proxy.getName());
        System.out.println("started: " + fmt.format(new Date(proxy.getProxyStartTime())));
        System.out.println("defined users: " + Arrays.asList(proxy.getLocalUsers()));
        System.out.println("connected user count: " + proxy.getSessionCount(null, false));
        System.out.println();
        System.out.println("active users:");
        UserStatus[] us = proxy.getUsersStatus(null, true);
        for (int i = 0; i < us.length; ++i) {
            SessionStatus[] sessions = us[i].getSessions();
            for (int n = 0; n < sessions.length; ++n) {
                System.out.println("  " + (n + 1) + ": " + sessions[n].getRemoteHost() + " watching: " + sessions[n].getCurrentService());
                System.out.println("    ecms: " + sessions[n].getEcmCount() + " emms: " + sessions[n].getEmmCount() + " avgInterval: " + sessions[n].getAvgEcmInterval());
            }
        }
        System.out.println();
        System.out.println("defined card count: " + proxy.getCwsCount(null));
        CwsStatus[] cs = proxy.getMultiCwsStatus(null);
        for (int i = 0; i < cs.length; ++i) {
            System.out.println(RemoteTestClient.formatCwsStatus(cs[i]));
        }
        System.out.println();
        System.out.println("printing events...");
        RemoteTestClient remoteTestClient = this;
        synchronized (remoteTestClient) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static String formatCwsStatus(CwsStatus cws) {
        String state = CWS_STATES[cws.getStatus()];
        String host = cws.getRemoteHost();
        if (host == null) {
            host = "unknown";
        }
        String status = state;
        if (cws.getStatus() == 1 || cws.getStatus() == 4) {
            status = status + " (up since: " + fmt.format(new Date(cws.getConnectTimeStamp()));
            status = status + ", avg processing time: " + cws.getCurrentEcmTime() + " ms)";
        }
        return "CWS[" + cws.getName() + "] remote host: " + host + " status: " + status;
    }

    public void eventRaised(RemoteEvent event) throws RemoteException {
        switch (event.getType()) {
            case 2: {
                System.out.println("Successfully connected to: " + event.getLabel());
                break;
            }
            case 3: {
                System.out.println("Connection lost with: " + event.getLabel());
                break;
            }
            case 4: {
                System.out.println("Connection attempt failed: " + event.getLabel() + " (" + event.getMessage() + ")");
                break;
            }
            case 5: {
                System.out.println("CWS Timeout warning: " + event.getLabel() + " (" + event.getMessage() + ")");
                break;
            }
            case 1: {
                System.out.println(event.getLabel() + " zapped to: " + event.getMessage());
                break;
            }
            case 6: {
                System.out.println(event.getLabel() + " lost service: " + event.getMessage());
                break;
            }
            case 7: {
                System.out.println(event.getLabel() + " finished ecm transaction: " + event.getProperty("flags"));
                break;
            }
            default: {
                System.out.println("Unknown remote event received: " + event.getType() + " " + event.getLabel() + " " + event.getMessage());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String url = "rmi://localhost:4099/cardservproxy";
        int port = 4100;
        if (args.length > 0) {
            url = args[0];
        }
        if (args.length > 1) {
            port = Integer.parseInt(args[1]);
        }
        new RemoteTestClient(port, url).test();
    }

    static {
        System.setProperty("java.security.policy", "etc/policy.all");
    }
}

