/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.irc;

import com.bowman.util.Globber;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class IrcHostMask
implements Serializable {
    static final long serialVersionUID = -8663482179955299154L;
    public static final String NICKIDENT_SEPARATOR = "!";
    public static final String IDENTHOST_SEPARATOR = "@";
    public static final String NOIDENT_MARKER = "~";
    public static final String MASK_TEMPLATE = "*!*@*.*";
    private String hostMask;
    private String hostMaskNoNick;

    public IrcHostMask(String hostMask) throws IllegalArgumentException {
        this(hostMask, false);
    }

    public IrcHostMask(String hostMask, boolean restrictionsApply) throws IllegalArgumentException {
        if (!this.globMatch(MASK_TEMPLATE, hostMask)) {
            throw new IllegalArgumentException("Mask does not match required template: *!*@*.*");
        }
        this.hostMask = hostMask;
        this.hostMaskNoNick = hostMask.substring(hostMask.indexOf(NICKIDENT_SEPARATOR) + 1);
    }

    public boolean matchesIrcSource(String ircSource, boolean disregardNick) {
        int tilde = ircSource.indexOf(NOIDENT_MARKER);
        if (tilde > 0 && ircSource.charAt(tilde - 1) == '!') {
            ircSource = new StringBuffer(ircSource).replace(tilde, tilde + 1, "").toString();
        }
        if (disregardNick) {
            return this.globMatch(this.hostMaskNoNick, ircSource.substring(ircSource.indexOf(NICKIDENT_SEPARATOR) + 1));
        }
        return this.globMatch(this.hostMask, ircSource);
    }

    public boolean matchesIrcSource(String ircSource) {
        return this.matchesIrcSource(ircSource, false);
    }

    public List getMatchingHosts(Set hosts) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator iter = hosts.iterator();
        String host = null;
        while (iter.hasNext()) {
            host = (String)iter.next();
            if (!this.matchesIrcSource(host)) continue;
            list.add(host);
        }
        return list;
    }

    private boolean globMatch(String mask, String name) {
        return Globber.match(mask, name, false);
    }

    public String toString() {
        return this.hostMask;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IrcHostMask)) {
            return false;
        }
        IrcHostMask mask = (IrcHostMask)o;
        return mask.hostMask.equalsIgnoreCase(this.hostMask);
    }

    public int hashCode() {
        return this.hostMask.hashCode();
    }

    public static IrcHostMask findFirstMatchingMask(String ircSource, Set masks) {
        Iterator iter = masks.iterator();
        IrcHostMask mask = null;
        while (iter.hasNext()) {
            mask = (IrcHostMask)iter.next();
            if (!mask.matchesIrcSource(ircSource)) continue;
            return mask;
        }
        return null;
    }

    public static List findAllMatchingMasks(String ircSource, Set masks) {
        ArrayList<IrcHostMask> list = new ArrayList<IrcHostMask>();
        Iterator iter = masks.iterator();
        IrcHostMask mask = null;
        while (iter.hasNext()) {
            mask = (IrcHostMask)iter.next();
            if (!mask.matchesIrcSource(ircSource)) continue;
            list.add(mask);
        }
        return list;
    }

    public static void main(String[] args) {
        System.out.println(new IrcHostMask("*!allan@*.apati.org").matchesIrcSource("allan-!allan@apati.org"));
    }
}

