/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.util;

import com.bowman.util.FtpControlConnection;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.X509TrustManager;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;

public class FtpSecureConnection
extends FtpControlConnection
implements HandshakeCompletedListener {
    private static SSLContext sslContext = null;
    private boolean secureNextTransfer;
    private boolean secureAllTransfers;

    public FtpSecureConnection(String host, int port, String user, String pass) throws UnknownHostException, GeneralSecurityException {
        super(host, port, user, pass);
        if (sslContext == null) {
            if (System.getProperty("java.protocol.handler.pkgs") == null) {
                Security.addProvider((java.security.Provider)new Provider());
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
            }
            sslContext = SSLContext.getInstance((String)"SSL");
            sslContext.init(null, new TrustManager[]{new FtpTrustManager()}, new SecureRandom());
        }
    }

    public void setSecureAllTransfers(boolean secureAllTransfers) {
        this.secureAllTransfers = secureAllTransfers;
    }

    protected void authenticate() throws IOException {
        this.initAuthTLS();
        super.authenticate();
    }

    private void initAuthTLS() throws IOException {
        String authReply = this.sendFtpCommand("AUTH TLS");
        if (this.getCode(authReply) != 234) {
            this.fatalError("Ftpd does not support AUTH TLS.");
        }
        SSLSocket sftpConn = (SSLSocket)sslContext.getSocketFactory().createSocket(this.ftpConn, this.ftpHost.getHostName(), this.ftpPort, true);
        sftpConn.setUseClientMode(true);
        sftpConn.addHandshakeCompletedListener(this);
        sftpConn.startHandshake();
        this.ftpConn = sftpConn;
        this.ftpReader = new BufferedReader(new InputStreamReader(this.ftpConn.getInputStream()));
        this.ftpWriter = new BufferedWriter(new OutputStreamWriter(this.ftpConn.getOutputStream()));
        if (this.getCode(this.sendFtpCommand("PBSZ 0")) != 200) {
            this.fatalError("PBSZ 0 TLS command failed.");
        }
    }

    protected void setupDataConnection(boolean list) throws IOException {
        if (!this.usePassiveMode) {
            throw new UnsupportedOperationException("PORT mode not implemented for SSL/TLS.");
        }
        this.secureNextTransfer = list || this.secureAllTransfers;
        super.setupDataConnection(list);
    }

    protected Socket getSocket(String host, int port) throws IOException {
        if (this.secureNextTransfer) {
            if (!this.usePretransfer && this.getCode(this.sendFtpCommand("PROT P")) != 200) {
                this.fatalError("PROT P TLS command failed.");
            }
            this.debug("returning secure data socket");
            return sslContext.getSocketFactory().createSocket(host, port);
        }
        if (!this.usePretransfer && this.getCode(this.sendFtpCommand("PROT C")) != 200) {
            this.fatalError("PROT C TLS command failed.");
        }
        return super.getSocket(host, port);
    }

    protected void sendPretransfer(boolean list, String cmd) throws IOException {
        boolean bl = this.secureNextTransfer = list || this.secureAllTransfers;
        if (this.secureNextTransfer) {
            if (this.getCode(this.sendFtpCommand("PROT P")) != 200) {
                this.fatalError("PROT P TLS command failed.");
            }
        } else if (this.getCode(this.sendFtpCommand("PROT C")) != 200) {
            this.fatalError("PROT C TLS command failed.");
        }
        super.sendPretransfer(list, cmd);
    }

    protected ServerSocket getServerSocket() throws IOException {
        return super.getServerSocket();
    }

    public void handshakeCompleted(HandshakeCompletedEvent event) {
        this.debug("SSL/TLS using cipher suite: " + event.getCipherSuite());
    }

    private class FtpTrustManager
    implements X509TrustManager {
        private FtpTrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public boolean isClientTrusted(X509Certificate[] x509Certificates) {
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] x509Certificates) {
            return true;
        }
    }
}

