/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.tabs.memory;

import com.jrockit.mc.console.ui.tabs.memory.MemoryPoolInformation;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

public class MemoryPoolModel
extends Observable {
    private volatile MemoryPoolInformation[] m_pools;

    public MemoryPoolModel(IConnectionHandle connectionHandle) {
        IMBeanHelperService mbeanHelperService = (IMBeanHelperService)connectionHandle.getServiceOrDummy(IMBeanHelperService.class);
        ISubscriptionService subscriptionService = (ISubscriptionService)connectionHandle.getServiceOrDummy(ISubscriptionService.class);
        List<ObjectName> memoryPools = this.findPools(mbeanHelperService);
        this.m_pools = this.setupSubscriptions(memoryPools, mbeanHelperService, subscriptionService);
    }

    public MemoryPoolInformation[] getAllPools() {
        return this.m_pools;
    }

    private MemoryPoolInformation[] setupSubscriptions(List<ObjectName> memoryPools, IMBeanHelperService mbeanHelperService, ISubscriptionService subscriptionService) {
        ArrayList<MemoryPoolInformation> pools = new ArrayList<MemoryPoolInformation>();
        for (ObjectName poolName : memoryPools) {
            pools.add(this.setupSubscription(poolName, mbeanHelperService, subscriptionService));
        }
        return pools.toArray(new MemoryPoolInformation[pools.size()]);
    }

    private MemoryPoolInformation setupSubscription(ObjectName poolName, IMBeanHelperService mbeanHelperService, ISubscriptionService subscriptionService) {
        final MemoryPoolInformation info = new MemoryPoolInformation();
        try {
            info.setPoolName(mbeanHelperService.getAttribute(new MRI(MRI.Type.ATTRIBUTE, poolName, "Name")).getValue().toString());
            info.setPoolType(mbeanHelperService.getAttribute(new MRI(MRI.Type.ATTRIBUTE, poolName, "Type")).getValue().toString());
            MRI usageMRI = new MRI(MRI.Type.ATTRIBUTE, poolName, "Usage");
            subscriptionService.addMRIValueListener(usageMRI, new IMRIValueListener(){

                public void valueChanged(MRIValueEvent event) {
                    if (event.getValue() instanceof CompositeData) {
                        MemoryPoolModel.this.updateUsage(info, (CompositeData)event.getValue());
                    }
                }
            });
            this.updateUsage(info, (CompositeData)mbeanHelperService.getAttribute(usageMRI).getValue());
            MRI peakMRI = new MRI(MRI.Type.ATTRIBUTE, poolName, "PeakUsage");
            subscriptionService.addMRIValueListener(peakMRI, new IMRIValueListener(){

                public void valueChanged(MRIValueEvent event) {
                    if (event.getValue() instanceof CompositeData) {
                        MemoryPoolModel.this.updatePeak(info, (CompositeData)event.getValue());
                    }
                }
            });
            this.updatePeak(info, (CompositeData)mbeanHelperService.getAttribute(peakMRI).getValue());
        }
        catch (Exception e) {
            return null;
        }
        return info;
    }

    private void updateUsage(MemoryPoolInformation info, CompositeData value) {
        Long used = (Long)value.get("used");
        Long max = (Long)value.get("max");
        if (used != null && max != null) {
            info.setCurUsed(used);
            info.setCurMax(max);
            info.setCurUsage(max == -1L ? max.doubleValue() : used.doubleValue() / max.doubleValue());
            this.setChanged();
            this.notifyObservers();
        }
    }

    private void updatePeak(MemoryPoolInformation info, CompositeData value) {
        Long used = (Long)value.get("used");
        Long max = (Long)value.get("max");
        if (used != null && max != null) {
            info.setPeakUsed(used);
            info.setPeakMax(max);
            this.setChanged();
            this.notifyObservers();
        }
    }

    private List<ObjectName> findPools(IMBeanHelperService mbeanHelperService) {
        ArrayList<ObjectName> poolNames = new ArrayList<ObjectName>();
        try {
            for (Map.Entry entry : mbeanHelperService.getMBeanInfos().entrySet()) {
                ObjectName o = (ObjectName)entry.getKey();
                if (!o.getDomain().equals("java.lang") || !o.getKeyProperty("type").equals("MemoryPool")) continue;
                poolNames.add(o);
            }
        }
        catch (IOException e1) {
            poolNames.clear();
        }
        return poolNames;
    }
}

