/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr;

import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.rjmx.services.flr.IOptionConstraint;
import com.jrockit.mc.rjmx.services.flr.internal.ContentMashup;
import com.jrockit.mc.rjmx.services.flr.internal.ConversionToolkit;
import com.jrockit.mc.rjmx.services.flr.internal.OptionMetadata;
import com.jrockit.mc.rjmx.services.flr.internal.RecordingSettingsToolkit;

public class OptionHelper {
    private static final IOptionConstraint<String> UNKNOWN_CONSTRAINT = new OptionMetadata<String>("No key, ignore", ContentMashup.UNKNOWN, "Unknown option, treating as string", null, null, "");

    private OptionHelper() {
    }

    public static <T extends Comparable<T>> String toConfigString(IOptionConstraint<T> optionConstraint, T serverValue) {
        return ConversionToolkit.toConfigString(optionConstraint, serverValue);
    }

    public static <T extends Comparable<T>> String toHuman(IOptionConstraint<T> optionConstraint, T serverValue) {
        return ConversionToolkit.toHuman(optionConstraint, serverValue);
    }

    public static <T extends Comparable<T>> T toServerValue(IOptionConstraint<T> optionConstraint, String configurationValue) throws QuantityConversionException {
        return ConversionToolkit.toServerValue(optionConstraint, configurationValue);
    }

    public static <T extends Comparable<T>> T fromHuman(IOptionConstraint<T> optionConstraint, String humanString) throws QuantityConversionException {
        return ConversionToolkit.fromHuman(optionConstraint, humanString);
    }

    public static IOptionConstraint<?> getWellKnownOptionConstraintFor(String key) {
        return RecordingSettingsToolkit.getWellKnownOptionMetaDataFor(key);
    }

    public static IOptionConstraint<?> getBestKnownConstraintFor(String key) {
        IOptionConstraint<?> constraint = OptionHelper.getWellKnownOptionConstraintFor(key);
        return constraint != null ? constraint : UNKNOWN_CONSTRAINT;
    }
}

