/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.cws;

import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.CardData;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.cws.AbstractCwsConnector;
import com.bowman.cardserv.cws.CwsConnectorManager;
import com.bowman.cardserv.interfaces.CwsConnector;
import com.bowman.cardserv.interfaces.UserManager;
import com.bowman.cardserv.util.ProxyXmlConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;

public class ConaxCwsConnector
extends AbstractCwsConnector {
    private static final String CONNECTOR_PROTOCOL = "Conax";
    private static final int CA_SYS_ID = 40;
    private static final int CA_DESC_EMM = 34;
    private static final int CW = 37;
    private static final int ACCESS_STATUS = 49;
    private static final int SUBSCRIPTION_STATUS = 50;
    private static final int CARD_NUMBER = 116;
    private static final int HOST_VER = 16;
    private static final int CAT = 17;
    private static final int EMM = 18;
    private static final int ECM = 20;
    private static final int ASCII_TEXT = 1;
    private static final int OCTET_STR = 32;
    private static final int ADDRESS = 35;
    private static final int TIME = 48;
    private static byte[] INIT_OAA = new byte[]{17, 18, 1, -48, 15, -1, -1, -35, 0, 0, 9, 4, 11, 0, -32, 48, -12, -35, 68, 63};
    private static final CommandAPDU INIT_CASS = new CommandAPDU(221, 38, 0, 0, new byte[]{16, 1, 64});
    private static final CommandAPDU CA_STATUS_SELECT = new CommandAPDU(221, 198, 0, 0, new byte[]{28, 1, 0});
    private static final CommandAPDU REQ_CARD_NUMBER = new CommandAPDU(221, 194, 0, 0, new byte[]{102, 0});
    private static final byte[] HISTORICAL_BYTES = new byte[]{48, 66, 48, 48};
    private int sequenceNr;
    byte[] DW = null;
    private Vector dcwReplies = new Vector();
    private Semaphore replyAvailable = new Semaphore(10, true);
    CardChannel channel;
    private int emmCount;
    private int nodeNumber;
    private byte[] nodeSerial;
    private String nodeName;
    private long lastTrafficTimeStamp = System.currentTimeMillis();
    private ConaxCardData internalCardData = new ConaxCardData();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        super.configUpdated(xml);
        xml.getStringValue("profile");
        boolean enabled = "true".equalsIgnoreCase(xml.getStringValue("enabled", "true"));
        try {
            this.auUsers.clear();
            UserManager um = this.config.getUserManager();
            String auUsersStr = xml.getStringValue("au-users");
            StringTokenizer st = new StringTokenizer(auUsersStr);
            while (st.hasMoreTokens()) {
                String auUser = st.nextToken();
                if (!um.exists(auUser)) {
                    this.logger.warning("AU-user '" + auUser + "' for " + this.getLabel() + " doesn't exist, skipping...");
                    continue;
                }
                this.auUsers.add(auUser.trim());
            }
        }
        catch (ConfigException e) {
            this.auUsers.clear();
        }
        String nodeName = xml.getStringValue("node");
        try {
            this.nodeSerial = xml.getBytesValue("node");
            if (this.nodeSerial.length < 4) {
                this.nodeSerial = null;
            }
        }
        catch (ConfigException e) {
            this.nodeSerial = null;
        }
        try {
            this.nodeNumber = xml.getIntValue("node");
        }
        catch (ConfigException e) {
            this.nodeNumber = -1;
        }
        boolean changed = !nodeName.equals(this.nodeName) || enabled != this.enabled;
        this.nodeName = nodeName;
        this.enabled = enabled;
        if (!enabled) {
            this.close();
        }
        if (changed && enabled) {
            this.close();
            if (this.connManager != null) {
                CwsConnectorManager cwsConnectorManager = this.connManager;
                synchronized (cwsConnectorManager) {
                    this.connManager.notifyAll();
                }
            }
        }
        this.logger.fine("Configuration updated. Enabled: " + enabled + " Changed: " + changed + " AU-users: " + this.auUsers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.alive = true;
        try {
            this.initCard();
            this.connectTimeStamp = System.currentTimeMillis();
            this.connManager.cwsConnected((CwsConnector)this);
            this.connecting = false;
            while (this.alive) {
                CamdNetMessage msg = this.readReply();
                if (msg == null) {
                    this.alive = false;
                    this.logger.warning("Connection closed");
                    continue;
                }
                if (msg.isEcm()) {
                    ConaxCwsConnector conaxCwsConnector = this;
                    synchronized (conaxCwsConnector) {
                        if (!this.reportReply(msg)) {
                            this.logger.info("No listener found for ECM reply: " + msg);
                        }
                        continue;
                    }
                }
                if (!msg.isEmm()) continue;
                this.logger.fine("EMM reply ignored: " + msg);
            }
        }
        catch (IOException e) {
            this.logger.throwing("Exception reading/parsing message: " + e, (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.readerThread = null;
        this.internalClose();
        this.reset();
        this.connManager.cwsDisconnected((CwsConnector)this);
        CwsConnectorManager cwsConnectorManager = this.connManager;
        synchronized (cwsConnectorManager) {
            this.connManager.notify();
        }
        this.connecting = false;
        if (this.noProfile) {
            this.profile = null;
        }
        this.logger.info("Connector dying");
    }

    CamdNetMessage readReply() throws IOException {
        CamdNetMessage msg = null;
        try {
            this.replyAvailable.acquire();
            this.logger.finest("Replies in buffer : " + this.dcwReplies.size());
            if (!this.dcwReplies.isEmpty()) {
                msg = (CamdNetMessage)this.dcwReplies.remove(0);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return msg;
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    public boolean isReady() {
        return this.isConnected();
    }

    public CardData getRemoteCard() {
        this.internalCardData.connectorName = this.getName();
        return this.internalCardData.getCardData();
    }

    public boolean isAuAllowed(String userName) {
        return this.auUsers.contains(userName);
    }

    public String[] getAuUsers() {
        return this.auUsers.toArray(new String[this.auUsers.size()]);
    }

    public long getLastTrafficTimeStamp() {
        return this.lastTrafficTimeStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int sendMessage(CamdNetMessage msg) {
        CommandAPDU apdu;
        if (msg.isKeepAlive()) {
            return -1;
        }
        if (msg.isOsdMsg()) {
            return -1;
        }
        if (!this.waitForPending()) {
            return -1;
        }
        if (msg.isEmm()) {
            ++this.emmCount;
        }
        this.sequenceNr &= 0xFFFF;
        msg.setSequenceNr(this.sequenceNr);
        int dataLength = msg.getDataLength();
        if (msg.isEmm()) {
            this.logger.fine("Sequence number : " + this.sequenceNr);
            byte[] cardCommand = new byte[dataLength + 5];
            cardCommand[0] = 18;
            cardCommand[1] = (byte)(dataLength + 3 & 0xFF);
            cardCommand[2] = (byte)(msg.getCommandTag() & 0xFF);
            cardCommand[3] = 112;
            cardCommand[4] = (byte)(dataLength & 0xFF);
            System.arraycopy(msg.getCustomData(), 0, cardCommand, 5, dataLength);
            apdu = new CommandAPDU(221, 132, 0, 0, cardCommand);
        } else {
            int sid = msg.getServiceId();
            this.logger.fine("Sequence number : " + msg.getSequenceNr() + ", sid : " + Integer.toHexString(sid));
            byte[] cardCommand = new byte[dataLength + 6];
            cardCommand[0] = 20;
            cardCommand[1] = (byte)(dataLength + 4 & 0xFF);
            cardCommand[2] = 0;
            cardCommand[3] = (byte)(msg.getCommandTag() & 0xFF);
            cardCommand[4] = 112;
            cardCommand[5] = (byte)(dataLength & 0xFF);
            System.arraycopy(msg.getCustomData(), 0, cardCommand, 6, dataLength);
            apdu = new CommandAPDU(221, 162, 0, 0, cardCommand);
        }
        try {
            ConaxResponse response = null;
            try {
                response = this.sendCommand(apdu);
            }
            catch (CardException e) {
                throw new IOException("Card communication failure");
            }
            catch (IllegalStateException e) {
                throw new IOException();
            }
            this.lastTrafficTimeStamp = System.currentTimeMillis();
            this.DW = null;
            if (response != null && response.getSW() == 36864 && response.getData() != null) {
                this.parseResponse(response, -1);
            }
            CamdNetMessage reply = null;
            if (this.DW != null) {
                reply = new CamdNetMessage(msg.getCommandTag());
                reply.setCustomData(this.DW);
                reply.setFixedData(msg.getFixedData());
            } else {
                reply = msg.isEmm() ? msg.getEmmReply() : msg.getEmptyReply();
            }
            reply.setSequenceNr(this.sequenceNr);
            this.dcwReplies.add(reply);
        }
        catch (IOException e) {
        }
        finally {
            this.replyAvailable.release();
        }
        return this.sequenceNr++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CardTerminal probeCard(List terminals) {
        this.logger.info("Searching terminals : " + terminals + " for card: " + DESUtil.bytesToString((byte[])this.nodeSerial));
        CardTerminal tempTerminal = null;
        Iterator iter = terminals.iterator();
        while (iter.hasNext()) {
            tempTerminal = (CardTerminal)iter.next();
            Card tempCard = null;
            try {
                String name = tempTerminal.getName();
                this.logger.info("Probing : " + name);
                if (!tempTerminal.waitForCardPresent(10L)) continue;
                tempCard = tempTerminal.connect("*");
                this.logger.fine("ATR Historical bytes:" + DESUtil.bytesToString((byte[])tempCard.getATR().getHistoricalBytes()));
                this.channel = tempCard.getBasicChannel();
                byte[] serial = this.getCardSerial();
                this.logger.fine("Card serial : " + DESUtil.bytesToString((byte[])serial));
                if (!Arrays.equals(this.nodeSerial, serial)) continue;
                CardTerminal cardTerminal = tempTerminal;
                return cardTerminal;
            }
            catch (CardException e) {
                this.logger.finest("CardExeption");
            }
            catch (IllegalStateException e) {
                this.logger.finest("IllegalStateException");
            }
            catch (IOException e) {
                this.logger.finest("IOException");
            }
            finally {
                if (tempCard != null) {
                    try {
                        tempCard.disconnect(true);
                    }
                    catch (CardException e) {}
                }
                this.channel = null;
            }
        }
        return null;
    }

    protected synchronized void connectNative() throws IOException {
        this.replyAvailable.drainPermits();
        TerminalFactory factory = TerminalFactory.getDefault();
        try {
            CardTerminal terminal = null;
            List<CardTerminal> terminals = null;
            if (this.nodeSerial != null) {
                terminals = factory.terminals().list(CardTerminals.State.CARD_PRESENT);
                terminal = this.probeCard(terminals);
            } else if (this.nodeNumber != -1) {
                terminals = factory.terminals().list();
                if (this.nodeNumber > terminals.size() - 1) {
                    throw new IOException("Node not found");
                }
                terminal = terminals.get(this.nodeNumber);
            } else if (this.nodeName != null) {
                terminals = factory.terminals().list();
                terminal = factory.terminals().getTerminal(this.nodeName);
            }
            if (terminal == null) {
                throw new IOException("Node not found");
            }
            this.host = terminal.getName();
            this.channel = terminal.connect("*").getBasicChannel();
            this.logger.info("PCSC node: " + this.host);
            this.logger.info("Card : " + this.channel.getCard());
            this.logger.info("ATR :" + DESUtil.bytesToString((byte[])this.channel.getCard().getATR().getBytes()));
        }
        catch (CardException e) {
            this.channel = null;
            throw new IOException("Card communication failure");
        }
        catch (IllegalStateException e) {
            this.channel = null;
            throw new IOException();
        }
        this.emmCount = 0;
        this.logger.info("Connected");
    }

    public int getEmmCount() {
        return this.emmCount;
    }

    public String getProtocol() {
        return CONNECTOR_PROTOCOL;
    }

    public Properties getRemoteInfo() {
        Iterator iter;
        Properties p = new Properties();
        p.setProperty("CAID: ", Integer.toHexString(this.internalCardData.caid));
        p.setProperty("Unique Address: ", DESUtil.bytesToString((byte[])this.internalCardData.UA));
        p.setProperty("Shared Address: ", DESUtil.bytesToString((byte[])this.internalCardData.SA));
        int i = 1;
        if (!this.internalCardData.subscriptions.isEmpty() && (iter = this.internalCardData.subscriptions.iterator()) != null) {
            while (iter.hasNext()) {
                p.setProperty("subscription " + i++, String.valueOf(iter.next()));
            }
        }
        return p;
    }

    public String getRemoteAddress() {
        return this.channel.getCard().toString();
    }

    private byte[] getCardSerial() throws IOException, CardException, IllegalStateException {
        this.parseResponse(this.sendCommand(REQ_CARD_NUMBER), -1);
        return this.internalCardData.cardSerial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalClose() {
        if (this.channel != null) {
            try {
                this.channel.getCard().disconnect(true);
            }
            catch (CardException e) {
            }
            catch (IllegalStateException illegalStateException) {
            }
            finally {
                this.channel = null;
            }
        }
    }

    public void close() {
        this.dcwReplies.clear();
        this.internalClose();
        super.close();
    }

    private ConaxResponse getResponse(int sw) throws CardException, IllegalStateException {
        byte[] rawData = new byte[]{};
        while ((sw & 0x9800) == 38912) {
            ResponseAPDU r = this.channel.transmit(new CommandAPDU(221, 202, 0, 0, sw & 0xFF));
            sw = r.getSW();
            this.logger.finest("SW : " + Integer.toHexString(sw) + " Data : " + DESUtil.bytesToString((byte[])r.getData()));
            byte[] newData = new byte[rawData.length + r.getNr()];
            System.arraycopy(rawData, 0, newData, 0, rawData.length);
            System.arraycopy(r.getData(), 0, newData, rawData.length, r.getNr());
            rawData = newData;
        }
        ConaxResponse response = new ConaxResponse(sw, rawData);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConaxResponse sendCommand(CommandAPDU apdu) throws CardException, IllegalStateException {
        try {
            this.channel.getCard().beginExclusive();
            this.logger.finest("Sending to card : " + DESUtil.bytesToString((byte[])apdu.getBytes()));
            ResponseAPDU r = this.channel.transmit(apdu);
            this.logger.finest("SW: " + Integer.toHexString(r.getSW()));
            if ((r.getSW1() & 0x98) == 152) {
                ConaxResponse conaxResponse = this.getResponse(r.getSW());
                return conaxResponse;
            }
            ConaxResponse conaxResponse = new ConaxResponse(r.getSW());
            return conaxResponse;
        }
        finally {
            this.channel.getCard().endExclusive();
        }
    }

    void initCard() throws IOException {
        try {
            this.parseResponse(this.sendCommand(INIT_CASS), -1);
            this.parseResponse(this.sendCommand(new CommandAPDU(221, 130, 0, 0, INIT_OAA)), -1);
            this.parseResponse(this.sendCommand(CA_STATUS_SELECT), -1);
        }
        catch (CardException e) {
            throw new IOException("Card communication failure");
        }
        catch (IllegalStateException e) {
            throw new IOException();
        }
    }

    void parseResponse(ConaxResponse response, int parentNano) throws IOException {
        if (response.getData() == null) {
            return;
        }
        ByteArrayInputStream input = new ByteArrayInputStream(response.getData());
        while (input.available() > 0) {
            int cmd = input.read();
            int len = input.read();
            byte[] nanoData = new byte[len];
            input.read(nanoData);
            switch (cmd) {
                case 1: {
                    if (parentNano == -1) break;
                    this.logger.info("ASCII_TEXT : " + new String(nanoData));
                    break;
                }
                case 32: {
                    if (parentNano == -1) break;
                    this.logger.fine("OCTET_STR : " + DESUtil.bytesToString((byte[])nanoData));
                    break;
                }
                case 48: {
                    if (parentNano == -1) break;
                    int year_offset = nanoData[0] >> 5 & 7;
                    int day = nanoData[0] & 0x1F;
                    int year = nanoData[1] >> 4 & 0xF;
                    int month = nanoData[1] & 0xF;
                    this.logger.fine("TIME : " + (year += 1990 + year_offset * 10) + "/" + month + "/" + day);
                    break;
                }
                case 40: {
                    ConaxCwsConnector.INIT_OAA[12] = nanoData[0];
                    ConaxCwsConnector.INIT_OAA[13] = nanoData[1];
                    this.internalCardData.caid = (nanoData[0] & 0xFF) << 8 | nanoData[1] & 0xFF;
                    this.logger.fine("CA_SYS_ID: " + Integer.toHexString(this.internalCardData.caid));
                    break;
                }
                case 35: {
                    if (parentNano == -1) break;
                    this.logger.info("ADDRESS : " + DESUtil.bytesToString((byte[])nanoData));
                    if (nanoData[3] != 0) {
                        System.arraycopy(nanoData, 0, this.internalCardData.UA, 1, 7);
                        break;
                    }
                    System.arraycopy(nanoData, 0, this.internalCardData.SA, 1, 7);
                    break;
                }
                case 37: {
                    if (this.DW == null) {
                        this.DW = new byte[16];
                    }
                    if (nanoData[2] == 1) {
                        System.arraycopy(nanoData, 5, this.DW, 8, 8);
                        break;
                    }
                    System.arraycopy(nanoData, 5, this.DW, 0, 8);
                    break;
                }
                case 34: {
                    this.parseResponse(new ConaxResponse(nanoData), cmd);
                    break;
                }
                case 50: {
                    this.parseSubscription(nanoData);
                    break;
                }
                case 116: {
                    this.logger.info("CARD_NUMBER : " + DESUtil.bytesToString((byte[])nanoData));
                    System.arraycopy(nanoData, 0, this.internalCardData.cardSerial, 0, 4);
                }
            }
        }
    }

    void parseSubscription(byte[] subscriptionData) throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(subscriptionData);
        String subscriptionString = "Provider : " + Integer.toHexString(input.read()) + Integer.toHexString(input.read());
        this.logger.fine(subscriptionString);
        while (input.available() > 0) {
            int cmd = input.read();
            int len = input.read();
            byte[] nanoData = new byte[len];
            input.read(nanoData);
            switch (cmd) {
                case 1: {
                    this.logger.info("Provider name: " + new String(nanoData));
                    subscriptionString = subscriptionString + ", " + new String(nanoData);
                    break;
                }
                case 32: {
                    this.logger.info("OCTET_STR : " + DESUtil.bytesToString((byte[])nanoData));
                    subscriptionString = subscriptionString + ", OCTET_STR : " + DESUtil.bytesToString((byte[])nanoData);
                    break;
                }
                case 48: {
                    int year_offset = nanoData[0] >> 5 & 7;
                    int day = nanoData[0] & 0x1F;
                    int year = nanoData[1] >> 4 & 0xF;
                    int month = nanoData[1] & 0xF;
                    this.logger.info("TIME : " + (year += 1990 + year_offset * 10) + "/" + month + "/" + day);
                    subscriptionString = subscriptionString + ", TIME : " + year + "/" + month + "/" + day;
                }
            }
        }
        this.internalCardData.subscriptions.add(subscriptionString);
    }

    private class ConaxResponse {
        private int sw;
        private byte[] data;

        ConaxResponse(int sw) {
            this.sw = sw;
        }

        ConaxResponse(int sw, byte[] data) {
            this.sw = sw;
            this.data = data;
        }

        ConaxResponse(byte[] data) {
            this.sw = 36864;
            this.data = data;
        }

        ConaxResponse(byte[] data, int pos, int len) {
            this.sw = 36864;
            this.data = new byte[len];
            System.arraycopy(data, pos, this.data, 0, len);
        }

        int getSW() {
            return this.sw;
        }

        byte[] getData() {
            return this.data;
        }
    }

    private class SubStatus {
        String id;
        String name;
        String octet1;
        String octet2;
        String start1;
        String start2;
        String end1;
        String end2;

        private SubStatus() {
        }

        public String toString() {
            return "Provider: " + this.id + "," + this.name + "\r\n" + this.octet1;
        }
    }

    private class ConaxCardData {
        String connectorName = null;
        int caid;
        byte[] UA = new byte[8];
        byte[] SA = new byte[8];
        byte[] cardSerial = new byte[4];
        Set subscriptions = new HashSet();

        private ConaxCardData() {
        }

        CardData getCardData() {
            byte[] rawCardData = new byte[23];
            rawCardData[0] = 1;
            rawCardData[1] = (byte)(this.caid >> 8 & 0xFF);
            rawCardData[2] = (byte)(this.caid & 0xFF);
            System.arraycopy(this.UA, 0, rawCardData, 3, 8);
            rawCardData[11] = 1;
            rawCardData[12] = 0;
            rawCardData[13] = 0;
            rawCardData[14] = 0;
            System.arraycopy(this.SA, 0, rawCardData, 15, 8);
            return new CardData(rawCardData, this.connectorName);
        }
    }
}

