/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.DefaultCache;
import com.bowman.cardserv.MessageCacheMap;
import com.bowman.cardserv.crypto.DESUtil;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.interfaces.StaleEntryListener;
import com.bowman.cardserv.session.CspSession;
import com.bowman.cardserv.session.SessionManager;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.cardserv.util.TimedAverageList;
import com.bowman.cardserv.web.CtrlCommand;
import com.bowman.cardserv.web.CtrlCommandResult;
import com.bowman.cardserv.web.FileFetcher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.MulticastSocket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class ClusteredCache
extends DefaultCache
implements Runnable,
StaleEntryListener {
    public static final int TYPE_REQUEST = 1;
    public static final int TYPE_REPLY = 2;
    public static final int TYPE_PINGREQ = 3;
    public static final int TYPE_PINGRPL = 4;
    public static final int TYPE_RESENDREQ = 5;
    private InetAddress mcGroup;
    private String trackerKey;
    private String localHost;
    private URL trackerUrl;
    private Set peerList = new HashSet();
    private Set badDcws = new HashSet();
    private Set blackList = new HashSet();
    private Map hostPings = new HashMap();
    private Map hostReceives = new HashMap();
    private long trackerInterval;
    private long syncPeriod;
    private long pingSent;
    private int remotePort;
    private int localPort;
    private byte ttl;
    private DatagramSocket recvSock;
    private DatagramSocket sendSock;
    private Thread clusterThread;
    private Thread trackerThread;
    private boolean useMulticast;
    private boolean debug;
    private boolean hideNames;
    private boolean autoAddPeers;
    private boolean checksumCws;
    private boolean zeroCounting;
    private boolean requireId;
    private boolean logWarnings;
    private int trackerFailures;
    private int receivedEntries;
    private int receivedPending;
    private int receivedDiscarded;
    private int sentPending;
    private int sentEntries;
    private int reSentEntries;
    private int receivedResendReqs;
    private int sentResendReqs;
    private int receivedBadChecksum;
    private int receivedZeroCw;
    private int receivedBadCw;
    private int receivedBadId;
    private TimedAverageList sentAvg = new TimedAverageList(10);
    private TimedAverageList recvAvg = new TimedAverageList(10);
    private RequestArbiter arbiter = new RequestArbiter();
    private Set mismatchedHosts = new HashSet();
    private MessageCacheMap resendReqs;

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        InetAddress remoteCache;
        super.configUpdated(xml);
        this.pendingEcms.setStaleEntryListener(this);
        this.mismatchedHosts.clear();
        if (this.resendReqs == null) {
            this.resendReqs = new MessageCacheMap(this.maxAge);
        } else {
            this.resendReqs.setMaxAge(this.maxAge);
        }
        try {
            String host = xml.getStringValue("remote-host");
            try {
                remoteCache = InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                throw new ConfigException(xml.getFullName(), "remote-host", "Unable to resolve '" + host + "': " + e.getMessage());
            }
        }
        catch (ConfigException e) {
            remoteCache = null;
        }
        this.debug = "true".equalsIgnoreCase(xml.getStringValue("debug", "false"));
        if (this.debug) {
            this.logger.warning("Cache debug mode enabled (will fail sooner or later under any significant traffic).");
        }
        this.hideNames = "true".equalsIgnoreCase(xml.getStringValue("hide-names", "false"));
        this.autoAddPeers = "true".equalsIgnoreCase(xml.getStringValue("auto-add-peers", "false"));
        this.syncPeriod = xml.getTimeValue("sync-period", 0, "ms");
        if (this.syncPeriod > 0L) {
            this.logger.info("Strict cache-synchronization is enabled (sync-period is: " + this.syncPeriod + " ms).");
        }
        this.useMulticast = false;
        try {
            String mcHost = xml.getStringValue("multicast-group");
            try {
                this.mcGroup = InetAddress.getByName(mcHost);
                this.useMulticast = true;
            }
            catch (UnknownHostException e) {
                throw new ConfigException(xml.getFullName(), "multicast-group", "Unable to resolve '" + mcHost + "': " + e.getMessage());
            }
        }
        catch (ConfigException e) {
            // empty catch block
        }
        this.ttl = (byte)xml.getIntValue("multicast-ttl", 2);
        this.remotePort = xml.getPortValue("remote-port", -1);
        if (!this.useMulticast && this.remotePort != -1 && remoteCache != null) {
            this.peerList.clear();
            this.peerList.add(new CachePeer(remoteCache, this.remotePort));
        }
        this.trackerUrl = null;
        this.trackerKey = null;
        this.trackerInterval = 0L;
        if (!this.useMulticast) {
            String trackerUrlStr = null;
            try {
                trackerUrlStr = xml.getStringValue("tracker-url");
                this.trackerKey = xml.getStringValue("tracker-key");
            }
            catch (ConfigException e) {
                // empty catch block
            }
            if (trackerUrlStr != null) {
                try {
                    this.trackerUrl = new URL(trackerUrlStr);
                }
                catch (MalformedURLException e) {
                    throw new ConfigException(xml.getFullName(), "tracker-url", "Malformed URL: " + trackerUrlStr);
                }
                this.trackerInterval = xml.getTimeValue("tracker-update", 0, "m");
                if (this.trackerInterval != 0L && this.trackerInterval < 60000L) {
                    this.trackerInterval = 60000L;
                }
                try {
                    this.localHost = xml.getStringValue("local-host");
                }
                catch (ConfigException e) {
                    try {
                        InetAddress lh = InetAddress.getLocalHost();
                        this.localHost = lh.getHostAddress();
                    }
                    catch (UnknownHostException e1) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.remotePort != -1 && remoteCache == null && this.trackerUrl == null && this.mcGroup == null) {
            throw new ConfigException(xml.getFullName(), "Either remote-host, tracker-url or multicast-group must be present when remote-port is set.");
        }
        this.localPort = xml.getPortValue("local-port");
        if (this.recvSock == null) {
            try {
                this.sendSock = this.useMulticast ? new MulticastSocket() : new DatagramSocket();
                this.recvSock = this.useMulticast ? new MulticastSocket(this.localPort) : new DatagramSocket(this.localPort);
            }
            catch (IOException e) {
                throw new ConfigException(xml.getFullName(), "local-port", "Unable to open udp socket on port " + this.localPort + ": " + e.getMessage());
            }
            if (this.useMulticast) {
                this.peerList.clear();
                try {
                    ((MulticastSocket)this.recvSock).joinGroup(this.mcGroup);
                }
                catch (IOException e) {
                    throw new ConfigException(xml.getFullName(), "Unable to join multicast-group '" + this.mcGroup.getHostAddress() + "': " + e.getMessage());
                }
            }
        }
        if (this.trackerUrl != null) {
            try {
                this.setPeerList(this.fetchList());
                this.logger.info("Fetched peer list from tracker (" + this.trackerUrl + "): " + this.peerList.size() + " entries");
                this.logger.fine("Peers: " + this.peerList);
            }
            catch (IOException e) {
                throw new ConfigException(xml.getFullName(), "tracker-url", "Failed to get list of peers from tracker url (" + this.trackerUrl + "): " + e, e);
            }
        }
        ProxyXmlConfig cwvXml = null;
        try {
            cwvXml = xml.getSubConfig("cw-validation");
        }
        catch (ConfigException e) {
            // empty catch block
        }
        if (cwvXml == null) {
            this.checksumCws = true;
            this.zeroCounting = true;
            this.logWarnings = true;
            this.requireId = true;
        } else {
            this.checksumCws = "true".equalsIgnoreCase(cwvXml.getStringValue("checksum", "true"));
            this.zeroCounting = "true".equalsIgnoreCase(cwvXml.getStringValue("zero-counting", "true"));
            this.logWarnings = "true".equalsIgnoreCase(cwvXml.getStringValue("log-warnings", "true"));
            this.requireId = "true".equalsIgnoreCase(cwvXml.getStringValue("require-id", "true"));
            this.badDcws.clear();
            Iterator iter = cwvXml.getMultipleStrings("bad-dcw");
            if (iter != null) {
                while (iter.hasNext()) {
                    byte[] bd = DESUtil.stringToBytes((String)iter.next());
                    if (bd.length != 16) {
                        throw new ConfigException(xml.getFullName(), "bad-dcw not 16 bytes: " + DESUtil.bytesToString(bd));
                    }
                    this.badDcws.add(bd);
                }
            }
            if (this.badDcws.size() > 10) {
                throw new ConfigException(xml.getFullName(), "Too many bad-dcw elements (max 10)");
            }
        }
        this.blackList.clear();
        String bl = FileFetcher.getProperty("cache.bl");
        if (bl != null) {
            this.blackList.addAll(Arrays.asList(bl.split(" ")));
        }
        this.registerCtrlCommands();
    }

    public int getLocalPort() {
        return this.localPort;
    }

    protected void registerCtrlCommands() {
        try {
            new CtrlCommand("toggle-debug", "Toggle debug", "Turn debugging on/off.").register(this);
            CtrlCommand cmd = new CtrlCommand("add-peer", "Add cache peer", "Temporarily add a cache peer (until tracker/cfg update).");
            cmd.addParam("host", "Host");
            cmd.addParam("port", "Port");
            cmd.register(this);
            cmd = new CtrlCommand("remove-peer", "Remove cache peer", "Temporarily remove a cache peer.");
            cmd.addParam("peer", "").setOptions(this.peerList, false);
            cmd.register(this);
            if (this.trackerUrl != null) {
                new CtrlCommand("update", "Run tracker update", "Fetch the tracker list now.").register(this);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public CtrlCommandResult runCtrlCmdToggleDebug() {
        this.debug = !this.debug;
        return new CtrlCommandResult(true, "Debugging is now " + (this.debug ? "on." : "off."));
    }

    public CtrlCommandResult runCtrlCmdUpdate() {
        try {
            this.setPeerList(this.fetchList());
        }
        catch (IOException e) {
            return new CtrlCommandResult(false, "Updated failed: " + e);
        }
        return new CtrlCommandResult(true, "Update completed.");
    }

    public CtrlCommandResult runCtrlCmdAddPeer(Map params) {
        String resultMsg;
        boolean result = false;
        String host = (String)params.get("host");
        String port = (String)params.get("port");
        if (host == null) {
            resultMsg = "Missing parameter: host";
        } else if (port == null) {
            resultMsg = "Missing parameter: port";
        } else {
            try {
                int p = Integer.parseInt(port);
                if (p < 1 || p >= 65535) {
                    throw new NumberFormatException();
                }
                InetAddress a = InetAddress.getByName(host);
                this.peerList.add(new CachePeer(a, p));
                resultMsg = "Cache peer added: " + a.getHostAddress() + ":" + p;
                result = true;
            }
            catch (NumberFormatException e) {
                resultMsg = "Bad port number: " + port;
            }
            catch (UnknownHostException e) {
                resultMsg = "Unknown host: " + host;
            }
        }
        return new CtrlCommandResult(result, resultMsg);
    }

    public CtrlCommandResult runCtrlCmdRemovePeer(Map params) {
        String resultMsg;
        String peer = (String)params.get("peer");
        if (peer.indexOf(47) > -1) {
            peer = peer.substring(peer.lastIndexOf(47) + 1);
        }
        boolean result = true;
        try {
            result = this.peerList.remove(new CachePeer(peer.split(":")));
            resultMsg = result ? "Peer removed: " + params.get("peer") : "Peer not found: " + params.get("peer");
        }
        catch (UnknownHostException e) {
            resultMsg = "Failed to remove peer: " + e;
        }
        return new CtrlCommandResult(result, resultMsg);
    }

    public void setPeerList(Set peerList) {
        this.peerList.clear();
        this.peerList.addAll(peerList);
        List cspSessions = SessionManager.getInstance().getSessions(CaProfile.MULTIPLE.getName());
        if (cspSessions != null) {
            Iterator iter = cspSessions.iterator();
            while (iter.hasNext()) {
                ProxySession session = (ProxySession)iter.next();
                if (!(session instanceof CspSession)) continue;
                this.addCachePeer((CspSession)session);
            }
        }
    }

    public CachePeer addCachePeer(CspSession session) {
        try {
            if (session.getCachePort() != -1) {
                CachePeer peer = new CachePeer(InetAddress.getByName(session.getCacheHost()), session.getCachePort());
                if (this.peerList.add(peer)) {
                    this.logger.fine("Added CspSession as cache peer: " + peer);
                }
                return peer;
            }
        }
        catch (UnknownHostException e) {
            this.logger.warning("Unable to add cache peer, unknown host: " + session.getCacheHost());
        }
        return null;
    }

    public void removeCachePeer(CachePeer peer) {
        if (this.peerList.remove(peer)) {
            this.logger.fine("Removed CspSession as cache peer: " + peer);
        }
    }

    public void start() {
        this.trackerFailures = 0;
        this.receivedPending = 0;
        this.receivedEntries = 0;
        this.receivedDiscarded = 0;
        this.receivedBadChecksum = 0;
        this.receivedZeroCw = 0;
        this.receivedBadCw = 0;
        this.receivedBadId = 0;
        this.sentPending = 0;
        this.sentEntries = 0;
        this.sentAvg.clear();
        this.recvAvg.clear();
        this.pingSent = System.currentTimeMillis();
        if (this.clusterThread == null) {
            this.clusterThread = new Thread((Runnable)this, "ClusteredCacheThread");
            this.clusterThread.start();
        }
        if (this.trackerUrl != null && this.trackerInterval != 0L) {
            if (this.trackerThread == null) {
                this.trackerThread = new Thread((Runnable)this, "ClusterCacheTrackerThread");
                this.trackerThread.start();
            }
        } else if (this.trackerThread != null) {
            this.trackerThread.interrupt();
        }
    }

    protected Set fetchList() throws IOException {
        List<String> lines = Arrays.asList(FileFetcher.fetchList(this.trackerUrl, this.trackerKey));
        if (lines.isEmpty()) {
            throw new IOException("Empty list or decryption failed.");
        }
        String thisProxy = this.localHost + ":" + this.localPort;
        if (!lines.contains(thisProxy)) {
            this.logger.warning("No record for this proxy found in list from tracker (" + this.trackerUrl + "), expected: " + thisProxy);
        }
        HashSet<CachePeer> peers = new HashSet<CachePeer>();
        Iterator<String> iter = lines.iterator();
        while (iter.hasNext()) {
            int port;
            InetAddress addr;
            String line = iter.next();
            String[] pair = line.split(":");
            if (pair.length != 2) {
                this.logger.warning("Malformed line in tracker list skipped: '" + line + "' (expected host:port)");
                continue;
            }
            if (this.localHost.equals(pair[0])) continue;
            try {
                addr = InetAddress.getByName(pair[0]);
            }
            catch (UnknownHostException e) {
                this.logger.warning("Unable to resolve host in tracker list, skipping: " + line);
                continue;
            }
            try {
                port = Integer.parseInt(pair[1]);
                if (port < 1 || port >= 65535) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                this.logger.warning("Bad port number in tracker list, skipping: " + line);
                continue;
            }
            peers.add(new CachePeer(addr, port));
        }
        if (peers.isEmpty()) {
            throw new IOException("No valid peers found in tracker list (" + this.trackerUrl + "), wrong password?");
        }
        return peers;
    }

    public CamdNetMessage processRequest(int successFactor, CamdNetMessage request, boolean alwaysWait, long maxCwWait) {
        if (!(this.syncPeriod <= 0L || alwaysWait || successFactor == -1 || this.contains(request) || this.containsPending(request))) {
            if (this.hasPeers()) {
                if (this.debug) {
                    this.logger.fine("Adding for arbitration: " + request.hashCodeStr() + " (" + successFactor + ")");
                }
                if (this.arbiter.addForArbitration(successFactor, request)) {
                    this.sendMessage(request, null);
                }
            }
            try {
                Thread.sleep(this.syncPeriod);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.hasPeers()) {
                if (!this.arbiter.resolveArbitration(request)) {
                    if (this.debug) {
                        this.logger.fine("Lost arbitration for: " + request.hashCodeStr());
                    }
                    super.addRequest(successFactor, request, true);
                } else if (this.debug) {
                    this.logger.fine("Won arbitration for: " + request.hashCodeStr());
                }
            }
        }
        return super.processRequest(successFactor, request, alwaysWait, maxCwWait);
    }

    public void delayAlert(int successFactor, CamdNetMessage request, boolean alwaysWait, long maxWait) {
        if (successFactor == -1 || alwaysWait || (long)successFactor > maxWait) {
            this.sendResendRequest(request);
        }
    }

    protected void addRequest(int successFactor, CamdNetMessage request, boolean alwaysWait) {
        super.addRequest(successFactor, request, alwaysWait);
        if (!alwaysWait && successFactor != -1) {
            request.setArbiterNumber(null);
            this.sendMessage(request, null);
            request.setLockSent(true);
            if (System.currentTimeMillis() - this.pingSent > 4000L) {
                this.sendPing();
            }
        }
    }

    public synchronized boolean processReply(CamdNetMessage request, CamdNetMessage reply) {
        if (reply == null || reply.isEmpty()) {
            if (this.pendingEcms.containsKey(request) && request.isLockSent()) {
                if (reply == null) {
                    reply = request.getEmptyReply();
                }
                this.sendMessage(request, reply);
                request.setLockSent(false);
            }
        } else {
            this.sendMessage(request, reply);
        }
        return super.processReply(request, reply);
    }

    private boolean hasPeers() {
        if (this.useMulticast) {
            return true;
        }
        return !this.peerList.isEmpty();
    }

    private void sendMessage(CamdNetMessage request, CamdNetMessage reply) {
        if (!this.hasPeers()) {
            return;
        }
        if (this.requireId && request.getCaId() == 0 && request.getNetworkId() == 0) {
            return;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            if (reply == null) {
                dos.writeByte(1);
            } else {
                dos.writeByte(2);
                request.setArbiterNumber(null);
            }
            ClusteredCache.writeCacheReq(dos, request, true);
            if (reply != null) {
                ClusteredCache.writeCacheRpl(dos, reply, !this.hideNames);
            }
            dos.close();
            byte[] buf = bos.toByteArray();
            if (reply == null) {
                if (this.debug) {
                    this.logger.fine("Sending pending ecm, " + buf.length + " bytes");
                }
                if (request.getArbiterNumber() == null) {
                    ++this.sentPending;
                }
            } else {
                if (this.debug) {
                    this.logger.fine("Sending ecm>cw pair, " + buf.length + " bytes");
                }
                ++this.sentEntries;
            }
            this.sendToPeers(buf);
        }
        catch (IOException e) {
            this.logger.throwing(e);
        }
    }

    private void reSendMessage(CamdNetMessage request, CamdNetMessage reply, CachePeer peer) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeByte(2);
            request.setArbiterNumber(null);
            ClusteredCache.writeCacheReq(dos, request, false);
            ClusteredCache.writeCacheRpl(dos, reply, !this.hideNames);
            dos.close();
            byte[] buf = bos.toByteArray();
            if (this.debug) {
                this.logger.fine("Resending ecm>cw pair, " + buf.length + " bytes");
            }
            ++this.reSentEntries;
            this.sendToPeer(buf, peer.addr, peer.port);
        }
        catch (IOException e) {
            this.logger.throwing(e);
        }
    }

    private void sendResendRequest(CamdNetMessage request) {
        if (!this.hasPeers()) {
            return;
        }
        Long lastSend = (Long)this.resendReqs.get(request);
        long now = System.currentTimeMillis();
        if (lastSend == null || now - lastSend > 50L) {
            this.resendReqs.put(request, new Long(now));
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(bos);
                dos.writeByte(5);
                dos.writeInt(this.localPort);
                ClusteredCache.writeCacheReq(dos, request, false);
                dos.close();
                byte[] buf = bos.toByteArray();
                if (this.debug) {
                    this.logger.fine("Sending resend request, " + buf.length + " bytes");
                }
                ++this.sentResendReqs;
                this.sendToPeers(buf);
            }
            catch (IOException e) {
                this.logger.throwing(e);
            }
        }
    }

    public static void writeCacheReq(DataOutputStream dos, CamdNetMessage msg, boolean extra) throws IOException {
        dos.writeByte(msg.getCommandTag());
        dos.writeShort(msg.getServiceId());
        dos.writeShort(msg.getNetworkId());
        dos.writeShort(msg.getCaId());
        dos.writeInt(msg.getDataHash());
        if (extra && msg.getArbiterNumber() != null) {
            dos.writeDouble(msg.getArbiterNumber());
        }
    }

    public static void writeCacheRpl(DataOutputStream dos, CamdNetMessage msg, boolean extra) throws IOException {
        dos.writeByte(msg.getCommandTag());
        if (!msg.isEmpty()) {
            dos.write(msg.getCustomData());
            if (extra && msg.getConnectorName() != null) {
                dos.writeUTF(msg.getConnectorName());
            }
        }
    }

    private void sendToPeers(byte[] buf) throws IOException {
        this.sendToPeers(buf, null);
    }

    private void sendToPeers(byte[] buf, String excludeIp) throws IOException {
        if (this.useMulticast) {
            DatagramPacket packet = new DatagramPacket(buf, buf.length, this.mcGroup, this.remotePort);
            ((MulticastSocket)this.sendSock).setTimeToLive(this.ttl);
            this.sendPacket(packet);
        } else {
            Iterator iter = new ArrayList(this.peerList).iterator();
            while (iter.hasNext()) {
                CachePeer peer = (CachePeer)iter.next();
                if (excludeIp != null && excludeIp.equals(peer.addr.getHostAddress())) continue;
                DatagramPacket packet = new DatagramPacket(buf, buf.length, peer.addr, peer.port);
                this.sendPacket(packet);
            }
        }
    }

    private void sendToPeer(byte[] buf, InetAddress target, int port) throws IOException {
        DatagramPacket packet = new DatagramPacket(buf, buf.length, target, port);
        this.sendPacket(packet);
    }

    private synchronized void sendPacket(DatagramPacket packet) throws IOException {
        this.sendSock.send(packet);
        this.sentAvg.addRecord(packet.getLength());
    }

    private void sendPing() {
        if (!this.hasPeers()) {
            return;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeByte(3);
            this.pingSent = System.currentTimeMillis();
            dos.writeLong(this.pingSent);
            dos.writeInt(this.localPort);
            dos.close();
            byte[] buf = bos.toByteArray();
            if (this.debug) {
                this.logger.fine("Sending ping request, " + buf.length + " bytes");
            }
            this.sendToPeers(buf);
        }
        catch (IOException e) {
            this.logger.throwing(e);
        }
    }

    private void sendPingReply(long ping, InetAddress target, int port) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeByte(4);
            dos.writeLong(ping);
            dos.close();
            byte[] buf = bos.toByteArray();
            this.sendToPeer(buf, target, port);
        }
        catch (IOException e) {
            this.logger.throwing(e);
        }
    }

    public void run() {
        if (Thread.currentThread() == this.clusterThread) {
            this.startReceiving();
        } else if (Thread.currentThread() == this.trackerThread) {
            this.startTrackerUpdates();
        }
    }

    private boolean isValidReq(CamdNetMessage msg) {
        if (!this.requireId) {
            return true;
        }
        if (msg.getCaId() == 0 || msg.getNetworkId() == 0) {
            if (this.logWarnings) {
                this.logger.warning("Bad id in request, dropping: " + msg.toDebugString());
            }
            ++this.receivedBadId;
            return false;
        }
        return true;
    }

    private boolean isValidCw(CamdNetMessage msg) {
        if (msg.isEmpty()) {
            return true;
        }
        if (!this.badDcws.isEmpty()) {
            byte[] data = msg.getCustomData();
            Iterator iter = this.badDcws.iterator();
            while (iter.hasNext()) {
                byte[] badDcw = (byte[])iter.next();
                if (!Arrays.equals(data, badDcw)) continue;
                ++this.receivedBadCw;
                return false;
            }
        }
        if (this.checksumCws && !msg.checksumDcw()) {
            if (this.logWarnings) {
                this.logger.warning("Bad checksum in DCW, dropping: " + msg.toDebugString());
            }
            ++this.receivedBadChecksum;
            return false;
        }
        if (this.zeroCounting && msg.hasFiveZeroes()) {
            if (this.logWarnings) {
                this.logger.warning("Bad DCW (>5 zeroes), dropping: " + msg.toDebugString());
            }
            ++this.receivedZeroCw;
            return false;
        }
        return true;
    }

    private void startReceiving() {
        boolean alive = true;
        while (alive) {
            DatagramPacket packet = null;
            try {
                byte[] buf = new byte[512];
                packet = new DatagramPacket(buf, buf.length);
                this.recvSock.receive(packet);
                this.recvAvg.addRecord(packet.getLength());
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(packet.getData(), 0, packet.getLength()));
                byte type = dis.readByte();
                String addr = packet.getAddress().getHostAddress();
                switch (type) {
                    case 2: {
                        ++this.receivedEntries;
                        CamdNetMessage request = CamdNetMessage.parseCacheReq(dis, false);
                        if (!this.isValidReq(request)) break;
                        CamdNetMessage reply = CamdNetMessage.parseCacheRpl(dis, request, true);
                        if (!this.blackList.contains(addr)) {
                            this.incrementReceived(addr);
                            request.setOriginAddress(addr);
                            reply.setOriginAddress(addr);
                        }
                        if (reply.getConnectorName() != null) {
                            reply.setConnectorName("remote: " + reply.getConnectorName());
                        }
                        if (!this.isValidCw(reply)) break;
                        if (!this.contains(request)) {
                            super.processReply(request, reply);
                        } else {
                            ++this.receivedDiscarded;
                            if (this.monitor != null) {
                                this.monitor.onReply(request, reply);
                            }
                        }
                        if (!this.debug) break;
                        this.logger.fine("Cache reply received for: " + request.hashCodeStr() + " -> " + reply.hashCodeStr() + " (from: " + reply.getOriginAddress() + ") " + packet.getLength() + " bytes");
                        break;
                    }
                    case 1: {
                        CamdNetMessage request = CamdNetMessage.parseCacheReq(dis, true);
                        if (!this.isValidReq(request)) break;
                        if (!this.blackList.contains(addr)) {
                            request.setOriginAddress(addr);
                        }
                        if (request.getArbiterNumber() != null && this.syncPeriod > 0L) {
                            this.arbiter.addArbitrationPeer(request);
                            if (!this.debug) break;
                            this.logger.fine("Arbitration request received: " + request.hashCodeStr() + " (from: " + packet.getAddress().getHostAddress() + ") arbiterNumber: " + request.getArbiterNumber());
                            break;
                        }
                        ++this.receivedPending;
                        super.addRequest(-1, request, false);
                        if (!this.debug) break;
                        this.logger.fine("Pending request received: " + request.hashCodeStr() + " (from: " + packet.getAddress().getHostAddress() + ") " + packet.getLength() + " bytes");
                        break;
                    }
                    case 3: {
                        long ping = dis.readLong();
                        int port = dis.readInt();
                        if (this.blackList.contains(addr)) break;
                        this.sendPingReply(ping, packet.getAddress(), port);
                        if (!this.autoAddPeers) break;
                        this.autoAddPeer(new CachePeer(packet.getAddress(), port));
                        break;
                    }
                    case 4: {
                        long ping = dis.readLong();
                        ping = System.currentTimeMillis() - ping;
                        if (this.blackList.contains(addr)) break;
                        this.hostPings.put(addr, new Long(ping));
                        break;
                    }
                    case 5: {
                        CachePeer peer;
                        CamdNetMessage reply;
                        ++this.receivedResendReqs;
                        int port = dis.readInt();
                        CamdNetMessage request = CamdNetMessage.parseCacheReq(dis, false);
                        if (!this.isValidReq(request) || !this.peerList.contains(peer = new CachePeer(packet.getAddress(), port)) || (reply = this.peekReply(request)) == null) break;
                        this.reSendMessage(request, reply, peer);
                        break;
                    }
                    default: {
                        this.logger.warning("Unknown cache message received from " + packet.getAddress() + ", type: " + type + " size: " + packet.getLength());
                    }
                }
                dis.close();
            }
            catch (IOException e) {
                this.logger.throwing(e);
                try {
                    this.logger.warning("Internal error receiving remote cache packet [" + packet.getAddress().getHostAddress() + " - " + DESUtil.bytesToString(packet.getData(), packet.getLength()) + "]: " + e);
                    this.mismatchedHosts.add(packet.getAddress().getHostAddress());
                }
                catch (Exception e2) {
                    this.logger.throwing(e2);
                    this.logger.warning("Internal error receiving remote cache packet [" + packet + "]: " + e2);
                }
            }
        }
        this.clusterThread = null;
        this.logger.fine("Cluster thread dying.");
    }

    private void autoAddPeer(CachePeer peer) {
        if (!this.peerList.contains(peer)) {
            this.peerList.add(peer);
            this.logger.info("New peer auto-added: " + peer.addr.getHostAddress() + ":" + peer.port);
        }
        if (System.currentTimeMillis() - this.pingSent > 4000L) {
            this.sendPing();
        }
    }

    private void incrementReceived(String addr) {
        Long l = (Long)this.hostReceives.get(addr);
        l = l == null ? new Long(1L) : new Long(1L + l);
        this.hostReceives.put(addr, l);
    }

    private void startTrackerUpdates() {
        boolean alive = true;
        while (alive && this.trackerInterval > 0L) {
            try {
                this.logger.fine("Waiting " + this.trackerInterval + " ms before next tracker update...");
                Thread.sleep(this.trackerInterval);
                try {
                    this.setPeerList(this.fetchList());
                    this.logger.info("Fetched peer list from tracker (" + this.trackerUrl + "): " + this.peerList.size() + " entries found.");
                    this.logger.fine("Peers: " + this.peerList);
                }
                catch (IOException e) {
                    ++this.trackerFailures;
                    this.logger.warning("Exception occured fetching tracker list: " + e);
                    this.logger.throwing(e);
                }
            }
            catch (InterruptedException e) {
                alive = false;
            }
        }
        this.trackerThread = null;
        this.logger.fine("Tracker thread dying.");
    }

    public Properties getUsageStats() {
        Properties p = super.getUsageStats();
        p.setProperty("cache-peers", String.valueOf(this.peerList.size()));
        p.setProperty("tracker-failures", String.valueOf(this.trackerFailures));
        p.setProperty("received-pending", String.valueOf(this.receivedPending));
        p.setProperty("received-cached", String.valueOf(this.receivedEntries));
        p.setProperty("received-discarded", String.valueOf(this.receivedDiscarded));
        p.setProperty("received-resendreqs", String.valueOf(this.receivedResendReqs));
        if (this.receivedBadChecksum > 0) {
            p.setProperty("received-bad-checksum", String.valueOf(this.receivedBadChecksum));
        }
        if (this.receivedZeroCw > 0) {
            p.setProperty("received-zero-cw", String.valueOf(this.receivedZeroCw));
        }
        if (this.receivedBadCw > 0) {
            p.setProperty("received-bad-cw", String.valueOf(this.receivedBadCw));
        }
        if (this.receivedBadId > 0) {
            p.setProperty("received-bad-id", String.valueOf(this.receivedBadId));
        }
        p.setProperty("sent-resends", String.valueOf(this.reSentEntries));
        p.setProperty("sent-resendreqs", String.valueOf(this.sentResendReqs));
        p.setProperty("sent-pending", String.valueOf(this.sentPending));
        p.setProperty("sent-cached", String.valueOf(this.sentEntries));
        p.setProperty("avg-sent-bytes/s", String.valueOf(this.sentAvg.getTotal(true) / 10));
        p.setProperty("avg-received-bytes/s", String.valueOf(this.recvAvg.getTotal(true) / 10));
        if (!this.mismatchedHosts.isEmpty()) {
            p.setProperty("version-mismatch", this.mismatchedHosts.toString());
        }
        if (this.debug) {
            p.setProperty("peer-pings", this.hostPings.toString());
            p.setProperty("peer-receives", this.hostReceives.toString());
            p.setProperty("cached-services", this.getServiceList());
            p.setProperty("pending-services", this.getPendingList());
            p.setProperty("arbiter-mine", String.valueOf(this.arbiter.prePendingMine.size()));
            p.setProperty("arbiter-all", String.valueOf(this.arbiter.prePendingAll.size()));
        }
        return p;
    }

    protected String getServiceList() {
        HashSet<String> ids = new HashSet<String>();
        Iterator iter = new ArrayList(this.ecmMap.values()).iterator();
        while (iter.hasNext()) {
            CamdNetMessage msg = (CamdNetMessage)iter.next();
            ids.add(Integer.toHexString(msg.getServiceId()));
        }
        return ((Object)ids).toString();
    }

    protected String getPendingList() {
        HashSet<String> ids = new HashSet<String>();
        Iterator iter = new ArrayList(this.pendingEcms.keySet()).iterator();
        while (iter.hasNext()) {
            CamdNetMessage msg = (CamdNetMessage)iter.next();
            ids.add(Integer.toHexString(msg.getServiceId()));
        }
        return ((Object)ids).toString();
    }

    protected void removeRequest(CamdNetMessage request) {
        super.removeRequest(request);
        this.arbiter.cleanupArbitration(request);
    }

    public void onRemoveStale(CamdNetMessage msg) {
        this.arbiter.cleanupArbitration(msg);
    }

    public static class CachePeer {
        InetAddress addr;
        int port;

        CachePeer(InetAddress addr, int port) {
            this.addr = addr;
            this.port = port;
        }

        CachePeer(String[] s) throws UnknownHostException {
            this(InetAddress.getByName(s[0]), Integer.parseInt(s[1]));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachePeer cachePeer = (CachePeer)o;
            return this.port == cachePeer.port && this.addr.equals(cachePeer.addr);
        }

        public int hashCode() {
            int result = this.addr.hashCode();
            result = 31 * result + this.port;
            return result;
        }

        public String toString() {
            return this.addr + ":" + this.port;
        }
    }

    static class RequestArbiter {
        Map prePendingMine = Collections.synchronizedMap(new MessageCacheMap(9000L));
        Map prePendingAll = Collections.synchronizedMap(new MessageCacheMap(9000L));

        RequestArbiter() {
        }

        boolean addForArbitration(int baseValue, CamdNetMessage request) {
            if (this.prePendingMine.containsKey(request)) {
                return false;
            }
            Double d = new Double(Math.random() + (double)baseValue);
            request.setArbiterNumber(d);
            this.prePendingMine.put(request, d);
            this.addArbitrationPeer(request);
            return true;
        }

        void addArbitrationPeer(CamdNetMessage request) {
            Set<Double> allNumbers = new TreeSet();
            if (this.prePendingAll.containsKey(request)) {
                allNumbers = (Set)this.prePendingAll.get(request);
            } else {
                this.prePendingAll.put(request, allNumbers);
            }
            allNumbers.add(request.getArbiterNumber());
        }

        boolean resolveArbitration(CamdNetMessage request) {
            Double mine = (Double)this.prePendingMine.get(request);
            TreeSet all = (TreeSet)this.prePendingAll.get(request);
            if (mine == null || all == null) {
                return true;
            }
            Double winner = (Double)all.first();
            return mine.equals(winner);
        }

        void cleanupArbitration(CamdNetMessage request) {
            this.prePendingMine.remove(request);
            this.prePendingAll.remove(request);
        }
    }
}

