/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv;

import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.MessageCacheMap;
import com.bowman.cardserv.interfaces.CacheHandler;
import com.bowman.cardserv.interfaces.CacheListener;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.util.ProxyXmlConfig;
import java.util.Properties;

public class DefaultCache
implements CacheHandler {
    protected ProxyLogger logger = ProxyLogger.getLabeledLogger(this.getClass().getName());
    protected MessageCacheMap pendingEcms;
    protected MessageCacheMap ecmMap;
    protected CacheListener listener;
    protected CacheListener monitor;
    protected long maxAge;
    private long maxCacheWait;
    private int maxWaitPercent;
    private int timeouts;
    private int instantHits;
    private int waitHits;
    private int remoteHits;
    private int pendingPeak;

    public void configUpdated(ProxyXmlConfig xml) throws ConfigException {
        this.maxAge = xml.getTimeValue("cw-max-age", "s");
        String maxWaitStr = xml.getStringValue("max-cache-wait");
        if (maxWaitStr.endsWith("%")) {
            this.maxCacheWait = -1L;
            maxWaitStr = maxWaitStr.substring(0, maxWaitStr.length() - 1);
            this.maxWaitPercent = Integer.parseInt(maxWaitStr);
            if (this.maxWaitPercent < 1 || this.maxWaitPercent > 100) {
                throw new ConfigException(xml.getFullName(), "max-cache-wait", "Must be a time value or 1-100%");
            }
        } else {
            this.maxWaitPercent = -1;
            this.maxCacheWait = xml.getTimeValue("max-cache-wait", "s");
        }
        if (this.pendingEcms == null) {
            this.pendingEcms = new MessageCacheMap(this.maxAge);
        } else {
            this.pendingEcms.setMaxAge(this.maxAge);
        }
        if (this.ecmMap == null) {
            this.ecmMap = new MessageCacheMap(this.maxAge);
        } else {
            this.ecmMap.setMaxAge(this.maxAge);
        }
        this.pendingPeak = 0;
    }

    public long getMaxCacheWait(long maxCwWait) {
        if (this.maxCacheWait == -1L) {
            return (long)((double)this.maxWaitPercent / 100.0 * (double)maxCwWait);
        }
        return Math.min(maxCwWait, this.maxCacheWait);
    }

    public void start() {
        this.timeouts = 0;
        this.instantHits = 0;
        this.waitHits = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CamdNetMessage processRequest(int successFactor, CamdNetMessage request, boolean alwaysWait, long maxCwWait) {
        long start = System.currentTimeMillis();
        long maxWait = this.getMaxCacheWait(maxCwWait);
        DefaultCache defaultCache = this;
        synchronized (defaultCache) {
            boolean waited = false;
            boolean alerted = false;
            if (!this.ecmMap.containsKey(request)) {
                String origin;
                if (alwaysWait && !this.pendingEcms.containsKey(request)) {
                    this.addRequest(successFactor, request, alwaysWait);
                }
                if (this.listener != null && !this.pendingEcms.containsKey(request) && this.listener.lockRequest(successFactor, request)) {
                    this.addRequest(successFactor, request, true);
                }
                while (this.pendingEcms.containsKey(request) && ((origin = ((CamdNetMessage)this.pendingEcms.get(request)).getOriginAddress()) == null || !origin.equals(request.getRemoteAddress()))) {
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    long delay = System.currentTimeMillis() - start;
                    this.logger.finest("Waited for " + request.hashCodeStr() + " in cache: " + delay + " ms");
                    waited = true;
                    if (!alerted && delay >= maxWait / 2L) {
                        alerted = true;
                        if (!this.ecmMap.containsKey(request)) {
                            this.delayAlert(successFactor, request, alwaysWait, maxWait);
                        }
                    }
                    if (delay < maxWait) continue;
                    break;
                }
            }
            request.setCacheTime(request.getCacheTime() + (System.currentTimeMillis() - start));
            if (this.ecmMap.containsKey(request)) {
                CamdNetMessage reply = new CamdNetMessage((CamdNetMessage)this.ecmMap.get(request));
                if (request.getServiceId() != 0) {
                    reply.setServiceId(request.getServiceId());
                }
                if (waited) {
                    ++this.waitHits;
                    reply.setInstant(false);
                } else {
                    ++this.instantHits;
                    reply.setInstant(true);
                }
                if (reply.getOriginAddress() != null) {
                    ++this.remoteHits;
                }
                return reply;
            }
            if (waited) {
                this.pendingEcms.remove(request);
                ++this.timeouts;
                request.setTimeOut(true);
                return null;
            }
            this.addRequest(successFactor, request, alwaysWait);
            return null;
        }
    }

    protected void delayAlert(int successFactor, CamdNetMessage request, boolean alwaysWait, long maxWait) {
    }

    public synchronized boolean processReply(CamdNetMessage request, CamdNetMessage reply) {
        if (this.monitor != null) {
            this.monitor.onReply(request, reply);
        }
        if (reply == null || reply.isEmpty()) {
            this.removeRequest(request);
            this.notifyAll();
        } else {
            if (this.listener != null) {
                this.listener.onReply(request, reply);
            }
            if (this.pendingEcms.containsKey(request)) {
                this.addReply(request, reply);
                this.logger.finer("Reply received: " + request.hashCodeStr() + " -> " + reply.hashCodeStr() + " (pending: " + this.pendingEcms.size() + ")");
                this.removeRequest(request);
                this.notifyAll();
                return true;
            }
            this.addReply(request, reply);
        }
        return false;
    }

    public CamdNetMessage peekReply(CamdNetMessage request) {
        return (CamdNetMessage)this.ecmMap.get(request);
    }

    public Properties getUsageStats() {
        Properties p = new Properties();
        p.setProperty("pending-ecms", String.valueOf(this.pendingEcms.size()) + " (peak: " + this.pendingPeak + ")");
        p.setProperty("cached-ecms", String.valueOf(this.ecmMap.size()));
        p.setProperty("timeouts", String.valueOf(this.timeouts));
        p.setProperty("instant-hits", String.valueOf(this.instantHits));
        p.setProperty("wait-hits", String.valueOf(this.waitHits));
        if (this.remoteHits > 0) {
            p.setProperty("remote-hits", String.valueOf(this.remoteHits));
        }
        return p;
    }

    protected synchronized boolean contains(CamdNetMessage request) {
        return this.ecmMap.containsKey(request);
    }

    protected synchronized boolean containsPending(CamdNetMessage request) {
        return this.pendingEcms.containsKey(request);
    }

    protected synchronized void addRequest(int successFactor, CamdNetMessage request, boolean alwaysWait) {
        CamdNetMessage oldRequest = this.pendingEcms.put(request, request);
        if (this.pendingEcms.size() > this.pendingPeak) {
            this.pendingPeak = this.pendingEcms.size();
        }
        if (oldRequest == null) {
            if (this.monitor != null) {
                this.monitor.onRequest(successFactor, request);
            }
            if (this.listener != null) {
                this.listener.onRequest(successFactor, request);
            }
        }
    }

    protected synchronized void addReply(CamdNetMessage request, CamdNetMessage reply) {
        CamdNetMessage oldReply;
        if (reply.isEmpty()) {
            return;
        }
        if (reply.getProfileName() == null) {
            reply.setProfileName(request.getProfileName());
        }
        if (reply.getNetworkId() == 0) {
            reply.setNetworkId(request.getNetworkId());
        }
        if ((oldReply = this.ecmMap.put(request, reply)) != null) {
            if (reply.getOriginAddress() != null) {
                this.logger.fine("Cache reply " + reply.hashCodeStr() + " late by: " + (reply.getTimeStamp() - oldReply.getTimeStamp()) + " ms");
            }
            if (!oldReply.equals(reply)) {
                if (!oldReply.equalsSingleDcw(reply)) {
                    this.logger.warning("Overwrote cache reply with different DCW! - Previous: " + oldReply.toDebugString() + " Current: " + reply.toDebugString() + " (time difference: " + (reply.getTimeStamp() - oldReply.getTimeStamp()) + "ms)");
                } else if (oldReply.hasZeroDcw() || reply.hasZeroDcw()) {
                    this.logger.info("Overwrote cache reply with reply that has a different opposing DCW - Previous: " + oldReply.toDebugString() + " Current: " + reply.toDebugString());
                } else {
                    this.logger.warning("Overwrote cache reply with reply that has a different opposing DCW - Previous: " + oldReply.toDebugString() + " Current: " + reply.toDebugString());
                }
            }
        }
    }

    protected void removeRequest(CamdNetMessage request) {
        this.pendingEcms.remove(request);
    }

    public void setListener(CacheListener listener) {
        this.listener = listener;
    }

    public CacheListener getListener() {
        return this.listener;
    }

    public void setMonitor(CacheListener monitor) {
        this.monitor = monitor;
    }

    public CacheListener getMonitor() {
        return this.monitor;
    }
}

