/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.session;

import com.bowman.cardserv.CamdNetMessage;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.cws.ServiceMapping;
import com.bowman.cardserv.interfaces.ProxySession;
import com.bowman.cardserv.interfaces.UserStatusListener;
import com.bowman.cardserv.session.SeenEntry;
import com.bowman.cardserv.tv.TvService;
import com.bowman.cardserv.util.CustomFormatter;
import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.util.CronTimer;
import com.bowman.util.CronTimerListener;
import com.bowman.util.Globber;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class SessionManager
implements CronTimerListener {
    private static SessionManager instance = null;
    private Map sessions = new TreeMap();
    private Map sessionsByUser = new HashMap();
    private Map sessionsByProfile = new HashMap();
    private Map sessionsByIp = new HashMap();
    private Map users = new HashMap();
    private int counter = 1;
    private ProxyLogger logger;
    private ProxyConfig config;
    private Map seenMap = new HashMap();
    private Map failMap = new HashMap();
    private File seenFile;
    private List userStatusListeners = new ArrayList();
    private Map userStatusMap = new HashMap();
    private long changeTimeStamp;

    public static SessionManager getInstance() {
        if (instance == null) {
            instance = new SessionManager();
        }
        return instance;
    }

    private SessionManager() {
        this.logger = ProxyLogger.getLabeledLogger(this.getClass().getName());
        this.config = ProxyConfig.getInstance();
        this.seenFile = new File("etc", "seen.dat");
        if (this.seenFile.exists()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.seenFile)));
                this.seenMap = (Map)ois.readObject();
                try {
                    this.failMap = (Map)ois.readObject();
                }
                catch (Exception e) {
                    this.logger.throwing(e);
                    this.failMap = new HashMap();
                }
                this.logger.fine("Loaded seen-data, " + (this.seenMap.size() + this.failMap.size()) + " entries.");
                ois.close();
            }
            catch (Exception e) {
                this.logger.throwing(e);
                this.logger.warning("Failed to load seen-data ('" + this.seenFile.getPath() + "'): " + e);
            }
        }
        CronTimer seenTimer = new CronTimer("* * * * *");
        seenTimer.addTimerListener(this);
        seenTimer.start();
    }

    public int getNewSessionId() {
        return this.counter++;
    }

    public synchronized void addSession(ProxySession session) {
        if (session != null) {
            this.sessions.put(String.valueOf(session.getId()), session);
            this.addSessionLookup(session, session.getProfileName(), this.sessionsByProfile);
            this.addSessionLookup(session, session.getRemoteAddress(), this.sessionsByIp);
            if (session.getUser() != null) {
                if (!session.isTempUser()) {
                    this.seenUserLogin(session.getUser(), session.getProfileName(), session.getRemoteAddress());
                }
                this.addSessionLookup(session, session.getUser(), this.sessionsByUser);
                this.fireUserLogin(session.getUser(), session.getProfileName(), session.getRemoteAddress(), SessionManager.getSessionIdStr(session));
            }
        }
    }

    private void addSessionLookup(ProxySession session, String key, Map map) {
        ArrayList<ProxySession> sessions = (ArrayList<ProxySession>)map.get(key);
        if (sessions == null) {
            sessions = new ArrayList<ProxySession>();
            map.put(key, sessions);
        }
        sessions.add(session);
    }

    public synchronized void removeSession(ProxySession session) {
        if (session != null) {
            this.userStatusMap.remove(session.toString());
            this.removeSessionLookup(session, session.getProfileName(), this.sessionsByProfile);
            this.removeSessionLookup(session, session.getRemoteAddress(), this.sessionsByIp);
            if (this.sessions.remove(String.valueOf(session.getId())) != null && session.getUser() != null) {
                if (!session.isTempUser()) {
                    this.seenUserLogout(session.getUser(), session.getProfileName());
                }
                this.removeSessionLookup(session, session.getUser(), this.sessionsByUser);
                this.fireUserLogout(session.getUser(), session.getProfileName(), SessionManager.getSessionIdStr(session));
            }
        }
    }

    private void removeSessionLookup(ProxySession session, String key, Map map) {
        List sessions = (List)map.get(key);
        if (sessions != null) {
            sessions.remove(session);
            if (sessions.isEmpty()) {
                map.remove(key);
            }
        } else {
            this.logger.fine("No sessions for ip: " + key + " (" + session + " " + session.getUser() + ")");
            this.logger.throwing(new Throwable());
        }
    }

    public synchronized int countSessionsIP(String ip, String profileName) {
        int count = 0;
        List ipSessions = (List)this.sessionsByIp.get(ip);
        if (ipSessions != null) {
            if (profileName == null) {
                return ipSessions.size();
            }
            Iterator iter = ipSessions.iterator();
            while (iter.hasNext()) {
                if (!profileName.equals(((ProxySession)iter.next()).getProfileName())) continue;
                ++count;
            }
        }
        return count;
    }

    public synchronized List getSessionsIP(String ip) {
        return (List)this.sessionsByIp.get(ip);
    }

    int countSessions(String user, String profileName) {
        int count = 0;
        List userSessions = (List)this.sessionsByUser.get(user);
        if (userSessions != null) {
            if (profileName == null) {
                return userSessions.size();
            }
            Iterator iter = userSessions.iterator();
            while (iter.hasNext()) {
                if (!profileName.equals(((ProxySession)iter.next()).getProfileName())) continue;
                ++count;
            }
        }
        return count;
    }

    synchronized int syncCountSessions(String user, String profileName) {
        return this.countSessions(user, profileName);
    }

    synchronized ProxySession hasSession(String user, String className) {
        List userSessions = (List)this.sessionsByUser.get(user);
        if (userSessions != null) {
            Iterator iter = userSessions.iterator();
            while (iter.hasNext()) {
                ProxySession session = (ProxySession)iter.next();
                if (!className.equals(session.getClass().getName())) continue;
                return session;
            }
        }
        return null;
    }

    synchronized long closeOldestSession(String key, boolean ip, String profileName) {
        ProxySession session;
        ArrayList existingSessions = (ArrayList)(ip ? this.sessionsByIp.get(key) : this.sessionsByUser.get(key));
        if (existingSessions == null) {
            return -1L;
        }
        existingSessions = new ArrayList(existingSessions);
        if ("*".equals(profileName)) {
            profileName = null;
        }
        if (profileName != null) {
            Iterator iter = existingSessions.iterator();
            while (iter.hasNext()) {
                session = (ProxySession)iter.next();
                if (session.getProfileName().equals(profileName)) continue;
                iter.remove();
            }
            if (existingSessions.isEmpty()) {
                return -1L;
            }
        }
        if (existingSessions.size() > 1) {
            Collections.sort(existingSessions, new Comparator(){

                public int compare(Object a, Object b) {
                    ProxySession pa = (ProxySession)a;
                    ProxySession pb = (ProxySession)b;
                    return new Long(pb.getIdleTime()).compareTo(new Long(pa.getIdleTime()));
                }
            });
        }
        session = (ProxySession)existingSessions.get(0);
        long idleTime = session.getIdleTime();
        session.close();
        return idleTime;
    }

    synchronized boolean checkSessionIP(String user, String ip) {
        if ("0.0.0.0".equals(ip)) {
            return false;
        }
        List sessions = (List)this.sessionsByUser.get(user);
        if (sessions == null || sessions.isEmpty()) {
            return false;
        }
        Iterator iter = new ArrayList(sessions).iterator();
        while (iter.hasNext()) {
            ProxySession session = (ProxySession)iter.next();
            if (session == null || ip.equals(session.getRemoteAddress())) continue;
            if (!"0.0.0.0".equals(session.getRemoteAddress())) {
                if (session.isActive()) {
                    return true;
                }
                session.close();
                continue;
            }
            session.close();
        }
        return false;
    }

    public synchronized int getSessionCount() {
        return this.sessions.size();
    }

    public synchronized int getSessionCount(String profileName) {
        if (profileName == null) {
            return this.getSessionCount();
        }
        List sessions = (List)this.sessionsByProfile.get(profileName);
        if (sessions != null) {
            return sessions.size();
        }
        return 0;
    }

    public List getActiveSessions() {
        return this.getSessions(null, Boolean.TRUE);
    }

    public List getActiveSessions(String profileName) {
        return this.getSessions(profileName, Boolean.TRUE);
    }

    public List getInactiveSessions() {
        return this.getSessions(null, Boolean.FALSE);
    }

    public List getInactiveSessions(String profileName) {
        return this.getSessions(profileName, Boolean.FALSE);
    }

    public synchronized List getSessionsForUser(String user) {
        if (this.sessionsByUser.containsKey(user)) {
            return new ArrayList((List)this.sessionsByUser.get(user));
        }
        return null;
    }

    public synchronized List getSessions() {
        return new ArrayList(this.sessions.values());
    }

    public List getSessions(String profileName) {
        return this.getSessions(profileName, null);
    }

    synchronized List getSessions(String profileName, Boolean active) {
        List sessions;
        ArrayList<ProxySession> activeSessions = new ArrayList<ProxySession>();
        if (profileName == null) {
            sessions = this.getSessions();
        } else {
            sessions = (List)this.sessionsByProfile.get(profileName);
            if (sessions == null || sessions.isEmpty()) {
                return activeSessions;
            }
            sessions = new ArrayList(sessions);
        }
        if (active == null) {
            return sessions;
        }
        Iterator iter = sessions.iterator();
        while (iter.hasNext()) {
            ProxySession session = (ProxySession)iter.next();
            if (session == null || active.booleanValue() != session.isActive()) continue;
            activeSessions.add(session);
        }
        return activeSessions;
    }

    public synchronized ProxySession getSession(String id) {
        return (ProxySession)this.sessions.get(id);
    }

    public synchronized List getSeenData(String profileName) {
        ArrayList<SeenEntry> entries = new ArrayList<SeenEntry>();
        Iterator iter = new ArrayList(this.seenMap.values()).iterator();
        while (iter.hasNext()) {
            SeenEntry se = (SeenEntry)iter.next();
            if (this.users.containsKey(SessionManager.getKey(se.name, se.profile))) continue;
            if (profileName == null) {
                entries.add(se);
                continue;
            }
            if (!profileName.equals(se.profile)) continue;
            entries.add(se);
        }
        return entries;
    }

    public synchronized List getFailData() {
        return new ArrayList(this.failMap.values());
    }

    void seenUserLogin(String name, String profile, String hostAddr) {
        SeenEntry se = this.getSeenEntry(name, profile);
        se.setLastLogin(System.currentTimeMillis());
        se.setHostAddr(hostAddr);
        this.incrementUsersMap(name, profile);
    }

    void seenUserFail(String name, String profile, String hostAddr, String reason) {
        SeenEntry se = this.getFailEntry(name, profile);
        se.setLastLogin(System.currentTimeMillis());
        se.setHostAddr(hostAddr);
        se.setLastReason(reason);
        se.incCount();
    }

    void incrementUsersMap(String name, String profile) {
        String key = SessionManager.getKey(name, profile);
        Integer count = (Integer)this.users.get(key);
        count = count == null ? new Integer(1) : new Integer(count + 1);
        this.users.put(key, count);
    }

    void seenUserLogout(String name, String profile) {
        this.getSeenEntry(name, profile).setLastLogout(System.currentTimeMillis());
        this.decrementUsersMap(name, profile);
    }

    void decrementUsersMap(String name, String profile) {
        String key = SessionManager.getKey(name, profile);
        Integer count = (Integer)this.users.get(key);
        if (count != null) {
            if ((count = new Integer(count - 1)) < 1) {
                this.users.remove(key);
            } else {
                this.users.put(key, count);
            }
        }
    }

    synchronized SeenEntry getSeenEntry(String name, String profile) {
        String key = SessionManager.getKey(name, profile);
        SeenEntry se = (SeenEntry)this.seenMap.get(key);
        if (se == null) {
            se = new SeenEntry(name, profile);
            this.seenMap.put(key, se);
        }
        this.changeTimeStamp = System.currentTimeMillis();
        return se;
    }

    synchronized SeenEntry getFailEntry(String name, String profile) {
        String key = SessionManager.getKey(name, profile);
        SeenEntry se = (SeenEntry)this.failMap.get(key);
        if (se == null) {
            se = new SeenEntry(name, profile);
            se.setLastLogout(System.currentTimeMillis());
            this.failMap.put(key, se);
        }
        this.changeTimeStamp = System.currentTimeMillis();
        return se;
    }

    public synchronized int removeSeenUser(String name) {
        int removed = 0;
        if (name == null) {
            removed = this.seenMap.size();
            this.seenMap.clear();
        } else {
            Iterator iter = this.seenMap.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (!name.equalsIgnoreCase(((SeenEntry)this.seenMap.get(key)).getName())) continue;
                iter.remove();
                ++removed;
            }
        }
        if (removed > 0) {
            this.changeTimeStamp = System.currentTimeMillis();
        }
        return removed;
    }

    public synchronized int removeLoginFailure(String mask) {
        int removed = 0;
        if (mask == null || "*".equals(mask)) {
            removed = this.failMap.size();
            this.failMap.clear();
        } else {
            Iterator iter = this.failMap.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String name = ((SeenEntry)this.failMap.get(key)).getName();
                if (!Globber.match(mask, name, false)) continue;
                iter.remove();
                ++removed;
            }
        }
        if (removed > 0) {
            this.changeTimeStamp = System.currentTimeMillis();
        }
        return removed;
    }

    private static String getKey(String name, String profile) {
        return name + ":" + profile;
    }

    protected static String getKey(ProxySession session) {
        return SessionManager.getKey(session.getUser(), session.getProfileName());
    }

    private static String getKey(SeenEntry se) {
        return SessionManager.getKey(se.name, se.profile);
    }

    public void timeout(CronTimer cronTimer) {
        this.saveSeenData();
        this.checkKeepAlives();
    }

    public synchronized void saveSeenData() {
        if (!this.seenFile.exists() || this.changeTimeStamp > this.seenFile.lastModified()) {
            long now = System.currentTimeMillis();
            Iterator iter = this.seenMap.values().iterator();
            while (iter.hasNext()) {
                SeenEntry se = (SeenEntry)iter.next();
                if (!this.users.containsKey(SessionManager.getKey(se))) continue;
                se.setLastSeen(now);
            }
            try {
                ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.seenFile)));
                oos.writeObject(this.seenMap);
                oos.writeObject(this.failMap);
                this.logger.fine("Saved seen-data, " + (this.seenMap.size() + this.failMap.size()) + " entries.");
                oos.close();
            }
            catch (IOException e) {
                this.logger.throwing(e);
                this.logger.warning("Failed to save seen-data ('" + this.seenFile.getPath() + "'): " + e);
            }
        }
    }

    public void checkKeepAlives() {
        long keepAlive = this.config.getSessionKeepAlive();
        if (keepAlive == 0L) {
            return;
        }
        this.logger.fine("Checking " + this.sessions.size() + " sessions for keep-alives...");
        Set clients = this.config.getKeepAliveExcludedClients();
        Iterator iter = this.getSessions().iterator();
        while (iter.hasNext()) {
            ProxySession session = (ProxySession)iter.next();
            if (session == null || session.getIdleTime() <= (long)this.config.getSessionKeepAlive() || clients.contains(session.getClientId().toLowerCase())) continue;
            try {
                long idleTime = session.getIdleTime();
                session.sendMessage(new CamdNetMessage(253));
                this.logger.fine("Keep-alive sent to " + session + " (was idle " + idleTime + " ms)");
            }
            catch (Exception e) {
                this.logger.warning("Failed to send keep-alive to " + session + " (" + e + ")");
                this.logger.throwing(e);
            }
        }
    }

    public void updateUserStatus(ProxySession session, CamdNetMessage msg, boolean debug) {
        if (!session.isConnected()) {
            return;
        }
        ServiceMapping id = new ServiceMapping(msg);
        Integer chanId = new Integer(id.serviceId);
        if (!chanId.equals(this.userStatusMap.get(session.toString()))) {
            if (this.userStatusMap.put(session.toString(), chanId) == null) {
                session.setFlag(msg, '1');
            } else {
                session.setFlag(msg, 'Z');
            }
            if (this.config.isLogZap() || debug) {
                this.logger.info("User '" + session.getUser() + "' (" + CustomFormatter.formatAddress(session.getRemoteAddress()) + ") now watching channel [" + this.config.getServiceName(msg) + "]");
            }
            TvService service = this.config.getService(msg);
            this.fireUserStatusChanged(session.getUser(), service, session.getProfileName(), SessionManager.getSessionIdStr(session));
        }
    }

    public void addUserStatusListener(UserStatusListener listener) {
        if (!this.userStatusListeners.contains(listener)) {
            this.userStatusListeners.add(listener);
        }
    }

    public void removeUserStatusListener(UserStatusListener listener) {
        this.userStatusListeners.remove(listener);
    }

    private void fireUserStatusChanged(String user, TvService service, String profile, String id) {
        Iterator iter = this.userStatusListeners.iterator();
        while (iter.hasNext()) {
            ((UserStatusListener)iter.next()).userStatusChanged(user, service, profile, id);
        }
    }

    private void fireUserLogin(String user, String profile, String ip, String id) {
        Iterator iter = this.userStatusListeners.iterator();
        while (iter.hasNext()) {
            ((UserStatusListener)iter.next()).userLogin(user, profile, ip, id);
        }
    }

    private void fireUserLogout(String user, String profile, String id) {
        Iterator iter = this.userStatusListeners.iterator();
        while (iter.hasNext()) {
            ((UserStatusListener)iter.next()).userLogout(user, profile, id);
        }
    }

    public void fireUserLoginFailed(String user, String profile, String ip, String reason) {
        this.seenUserFail(user, profile, ip, reason);
        Iterator iter = this.userStatusListeners.iterator();
        while (iter.hasNext()) {
            ((UserStatusListener)iter.next()).userLoginFailed(user, profile, ip, reason);
        }
    }

    public static String getSessionIdStr(ProxySession session) {
        return session.getProtocol() + "[" + session.getId() + "]";
    }
}

