/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.tv;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TvService
implements Serializable,
Comparable {
    public static final int TYPE_TV = 1;
    public static final int TYPE_RADIO = 2;
    public static final int TYPE_HDTV_MPEG2 = 17;
    public static final int TYPE_HDTV_MPEG4 = 25;
    public static final int TYPE_TV_SUB = 211;
    private final boolean unknown;
    private final int id;
    private final int number;
    private final int type;
    private int watchers;
    private final long namespace;
    private final long transponder;
    private long customData;
    private long networkId;
    private final String profileName;
    private String name;
    private String provider;
    private final List conflicting = new ArrayList();

    public TvService(int unknownSid, String profile) {
        this.id = unknownSid;
        this.namespace = -1L;
        this.transponder = -1L;
        this.networkId = -1L;
        this.type = 1;
        this.number = 100;
        this.unknown = true;
        this.profileName = profile;
        this.provider = "?";
        this.name = "Unknown (" + Integer.toHexString(unknownSid) + ")";
    }

    public TvService(TvService ts, long customData) {
        this(ts, customData, null);
    }

    public TvService(TvService ts, long customData, String profile) {
        this.id = ts.id;
        this.namespace = ts.namespace;
        this.transponder = ts.transponder;
        this.networkId = ts.networkId;
        this.type = ts.type;
        this.number = ts.number;
        this.unknown = ts.unknown;
        this.profileName = profile == null ? ts.profileName : profile;
        this.provider = ts.provider;
        this.name = ts.name;
        this.customData = customData;
    }

    public TvService(String[] tokens, String profile) {
        String sid = tokens[0].startsWith("0x") ? tokens[0].substring(2) : tokens[0];
        this.id = Integer.parseInt(sid, 16);
        this.namespace = Long.parseLong(tokens[1], 16);
        this.transponder = Long.parseLong(tokens[2], 16);
        this.networkId = Long.parseLong(tokens[3], 16);
        this.type = Integer.parseInt(tokens[4]);
        this.number = Integer.parseInt(tokens[5]);
        this.unknown = false;
        this.profileName = profile;
    }

    public TvService(int[] tokens, String profile) {
        this.id = tokens[0];
        this.namespace = tokens[1];
        this.transponder = tokens[2];
        this.networkId = tokens[3];
        this.type = tokens[4];
        this.number = tokens[5];
        this.unknown = false;
        this.profileName = profile;
    }

    public int getId() {
        return this.id;
    }

    public long getNamespace() {
        return this.namespace;
    }

    public int getNumber() {
        return this.number;
    }

    public long getTransponder() {
        return this.transponder;
    }

    public long getNetworkId() {
        return this.networkId;
    }

    public long getCustomData() {
        return this.customData;
    }

    public void setCustomData(long customData) {
        this.customData = customData;
    }

    public int getType() {
        return this.type;
    }

    public boolean isTv() {
        switch (this.type) {
            case 1: 
            case 2: 
            case 17: 
            case 25: 
            case 211: {
                return true;
            }
        }
        return false;
    }

    public String getName() {
        if (this.conflicting.isEmpty()) {
            return this.name;
        }
        return this.name + "?(" + this.conflicting.size() + ")?";
    }

    public String getDisplayName() {
        switch (this.type) {
            case 211: {
                return "[SUB]" + this.name;
            }
            case 2: {
                return "[R]" + this.name;
            }
            case 17: 
            case 25: {
                return "[HD]" + this.name;
            }
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public void setNetworkId(int networkId) {
        this.networkId = networkId;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public boolean isUnknown() {
        return this.unknown;
    }

    public String toEnigmaString() {
        StringBuffer sb = new StringBuffer(this.name);
        sb.append(' ').append(Integer.toHexString(this.id));
        sb.append(':').append(Long.toHexString(this.namespace));
        sb.append(':').append(Long.toHexString(this.transponder));
        sb.append(':').append(Long.toHexString(this.networkId));
        sb.append(':').append(this.type);
        sb.append(':').append(this.number);
        sb.append(" p: ").append(this.provider);
        return sb.toString();
    }

    public String toString() {
        return this.name + " " + this.profileName + ":" + Integer.toHexString(this.id);
    }

    public void setProviderStr(String prov) {
        String[] tokens = prov.split(",");
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].startsWith("p:")) continue;
            this.provider = tokens[i].substring(2).trim();
        }
    }

    public void addConflicting(TvService service) {
        this.conflicting.add(service);
    }

    public int getWatchers() {
        return this.watchers;
    }

    public void setWatchers(int watchers) {
        this.watchers = watchers;
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TvService tvService = (TvService)o;
        return this.id == tvService.id && this.profileName.equals(tvService.profileName);
    }

    public int hashCode() {
        int result = this.id;
        result = 29 * result + this.profileName.hashCode();
        return result;
    }

    public boolean isPPVSlot() {
        return this.name.startsWith("CH") && this.name.length() == 4;
    }

    public static TvService getUnknownService(String profileName, int unknownSid) {
        return new TvService(unknownSid, profileName);
    }
}

