/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.util;

import com.bowman.cardserv.util.ProxyLogger;
import com.bowman.cardserv.web.FileFetcher;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PluginClassLoader
extends ClassLoader {
    private ClassLoader parent = null;
    private JarFile jar;

    public PluginClassLoader(File jar, ClassLoader parent) throws IOException {
        if (jar == null || !jar.exists() || !jar.isFile()) {
            throw new IllegalArgumentException("Invalid jar file specified: " + jar.getAbsolutePath());
        }
        this.parent = parent;
        this.jar = new JarFile(jar);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> c = null;
        String fileName = name.replace('.', '/') + ".class";
        JarEntry classEntry = this.jar.getJarEntry(fileName);
        if (classEntry != null) {
            try {
                InputStream is = this.jar.getInputStream(classEntry);
                byte[] classData = this.loadClassData(is, classEntry.getSize());
                is.close();
                c = this.defineClass(name, classData, 0, classData.length);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ClassNotFoundException(name);
            }
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        return c;
    }

    private byte[] loadClassData(InputStream classData, long size) throws IOException {
        DataInputStream dis = new DataInputStream(classData);
        byte[] data = new byte[(int)size];
        dis.readFully(data);
        dis.close();
        return data;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        block3: {
            c = null;
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                if (this.parent == null) break block3;
                c = this.parent.loadClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public InputStream getResourceAsStream(String name) {
        JarEntry res = this.jar.getJarEntry(name);
        if (res != null) {
            try {
                return this.jar.getInputStream(res);
            }
            catch (IOException e) {
                return this.parent.getResourceAsStream(name);
            }
        }
        return this.parent.getResourceAsStream(name);
    }

    public void flush() {
        if (this.jar != null) {
            try {
                this.jar.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.parent = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void resolveDependencies(String[] urlStrings, ProxyLogger logger) throws IOException {
        URL[] urls = new URL[urlStrings.length];
        for (int i = 0; i < urlStrings.length; ++i) {
            urls[i] = new URL(urlStrings[i]);
            File jar = new File(urls[i].getFile());
            if (!(jar = new File("lib", jar.getName())).exists()) {
                if (logger != null) {
                    logger.info("Fetching dependency jar: " + urlStrings[i]);
                }
                FileFetcher.fetchBinary(urls[i], jar);
                if (jar.exists()) {
                    if (logger != null) {
                        logger.info("Successfully fetched: " + jar.getName());
                    }
                } else {
                    throw new IOException("Unknown error fetching jar: " + urlStrings[i]);
                }
            }
            urls[i] = jar.toURI().toURL();
        }
        if (logger != null) {
            logger.fine("Dependencies: " + Arrays.asList(urls));
        }
        this.parent = new URLClassLoader(urls, this.parent);
    }
}

