/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.util;

import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.util.ProxyXmlTracer;
import com.bowman.xml.XMLConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ProxyXmlConfig {
    private static ProxyXmlTracer tracer;
    private static Map timeSuffixes;
    private XMLConfig currentConfig;
    private XMLConfig overrides;
    private String name;
    private String fullName;
    private String parentPath;
    private Properties stringOverrides;

    private void trace(String name, Object def, String typeInfo) {
        StackTraceElement caller;
        if (tracer != null && (caller = this.getCallerStackFrame()) != null) {
            if (typeInfo == null) {
                tracer.trace(this.parentPath + "/" + this.name + "/" + name, null, null, null, caller);
            } else {
                tracer.trace(this.parentPath + "/" + this.name, name, def, typeInfo, caller);
            }
        }
    }

    private StackTraceElement getCallerStackFrame() {
        int index;
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        for (index = 0; index < stackTrace.length && !stackTrace[index].getClassName().equals(this.getClass().getName()); ++index) {
        }
        while (index < stackTrace.length && stackTrace[index].getClassName().equals(this.getClass().getName())) {
            ++index;
        }
        if (index > 3) {
            return null;
        }
        return index < stackTrace.length ? stackTrace[index] : null;
    }

    public ProxyXmlConfig(XMLConfig xml) {
        this.currentConfig = xml;
        this.name = this.currentConfig.getName();
        StringBuffer sb = new StringBuffer();
        String[] parents = this.currentConfig.getParentNames();
        for (int i = 0; i < parents.length; ++i) {
            sb.append('/').append(parents[i]);
        }
        this.parentPath = sb.toString();
        this.fullName = this.name + " (" + this.parentPath + ")";
    }

    public ProxyXmlConfig(String name, String parentPath) {
        this.fullName = name + " (" + parentPath + ")";
    }

    public ProxyXmlConfig(XMLConfig xml, ProxyXmlConfig overrides) {
        this(xml);
        this.setOverrides(overrides);
    }

    public void setOverrides(ProxyXmlConfig overrides) {
        this.overrides = overrides == null ? null : overrides.currentConfig;
    }

    public void setStringOverride(String key, String value) {
        if (this.stringOverrides == null) {
            this.stringOverrides = new Properties();
        }
        this.stringOverrides.put(key, value);
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getName() {
        return this.name;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    private XMLConfig getSubConfigInternal(String s) {
        XMLConfig x;
        if (this.overrides != null && (x = this.overrides.getSubConfig(s)) != null) {
            return x;
        }
        if (this.currentConfig == null) {
            return null;
        }
        return this.currentConfig.getSubConfig(s);
    }

    public ProxyXmlConfig getSubConfig(String s) throws ConfigException {
        this.trace(s, null, null);
        XMLConfig subConf = this.getSubConfigInternal(s);
        if (subConf == null) {
            throw new ConfigException(this.fullName, "Required element missing: " + s);
        }
        return new ProxyXmlConfig(subConf);
    }

    public Iterator getMultipleSubConfigs(String s) {
        if (s != null) {
            this.trace(s, null, null);
        }
        if (this.currentConfig == null) {
            return null;
        }
        Enumeration en = s != null ? this.currentConfig.getMultipleSubConfigs(s) : this.currentConfig.getAllSubConfigs();
        if (en == null) {
            return null;
        }
        ArrayList<ProxyXmlConfig> temp = new ArrayList<ProxyXmlConfig>();
        while (en.hasMoreElements()) {
            temp.add(new ProxyXmlConfig((XMLConfig)en.nextElement()));
        }
        return temp.iterator();
    }

    public Iterator getMultipleStrings(String s) {
        if (s != null) {
            this.trace(s, null, null);
        }
        if (this.currentConfig == null) {
            return null;
        }
        Enumeration en = this.currentConfig.getMultipleStrings(s);
        if (en == null) {
            return null;
        }
        ArrayList temp = new ArrayList();
        while (en.hasMoreElements()) {
            temp.add(en.nextElement());
        }
        return temp.iterator();
    }

    private String getString(String s) {
        String o;
        if (this.stringOverrides != null && this.stringOverrides.containsKey(s)) {
            return this.stringOverrides.getProperty(s);
        }
        if (this.overrides != null && (o = this.overrides.getString(s)) != null) {
            return o;
        }
        if (this.currentConfig == null) {
            return null;
        }
        return this.currentConfig.getString(s);
    }

    public String getStringValue(String s, String def) throws ConfigException {
        this.trace(s, def, "String");
        String value = this.getString(s);
        if (value == null) {
            value = def;
        }
        if (value == null) {
            throw new ConfigException(this.fullName, "Required value missing: " + s);
        }
        return value;
    }

    public String getStringValue(String s) throws ConfigException {
        this.trace(s, null, "String");
        return this.getStringValue(s, null);
    }

    public String getContents() {
        if (this.currentConfig == null) {
            return null;
        }
        return this.currentConfig.getContents();
    }

    public int getPortValue(String s) throws ConfigException {
        this.trace(s, null, "Portnumber");
        int port = this.getIntValue(s);
        if (port < 1 || port >= 65535) {
            throw new ConfigException(this.fullName, "Parameter '" + s + "' has an invalid port value: " + port);
        }
        return port;
    }

    public int getPortValue(String s, int def) throws ConfigException {
        this.trace(s, new Integer(def), "Portnumber");
        int port = this.getIntValue(s, def);
        if (port == def && def == -1) {
            return port;
        }
        if (port < 1 || port >= 65535) {
            throw new ConfigException(this.fullName, "Parameter '" + s + "' has an invalid port value: " + port);
        }
        return port;
    }

    public int getIntValue(String s, int def) throws ConfigException {
        this.trace(s, new Integer(def), "Integer");
        try {
            int i;
            String intStr = this.getString(s);
            int n = i = intStr == null ? def : Integer.parseInt(intStr);
            if (def != i && i < 0) {
                throw new NumberFormatException(i + " must be positive");
            }
            return i;
        }
        catch (NumberFormatException e) {
            throw new ConfigException(this.fullName, "Parameter '" + s + "' has an invalid integer value: " + e.getMessage(), e);
        }
    }

    public int getIntValue(String s) throws ConfigException {
        this.trace(s, null, "Integer");
        try {
            int i = Integer.parseInt(this.getStringValue(s, null));
            if (i < 0) {
                throw new NumberFormatException(i + " must be positive");
            }
            return i;
        }
        catch (NumberFormatException e) {
            throw new ConfigException(this.fullName, "Parameter '" + s + "' has an invalid integer value: " + e.getMessage(), e);
        }
    }

    public int getTimeValue(String s, int def, String defSuffix) throws ConfigException {
        int mp;
        this.trace(s, new Integer(def), "Time (defSuffix=" + defSuffix + ")");
        String timeStr = this.getStringValue(s, def == -1 ? null : String.valueOf(def));
        if (timeStr.endsWith("ms")) {
            mp = ProxyXmlConfig.getTimeMp("ms");
            timeStr = timeStr.substring(0, timeStr.length() - 2);
        } else if (timeStr.endsWith("s")) {
            mp = ProxyXmlConfig.getTimeMp("s");
            timeStr = timeStr.substring(0, timeStr.length() - 1);
        } else if (timeStr.endsWith("m")) {
            mp = ProxyXmlConfig.getTimeMp("m");
            timeStr = timeStr.substring(0, timeStr.length() - 1);
        } else {
            mp = ProxyXmlConfig.getTimeMp(defSuffix);
        }
        if (mp == -1) {
            throw new ConfigException(this.fullName, "Invalid default suffix when retrieving '" + s + "': " + defSuffix);
        }
        try {
            int t = Integer.parseInt(timeStr.trim()) * mp;
            if (t < 0) {
                throw new NumberFormatException(t + " must be positive");
            }
            return t;
        }
        catch (NumberFormatException e) {
            throw new ConfigException(this.fullName, "Parameter '" + s + "' has an invald time value: " + e.getMessage() + "(supported suffixes are m, s and ms)", e);
        }
    }

    public int getTimeValue(String s, String defSuffix) throws ConfigException {
        return this.getTimeValue(s, -1, defSuffix);
    }

    private static int getTimeMp(String suffix) {
        Integer mp = (Integer)timeSuffixes.get(suffix);
        if (mp == null) {
            return -1;
        }
        return mp;
    }

    public String getFileValue(String s, boolean create) throws ConfigException {
        this.trace(s, null, "File (create=" + create + ")");
        return this.getFileValue(s, null, create, false);
    }

    public String getFileValue(String s, String def, boolean create) throws ConfigException {
        this.trace(s, def, "File (create=" + create + ")");
        return this.getFileValue(s, def, create, false);
    }

    public String getFileValue(String s, boolean create, boolean dir) throws ConfigException {
        this.trace(s, null, "File (create=" + create + " dir=" + dir + ")");
        return this.getFileValue(s, null, create, dir);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getFileValue(String s, String def, boolean create, boolean dir) throws ConfigException {
        this.trace(s, def, "File (create=" + create + " dir=" + dir + ")");
        String fileName = this.getStringValue(s, def);
        File file = new File(fileName);
        File parentDir = file.getParentFile();
        if (!create) {
            if (!file.exists() || !file.canRead()) throw new ConfigException(this.fullName, "Unable to find/read from: " + file.getAbsolutePath());
            if (!dir || file.isDirectory()) return fileName;
            throw new ConfigException(this.fullName, "Not a directory: " + file.getAbsolutePath());
        }
        if (parentDir != null) {
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            if (!parentDir.exists()) {
                throw new ConfigException(this.fullName, "Unable to create directory: " + parentDir.getAbsolutePath());
            }
        }
        if (file.exists()) {
            if (!file.canRead() || !file.canWrite()) throw new ConfigException(this.fullName, "Unable to read/write: " + file.getAbsolutePath());
            if (!dir || file.isDirectory()) return fileName;
            throw new ConfigException(this.fullName, "Not a directory: " + file.getAbsolutePath());
        }
        try {
            if (!(!dir ? !file.createNewFile() : !file.mkdirs())) return fileName;
            throw new IOException();
        }
        catch (IOException e) {
            throw new ConfigException(this.fullName, "Unable to create " + (dir ? "dir" : "file") + ": " + file.getAbsolutePath(), e);
        }
    }

    public byte[] getBytesValue(String s) throws ConfigException {
        this.trace(s, null, "Bytes");
        String byteStr = this.getStringValue(s, null);
        String[] parts = byteStr.split(" ");
        byte[] bytes = new byte[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].length() != 2) {
                throw new ConfigException(this.fullName, "Bad byte value '" + parts[i] + "' in '" + s + "' (must be 2 digit hex value)");
            }
            try {
                int tmp = Integer.parseInt(parts[i], 16);
                if (tmp < 0 || tmp > 255) {
                    throw new NumberFormatException();
                }
                bytes[i] = (byte)(tmp & 0xFF);
                continue;
            }
            catch (NumberFormatException e) {
                throw new ConfigException(this.fullName, "Bad byte value '" + parts[i] + "' in '" + s + "' (must be 00-FF)");
            }
        }
        return bytes;
    }

    public static Set getIntTokens(String param, String list) throws ConfigException {
        HashSet<Integer> result = new HashSet<Integer>();
        String[] tokens = list.split(" ");
        for (int i = 0; i < tokens.length; ++i) {
            try {
                result.add(new Integer(Integer.parseInt(tokens[i], 16)));
                continue;
            }
            catch (NumberFormatException e) {
                throw new ConfigException(param, "Bad hex integer value: " + e.getMessage());
            }
        }
        return result;
    }

    public Properties toProperties() {
        if (this.currentConfig == null) {
            return new Properties();
        }
        return this.currentConfig.flatten();
    }

    public String toString() {
        return this.toProperties().toString();
    }

    static {
        if ("true".equalsIgnoreCase(System.getProperty("com.bowman.cardserv.util.tracexmlcfg"))) {
            tracer = new ProxyXmlTracer();
        }
        timeSuffixes = new HashMap();
        timeSuffixes.put("m", new Integer(60000));
        timeSuffixes.put("s", new Integer(1000));
        timeSuffixes.put("ms", new Integer(1));
    }
}

