/*
 * Decompiled with CFR 0.152.
 */
package com.bowman.cardserv.web;

import com.bowman.cardserv.CaProfile;
import com.bowman.cardserv.CardServProxy;
import com.bowman.cardserv.ConfigException;
import com.bowman.cardserv.ProxyConfig;
import com.bowman.cardserv.cws.ServiceMapping;
import com.bowman.cardserv.interfaces.CommandManager;
import com.bowman.cardserv.rmi.CacheStatus;
import com.bowman.cardserv.rmi.CwsStatus;
import com.bowman.cardserv.rmi.PluginStatus;
import com.bowman.cardserv.rmi.PortStatus;
import com.bowman.cardserv.rmi.ProfileStatus;
import com.bowman.cardserv.rmi.RemoteEvent;
import com.bowman.cardserv.rmi.RemoteProxy;
import com.bowman.cardserv.rmi.SessionStatus;
import com.bowman.cardserv.rmi.UserStatus;
import com.bowman.cardserv.session.SeenEntry;
import com.bowman.cardserv.session.SessionManager;
import com.bowman.cardserv.tv.TvService;
import com.bowman.cardserv.util.CustomFormatter;
import com.bowman.cardserv.util.ProxyXmlConfig;
import com.bowman.cardserv.util.UnixUtil;
import com.bowman.cardserv.util.XmlStringBuffer;
import com.bowman.cardserv.web.Command;
import com.bowman.cardserv.web.CtrlCommand;
import com.bowman.cardserv.web.CtrlCommandResult;
import com.bowman.cardserv.web.StatusCommand;
import com.bowman.cardserv.web.WebBackend;
import com.bowman.xml.XMLConfig;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class XmlHelper
implements CommandManager {
    private static final SimpleDateFormat rfc822fmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
    private static final String[] CWS_STATES = new String[]{"disconnected", "connected", "connecting", "", "unresponsive", "disabled"};
    private static boolean checkFileDescriptors = true;
    private RemoteProxy proxy;
    private WebBackend webBackend;
    Map ctrlCommands = new LinkedHashMap();
    Map statusCommands = new LinkedHashMap();

    public XmlHelper(WebBackend webBackend) {
        this.proxy = webBackend.proxy;
        this.webBackend = webBackend;
        this.registerCommands();
    }

    void registerCommands() {
        Command.setManager(this);
        try {
            XmlHelper.registerControlCommands(WebBackend.class.getResourceAsStream("ctrl-commands.xml"), this, "Internal");
        }
        catch (Exception e) {
            this.webBackend.logger.severe("Failed to load/parse internal control commands (ctrl-commands.xml).", e);
        }
        try {
            XmlHelper.registerStatusCommands(WebBackend.class.getResourceAsStream("status-commands.xml"), this, "Internal");
        }
        catch (Exception e) {
            this.webBackend.logger.severe("Failed to load/parse internal status commands (status-commands.xml).", e);
        }
    }

    public static Set registerStatusCommands(InputStream is, Object handler, String label) throws Exception {
        ProxyXmlConfig cmdDefs = new ProxyXmlConfig(new XMLConfig(is, false, "UTF-8"));
        HashSet<StatusCommand> commands = new HashSet<StatusCommand>();
        Iterator iter = cmdDefs.getMultipleSubConfigs("command");
        while (iter.hasNext()) {
            StatusCommand cmd = StatusCommand.createFromXml((ProxyXmlConfig)iter.next());
            cmd.register(handler, label);
            commands.add(cmd);
        }
        return commands;
    }

    public static Set registerControlCommands(InputStream is, Object handler, String label) throws Exception {
        ProxyXmlConfig cmdDefs = new ProxyXmlConfig(new XMLConfig(is, false, "UTF-8"));
        HashSet<CtrlCommand> commands = new HashSet<CtrlCommand>();
        Iterator iter = cmdDefs.getMultipleSubConfigs("command");
        while (iter.hasNext()) {
            CtrlCommand cmd = CtrlCommand.createFromXml((ProxyXmlConfig)iter.next());
            cmd.register(handler, label);
            commands.add(cmd);
        }
        return commands;
    }

    Set getServices(String[] profiles) throws RemoteException {
        return this.getServices(profiles, false);
    }

    Set getServices(String[] profiles, boolean includeParsed) throws RemoteException {
        TvService[] services;
        CwsStatus[] connectors = this.proxy.getMultiCwsStatus(profiles);
        HashSet<TvService> canDecode = new HashSet<TvService>();
        HashSet<TvService> cannotDecode = new HashSet<TvService>();
        for (int i = 0; i < connectors.length; ++i) {
            services = this.proxy.getServices(connectors[i].getName(), false);
            if (services != null) {
                canDecode.addAll(Arrays.asList(services));
            }
            if (!includeParsed || (services = this.proxy.getCannotDecodeServices(connectors[i].getName())) == null) continue;
            cannotDecode.addAll(Arrays.asList(services));
        }
        if (includeParsed) {
            cannotDecode.removeAll(canDecode);
            services = this.proxy.getParsedServices(profiles);
            if (services != null) {
                HashSet<TvService> open = new HashSet<TvService>(Arrays.asList(services));
                Iterator iter = open.iterator();
                block4: while (iter.hasNext()) {
                    TvService srv = (TvService)iter.next();
                    switch (srv.getType()) {
                        case 1: 
                        case 17: 
                        case 25: {
                            continue block4;
                        }
                    }
                    iter.remove();
                }
                open.removeAll(cannotDecode);
                open.removeAll(canDecode);
                canDecode.addAll(open);
            }
        }
        return canDecode;
    }

    public String onQryStatusCommand(String cmd, Map params, String authUser) throws RemoteException {
        XmlStringBuffer xb = new XmlStringBuffer();
        xb.appendElement("cws-status-resp", "ver", "1.0");
        String profile = (String)params.get("profile");
        ProfileStatus[] ps = this.proxy.getUserProfiles(authUser);
        if (ps == null) {
            ps = this.proxy.getProfiles();
        }
        String[] profiles = XmlHelper.getProfileNames(ps, profile);
        params.put("ps", ps);
        params.put("profiles", profiles);
        this.runStatusCmd(cmd, xb, params, authUser);
        xb.closeElement("cws-status-resp");
        return xb.toString();
    }

    public String onQryControlCommand(String cmd, Map params, String authUser) throws RemoteException {
        XmlStringBuffer xb = new XmlStringBuffer();
        xb.appendElement("cws-command-resp", "ver", "1.0");
        if (!this.proxy.isAdmin(authUser)) {
            this.appendCmdResult(cmd, new CtrlCommandResult(false, "Admin user required.", null), xb);
        } else {
            this.appendCmdResult(cmd, this.runCtrlCmd(cmd, params, authUser), xb);
        }
        xb.closeElement("cws-command-resp");
        return xb.toString();
    }

    private void appendCmdResult(String cmd, CtrlCommandResult res, XmlStringBuffer xb) {
        xb.appendElement("cmd-result", "command", cmd);
        xb.appendAttr("success", res.success);
        if (res.data != null) {
            xb.appendAttr("data", res.data.toString());
        }
        xb.endElement(false);
        xb.appendText(res.message);
        xb.closeElement("cmd-result");
    }

    public CtrlCommandResult runCtrlCmdShutdown() throws RemoteException {
        this.proxy.shutdown();
        return new CtrlCommandResult(true, "Shutdown initiated.", null);
    }

    public CtrlCommandResult runCtrlCmdResetConnector(Map params) throws RemoteException {
        return this.runCtrlCmdReset(params);
    }

    public CtrlCommandResult runCtrlCmdResetService(Map params) throws RemoteException {
        return this.runCtrlCmdReset(params);
    }

    private CtrlCommandResult runCtrlCmdReset(Map params) throws RemoteException {
        String resultMsg;
        boolean result = false;
        int count = -1;
        String name = (String)params.get("name");
        String idStr = (String)params.get("id");
        String profile = (String)params.get("profile");
        boolean full = "true".equalsIgnoreCase((String)params.get("full"));
        if (name != null) {
            if ("ALL".equals(name)) {
                CwsStatus[] connectors = this.proxy.getMultiCwsStatus(null);
                count = 0;
                for (int i = 0; i < connectors.length; ++i) {
                    count += this.proxy.resetStatus(connectors[i].getName(), full);
                }
                resultMsg = "Service map for 'ALL' reset (" + count + " entries cleared).";
                result = true;
            } else {
                count = this.proxy.resetStatus(name, full);
                result = count != -1;
                resultMsg = result ? "Service map for '" + name + "' reset (" + count + " cleared)." : "No such connector: " + name;
            }
        } else if (idStr != null) {
            if (profile == null) {
                resultMsg = "Missing parameter: profile";
            } else {
                try {
                    Set services = ProxyConfig.getServiceTokens("id", idStr, false);
                    ServiceMapping sm = (ServiceMapping)services.iterator().next();
                    result = this.proxy.resetStatus(profile, sm.serviceId, sm.getCustomData());
                    resultMsg = result ? "Service status for '" + profile + ":" + idStr + "' reset." : "No match found for: " + idStr;
                }
                catch (ConfigException e) {
                    resultMsg = e.getMessage();
                }
            }
        } else {
            resultMsg = "Missing parameter: name or id";
        }
        return new CtrlCommandResult(result, resultMsg, count > -1 ? new Integer(count) : null);
    }

    public CtrlCommandResult runCtrlCmdRetryConnector(Map params) throws RemoteException {
        String resultMsg;
        boolean result = false;
        String name = (String)params.get("name");
        if (name != null) {
            this.proxy.retryConnector(name);
            result = true;
            resultMsg = "Connector notified, attempting reconnect.";
        } else {
            resultMsg = "Missing parameter: name";
        }
        return new CtrlCommandResult(result, resultMsg, null);
    }

    public CtrlCommandResult runCtrlCmdDisableConnector(Map params) throws RemoteException {
        String resultMsg;
        boolean result = false;
        String name = (String)params.get("name");
        if (name != null) {
            this.proxy.disableConnector(name);
            result = true;
            resultMsg = "Connector disabled.";
        } else {
            resultMsg = "Missing parameter: name";
        }
        return new CtrlCommandResult(result, resultMsg, null);
    }

    public CtrlCommandResult runCtrlCmdSetConnectorMetric(Map params) throws RemoteException {
        String resultMsg;
        boolean result = false;
        String name = (String)params.get("name");
        String metricStr = (String)params.get("metric");
        if (metricStr == null) {
            return new CtrlCommandResult(false, "Missing parameter: metric", null);
        }
        int metric = 1;
        try {
            metric = Integer.parseInt(metricStr);
        }
        catch (NumberFormatException e) {
            return new CtrlCommandResult(false, "Bad metric value: " + metricStr, null);
        }
        if (name != null) {
            this.proxy.setConnectorMetric(name, metric);
            result = true;
            resultMsg = "Metric set for: " + name;
        } else {
            resultMsg = "Missing parameter: name";
        }
        return new CtrlCommandResult(result, resultMsg, null);
    }

    public CtrlCommandResult runCtrlCmdSetAuUser(Map params) throws RemoteException {
        boolean result = false;
        String name = (String)params.get("name");
        String user = (String)params.get("user");
        if (user == null) {
            return new CtrlCommandResult(false, "Missing parameter: user", null);
        }
        String resultMsg = name != null ? ((result = this.proxy.setAuUser(name, user)) ? "Temp au-user '" + user + "' toggled for: " + name : "Invalid connector/user") : "Missing parameter: name";
        return new CtrlCommandResult(result, resultMsg, null);
    }

    public CtrlCommandResult runCtrlCmdSetProfileDebug(Map params) throws RemoteException {
        boolean value = "true".equalsIgnoreCase((String)params.get("value"));
        String profile = (String)params.get("profile");
        if ("ALL".equals(profile)) {
            profile = null;
        }
        this.proxy.setProfileDebug(value, profile);
        if (!value) {
            this.webBackend.clearTransactions(profile);
        }
        return new CtrlCommandResult(true, "Debug flag set for: " + (profile == null ? "ALL" : profile), null);
    }

    public CtrlCommandResult runCtrlCmdSetUserDebug(Map params) throws RemoteException {
        String user;
        boolean value = "true".equalsIgnoreCase((String)params.get("value"));
        if (this.proxy.setUserDebug(value, user = (String)params.get("name"))) {
            return new CtrlCommandResult(true, "Debug flag set for: " + user);
        }
        return new CtrlCommandResult(false, "No such user connected: " + user);
    }

    public CtrlCommandResult runCtrlCmdKickUser(Map params) throws RemoteException {
        String resultMsg;
        boolean result = false;
        int count = 0;
        String name = (String)params.get("name");
        if (name != null) {
            count = this.proxy.kickUser(name);
            if (count != -1) {
                result = true;
            }
            resultMsg = count == 0 ? "User '" + name + "' not connected." : (result ? "User '" + name + "' kicked: " + count + " sessions closed." : "No such user: " + name);
        } else {
            resultMsg = "Missing parameter: name";
        }
        return new CtrlCommandResult(result, resultMsg, count > -1 ? new Integer(count) : null);
    }

    public CtrlCommandResult runCtrlCmdOsdMessage(Map params) throws RemoteException {
        String resultMsg;
        boolean result = false;
        int count = -1;
        String text = (String)params.get("text");
        String name = (String)params.get("name");
        if ("ALL".equalsIgnoreCase(name)) {
            name = null;
        }
        if (text == null) {
            resultMsg = "Missing parameter: text";
        } else {
            count = this.proxy.sendOsdMessage(name, text);
            if (count > 0) {
                result = true;
            }
            resultMsg = result ? "Message sent to " + count + " active and compatible newcamd sessions." : "No active/compatible newcamd sessions found";
        }
        return new CtrlCommandResult(result, resultMsg, count > -1 ? new Integer(count) : null);
    }

    public CtrlCommandResult runCtrlCmdRemoveSeen(Map params) throws RemoteException {
        int count;
        String name = (String)params.get("name");
        if ("ALL".equalsIgnoreCase(name)) {
            name = null;
        }
        return new CtrlCommandResult((count = this.proxy.removeSeenUser(name)) > 0, "Removed " + count + " matching entries from the seen log.", new Integer(count));
    }

    public CtrlCommandResult runCtrlCmdRemoveFailed(Map params) throws RemoteException {
        int count;
        String mask = (String)params.get("mask");
        if (mask == null) {
            mask = "*";
        }
        return new CtrlCommandResult((count = this.proxy.removeLoginFailure(mask)) > 0, "Removed " + count + " matching entries from the failure log.", new Integer(count));
    }

    public CtrlCommandResult runCtrlCmdClearWarnings() throws RemoteException {
        this.webBackend.warningLog.clear();
        return new CtrlCommandResult(true, "Warnings cleared.");
    }

    public CtrlCommandResult runCtrlCmdClearEvents() throws RemoteException {
        this.webBackend.eventLog.clear();
        return new CtrlCommandResult(true, "Events cleared.");
    }

    public CtrlCommandResult runCtrlCmdClearFileLog() throws RemoteException {
        this.webBackend.fileLog.clear();
        return new CtrlCommandResult(true, "File log events cleared.");
    }

    public CtrlCommandResult runCtrlCmdGenKeystore(Map params) throws RemoteException {
        File binDir;
        String password = (String)params.get("password");
        String host = (String)params.get("host");
        String validity = (String)params.get("validity");
        if (password == null || password.length() < 2) {
            return new CtrlCommandResult(false, "Missing parameter: password");
        }
        if (host == null || host.length() < 2) {
            return new CtrlCommandResult(false, "Missing parameter: host");
        }
        if (validity == null || validity.length() == 0) {
            validity = "1000";
        }
        if ((binDir = new File(System.getProperty("java.home"), "bin")).exists() && binDir.isDirectory()) {
            File keyTool = new File(binDir, "keytool");
            if (!keyTool.exists()) {
                keyTool = new File(binDir, "keytool.exe");
            }
            if (keyTool.exists()) {
                try {
                    String line;
                    String cmdLine = keyTool.getAbsolutePath();
                    cmdLine = cmdLine + " -keystore csp_keystore -genkey -alias Cardservproxy -keyalg RSA";
                    cmdLine = cmdLine + " -storepass " + password + " -keypass " + password;
                    cmdLine = cmdLine + " -dname cn=" + host + " -validity " + validity;
                    Process p = Runtime.getRuntime().exec(cmdLine);
                    BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    StringBuffer sb = new StringBuffer();
                    while ((line = br.readLine()) != null) {
                        sb.append(line).append(" ");
                        this.webBackend.logger.warning(line);
                    }
                    int exitValue = p.waitFor();
                    if (exitValue != 0) {
                        this.webBackend.logger.warning("Keytool exit value: " + exitValue + " CmdLine: " + cmdLine);
                        return new CtrlCommandResult(false, "Keystore generation failed: " + sb, new Integer(exitValue));
                    }
                    return new CtrlCommandResult(true, "Keystore file 'csp_keystore' successfully created in proxy dir (probably). Enabling ssl requires restart.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new CtrlCommandResult(false, "Error occured: " + e);
                }
            }
        }
        return new CtrlCommandResult(false, "Couldn't find keytool executable.");
    }

    String getCfgXml() throws IOException {
        File cfgFile = ProxyConfig.getInstance().getCfgFile();
        byte[] buf = new byte[(int)cfgFile.length()];
        DataInputStream dis = new DataInputStream(new FileInputStream(cfgFile));
        dis.readFully(buf);
        dis.close();
        return new String(buf, "UTF-8");
    }

    CtrlCommandResult runCtrlCmd(String cmd, Map params, String user) throws RemoteException {
        CtrlCommand cmdDef = (CtrlCommand)this.ctrlCommands.get(cmd);
        CtrlCommandResult cmdRes = cmdDef.invoke(params, user);
        this.webBackend.logger.info("CtrlCommand '" + cmd + "' executed by user: " + user + " (result: " + cmdRes.message + ")");
        return cmdRes;
    }

    public void runStatusCmdCaProfiles(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        String profileName = (String)params.get("name");
        ProfileStatus[] ps = (ProfileStatus[])params.get("ps");
        ProfileStatus[] psShow = null;
        if (profileName != null) {
            for (int i = 0; i < ps.length; ++i) {
                if (!profileName.equals(ps[i].getName())) continue;
                psShow = new ProfileStatus[]{ps[i]};
                break;
            }
        } else {
            psShow = ps;
        }
        this.xmlFormatProfiles(psShow, xb, this.proxy.isAdmin(user));
    }

    public void runStatusCmdCwsConnectors(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        String[] profiles = (String[])params.get("profiles");
        CwsStatus[] connectors = null;
        String cwsName = (String)params.get("name");
        if (cwsName != null) {
            CwsStatus temp = this.proxy.getCwsStatus(cwsName);
            if (temp != null) {
                connectors = new CwsStatus[]{temp};
            }
        } else {
            connectors = this.proxy.getMultiCwsStatus(profiles);
        }
        XmlHelper.xmlFormatConnectors(connectors, xb, this.proxy.isAdmin(user), this.webBackend.cwsTransactions, this.proxy, profiles);
    }

    public void runStatusCmdProxyUsers(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        String[] profiles = (String[])params.get("profiles");
        UserStatus[] users = null;
        String userName = (String)params.get("name");
        boolean activeOnly = "true".equalsIgnoreCase((String)params.get("hide-inactive"));
        if (!this.proxy.isAdmin(user)) {
            userName = user;
        }
        if (userName != null) {
            UserStatus temp = this.proxy.getUserStatus(userName, activeOnly);
            if (temp != null) {
                users = new UserStatus[]{temp};
            }
        } else {
            users = this.proxy.getUsersStatus(profiles, activeOnly);
        }
        SeenEntry[] seen = this.proxy.getSeenUsers(null, userName, true);
        XmlHelper.xmlFormatUsers(users, seen.length, xb);
    }

    public void runStatusCmdProxyPlugins(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        String name = (String)params.get("name");
        this.xmlFormatProxyPlugins(xb, name, this.proxy.isAdmin(user));
    }

    public void runStatusCmdProxyStatus(XmlStringBuffer xb, Map params) throws RemoteException {
        this.xmlFormatProxyStatus(xb, (String[])params.get("profiles"));
    }

    public void runStatusCmdCacheStatus(XmlStringBuffer xb) throws RemoteException {
        CacheStatus cs = this.proxy.getCacheStatus();
        XmlHelper.xmlFormatCacheStatus(cs, xb);
    }

    public void runStatusCmdErrorLog(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        this.xmlFormatErrorLog(xb, (String[])params.get("profiles"), this.proxy.isAdmin(user));
    }

    public void runStatusCmdFileLog(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        if (!this.proxy.isAdmin(user) || !ProxyConfig.getInstance().isIncludeFileEvents()) {
            xb.appendElement("file-log", "size", "-1", true);
        } else {
            this.xmlFormatFileLog(xb);
        }
    }

    public void runStatusCmdUserLog(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        String userName = (String)params.get("name");
        if (userName == null || !this.proxy.isAdmin(user)) {
            userName = user;
        }
        this.xmlFormatUserLog(xb, userName, (String[])params.get("profiles"));
    }

    public void runStatusCmdUserWarningLog(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        String[] profiles = (String[])params.get("profiles");
        if (this.proxy.isAdmin(user)) {
            this.xmlFormatUserWarningLog(xb, null, profiles);
        } else {
            this.xmlFormatUserWarningLog(xb, user, profiles);
        }
    }

    public void runStatusCmdCwsLog(XmlStringBuffer xb, Map params) throws RemoteException {
        this.xmlFormatCwsLog(xb, (String)params.get("name"));
    }

    public void runStatusCmdAllServices(XmlStringBuffer xb, Map params) throws RemoteException {
        String[] profiles = (String[])params.get("profiles");
        boolean includeParsed = "true".equalsIgnoreCase((String)params.get("include-parsed"));
        Set all = this.getServices(profiles, includeParsed);
        ArrayList sorted = new ArrayList(all);
        Collections.sort(sorted);
        xb.appendElement("all-services", "count", sorted.size());
        XmlHelper.xmlFormatServices(sorted.toArray(new TvService[sorted.size()]), xb, false, true, true, null, profiles);
        xb.closeElement("all-services");
    }

    public void runStatusCmdWatchedServices(XmlStringBuffer xb, Map params) throws RemoteException {
        String[] profiles = (String[])params.get("profiles");
        List<TvService> watched = Arrays.asList(this.proxy.getWatchedServices(profiles));
        Collections.sort(watched);
        xb.appendElement("watched-services", "count", watched.size());
        XmlHelper.xmlFormatServices(watched.toArray(new TvService[watched.size()]), xb, true, true, true, null, profiles);
        xb.closeElement("watched-services");
    }

    public void runStatusCmdExportServices(XmlStringBuffer xb, Map params) throws RemoteException {
        CwsStatus temp;
        String[] profiles = (String[])params.get("profiles");
        String format = (String)params.get("format");
        String cwsName = (String)params.get("name");
        CwsStatus[] connectors = cwsName != null ? ((temp = this.proxy.getCwsStatus(cwsName)) != null ? new CwsStatus[]{temp} : new CwsStatus[]{}) : this.proxy.getMultiCwsStatus(profiles);
        xb.appendElement("export-services", "connectors", connectors.length);
        for (int i = 0; i < connectors.length; ++i) {
            xb.appendElement("connector", "name", connectors[i].getName());
            TvService[] services = this.proxy.getServices(connectors[i].getName(), false);
            if (services != null) {
                xb.appendElement("can-decode-services", "count", services.length);
                if ("hex".equalsIgnoreCase(format)) {
                    this.xmlFormatHexTokenList(services, xb);
                } else {
                    XmlHelper.xmlFormatServices(services, xb, false, true, null);
                }
                xb.closeElement("can-decode-services");
            }
            if ((services = this.proxy.getCannotDecodeServices(connectors[i].getName())) != null) {
                xb.appendElement("cannot-decode-services", "count", services.length);
                if ("hex".equalsIgnoreCase(format)) {
                    this.xmlFormatHexTokenList(services, xb);
                } else {
                    XmlHelper.xmlFormatServices(services, xb, false, true, null);
                }
                xb.closeElement("cannot-decode-services");
            }
            xb.closeElement("connector");
        }
        xb.closeElement("export-services");
    }

    private void xmlFormatHexTokenList(TvService[] services, XmlStringBuffer xb) {
        HashMap perProfile = new HashMap();
        for (int i = 0; i < services.length; ++i) {
            Set<String> tokens;
            if (perProfile.containsKey(services[i].getProfileName())) {
                tokens = (Set)perProfile.get(services[i].getProfileName());
            } else {
                tokens = new LinkedHashSet();
                perProfile.put(services[i].getProfileName(), tokens);
            }
            String token = new ServiceMapping(services[i]).toString();
            tokens.add(token);
        }
        Iterator iter = perProfile.keySet().iterator();
        while (iter.hasNext()) {
            String profile = (String)iter.next();
            xb.appendElement("profile", "name", profile);
            Iterator i = ((Set)perProfile.get(profile)).iterator();
            while (i.hasNext()) {
                xb.appendText((String)i.next());
                if (!i.hasNext()) continue;
                xb.appendText(" ");
            }
            xb.closeElement("profile");
        }
    }

    public void runStatusCmdLastSeen(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        String userName = (String)params.get("name");
        if (!this.proxy.isAdmin(user)) {
            userName = user;
        }
        SeenEntry[] seen = this.proxy.getSeenUsers((String[])params.get("profiles"), userName, false);
        this.xmlFormatLastSeen(seen, xb);
    }

    public void runStatusCmdLoginFailures(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        String userName = (String)params.get("name");
        if (!this.proxy.isAdmin(user)) {
            userName = user;
        }
        SeenEntry[] seen = this.proxy.getSeenUsers((String[])params.get("profiles"), userName, true);
        this.xmlFormatLoginFailures(seen, xb);
    }

    public void runStatusCmdFetchCfg(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        if (!this.webBackend.isSuperUser(user)) {
            xb.appendElement("error", "description", "Super-user required.", true);
        } else {
            try {
                xb.setContents(this.getCfgXml());
            }
            catch (Exception e) {
                xb.setContents(XmlHelper.getError(e.toString()));
            }
        }
    }

    public void runStatusCmdCwsBouquet(XmlStringBuffer xb, Map params) throws RemoteException {
        TvService service;
        if (!params.containsKey("xml")) {
            return;
        }
        Set all = this.getServices((String[])params.get("profiles"), true);
        HashMap<String, TvService> serviceMap = new HashMap<String, TvService>();
        Iterator iter = all.iterator();
        while (iter.hasNext()) {
            service = (TvService)iter.next();
            serviceMap.put(service.getId() + ":" + service.getProfileName(), service);
        }
        StringBuffer bqFile = new StringBuffer();
        StringBuffer bqLine = new StringBuffer();
        bqFile.append("#NAME Favourites (TV)\n");
        XMLConfig bqXml = (XMLConfig)params.get("xml");
        XMLConfig fileXml = bqXml.getSubConfig("file");
        XMLConfig includeNamesXml = bqXml.getSubConfig("include-names");
        boolean enigma2 = false;
        boolean includeNames = false;
        if (fileXml != null) {
            enigma2 = "enigma2".equalsIgnoreCase(fileXml.getString("format"));
        }
        if (includeNamesXml != null) {
            includeNames = "true".equalsIgnoreCase(includeNamesXml.getString("value"));
        }
        String prefix = enigma2 ? "#SERVICE 1:0:" : "#SERVICE: 1:0:";
        String namePrefix = enigma2 ? "#DESCRIPTION " : "#DESCRIPTION: ";
        Enumeration en = bqXml.getMultipleSubConfigs("service");
        while (en.hasMoreElements()) {
            try {
                service = (TvService)serviceMap.get(((XMLConfig)en.nextElement()).getString("id"));
                if (service == null || service.getTransponder() == -1L) continue;
                bqLine.append(prefix).append(Integer.toHexString(service.getType())).append(":");
                bqLine.append(Integer.toHexString(service.getId())).append(":");
                bqLine.append(Integer.toHexString((int)service.getTransponder())).append(":");
                bqLine.append(Integer.toHexString((int)service.getNetworkId())).append(":");
                bqLine.append(Long.toHexString(service.getNamespace())).append(":0:0:0:\n");
                bqFile.append(enigma2 ? bqLine.toString().toUpperCase() : bqLine.toString());
                if (includeNames) {
                    bqFile.append(namePrefix).append(service.getName()).append("\n");
                }
                bqLine = new StringBuffer();
            }
            catch (NumberFormatException e) {}
        }
        String id = enigma2 ? "favourites" : Long.toString(System.currentTimeMillis(), 36);
        String fileName = "/userbouquet." + id + ".tv";
        String data = bqFile.toString();
        this.webBackend.bouquets.put(fileName, data);
        xb.appendElement("cws-bouquet", "url", fileName, true);
    }

    public void runStatusCmdSystemProperties(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        if (!this.webBackend.isSuperUser(user)) {
            xb.appendElement("error", "description", "Super-user required.", true);
        } else {
            Properties p = System.getProperties();
            xb.appendElement("system-properties", "count", p.size());
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                xb.appendElement("property", "name", key);
                xb.appendAttr("value", p.getProperty(key)).endElement(true);
            }
            xb.closeElement("system-properties");
        }
    }

    public void runStatusCmdSystemThreads(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        if (!this.webBackend.isSuperUser(user)) {
            xb.appendElement("error", "description", "Super-user required.", true);
        } else {
            Thread[] threads = new Thread[Thread.activeCount()];
            Thread.enumerate(threads);
            xb.appendElement("system-threads", "count", threads.length);
            for (int i = 0; i < threads.length; ++i) {
                if (threads[i] == null) continue;
                xb.appendElement("thread", "name", threads[i].toString());
                if (checkFileDescriptors) {
                    xb.appendAttr("cpu-time", UnixUtil.getThreadCpuTime(threads[i].getId()));
                    xb.appendAttr("user-time", UnixUtil.getThreadUserTime(threads[i].getId())).endElement(true);
                    continue;
                }
                xb.appendAttr("cpu-time", "?").endElement(true);
            }
            xb.closeElement("system-threads");
        }
    }

    public void runStatusCmdCtrlCommands(XmlStringBuffer xb, Map params) throws RemoteException {
        String cmdName = (String)params.get("name");
        String grpName = (String)params.get("group");
        this.xmlFormatCtrlCommands(xb, cmdName, grpName);
    }

    public void runStatusCmdStatusCommands(XmlStringBuffer xb, Map params, String user) throws RemoteException {
        String cmdName = (String)params.get("name");
        String grpName = (String)params.get("group");
        this.xmlFormatStatusCommands(xb, cmdName, grpName, this.proxy.isAdmin(user));
    }

    void runStatusCmd(String cmd, XmlStringBuffer xb, Map params, String user) throws RemoteException {
        StatusCommand cmdDef = (StatusCommand)this.statusCommands.get(cmd);
        if (cmdDef == null) {
            xb.appendElement("error", "description", "Command unregistered", true);
        } else if (cmdDef.adminOnly && !this.proxy.isAdmin(user)) {
            xb.appendElement("error", "description", "Admin user required.", true);
        } else {
            cmdDef.invoke(xb, params, user);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String onXMLInput(XMLConfig xml, String preAuthUser, String ip) throws RemoteException {
        XmlStringBuffer xb = new XmlStringBuffer();
        String authUser = preAuthUser;
        if ("cws-status-req".equals(xml.getName())) {
            xb.appendElement("cws-status-resp", "ver", "1.0");
        } else if ("cws-command-req".equals(xml.getName())) {
            xb.appendElement("cws-command-resp", "ver", "1.0");
        }
        XMLConfig loginXml = xml.getSubConfig("cws-login");
        if (loginXml != null) {
            if ((loginXml = loginXml.getSubConfig("user")) != null) {
                String passwd;
                String user = loginXml.getString("name");
                if (this.webBackend.authUser(user, passwd = loginXml.getString("password"))) {
                    String sessionId = this.webBackend.createSession(user);
                    xb.appendElement("status", "state", "loggedIn");
                    xb.appendAttr("user", user).appendAttr("admin", this.proxy.isAdmin(user));
                    xb.appendAttr("super-user", this.webBackend.isSuperUser(user));
                    xb.appendAttr("session-id", sessionId).endElement(true);
                } else {
                    xb.appendElement("status", "state", "failed", true);
                    this.webBackend.logger.warning("User '" + user + "' (" + CustomFormatter.formatAddress(ip) + ") login failure: invalid password");
                    SessionManager.getInstance().fireUserLoginFailed(user, "Web/" + CaProfile.MULTIPLE.getName(), ip, "xml api post auth failed (bad password)");
                }
            }
        } else {
            String sessionId;
            XMLConfig sessionXml = xml.getSubConfig("session");
            if (sessionXml != null && (sessionId = sessionXml.getString("session-id")) != null) {
                authUser = (String)this.webBackend.sessions.get(sessionId);
            }
        }
        if (authUser != null) {
            if ("cws-status-req".equals(xml.getName())) {
                this.onXMLStatus(xml, authUser, xb);
            } else {
                if (!"cws-command-req".equals(xml.getName())) throw new IllegalArgumentException("Malformed request. Expected root element cws-status-req or cws-command-req.");
                this.onXMLCtrlCmd(xml, authUser, xb);
            }
        } else if (loginXml == null) {
            xb.appendElement("error", "description", "Not logged in.", true);
        }
        if ("cws-status-req".equals(xml.getName())) {
            xb.closeElement("cws-status-resp");
            return xb.toString();
        } else {
            if (!"cws-command-req".equals(xml.getName())) return xb.toString();
            xb.closeElement("cws-command-resp");
        }
        return xb.toString();
    }

    private void onXMLCtrlCmd(XMLConfig xml, String preAuthUser, XmlStringBuffer reply) throws RemoteException {
        if (!this.webBackend.isSuperUser(preAuthUser)) {
            reply.appendElement("error", "description", "Super-user required.", true);
        } else {
            XMLConfig cmdXml = xml.getSubConfig("command");
            if (cmdXml == null) {
                throw new IllegalArgumentException("Malformed request. No command element in cws-command-req.");
            }
            String cmd = cmdXml.getString("command");
            if (cmd == null) {
                xml.getString("command");
            }
            if (cmd == null || !this.ctrlCommands.containsKey(cmd.toLowerCase())) {
                throw new IllegalArgumentException("Malformed request. Unknown command: " + cmd);
            }
            this.appendCmdResult(cmd, this.runCtrlCmd(cmd, cmdXml.flatten(true), preAuthUser), reply);
        }
    }

    private void onXMLStatus(XMLConfig xml, String authUser, XmlStringBuffer xb) throws RemoteException {
        String profile = xml.getString("profile");
        ProfileStatus[] ps = this.proxy.getUserProfiles(authUser);
        String[] profiles = XmlHelper.getProfileNames(ps, profile);
        Enumeration e = xml.getAllSubConfigs();
        while (e.hasMoreElements()) {
            XMLConfig statusCmd = (XMLConfig)e.nextElement();
            if (!"true".equalsIgnoreCase(statusCmd.getString("include"))) continue;
            Properties params = statusCmd.flatten(true);
            params.put("ps", ps);
            params.put("profiles", profiles);
            params.put("xml", statusCmd);
            this.runStatusCmd(statusCmd.getName(), xb, params, authUser);
        }
    }

    private void xmlFormatProfiles(ProfileStatus[] profiles, XmlStringBuffer xb, boolean admin) throws RemoteException {
        if (profiles != null) {
            xb.appendElement("ca-profiles");
            for (int i = 0; i < profiles.length; ++i) {
                int mappedServices = this.getServices(new String[]{profiles[i].getName()}).size();
                int capacity = this.proxy.getCwsCapacity(new String[]{profiles[i].getName()});
                xb.appendElement("profile");
                xb.appendAttr("name", profiles[i].getName());
                xb.appendAttr("enabled", profiles[i].isEnabled());
                if (!CaProfile.MULTIPLE.getName().equals(profiles[i].getName())) {
                    xb.appendAttr("cache-only", profiles[i].isCacheOnly());
                    xb.appendAttr("ca-id", profiles[i].getCaId());
                    xb.appendAttr("network-id", profiles[i].getNetworkId());
                    if (profiles[i].getProviderIdents() != null) {
                        xb.appendAttr("provider-idents", profiles[i].getProviderIdents());
                    }
                    xb.appendAttr("mismatched-cards", profiles[i].isMismatchedCards());
                    xb.appendAttr("provider-match", profiles[i].isRequiresProviderMatch());
                    xb.appendAttr("parsed-services", profiles[i].getServices());
                    xb.appendAttr("parsed-conflicts", profiles[i].getConflicts());
                    if (profiles[i].getResetStr() != null) {
                        xb.appendAttr("reset-services", profiles[i].getResetStr());
                    }
                    if (profiles[i].getBlockedStr() != null) {
                        xb.appendAttr("blocked-services", profiles[i].getBlockedStr());
                    }
                    if (profiles[i].getAllowedStr() != null) {
                        xb.appendAttr("allowed-services", profiles[i].getAllowedStr());
                    }
                }
                xb.appendAttr("mapped-services", mappedServices);
                xb.appendAttr("debug", profiles[i].isDebug());
                xb.appendAttr("capacity", capacity);
                xb.appendAttr("sessions", profiles[i].getSessions());
                xb.appendAttr("max-cw-wait", profiles[i].getMaxCwWait());
                xb.appendAttr("max-cache-wait", profiles[i].getMaxCacheWait());
                if (profiles[i].getCongestionLimit() != profiles[i].getMaxCwWait()) {
                    xb.appendAttr("congestion-limit", profiles[i].getCongestionLimit());
                }
                xb.endElement(false);
                PortStatus[] ps = profiles[i].getListenPorts();
                for (int n = 0; n < ps.length; ++n) {
                    if (ps[n].getPort() <= 0) continue;
                    xb.appendElement("listen-port", "name", ps[n].getLabel());
                    xb.appendAttr("protocol", ps[n].getProtocol());
                    xb.appendAttr("port-number", ps[n].getPort());
                    xb.appendAttr("alive", ps[n].isAlive());
                    if (!"".equals(ps[n].getProperties()) && admin) {
                        xb.appendAttr("properties", ps[n].getProperties());
                    }
                    xb.endElement(true);
                }
                xb.closeElement("profile");
            }
            xb.closeElement("ca-profiles");
        }
    }

    public static void xmlFormatConnectors(CwsStatus[] connectors, XmlStringBuffer xb, boolean admin, Map cwsLog, RemoteProxy proxy, String[] profiles) throws RemoteException {
        if (connectors != null) {
            xb.appendElement("cws-connectors", "count", connectors.length);
            for (int i = 0; i < connectors.length; ++i) {
                CwsStatus conn = connectors[i];
                xb.appendElement("connector");
                xb.appendAttr("name", conn.getName());
                xb.appendAttr("protocol", conn.getProtocol());
                xb.appendAttr("profile", conn.getProfileName());
                xb.appendAttr("metric", conn.getMetric());
                xb.appendAttr("status", CWS_STATES[conn.getStatus()]);
                if (conn.getStatus() == 1 || conn.getStatus() == 4) {
                    TvService[] services = proxy.getServices(conn.getName(), true);
                    if (admin) {
                        xb.appendAttr("host", conn.getRemoteHost());
                    }
                    if (!CaProfile.MULTIPLE.getName().equals(conn.getProfileName())) {
                        xb.appendAttr("provider-idents", conn.getProviderIdents());
                    }
                    xb.appendAttr("connected", XmlHelper.formatTimeStamp(conn.getConnectTimeStamp()));
                    xb.appendAttr("duration", XmlHelper.formatDurationFrom(conn.getConnectTimeStamp()));
                    xb.appendAttr("service-count", services.length);
                    xb.appendAttr("sendq", conn.getSendQ());
                    xb.appendAttr("utilization", conn.getUtilization());
                    xb.appendAttr("avgutilization", conn.getAvgUtilization());
                    xb.appendAttr("ecm-count", conn.getEcmCount());
                    xb.appendAttr("ecm-load", conn.getEcmLoad());
                    xb.appendAttr("emm-count", conn.getEmmCount());
                    xb.appendAttr("timeout-count", conn.getTimeoutCount());
                    xb.appendAttr("capacity", conn.getCapacity());
                    xb.appendAttr("cutime", conn.getCurrentEcmTime());
                    xb.appendAttr("avgtime", conn.getAverageEcmTime());
                    if (admin && conn.getCardData1() != null) {
                        xb.appendAttr("card-data1", conn.getCardData1());
                    }
                    if (admin && conn.getCardData2() != null) {
                        xb.appendAttr("card-data2", conn.getCardData2());
                    }
                    if (cwsLog != null && cwsLog.containsKey(conn.getName())) {
                        xb.appendAttr("cws-log", ((List)cwsLog.get(conn.getName())).size());
                    }
                    xb.endElement(false);
                    boolean includeProfile = CaProfile.MULTIPLE.getName().equals(conn.getProfileName());
                    XmlHelper.xmlFormatServices(services, xb, false, includeProfile, false, conn.getRecentSids(), profiles);
                    if (admin) {
                        XmlHelper.xmlFormatRemoteInfo(conn, xb);
                    }
                    xb.closeElement("connector");
                    continue;
                }
                if (conn.getStatus() == 0) {
                    long secsLeft = (conn.getNextAttemptTimeStamp() - System.currentTimeMillis()) / 1000L;
                    String nextAttempt = XmlHelper.formatDuration(secsLeft);
                    if (nextAttempt.length() > 0) {
                        xb.appendAttr("next-attempt", nextAttempt);
                    }
                    if (conn.getDisconnectTimeStamp() > 0L) {
                        xb.appendAttr("disconnected", XmlHelper.formatTimeStamp(conn.getDisconnectTimeStamp()));
                    }
                    xb.endElement(true);
                    continue;
                }
                xb.endElement(true);
            }
            xb.closeElement("cws-connectors");
        }
    }

    public static void xmlFormatRemoteInfo(CwsStatus connector, XmlStringBuffer xb) {
        Properties p = connector.getRemoteInfo();
        if (p == null || p.isEmpty()) {
            return;
        }
        xb.appendElement("remote-info", "count", p.size());
        ArrayList<Object> sorted = new ArrayList<Object>(p.keySet());
        Collections.sort(sorted);
        Iterator iter = sorted.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            xb.appendElement("cws-param", "name", key);
            xb.appendAttr("value", p.getProperty(key)).endElement(true);
        }
        xb.closeElement("remote-info");
    }

    public static void xmlFormatUsers(UserStatus[] users, int loginFailures, XmlStringBuffer xb) {
        if (users == null) {
            users = new UserStatus[]{};
        }
        xb.appendElement("proxy-users", "count", users.length);
        xb.appendAttr("login-failures", loginFailures).endElement(false);
        for (int i = 0; i < users.length; ++i) {
            xb.appendElement("user", "name", users[i].getUserName());
            xb.appendAttr("display-name", users[i].getDisplayName());
            if (users[i].isAdmin()) {
                xb.appendAttr("admin", users[i].isAdmin());
            }
            xb.appendAttr("sessions", users[i].getSessionCount(null));
            Iterator iter = users[i].getPropertyNames();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                xb.appendAttr(name, users[i].getProperty(name));
            }
            xb.endElement(false);
            SessionStatus[] sessions = users[i].getSessions();
            for (int n = 0; n < sessions.length; ++n) {
                SessionStatus ss = sessions[n];
                xb.appendElement("session", "host", ss.getRemoteHost());
                xb.appendAttr("id", ss.getSessionId());
                xb.appendAttr("count", users[i].getSessionCount(ss.getProfileName()) + "/" + ss.getMaxSessions());
                xb.appendAttr("active", ss.isActive());
                xb.appendAttr("profile", ss.getProfileName());
                xb.appendAttr("client-id", ss.getClientId());
                xb.appendAttr("protocol", ss.getProtocol());
                xb.appendAttr("context", ss.getContext());
                int idx = ss.getContext().indexOf("No (");
                if (idx != -1) {
                    xb.appendAttr("au", ss.getContext().substring(idx + 4, ss.getContext().lastIndexOf(")")));
                }
                xb.appendAttr("connected", XmlHelper.formatTimeStamp(ss.getConnectTimeStamp()));
                xb.appendAttr("duration", XmlHelper.formatDurationFrom(ss.getConnectTimeStamp()));
                xb.appendAttr("ecm-count", ss.getEcmCount());
                xb.appendAttr("emm-count", ss.getEmmCount());
                xb.appendAttr("pending-count", ss.getPendingCount());
                if (ss.getKaCount() > 0) {
                    xb.appendAttr("keepalive-count", ss.getKaCount());
                }
                xb.appendAttr("last-transaction", ss.getLastTransactionTime());
                if (ss.getLastZapTimeStamp() > 0L) {
                    xb.appendAttr("last-zap", XmlHelper.formatDurationFrom(ss.getLastZapTimeStamp()));
                }
                if (ss.getIdleTime() > -1L) {
                    xb.appendAttr("idle-time", XmlHelper.formatDuration(ss.getIdleTime() / 1000L));
                }
                xb.appendAttr("flags", ss.getFlags());
                xb.appendAttr("avg-ecm-interval", ss.getAvgEcmInterval());
                xb.endElement(false);
                XmlHelper.xmlFormatServices(new TvService[]{ss.getLastService()}, xb, false, CaProfile.MULTIPLE.getName().equals(ss.getProfileName()), null);
                xb.closeElement("session");
            }
            xb.closeElement("user");
        }
        xb.closeElement("proxy-users");
    }

    private void xmlFormatLastSeen(SeenEntry[] seen, XmlStringBuffer xb) {
        xb.appendElement("last-seen", "count", seen.length);
        for (int i = 0; i < seen.length; ++i) {
            xb.appendElement("entry", "name", seen[i].getName());
            xb.appendAttr("profile", seen[i].getProfile());
            xb.appendAttr("last-login", XmlHelper.formatTimeStamp(seen[i].getLastLogin()));
            xb.appendAttr("last-seen", XmlHelper.formatTimeStamp(seen[i].getLastSeen()));
            xb.appendAttr("host", seen[i].getHostAddr());
            ArrayList log = (ArrayList)this.webBackend.userTransactions.get(seen[i].getName());
            if (log == null) {
                log = new ArrayList();
            }
            xb.appendAttr("user-log", log.size());
            xb.endElement(true);
        }
        xb.closeElement("last-seen");
    }

    private void xmlFormatLoginFailures(SeenEntry[] seen, XmlStringBuffer xb) {
        xb.appendElement("login-failures", "count", seen.length);
        for (int i = 0; i < seen.length; ++i) {
            xb.appendElement("entry", "name", seen[i].getName());
            xb.appendAttr("context", seen[i].getProfile());
            xb.appendAttr("last-failure", XmlHelper.formatTimeStamp(seen[i].getLastLogin()));
            xb.appendAttr("first-failure", XmlHelper.formatTimeStamp(seen[i].getLastLogout()));
            xb.appendAttr("failure-count", seen[i].getCount());
            xb.appendAttr("host", seen[i].getHostAddr());
            xb.appendAttr("reason", seen[i].getLastReason());
            xb.endElement(true);
        }
        xb.closeElement("login-failures");
    }

    public static void xmlFormatServices(TvService[] services, XmlStringBuffer xb, boolean includeCount, boolean includeProfile, int[] recentSids) {
        XmlHelper.xmlFormatServices(services, xb, includeCount, includeProfile, true, recentSids, null);
    }

    public static void xmlFormatServices(TvService[] services, XmlStringBuffer xb, boolean includeCount, boolean includeProfile, boolean includeCid, int[] recentSids, String[] profileNames) {
        if (services != null) {
            HashSet<Integer> sids = null;
            if (recentSids != null && recentSids.length > 0) {
                sids = new HashSet<Integer>();
                for (int i = 0; i < recentSids.length; ++i) {
                    sids.add(new Integer(recentSids[i]));
                }
            }
            HashSet<String> profiles = new HashSet<String>();
            if (profileNames != null) {
                profiles.addAll(Arrays.asList(profileNames));
            }
            for (int n = 0; n < services.length; ++n) {
                if (services[n] == null || services[n].getId() == -1 || !profiles.isEmpty() && !profiles.contains(services[n].getProfileName())) continue;
                xb.appendElement("service", "id", services[n].getId());
                if (includeCid) {
                    xb.appendAttr("cdata", new ServiceMapping(services[n]).toString());
                }
                xb.appendAttr("name", services[n].getDisplayName());
                if (includeCount) {
                    xb.appendAttr("watchers", services[n].getWatchers());
                }
                if (includeProfile) {
                    xb.appendAttr("profile", services[n].getProfileName());
                }
                if (sids != null && sids.contains(new Integer(services[n].getId()))) {
                    xb.appendAttr("hit", "true");
                }
                xb.endElement(true);
            }
        }
    }

    private void xmlFormatProxyPlugins(XmlStringBuffer xb, String name, boolean admin) throws RemoteException {
        PluginStatus[] plugins = admin ? this.proxy.getPlugins() : new PluginStatus[]{};
        xb.appendElement("proxy-plugins", "count", plugins.length);
        for (int i = 0; i < plugins.length; ++i) {
            if (name != null && !name.equals(plugins[i].getName())) continue;
            xb.appendElement("plugin", "name", plugins[i].getName());
            xb.appendAttr("description", plugins[i].getDescription());
            xb.appendAttr("class-name", plugins[i].getClassName());
            xb.endElement(false);
            Iterator iter = plugins[i].getPropertyNames();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                xb.appendElement("plugin-param", "name", key);
                xb.appendAttr("value", plugins[i].getProperty(key)).endElement(true);
            }
            xb.closeElement("plugin");
        }
        xb.closeElement("proxy-plugins");
    }

    private void xmlFormatProxyStatus(XmlStringBuffer xb, String[] profiles) throws RemoteException {
        int sessions = this.proxy.getSessionCount(profiles, false);
        int connectors = this.proxy.getCwsCount(profiles);
        long startTime = this.proxy.getProxyStartTime();
        if (sessions == -1 && connectors == -1 && startTime == -1L) {
            xb.appendElement("proxy-status", "state", "down", true);
        } else {
            int[] counters = this.proxy.getCounters();
            xb.appendElement("proxy-status", "state", "up");
            xb.appendAttr("name", this.proxy.getName());
            xb.appendAttr("version", "0.9.0");
            xb.appendAttr("build", CardServProxy.APP_BUILD);
            xb.appendAttr("ecm-count", counters[0]);
            xb.appendAttr("ecm-forwards", counters[1]);
            xb.appendAttr("ecm-cache-hits", counters[2]);
            xb.appendAttr("ecm-failures", counters[3]);
            xb.appendAttr("ecm-denied", counters[5]);
            xb.appendAttr("ecm-filtered", counters[6]);
            xb.appendAttr("emm-count", counters[4]);
            xb.appendAttr("ecm-rate", counters[7]);
            xb.appendAttr("probeq", counters[8]);
            xb.appendAttr("started", XmlHelper.formatTimeStamp(startTime));
            xb.appendAttr("duration", XmlHelper.formatDurationFrom(startTime));
            xb.appendAttr("connectors", connectors);
            xb.appendAttr("capacity", this.proxy.getCwsCapacity(profiles));
            xb.appendAttr("active-sessions", this.proxy.getSessionCount(profiles, true));
            xb.appendAttr("sessions", sessions);
            xb.endElement(false);
            String os = System.getProperty("os.name", "undetermined") + " " + System.getProperty("os.version", "") + " (" + System.getProperty("os.arch", "unknown") + ")";
            Runtime rt = Runtime.getRuntime();
            xb.appendElement("jvm", "name", System.getProperty("java.vm.name", "Unknown"));
            xb.appendAttr("version", System.getProperty("java.runtime.version", "0.0.0"));
            xb.appendAttr("heap-total", rt.totalMemory() / 1024L);
            xb.appendAttr("heap-free", rt.freeMemory() / 1024L);
            xb.appendAttr("threads", Thread.activeCount());
            if (checkFileDescriptors) {
                try {
                    long openFd = UnixUtil.getOpenFileDescriptorCount();
                    long maxFd = UnixUtil.getMaxFileDescriptorCount();
                    if (openFd > 0L) {
                        xb.appendAttr("filedesc-open", openFd);
                    }
                    if (maxFd > 0L) {
                        xb.appendAttr("filedesc-max", maxFd);
                    }
                }
                catch (Throwable e) {
                    this.webBackend.logger.fine("No unix management instrumentation available: " + e);
                    checkFileDescriptors = false;
                }
            }
            xb.appendAttr("time", XmlHelper.formatTimeStamp(System.currentTimeMillis()));
            xb.appendAttr("os", os).endElement(true);
            xb.closeElement("proxy-status");
        }
    }

    public static void xmlFormatCacheStatus(CacheStatus cs, XmlStringBuffer xb) {
        xb.appendElement("cache-status", "type", cs.getType());
        Properties p = cs.getUsageStats();
        if (p == null) {
            p = new Properties();
        }
        ArrayList<Object> sorted = new ArrayList<Object>(p.keySet());
        Collections.sort(sorted);
        Iterator iter = sorted.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            xb.appendElement("cache-param", "name", key);
            xb.appendAttr("value", p.getProperty(key)).endElement(true);
        }
        xb.closeElement("cache-status");
    }

    private void xmlFormatErrorLog(XmlStringBuffer xb, String[] profiles, boolean admin) {
        HashSet<String> ps = profiles == null ? null : new HashSet<String>(Arrays.asList(profiles));
        xb.appendElement("error-log", "size", this.webBackend.eventLog.size());
        Iterator iter = new ArrayList(this.webBackend.eventLog).iterator();
        while (iter.hasNext()) {
            RemoteEvent event = (RemoteEvent)iter.next();
            if (ps != null && event.getProfile() != null && !ps.contains(event.getProfile())) continue;
            xb.appendElement("event");
            xb.appendAttr("timestamp", XmlHelper.formatTimeStamp(event.getTimeStamp()));
            xb.appendAttr("type", event.getType());
            xb.appendAttr("profile", event.getProfile());
            xb.appendAttr("label", event.getLabel());
            xb.appendAttr("msg", admin ? event.getMessage() : "");
            xb.endElement(true);
        }
        xb.closeElement("error-log");
    }

    private void xmlFormatFileLog(XmlStringBuffer xb) {
        xb.appendElement("file-log", "size", this.webBackend.fileLog.size());
        Iterator iter = new ArrayList(this.webBackend.fileLog).iterator();
        while (iter.hasNext()) {
            RemoteEvent event = (RemoteEvent)iter.next();
            xb.appendElement("event");
            xb.appendAttr("timestamp", XmlHelper.formatTimeStamp(event.getTimeStamp()));
            xb.appendAttr("log-level", event.getProperty("log-level"));
            xb.appendAttr("label", event.getLabel());
            xb.appendAttr("msg", event.getMessage());
            xb.endElement(true);
        }
        xb.closeElement("file-log");
    }

    private void xmlFormatUserLog(XmlStringBuffer xb, String userName, String[] profiles) {
        ArrayList ecmLog = (ArrayList)this.webBackend.userTransactions.get(userName);
        if (ecmLog == null) {
            ecmLog = new ArrayList();
        }
        xb.appendElement("user-log", "size", ecmLog.size()).appendAttr("name", userName).endElement(false);
        XmlHelper.xmlFormatEcmTransactions(xb, ecmLog, profiles, null, false, false);
        xb.closeElement("user-log");
    }

    private void xmlFormatUserWarningLog(XmlStringBuffer xb, String userName, String[] profiles) {
        xb.appendElement("user-warning-log");
        if (userName != null) {
            xb.appendAttr("name", userName).endElement(false);
        }
        XmlHelper.xmlFormatEcmTransactions(xb, this.webBackend.warningLog, profiles, userName, true, false);
        xb.closeElement("user-warning-log");
    }

    private void xmlFormatCwsLog(XmlStringBuffer xb, String cwsName) {
        ArrayList ecmLog = (ArrayList)this.webBackend.cwsTransactions.get(cwsName);
        if (ecmLog == null) {
            ecmLog = new ArrayList();
        }
        xb.appendElement("cws-log", "size", ecmLog.size()).appendAttr("name", cwsName).endElement(false);
        XmlHelper.xmlFormatEcmTransactions(xb, ecmLog, null, null, false, true);
        xb.closeElement("cws-log");
    }

    public static void xmlFormatEcmTransactions(XmlStringBuffer xb, Collection ecmLog, String[] profiles, String userName, boolean warningsOnly, boolean cwsLog) {
        HashSet<String> ps = profiles == null ? null : new HashSet<String>(Arrays.asList(profiles));
        Iterator iter = new ArrayList(ecmLog).iterator();
        while (iter.hasNext()) {
            RemoteEvent event = (RemoteEvent)iter.next();
            if (warningsOnly && !"true".equalsIgnoreCase(event.getProperty("warning")) || warningsOnly && userName != null && !userName.equals(event.getMessage()) || ps != null && event.getProfile() != null && !ps.contains(event.getProfile())) continue;
            xb.appendElement("ecm");
            try {
                if (warningsOnly) {
                    xb.appendAttr("name", event.getMessage());
                    if (event.getProperty("time-cache") != null) {
                        xb.appendAttr("time-cache", event.getProperty("time-cache"));
                    }
                    if (event.getProperty("time-queue") != null) {
                        xb.appendAttr("time-queue", event.getProperty("time-queue"));
                    }
                    if (event.getProperty("time-cws") != null) {
                        xb.appendAttr("time-cws", event.getProperty("time-cws"));
                    }
                    if (event.getProperty("time-client") != null) {
                        xb.appendAttr("time-client", event.getProperty("time-client"));
                    }
                } else if ("true".equalsIgnoreCase(event.getProperty("warning"))) {
                    xb.appendAttr("warning", "true");
                }
                if (event.getProperty("count") != null) {
                    xb.appendAttr("count", event.getProperty("count"));
                }
                xb.appendAttr("timestamp", XmlHelper.formatTimeStamp(Long.parseLong(event.getProperty("timestamp"))));
                xb.appendAttr("request-hash", event.getProperty("request-hash"));
                xb.appendAttr("ecm-size", event.getProperty("ecm-size"));
                if (event.getProperty("cw") != null) {
                    xb.appendAttr("cw", event.getProperty("cw"));
                }
                if (event.getProperty("ext-newcamd") != null) {
                    xb.appendAttr("ext-newcamd", event.getProperty("ext-newcamd"));
                }
                xb.appendAttr("session-id", event.getProperty("id"));
                xb.appendAttr("service-name", event.getProperty("service"));
                if (event.getProperty("provider-ident") != null) {
                    xb.appendAttr("provider-ident", event.getProperty("provider-ident"));
                }
                if (event.getProperty("ca-id") != null) {
                    xb.appendAttr("ca-id", event.getProperty("ca-id"));
                }
                if (event.getProperty("network-id") != null) {
                    xb.appendAttr("network-id", event.getProperty("network-id"));
                }
                if (event.getProperty("origin-id") != null) {
                    xb.appendAttr("origin-id", event.getProperty("origin-id"));
                }
                if (event.getProperty("reply-sid") != null) {
                    xb.appendAttr("reply-sid", event.getProperty("reply-sid"));
                }
                xb.appendAttr("time", event.getProperty("time"));
                xb.appendAttr("flags", event.getProperty("flags"));
                if (event.getProperty("filtered-by") != null) {
                    xb.appendAttr("filtered-by", event.getProperty("filtered-by"));
                }
                if (cwsLog) {
                    xb.appendAttr("user-name", event.getMessage());
                } else if (event.getProperty("cws-name") != null) {
                    xb.appendAttr("cws-name", event.getProperty("cws-name"));
                }
                xb.endElement(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                xb.endElement(true);
            }
        }
    }

    private void xmlFormatCtrlCommands(XmlStringBuffer xb, String cmdName, String grpName) throws RemoteException {
        xb.appendElement("ctrl-commands", "count", this.ctrlCommands.size());
        this.xmlFormatCommands(xb, cmdName, grpName, this.ctrlCommands, true);
        xb.closeElement("ctrl-commands");
    }

    private void xmlFormatStatusCommands(XmlStringBuffer xb, String cmdName, String grpName, boolean admin) throws RemoteException {
        xb.appendElement("status-commands", "count", this.statusCommands.size());
        this.xmlFormatCommands(xb, cmdName, grpName, this.statusCommands, admin);
        xb.closeElement("status-commands");
    }

    private void xmlFormatCommands(XmlStringBuffer xb, String cmdName, String grpName, Map commands, boolean admin) throws RemoteException {
        HashMap optionLists = new HashMap();
        LinkedHashMap<String, Object> groups = new LinkedHashMap<String, Object>();
        Iterator iter = commands.values().iterator();
        while (iter.hasNext()) {
            Command cmd = (Command)iter.next();
            if (groups.containsKey(cmd.groupLabel)) continue;
            groups.put(cmd.groupLabel, cmd.handler);
        }
        Iterator iter2 = groups.keySet().iterator();
        while (iter2.hasNext()) {
            String group = (String)iter2.next();
            if (grpName != null && !grpName.equals(group)) continue;
            xb.appendElement("command-group", "name", group);
            xb.appendAttr("handler", groups.get(group).getClass().getName()).endElement(false);
            this.xmlFormatCommandGroup(xb, group, cmdName, commands, optionLists, admin);
            xb.closeElement("command-group");
        }
        XmlHelper.xmlFormatOptionLists(xb, optionLists);
    }

    public static void xmlFormatOptionLists(XmlStringBuffer xb, Map optionLists) {
        Iterator iter = optionLists.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            xb.appendElement("option-list", "name", name);
            Iterator i = ((Set)optionLists.get(name)).iterator();
            while (i.hasNext()) {
                xb.appendElement("option", "value", i.next().toString(), true);
            }
            xb.closeElement("option-list");
        }
    }

    private void xmlFormatCommandGroup(XmlStringBuffer xb, String groupName, String cmdName, Map commands, Map optionLists, boolean admin) throws RemoteException {
        Iterator iter = commands.values().iterator();
        while (iter.hasNext()) {
            Command cmd = (Command)iter.next();
            if (cmdName != null && !cmd.name.equals(cmdName) || groupName != null && !groupName.equals(cmd.groupLabel) || cmd instanceof StatusCommand && ((StatusCommand)cmd).adminOnly && !admin) continue;
            xb.appendElement("command", "name", cmd.name);
            xb.appendAttr("label", cmd.label);
            xb.appendAttr("description", cmd.description);
            if (cmd instanceof CtrlCommand) {
                xb.appendAttr("confirm", ((CtrlCommand)cmd).confirm);
            }
            if (cmd instanceof StatusCommand) {
                xb.appendAttr("admin-only", ((StatusCommand)cmd).adminOnly);
            }
            xb.endElement(false);
            Iterator prms = cmd.params.values().iterator();
            while (prms.hasNext()) {
                Command.CommandParam prm = (Command.CommandParam)prms.next();
                if (!admin && prm.adminOnly) continue;
                xb.appendElement("command-param", "name", prm.name);
                xb.appendAttr("label", prm.label);
                if (prm.value != null) {
                    xb.appendAttr("value", prm.value);
                }
                if (prm.size > 0) {
                    xb.appendAttr("size", prm.size);
                }
                if (cmd instanceof CtrlCommand) {
                    xb.appendAttr("allow-arbitrary", prm.allowArbitrary);
                    if (!prm.allowArbitrary && prm.options.contains("true")) {
                        xb.appendAttr("boolean", true);
                    }
                }
                if (cmd instanceof StatusCommand) {
                    xb.appendAttr("optional", prm.optional);
                    xb.appendAttr("admin-only", prm.adminOnly);
                }
                xb.endElement(false);
                String[] options = prm.getOptions();
                if (options != null) {
                    for (int i = 0; i < options.length; ++i) {
                        if (options[i].startsWith("@") && !optionLists.containsKey(options[i])) {
                            optionLists.put(options[i], this.getParamOptions(options[i].substring(1)));
                        }
                        xb.appendElement("option", "value", options[i], true);
                    }
                }
                xb.closeElement("command-param");
            }
            xb.closeElement("command");
        }
    }

    private Set getParamOptions(String source) throws RemoteException {
        TreeSet<String> set;
        block8: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block7: {
                                set = new TreeSet<String>();
                                if (!"connected-users".equals(source)) break block7;
                                UserStatus[] users = this.proxy.getUsersStatus(null, false);
                                for (int i = 0; i < users.length; ++i) {
                                    set.add(users[i].getUserName());
                                }
                                break block8;
                            }
                            if (!"active-users".equals(source)) break block9;
                            UserStatus[] users = this.proxy.getUsersStatus(null, true);
                            for (int i = 0; i < users.length; ++i) {
                                set.add(users[i].getUserName());
                            }
                            break block8;
                        }
                        if (!"known-users".equals(source)) break block10;
                        UserStatus[] users = this.proxy.getUsersStatus(null, false);
                        for (int i = 0; i < users.length; ++i) {
                            set.add(users[i].getUserName());
                        }
                        SeenEntry[] seen = this.proxy.getSeenUsers(null, null, false);
                        for (int i = 0; i < seen.length; ++i) {
                            set.add(seen[i].getName());
                        }
                        break block8;
                    }
                    if (!"offline-users".equals(source)) break block11;
                    SeenEntry[] seen = this.proxy.getSeenUsers(null, null, false);
                    for (int i = 0; i < seen.length; ++i) {
                        set.add(seen[i].getName());
                    }
                    break block8;
                }
                if (!"profiles".equals(source)) break block12;
                ProfileStatus[] profiles = this.proxy.getProfiles();
                for (int i = 0; i < profiles.length; ++i) {
                    if (CaProfile.MULTIPLE.getName().equals(profiles[i].getName())) continue;
                    set.add(profiles[i].getName());
                }
                break block8;
            }
            if (!"connectors".equals(source)) break block8;
            CwsStatus[] connectors = this.proxy.getMultiCwsStatus(null);
            for (int i = 0; i < connectors.length; ++i) {
                set.add(connectors[i].getName());
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatTimeStamp(long timeStamp) {
        SimpleDateFormat simpleDateFormat = rfc822fmt;
        synchronized (simpleDateFormat) {
            return rfc822fmt.format(new Date(timeStamp));
        }
    }

    public static String formatDuration(long s) {
        if (s == 0L) {
            return "0s";
        }
        int i = 0;
        String res = "";
        while (s > 0L) {
            switch (i++) {
                case 0: {
                    res = res + s % 60L + "s";
                    s /= 60L;
                }
                case 1: {
                    if (s % 60L > 0L) {
                        res = s % 60L + "m " + res;
                    }
                    s /= 60L;
                }
                case 2: {
                    if (s % 24L > 0L) {
                        res = s % 24L + "h " + res;
                    }
                    s /= 24L;
                }
                case 3: {
                    if (s % 7L > 0L) {
                        res = s % 7L + "d " + res;
                    }
                    s /= 7L;
                }
                case 4: {
                    if (s > 0L) {
                        res = s + "w " + res;
                    }
                    s = 0L;
                }
            }
        }
        return res;
    }

    public static String formatDurationFrom(long timeStamp) {
        long s = (System.currentTimeMillis() - timeStamp) / 1000L;
        return XmlHelper.formatDuration(s);
    }

    public static String[] getProfileNames(ProfileStatus[] profiles, String selected) {
        String[] names = new String[profiles.length];
        for (int i = 0; i < profiles.length; ++i) {
            names[i] = profiles[i].getName();
        }
        HashSet<String> profileSet = new HashSet<String>(Arrays.asList(names));
        if (selected != null) {
            names = profileSet.contains(selected) ? new String[]{selected} : new String[]{};
        }
        return names;
    }

    public static String getError(String descr) {
        return new XmlStringBuffer().appendElement("error", "description", descr, true).toString();
    }

    public static String getCfgResult(String message) {
        return new XmlStringBuffer().appendElement("cfg-result", "message", message, true).toString();
    }

    private void addCommand(Map commands, Command command, boolean override) {
        if (commands.containsKey(command.name) && override) {
            Command old = (Command)commands.get(command.name);
            old.setOverride(command);
        } else {
            commands.put(command.name, command);
        }
    }

    private void removeCommand(Map commands, Command command) {
        Command cmd = (Command)commands.get(command.name);
        if (cmd == command) {
            commands.remove(command.name);
        } else {
            cmd.setOverride(null);
        }
    }

    public void registerCommand(Command command) {
        this.registerCommand(command, false);
    }

    public void registerCommand(Command command, boolean override) {
        if (command instanceof CtrlCommand) {
            this.addCommand(this.ctrlCommands, command, override);
        }
        if (command instanceof StatusCommand) {
            this.addCommand(this.statusCommands, command, override);
        }
    }

    public void unregisterCommand(Command command) {
        if (command instanceof CtrlCommand) {
            this.removeCommand(this.ctrlCommands, command);
        }
        if (command instanceof StatusCommand) {
            this.removeCommand(this.statusCommands, command);
        }
    }
}

