/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.views.types;

import com.jrockit.mc.flightrecorder.ui.views.types.TypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.views.types.TypeFolder;
import com.jrockit.mc.flightrecorder.ui.views.types.visitor.IVisitable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ICheckStateProvider;

public class TypeCheckedStateProvider
implements ICheckStateProvider {
    public boolean isGrayed(Object element) {
        return TypeCheckedStateProvider.getCheckState(element) == null;
    }

    public boolean isChecked(Object element) {
        Boolean checked = TypeCheckedStateProvider.getCheckState(element);
        return checked == null || checked != false;
    }

    private static boolean setChildEventState(List<? extends IVisitable> children, boolean checked) {
        boolean retValue = false;
        Iterator<? extends IVisitable> it = children.iterator();
        while (it.hasNext()) {
            if (!TypeCheckedStateProvider.setCheckedState(it.next(), checked)) continue;
            retValue = true;
        }
        return retValue;
    }

    public static boolean setCheckedState(Object element, boolean checked) {
        if (element instanceof TypeFolder) {
            return TypeCheckedStateProvider.setChildEventState(((TypeFolder)element).getChildren(), checked);
        }
        if (element instanceof TypeDescriptor) {
            boolean retValue = false;
            TypeDescriptor typeDescriptor = (TypeDescriptor)element;
            if (typeDescriptor.isChecked() != checked) {
                typeDescriptor.setChecked(checked);
                retValue = true;
            }
            return retValue;
        }
        return false;
    }

    private static Boolean getChildState(List<? extends IVisitable> collection) {
        int visibleCount = 0;
        for (IVisitable iVisitable : collection) {
            Boolean childChecked = TypeCheckedStateProvider.getCheckState(iVisitable);
            if (childChecked == null) {
                return null;
            }
            if (!childChecked.booleanValue()) continue;
            ++visibleCount;
        }
        if (visibleCount == 0) {
            return false;
        }
        if (visibleCount == collection.size()) {
            return true;
        }
        return null;
    }

    private static Boolean getCheckState(Object element) {
        if (element instanceof TypeDescriptor) {
            return ((TypeDescriptor)element).isChecked();
        }
        if (element instanceof TypeFolder) {
            return TypeCheckedStateProvider.getChildState(((TypeFolder)element).getChildren());
        }
        return null;
    }
}

